/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param;

import java.util.ListIterator;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.ParameterException;
import org.opensha.exceptions.TranslateException;
import org.opensha.exceptions.WarningException;
import org.opensha.param.DependentParameterAPI;
import org.opensha.param.DoubleConstraint;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterConstraint;
import org.opensha.param.ParameterConstraintAPI;
import org.opensha.param.ParameterList;
import org.opensha.param.WarningDoubleParameter;
import org.opensha.param.WarningParameterAPI;
import org.opensha.param.event.ParameterChangeEvent;
import org.opensha.param.event.ParameterChangeFailEvent;
import org.opensha.param.event.ParameterChangeFailListener;
import org.opensha.param.event.ParameterChangeListener;
import org.opensha.param.event.ParameterChangeWarningEvent;
import org.opensha.param.event.ParameterChangeWarningListener;
import org.opensha.param.translate.LogTranslator;
import org.opensha.param.translate.TranslatorAPI;

public class TranslatedWarningDoubleParameter
implements WarningParameterAPI,
DependentParameterAPI {
    protected static final String C = "TranslatedWarningDoubleParameter";
    protected static final boolean D = false;
    protected TranslatorAPI trans = new LogTranslator();
    protected boolean translate = true;
    protected WarningDoubleParameter param = null;

    public boolean isTranslate() {
        return this.translate;
    }

    public void setTranslate(boolean translate) {
        this.translate = translate;
    }

    public TranslatedWarningDoubleParameter(WarningDoubleParameter param) {
        this.param = param;
    }

    public TranslatedWarningDoubleParameter(TranslatorAPI trans) {
        this(null, trans);
    }

    public TranslatedWarningDoubleParameter(WarningDoubleParameter param, TranslatorAPI trans) {
        this.trans = trans;
        this.param = param;
    }

    public void setParameter(WarningDoubleParameter param) {
        this.param = param;
    }

    public WarningDoubleParameter getParameter() {
        return this.param;
    }

    public Object getWarningMin() throws TranslateException, Exception {
        Double min = (Double)this.param.getWarningMin();
        if (min == null || !this.translate) {
            return min;
        }
        return new Double(this.trans.reverse(min));
    }

    public boolean isAllowed(Object value) {
        if (value == null || value instanceof Double || !this.translate) {
            return this.param.isAllowed(value);
        }
        double d = (Double)value;
        return this.param.isAllowed(this.trans.translate(d));
    }

    public Object getWarningMax() throws TranslateException {
        Double max = (Double)this.param.getWarningMax();
        if (max == null || !this.translate) {
            return max;
        }
        return new Double(this.trans.reverse(max));
    }

    public synchronized void setValue(Object value) throws ConstraintException, WarningException {
        String S = this.getName() + ": setValue(): ";
        if (value == null || !this.translate || !(value instanceof Double)) {
            this.param.setValue(value);
        } else {
            Double dUntranslated = (Double)value;
            Double dTranslated = new Double(this.trans.translate(dUntranslated));
            if (!this.param.isAllowed(dTranslated)) {
                String err = S + "Value is not allowed: ";
                if (value != null) {
                    err = err + dUntranslated.toString();
                }
                throw new ConstraintException(err);
            }
            if (!this.param.isRecommended(dTranslated)) {
                ParameterChangeWarningEvent event = new ParameterChangeWarningEvent(this, this, this.getValue(), dUntranslated);
                this.fireParameterChangeWarning(event);
                throw new WarningException(S + "Value is not recommended: " + dUntranslated.toString());
            }
            this.param.setValue(dTranslated);
            ParameterChangeEvent event = new ParameterChangeEvent(this, this.getName(), this.getValue(), value);
            this.firePropertyChange(event);
        }
    }

    public void unableToSetValue(Object value) throws ConstraintException {
        this.param.unableToSetValue(value);
    }

    public Object getValue() {
        Object value = this.param.getValue();
        if (value == null || !this.translate || !(value instanceof Double)) {
            return value;
        }
        double d = (Double)value;
        d = this.trans.reverse(d);
        return new Double(d);
    }

    public void setValueIgnoreWarning(Object value) throws ConstraintException, ParameterException {
        String S = "TranslatedWarningDoubleParameter: setValueIgnoreWarning(): ";
        if (value == null || !this.translate || !(value instanceof Double)) {
            this.param.setValueIgnoreWarning(value);
        } else {
            double d = this.trans.translate((Double)value);
            this.param.setValueIgnoreWarning(new Double(d));
        }
    }

    public boolean isRecommended(Object obj) {
        if (obj == null || !this.translate || !(obj instanceof Double)) {
            return this.param.isRecommended(obj);
        }
        double d = this.trans.translate((Double)obj);
        return this.param.isRecommended(new Double(d));
    }

    public Double getMin() throws Exception {
        Double min = this.param.getMin();
        if (min == null || !this.translate) {
            return min;
        }
        return new Double(this.trans.reverse(min));
    }

    public Double getMax() {
        Double max = this.param.getMax();
        if (max == null || !this.translate) {
            return max;
        }
        return new Double(this.trans.reverse(max));
    }

    public void setIgnoreWarning(boolean ignoreWarning) {
        this.param.setIgnoreWarning(ignoreWarning);
    }

    public boolean isIgnoreWarning() {
        return this.param.isIgnoreWarning();
    }

    public void setWarningConstraint(ParameterConstraint warningConstraint) {
        this.param.setWarningConstraint(warningConstraint);
    }

    public ParameterConstraint getWarningConstraint() throws ParameterException {
        return this.param.getWarningConstraint();
    }

    public void addParameterChangeWarningListener(ParameterChangeWarningListener listener) {
        this.param.addParameterChangeWarningListener(listener);
    }

    public void removeParameterChangeWarningListener(ParameterChangeWarningListener listener) {
        this.param.removeParameterChangeWarningListener(listener);
    }

    public synchronized void addParameterChangeFailListener(ParameterChangeFailListener listener) {
        this.param.addParameterChangeFailListener(listener);
    }

    public synchronized void removeParameterChangeFailListener(ParameterChangeFailListener listener) {
        this.param.removeParameterChangeFailListener(listener);
    }

    public synchronized void addParameterChangeListener(ParameterChangeListener listener) {
        this.param.addParameterChangeListener(listener);
    }

    public synchronized void removeParameterChangeListener(ParameterChangeListener listener) {
        this.param.removeParameterChangeListener(listener);
    }

    public void firePropertyChange(ParameterChangeEvent event) {
        this.param.firePropertyChange(event);
    }

    public void firePropertyChangeFailed(ParameterChangeFailEvent event) {
        this.param.firePropertyChangeFailed(event);
    }

    public void fireParameterChangeWarning(ParameterChangeWarningEvent event) {
        this.param.fireParameterChangeWarning(event);
    }

    public boolean equals(Object obj) throws ClassCastException {
        return this.param.equals(obj);
    }

    public Object clone() {
        TranslatedWarningDoubleParameter param1 = new TranslatedWarningDoubleParameter((WarningDoubleParameter)this.param.clone());
        param1.setTranslate(this.translate);
        return param1;
    }

    public ListIterator getIndependentParametersIterator() {
        return this.param.getIndependentParametersIterator();
    }

    public ParameterAPI getIndependentParameter(String name) throws ParameterException {
        return this.param.getIndependentParameter(name);
    }

    public void setIndependentParameters(ParameterList list) {
        this.param.setIndependentParameters(list);
    }

    public void addIndependentParameter(ParameterAPI parameter) throws ParameterException {
        this.param.addIndependentParameter(parameter);
    }

    public boolean containsIndependentParameter(String name) {
        return this.param.containsIndependentParameter(name);
    }

    public void removeIndependentParameter(String name) throws ParameterException {
        this.param.removeIndependentParameter(name);
    }

    public String getIndependentParametersKey() {
        return this.param.getIndependentParametersKey();
    }

    public String getName() {
        return this.param.getName();
    }

    public void setName(String name) {
        this.param.setName(name);
    }

    public String getConstraintName() {
        return this.param.getConstraintName();
    }

    public ParameterConstraintAPI getConstraint() {
        if (this.param.getConstraint() == null || !this.translate) {
            return this.param.getConstraint();
        }
        DoubleConstraint constraint = (DoubleConstraint)this.param.getConstraint();
        double transMin = this.trans.reverse(constraint.getMin());
        double transMax = this.trans.reverse(constraint.getMax());
        DoubleConstraint constraint2 = new DoubleConstraint(transMin, transMax);
        return constraint2;
    }

    public void setConstraint(ParameterConstraintAPI constraint) {
        this.param.setConstraint(constraint);
    }

    public String getUnits() {
        return this.param.getUnits();
    }

    public void setUnits(String units) {
        this.param.setUnits(units);
    }

    public String getInfo() {
        return this.param.getInfo();
    }

    public void setInfo(String info) {
        this.param.setInfo(info);
    }

    public String getType() {
        return C;
    }

    public int compareTo(Object parameter) throws ClassCastException {
        return this.param.compareTo(parameter);
    }

    public boolean isEditable() {
        return this.param.isEditable();
    }

    public void setNonEditable() {
        this.param.setNonEditable();
    }

    public String getMetadataString() {
        return this.getName() + " = " + this.getValue().toString();
    }

    public String getDependentParamMetadataString() {
        StringBuffer metadata = new StringBuffer();
        metadata.append(this.getName() + " [ ");
        ListIterator list = this.getIndependentParametersIterator();
        while (list.hasNext()) {
            ParameterAPI tempParam = (ParameterAPI)list.next();
            metadata.append(tempParam.getMetadataString() + " ; ");
        }
        metadata.replace(metadata.length() - 2, metadata.length(), " ]");
        return metadata.toString();
    }

    public boolean isNullAllowed() {
        return this.param.isNullAllowed();
    }

    public TranslatorAPI getTrans() {
        return this.trans;
    }
}

