/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param;

import java.io.Serializable;
import java.util.ListIterator;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.DoubleParameter;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterList;
import org.opensha.param.ParameterListParameter;

public class TreeBranchWeightsParameter
extends ParameterListParameter
implements Serializable {
    protected static final String C = "TreeBranchWeightsParameter";
    protected static final boolean D = false;
    protected static final String PARAM_TYPE = "TreeBranchWeightsParameter";
    private double tolerance = 0.01;

    public TreeBranchWeightsParameter(String name) {
        super(name);
    }

    public TreeBranchWeightsParameter(String name, ParameterList paramList) {
        super(name, paramList);
    }

    public void setTolerence(double tolerance) {
        this.tolerance = tolerance;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setValue(ParameterList value) throws ParameterException {
        ListIterator it = value.getParametersIterator();
        while (it.hasNext()) {
            ParameterAPI param = (ParameterAPI)it.next();
            if (param instanceof DoubleParameter) continue;
            throw new RuntimeException("TreeBranchWeightsParameter Only DoubleParameter allowed in this Parameter");
        }
        this.setValue((Object)value);
    }

    public boolean isAllowed(Object obj) {
        if (obj == null && this.isNullAllowed()) {
            return true;
        }
        return obj instanceof ParameterList;
    }

    public boolean doWeightsSumToOne(ParameterList paramList) {
        ListIterator it = paramList.getParametersIterator();
        double paramsSum = 0.0;
        while (it.hasNext()) {
            paramsSum += ((Double)((ParameterAPI)it.next()).getValue()).doubleValue();
        }
        return this.isInTolerence(paramsSum);
    }

    private boolean isInTolerence(double num) {
        return num <= 1.0 + this.tolerance && num >= 1.0 - this.tolerance;
    }

    public String getType() {
        String type = "TreeBranchWeightsParameter";
        return type;
    }
}

