/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param;

import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.EditableException;
import org.opensha.exceptions.ParameterException;
import org.opensha.exceptions.WarningException;
import org.opensha.param.IntegerConstraint;
import org.opensha.param.IntegerParameter;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterConstraint;
import org.opensha.param.WarningParameterAPI;
import org.opensha.param.event.ParameterChangeEvent;
import org.opensha.param.event.ParameterChangeWarningEvent;
import org.opensha.param.event.ParameterChangeWarningListener;

public class WarningIntegerParameter
extends IntegerParameter
implements WarningParameterAPI {
    protected static final String C = "WarningIntegerParameter";
    protected static final boolean D = false;
    protected IntegerConstraint warningConstraint = null;
    protected transient ArrayList warningListeners = null;
    private boolean ignoreWarning;

    public WarningIntegerParameter(String name) {
        super(name);
    }

    public WarningIntegerParameter(String name, String units) {
        super(name, units);
    }

    public WarningIntegerParameter(String name, int min, int max) throws ConstraintException {
        super(name, min, max);
    }

    public WarningIntegerParameter(String name, int min, int max, String units) throws ConstraintException {
        super(name, min, max, units);
    }

    public WarningIntegerParameter(String name, Integer min, Integer max) throws ConstraintException {
        super(name, min, max);
    }

    public WarningIntegerParameter(String name, Integer min, Integer max, String units) throws ConstraintException {
        super(name, min, max, units);
    }

    public WarningIntegerParameter(String name, IntegerConstraint constraint) throws ConstraintException {
        super(name, constraint);
    }

    public WarningIntegerParameter(String name, IntegerConstraint constraint, String units) throws ConstraintException {
        super(name, constraint, units);
    }

    public WarningIntegerParameter(String name, Integer value) {
        super(name, value);
    }

    public WarningIntegerParameter(String name, String units, Integer value) throws ConstraintException {
        super(name, units, value);
    }

    public WarningIntegerParameter(String name, int min, int max, Integer value) throws ConstraintException {
        super(name, min, max, value);
    }

    public WarningIntegerParameter(String name, IntegerConstraint constraint, Integer value) throws ConstraintException {
        super(name, constraint, value);
    }

    public WarningIntegerParameter(String name, int min, int max, String units, Integer value) throws ConstraintException {
        super(name, min, max, units, value);
    }

    public WarningIntegerParameter(String name, Integer min, Integer max, String units, Integer value) throws ConstraintException {
        super(name, min, max, units, value);
    }

    public WarningIntegerParameter(String name, IntegerConstraint constraint, String units, Integer value) throws ConstraintException {
        super(name, constraint, units, value);
    }

    public synchronized void addParameterChangeWarningListener(ParameterChangeWarningListener listener) throws EditableException {
        String S = "WarningIntegerParameter: addParameterChangeWarningListener(): ";
        if (this.warningListeners == null) {
            this.warningListeners = new ArrayList();
        }
        if (!this.warningListeners.contains(listener)) {
            this.warningListeners.add(listener);
        }
    }

    public synchronized void removeParameterChangeWarningListener(ParameterChangeWarningListener listener) throws EditableException {
        String S = "WarningIntegerParameter: removeParameterChangeWarningListener(): ";
        if (this.warningListeners != null && this.warningListeners.contains(listener)) {
            this.warningListeners.remove(listener);
        }
    }

    public void setWarningConstraint(ParameterConstraint warningConstraint) throws ParameterException, EditableException {
        String S = "WarningIntegerParameter: setWarningConstraint(): ";
        this.checkEditable(S);
        this.warningConstraint = (IntegerConstraint)warningConstraint;
    }

    public ParameterConstraint getWarningConstraint() throws ParameterException {
        return this.warningConstraint;
    }

    public Object getWarningMin() throws Exception {
        if (this.warningConstraint != null) {
            return this.warningConstraint.getMin();
        }
        return null;
    }

    public Object getWarningMax() {
        if (this.warningConstraint != null) {
            return this.warningConstraint.getMax();
        }
        return null;
    }

    public synchronized void setValue(Object value) throws ConstraintException, WarningException {
        String S = this.getName() + ": setValue(): ";
        if (!this.isAllowed(value)) {
            String err = S + "Value is not allowed: ";
            if (value != null) {
                err = err + value.toString();
            }
            throw new ConstraintException(err);
        }
        if (value == null) {
            this.value = null;
        } else {
            if (!this.ignoreWarning && !this.isRecommended(value)) {
                ParameterChangeWarningEvent event = new ParameterChangeWarningEvent(this, this, this.value, value);
                this.fireParameterChangeWarning(event);
                throw new WarningException(S + "Value is not recommended: " + value.toString());
            }
            this.value = value;
            ParameterChangeEvent event = new ParameterChangeEvent(this, this.getName(), this.getValue(), value);
            this.firePropertyChange(event);
        }
    }

    public void setValueIgnoreWarning(Object value) throws ConstraintException, ParameterException {
        String S = "WarningIntegerParameter: setValueIgnoreWarning(): ";
        this.value = value;
    }

    public boolean isRecommended(Object obj) {
        if (this.warningConstraint != null) {
            return this.warningConstraint.isAllowed(obj);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireParameterChangeWarning(ParameterChangeWarningEvent event) {
        ArrayList vector;
        String S = "WarningIntegerParameter: firePropertyChange(): ";
        WarningIntegerParameter warningIntegerParameter = this;
        synchronized (warningIntegerParameter) {
            if (this.warningListeners == null) {
                return;
            }
            vector = (ArrayList)this.warningListeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ParameterChangeWarningListener listener = (ParameterChangeWarningListener)vector.get(i);
            listener.parameterChangeWarning(event);
        }
    }

    public int compareTo(Object obj) throws ClassCastException {
        String S = "WarningIntegerParameter:compareTo(): ";
        if (!(obj instanceof IntegerParameter) && !(obj instanceof WarningIntegerParameter)) {
            throw new ClassCastException(S + "Object not a IntegerParameter, WarningIntegerParameter, or IntegerDiscreteParameter, unable to compare");
        }
        boolean result = false;
        Integer n1 = (Integer)this.getValue();
        Integer n2 = null;
        if (obj instanceof IntegerParameter) {
            IntegerParameter param = (IntegerParameter)obj;
            n2 = (Integer)param.getValue();
        } else if (obj instanceof WarningIntegerParameter) {
            WarningIntegerParameter param = (WarningIntegerParameter)obj;
            n2 = (Integer)param.getValue();
        }
        return n1.compareTo(n2);
    }

    public boolean equals(Object obj) throws ClassCastException {
        String S = "WarningIntegerParameter:equals(): ";
        if (!(obj instanceof IntegerParameter) && !(obj instanceof WarningIntegerParameter)) {
            throw new ClassCastException(S + "Object not a IntegerParameter, WarningIntegerParameter, or IntegerDiscreteParameter, unable to compare");
        }
        String otherName = ((IntegerParameter)obj).getName();
        return this.compareTo(obj) == 0 && this.getName().equals(otherName);
    }

    public Object clone() {
        String S = "WarningIntegerParameter:clone(): ";
        IntegerConstraint c1 = null;
        IntegerConstraint c2 = null;
        if (this.constraint != null) {
            c1 = (IntegerConstraint)this.constraint.clone();
        }
        if (this.warningConstraint != null) {
            c2 = (IntegerConstraint)this.warningConstraint.clone();
        }
        WarningIntegerParameter param = null;
        param = this.value == null ? new WarningIntegerParameter(this.name, c1, this.units) : new WarningIntegerParameter(this.name, c1, this.units, new Integer(this.value.toString()));
        if (param == null) {
            return null;
        }
        param.setWarningConstraint(c2);
        ListIterator it = this.getIndependentParametersIterator();
        while (it.hasNext()) {
            ParameterAPI p1 = (ParameterAPI)it.next();
            ParameterAPI p2 = (ParameterAPI)p1.clone();
            param.addIndependentParameter(p2);
        }
        if (this.warningListeners != null) {
            it = this.warningListeners.listIterator();
            while (it.hasNext()) {
                ParameterChangeWarningListener listener = (ParameterChangeWarningListener)it.next();
                param.addParameterChangeWarningListener(listener);
            }
        }
        param.setInfo(this.info);
        param.setIgnoreWarning(this.ignoreWarning);
        param.editable = true;
        return param;
    }

    public void setIgnoreWarning(boolean ignoreWarning) {
        this.ignoreWarning = ignoreWarning;
    }

    public boolean isIgnoreWarning() {
        return this.ignoreWarning;
    }
}

