/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.opensha.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.DataPoint2DException;
import org.opensha.param.ArbitrarilyDiscretizedFuncParameter;
import org.opensha.param.ParameterAPI;
import org.opensha.param.editor.ParameterEditor;

public class ArbitrarilyDiscretizedFuncParameterEditor
extends ParameterEditor {
    protected static final String C = "DiscretizedFuncParameterEditor";
    protected static final boolean D = false;
    private static final String ONE_XY_VAL_MSG = "Each line should have exactly one X and one Y value";
    private static final String XY_VALID_MSG = "X and Y Values entered must be valid numbers";
    protected static final Dimension WIGET_PANEL_DIM = new Dimension(140, 230);
    protected static final Dimension SCROLLPANE_DIM = new Dimension(70, 215);
    protected static final GridBagConstraints WIDGET_GBC = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 5, 0, 1), 0, 0);
    protected static final GridBagConstraints WIDGET_PANEL_GBC = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, ZERO_INSETS, 0, 0);
    private JTextArea xValsTextArea;
    private JTextArea yValsTextArea;
    private boolean isFocusListenerForX = false;

    public ArbitrarilyDiscretizedFuncParameterEditor() {
    }

    public ArbitrarilyDiscretizedFuncParameterEditor(ParameterAPI model) throws Exception {
        super(model);
        String S = "DiscretizedFuncParameterEditor: Constructor(model): ";
    }

    public void setXEnabled(boolean isEnabled) {
        this.xValsTextArea.setEnabled(isEnabled);
    }

    protected void addWidget() {
        String S = "DiscretizedFuncParameterEditor: addWidget(): ";
        String xLabelText = "";
        String yLabelText = "";
        ArbitrarilyDiscretizedFunc function = (ArbitrarilyDiscretizedFunc)this.model.getValue();
        if (function != null) {
            if (function.getXAxisName() != null) {
                xLabelText = function.getXAxisName();
            }
            if (function.getYAxisName() != null) {
                yLabelText = function.getYAxisName();
            }
        }
        JLabel xLabel = new JLabel(xLabelText);
        JLabel yLabel = new JLabel(yLabelText);
        this.xValsTextArea = new JTextArea();
        JScrollPane xScrollPane = new JScrollPane(this.xValsTextArea);
        xScrollPane.setMinimumSize(SCROLLPANE_DIM);
        xScrollPane.setPreferredSize(SCROLLPANE_DIM);
        this.widgetPanel.add((Component)xLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.widgetPanel.add((Component)xScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.yValsTextArea = new JTextArea();
        this.yValsTextArea.addFocusListener(this);
        JScrollPane yScrollPane = new JScrollPane(this.yValsTextArea);
        yScrollPane.setMinimumSize(SCROLLPANE_DIM);
        yScrollPane.setPreferredSize(SCROLLPANE_DIM);
        this.widgetPanel.add((Component)yLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.widgetPanel.add((Component)yScrollPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.widgetPanel.setBackground(null);
        this.widgetPanel.validate();
        this.widgetPanel.repaint();
    }

    protected void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createLineBorder(FORE_COLOR, 1), "");
        this.titledBorder1.setTitleColor(FORE_COLOR);
        this.titledBorder1.setTitleFont(DEFAULT_LABEL_FONT);
        this.titledBorder1.setTitle("Parameter Name");
        this.border1 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(0, 0, 3, 0));
        this.setLayout(GBL);
        this.outerPanel.setLayout(GBL);
        this.outerPanel.setBorder(this.border1);
        this.widgetPanel.setLayout(GBL);
        this.widgetPanel.setMinimumSize(WIGET_PANEL_DIM);
        this.widgetPanel.setPreferredSize(WIGET_PANEL_DIM);
        this.nameLabel.setMaximumSize(LABEL_DIM);
        this.nameLabel.setMinimumSize(LABEL_DIM);
        this.nameLabel.setPreferredSize(LABEL_DIM);
        this.nameLabel.setHorizontalAlignment(2);
        this.nameLabel.setHorizontalTextPosition(2);
        this.nameLabel.setText("This is the Label");
        this.nameLabel.setFont(DEFAULT_LABEL_FONT);
        this.outerPanel.add((Component)this.widgetPanel, WIDGET_PANEL_GBC);
        this.add((Component)this.outerPanel, OUTER_PANEL_GBC);
    }

    public void focusLost(FocusEvent e) throws ConstraintException {
        String S = "DiscretizedFuncParameterEditor: focusLost(): ";
        super.focusLost(e);
        this.focusLostProcessing = false;
        if (this.keyTypeProcessing) {
            return;
        }
        this.focusLostProcessing = true;
        this.setValueInParameter();
        if (!this.isFocusListenerForX) {
            this.xValsTextArea.addFocusListener(this);
            this.isFocusListenerForX = true;
        }
        this.focusLostProcessing = false;
    }

    private void setValueInParameter() throws DataPoint2DException, HeadlessException, NumberFormatException {
        String xValsStr = this.xValsTextArea.getText();
        String yValsStr = this.yValsTextArea.getText();
        ArbitrarilyDiscretizedFunc function = (ArbitrarilyDiscretizedFunc)this.model.getValue();
        function.clear();
        StringTokenizer xStringTokenizer = new StringTokenizer(xValsStr, "\n");
        StringTokenizer yStringTokenizer = new StringTokenizer(yValsStr, "\n");
        while (xStringTokenizer.hasMoreTokens()) {
            double tempX_Val = 0.0;
            double tempY_Val = 0.0;
            try {
                tempX_Val = Double.parseDouble(xStringTokenizer.nextToken());
                tempY_Val = Double.parseDouble(yStringTokenizer.nextToken());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, XY_VALID_MSG);
                return;
            }
            function.set(tempX_Val, tempY_Val);
        }
        if (yStringTokenizer.hasMoreTokens()) {
            JOptionPane.showMessageDialog(this, ONE_XY_VAL_MSG);
        }
        this.refreshParamEditor();
    }

    public void setParameter(ParameterAPI model) {
        String S = "DiscretizedFuncParameterEditor: setParameter(): ";
        if (model != null && !(model instanceof ArbitrarilyDiscretizedFuncParameter)) {
            throw new RuntimeException(S + "Input model parameter must be a DiscretizedFuncParameter.");
        }
        super.setParameter(model);
        this.xValsTextArea.setToolTipText("No Constraints");
        this.yValsTextArea.setToolTipText("No Constraints");
        String info = model.getInfo();
        if (info != null && !info.equals("")) {
            this.nameLabel.setToolTipText(info);
        } else {
            this.nameLabel.setToolTipText(null);
        }
    }

    public void refreshParamEditor() {
        ArbitrarilyDiscretizedFunc func = (ArbitrarilyDiscretizedFunc)this.model.getValue();
        if (func != null) {
            this.xValsTextArea.setText("");
            this.yValsTextArea.setText("");
            int num = func.getNum();
            String xText = "";
            String yText = "";
            for (int i = 0; i < num; ++i) {
                xText = xText + func.getX(i) + "\n";
                yText = yText + func.getY(i) + "\n";
            }
            this.xValsTextArea.setText(xText);
            this.yValsTextArea.setText(yText);
        } else {
            this.xValsTextArea.setText("");
            this.yValsTextArea.setText("");
        }
        this.repaint();
    }

    public void setEnabled(boolean isEnabled) {
        this.xValsTextArea.setEnabled(isEnabled);
        this.yValsTextArea.setEnabled(isEnabled);
    }
}

