/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.editor;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.border.Border;
import org.opensha.exceptions.ConstraintException;
import org.opensha.param.DoubleDiscreteConstraint;
import org.opensha.param.DoubleDiscreteParameter;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterConstraintAPI;
import org.opensha.param.editor.ParameterEditor;

public class ConstrainedDoubleDiscreteParameterEditor
extends ParameterEditor
implements ItemListener {
    protected static final String C = "ConstrainedDoubleDiscreteParameterEditor";
    protected static final boolean D = false;

    public ConstrainedDoubleDiscreteParameterEditor() {
    }

    public ConstrainedDoubleDiscreteParameterEditor(ParameterAPI model) throws ConstraintException {
        super(model);
        String S = "ConstrainedDoubleDiscreteParameterEditor: Constructor(model): ";
        this.setParameter(model);
    }

    public void setParameter(ParameterAPI model) throws ConstraintException {
        String S = "ConstrainedDoubleDiscreteParameterEditor: setParameter(): ";
        this.verifyModel(model);
        this.model = model;
        String name = model.getName();
        Object value = model.getValue();
        this.removeWidget();
        this.addWidget();
        this.setWidgetObject(name, value);
        this.setNameLabelToolTip(model.getInfo());
    }

    private void verifyModel(ParameterAPI model) throws ConstraintException {
        String S = "ConstrainedDoubleDiscreteParameterEditor: Constructor(model): ";
        if (model == null) {
            throw new ConstraintException(S + "Input Parameter model cannot be null");
        }
        if (!(model instanceof DoubleDiscreteParameter)) {
            throw new ConstraintException(S + "Input model parameter must be a DoubleDiscreteParameter.");
        }
        ParameterConstraintAPI constraint = model.getConstraint();
        if (!(constraint instanceof DoubleDiscreteConstraint)) {
            throw new ConstraintException(S + "Input model constraints must be a DoubleDiscreteConstraint.");
        }
        int numConstriants = ((DoubleDiscreteConstraint)constraint).size();
        if (numConstriants < 1) {
            throw new ConstraintException(S + "There are no constraints present, unable to build editor selection list.");
        }
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    protected void setWidgetObject(String name, Object obj) {
        String S = "ConstrainedDoubleDiscreteParameterEditor: setWidgetObject(): ";
        super.setWidgetObject(name, obj);
        if (obj != null && this.valueEditor != null && this.valueEditor instanceof JComboBox) {
            ((JComboBox)this.valueEditor).setSelectedItem(obj.toString());
        }
    }

    public void setWidgetBorder(Border b) {
    }

    protected void addWidget() {
        String S = "ConstrainedDoubleDiscreteParameterEditor: addWidget(): ";
        if (this.model != null) {
            DoubleDiscreteConstraint con = (DoubleDiscreteConstraint)((DoubleDiscreteParameter)this.model).getConstraint();
            ListIterator it = con.listIterator();
            Vector<String> strs = new Vector<String>();
            while (it.hasNext()) {
                String str = it.next().toString();
                if (strs.contains(str)) continue;
                strs.add(str);
            }
            if (strs.size() > 1) {
                this.valueEditor = new JComboBox(strs);
                this.valueEditor.setPreferredSize(JCOMBO_DIM);
                this.valueEditor.setMinimumSize(JCOMBO_DIM);
                this.valueEditor.setFont(JCOMBO_FONT);
                ((JComboBox)this.valueEditor).addItemListener(this);
                ((JComboBox)this.valueEditor).addFocusListener(this);
                this.widgetPanel.add((Component)this.valueEditor, COMBO_WIDGET_GBC);
            } else {
                this.valueEditor = ConstrainedDoubleDiscreteParameterEditor.makeConstantEditor(strs.get(0).toString());
                this.widgetPanel.setBackground(STRING_BACK_COLOR);
                this.widgetPanel.add((Component)this.valueEditor, WIDGET_GBC);
            }
        }
    }

    public void refreshParamEditor() {
        Object obj;
        if (this.valueEditor instanceof JComboBox && (obj = this.model.getValue()) != null) {
            ((JComboBox)this.valueEditor).setSelectedItem(obj.toString());
        }
    }

    public void itemStateChanged(ItemEvent e) {
        String S = "ConstrainedDoubleDiscreteParameterEditor: itemStateChanged(): ";
        String value = ((JComboBox)this.valueEditor).getSelectedItem().toString();
        Double d = new Double(value);
        this.setValue(d);
    }

    public void focusGained(FocusEvent e) {
        String S = "ConstrainedDoubleDiscreteParameterEditor: focusGained(): ";
        super.focusGained(e);
    }

    public void focusLost(FocusEvent e) {
        String S = "ConstrainedDoubleDiscreteParameterEditor: focusLost(): ";
        super.focusLost(e);
    }
}

