/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.editor;

import java.awt.Color;
import javax.swing.border.Border;
import org.opensha.param.DoubleConstraint;
import org.opensha.param.ParameterAPI;
import org.opensha.param.WarningParameterAPI;
import org.opensha.param.editor.DoubleParameterEditor;
import org.opensha.param.editor.NumericTextField;
import org.opensha.util.ParamUtils;

public class ConstrainedDoubleParameterEditor
extends DoubleParameterEditor {
    protected static final String C = "ConstrainedDoubleParameterEditor";
    protected static final boolean D = false;

    public ConstrainedDoubleParameterEditor() {
    }

    public ConstrainedDoubleParameterEditor(ParameterAPI model) throws Exception {
        super(model);
        this.setParameter(model);
    }

    public void setParameter(ParameterAPI model) {
        String S = "ConstrainedDoubleParameterEditor: setParameter(): ";
        super.setParameter(model);
        this.setToolTipText();
        this.setNameLabelToolTip(model.getInfo());
    }

    public void setWidgetBorder(Border b) {
        ((NumericTextField)this.valueEditor).setBorder(b);
    }

    protected void addWidget() {
        String S = "ConstrainedDoubleParameterEditorConstrainedDoubleParameterEditor: addWidget(): ";
        super.addWidget();
        DoubleConstraint constraint = this.getConstraint();
        if (constraint.getMax().doubleValue() == constraint.getMin().doubleValue() && this.valueEditor != null) {
            ((NumericTextField)this.valueEditor).setEditable(false);
            ((NumericTextField)this.valueEditor).setMinimumSize(LABEL_DIM);
            ((NumericTextField)this.valueEditor).setFont(JCOMBO_FONT);
            ((NumericTextField)this.valueEditor).setForeground(Color.blue);
            ((NumericTextField)this.valueEditor).setBorder(CONST_BORDER);
            this.widgetPanel.setBackground(STRING_BACK_COLOR);
            this.widgetPanel.setForeground(Color.blue);
        }
    }

    protected DoubleConstraint getConstraint() {
        DoubleConstraint constraint;
        if (ParamUtils.isWarningParameterAPI(this.model)) {
            constraint = (DoubleConstraint)((WarningParameterAPI)this.model).getWarningConstraint();
            if (constraint == null) {
                constraint = (DoubleConstraint)this.model.getConstraint();
            }
        } else {
            constraint = (DoubleConstraint)this.model.getConstraint();
        }
        return constraint;
    }

    public void refreshParamEditor() {
        super.refreshParamEditor();
        this.setToolTipText();
    }

    private void setToolTipText() {
        DoubleConstraint constraint = this.getConstraint();
        this.valueEditor.setToolTipText("Min = " + constraint.getMin().toString() + "; Max = " + constraint.getMax().toString());
    }
}

