/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.editor;

import java.awt.Color;
import org.opensha.param.IntegerConstraint;
import org.opensha.param.ParameterAPI;
import org.opensha.param.WarningParameterAPI;
import org.opensha.param.editor.IntegerParameterEditor;
import org.opensha.param.editor.IntegerTextField;
import org.opensha.util.ParamUtils;

public class ConstrainedIntegerParameterEditor
extends IntegerParameterEditor {
    protected static final String C = "ConstrainedIntegerParameterEditor";
    protected static final boolean D = false;

    public ConstrainedIntegerParameterEditor() {
    }

    public ConstrainedIntegerParameterEditor(ParameterAPI model) throws Exception {
        super(model);
        this.setParameter(model);
    }

    public void setParameter(ParameterAPI model) {
        String S = "ConstrainedIntegerParameterEditor: setParameter(): ";
        super.setParameter(model);
        this.setToolTipText();
        this.setNameLabelToolTip(model.getInfo());
    }

    protected void addWidget() {
        String S = "ConstrainedIntegerParameterEditorConstrainedDoubleParameterEditor: addWidget(): ";
        super.addWidget();
        IntegerConstraint constraint = this.getConstraint();
        if (constraint.getMax().doubleValue() == constraint.getMin().doubleValue() && this.valueEditor != null) {
            ((IntegerTextField)this.valueEditor).setEditable(false);
            ((IntegerTextField)this.valueEditor).setMinimumSize(LABEL_DIM);
            ((IntegerTextField)this.valueEditor).setFont(JCOMBO_FONT);
            ((IntegerTextField)this.valueEditor).setForeground(Color.blue);
            ((IntegerTextField)this.valueEditor).setBorder(CONST_BORDER);
            this.widgetPanel.setBackground(STRING_BACK_COLOR);
            this.widgetPanel.setForeground(Color.blue);
        }
    }

    protected IntegerConstraint getConstraint() {
        IntegerConstraint constraint;
        if (ParamUtils.isWarningParameterAPI(this.model)) {
            constraint = (IntegerConstraint)((WarningParameterAPI)this.model).getWarningConstraint();
            if (constraint == null) {
                constraint = (IntegerConstraint)this.model.getConstraint();
            }
        } else {
            constraint = (IntegerConstraint)this.model.getConstraint();
        }
        return constraint;
    }

    public void refreshParamEditor() {
        super.refreshParamEditor();
        this.setToolTipText();
    }

    private void setToolTipText() {
        IntegerConstraint constraint = this.getConstraint();
        this.valueEditor.setToolTipText("Min = " + constraint.getMin().toString() + "; Max = " + constraint.getMax().toString());
    }
}

