/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.editor;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import org.opensha.data.Location;
import org.opensha.exceptions.ConstraintException;
import org.opensha.param.LocationConstraint;
import org.opensha.param.LocationParameter;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterConstraintAPI;
import org.opensha.param.editor.ParameterEditor;

public class ConstrainedLocationParameterEditor
extends ParameterEditor
implements ItemListener {
    protected static final String C = "ConstrainedLocationParameterEditor";
    protected static final boolean D = false;

    public ConstrainedLocationParameterEditor() {
        String S = "ConstrainedLocationParameterEditor: Constructor(): ";
    }

    public ConstrainedLocationParameterEditor(ParameterAPI model) throws ConstraintException {
        super(model);
        String S = "ConstrainedLocationParameterEditor: Constructor(model): ";
        this.setParameter(model);
    }

    public void setParameter(ParameterAPI model) {
        String S = "ConstrainedLocationParameterEditor: setParameter(): ";
        this.verifyModel(model);
        this.model = model;
        String name = model.getName();
        Object value = model.getValue();
        this.removeWidget();
        this.addWidget();
        this.setWidgetObject(name, value);
    }

    private void verifyModel(ParameterAPI model) throws ConstraintException {
        String S = "ConstrainedLocationParameterEditor: Constructor(model): ";
        if (model == null) {
            throw new NullPointerException(S + "Input Parameter model cannot be null");
        }
        if (!(model instanceof LocationParameter)) {
            throw new ConstraintException(S + "Input model parameter must be a LocationParameter.");
        }
        ParameterConstraintAPI constraint = model.getConstraint();
        if (!(constraint instanceof LocationConstraint)) {
            throw new ConstraintException(S + "Input model constraints must be a LocationConstraint.");
        }
        int numConstriants = ((LocationConstraint)constraint).size();
        if (numConstriants < 1) {
            throw new ConstraintException(S + "There are no constraints present, unable to build editor selection list.");
        }
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    protected void setWidgetObject(String name, Object obj) {
        String S = "ConstrainedLocationParameterEditor: setWidgetObject(): ";
        super.setWidgetObject(name, obj);
        if (obj != null && this.valueEditor != null && this.valueEditor instanceof JComboBox) {
            ((JComboBox)this.valueEditor).setSelectedItem(obj.toString());
        }
    }

    protected void addWidget() {
        String S = "ConstrainedLocationParameterEditor: addWidget(): ";
        if (this.model != null) {
            LocationConstraint con = (LocationConstraint)((LocationParameter)this.model).getConstraint();
            ListIterator it = con.listIterator();
            Vector<String> strs = new Vector<String>();
            while (it.hasNext()) {
                String str = it.next().toString();
                if (strs.contains(str)) continue;
                strs.add(str);
            }
            if (strs.size() > 1) {
                this.valueEditor = new JComboBox(strs);
                this.valueEditor.setPreferredSize(JCOMBO_DIM);
                this.valueEditor.setMinimumSize(JCOMBO_DIM);
                this.valueEditor.setFont(JCOMBO_FONT);
                ((JComboBox)this.valueEditor).addItemListener(this);
                this.valueEditor.addFocusListener(this);
                this.widgetPanel.add((Component)this.valueEditor, COMBO_WIDGET_GBC);
                this.widgetPanel.setBackground(null);
                this.widgetPanel.validate();
                this.widgetPanel.repaint();
            } else {
                this.valueEditor = ConstrainedLocationParameterEditor.makeConstantEditor(strs.get(0).toString());
                this.widgetPanel.setBackground(STRING_BACK_COLOR);
                this.widgetPanel.add((Component)this.valueEditor, WIDGET_GBC);
            }
        }
    }

    public void refreshParamEditor() {
        Object obj;
        if (this.valueEditor instanceof JComboBox && (obj = this.model.getValue()) != null) {
            ((JComboBox)this.valueEditor).setSelectedItem(obj);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        String S = "ConstrainedLocationParameterEditor: itemStateChanged(): ";
        String value = (String)((JComboBox)this.valueEditor).getSelectedItem();
        StringTokenizer str = new StringTokenizer(value, ",");
        double lat = Double.parseDouble(str.nextToken().trim());
        double lon = Double.parseDouble(str.nextToken().trim());
        double depth = Double.parseDouble(str.nextToken().trim());
        Location loc = new Location(lat, lon, depth);
        this.setValue(loc);
    }

    public void setValue(Location loc) {
        ((LocationParameter)this.model).setValue(loc);
    }

    public void focusGained(FocusEvent e) {
        super.focusGained(e);
    }

    public void focusLost(FocusEvent e) {
        super.focusLost(e);
    }
}

