/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.opensha.data.Location;
import org.opensha.param.LocationParameter;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterList;
import org.opensha.param.ParameterListParameter;
import org.opensha.param.editor.ParameterEditor;
import org.opensha.param.editor.ParameterListEditor;
import org.opensha.param.event.ParameterChangeEvent;
import org.opensha.param.event.ParameterChangeListener;

public class LocationParameterEditor
extends ParameterEditor
implements ActionListener,
ParameterChangeListener {
    protected static final String C = "LocationParameterEditor";
    private LocationParameter param;
    private ParameterListEditor editor;
    private boolean parameterChangeFlag = true;
    protected JDialog frame;
    private boolean showEditorAsPanel = false;
    protected static final Dimension WIGET_PANEL_DIM = new Dimension(140, 220);

    public LocationParameterEditor() {
    }

    public LocationParameterEditor(ParameterAPI model) {
        this(model, false);
    }

    public LocationParameterEditor(ParameterAPI model, boolean showEditorAsPanel) {
        this.showEditorAsPanel = showEditorAsPanel;
        try {
            this.jbInit();
            this.setParameter(model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
    }

    public void setParameter(ParameterAPI param) {
        int fillConstraint;
        this.setParameterInEditor(param);
        this.param = (LocationParameter)param;
        this.initParamListAndEditor();
        if (!this.showEditorAsPanel) {
            this.valueEditor = new JButton(param.getName());
            ((JButton)this.valueEditor).addActionListener(this);
            fillConstraint = 2;
            this.editor.setTitle("Set " + param.getName());
        } else {
            this.valueEditor = this.editor;
            fillConstraint = 1;
            this.valueEditor.setMinimumSize(WIGET_PANEL_DIM);
            this.valueEditor.setPreferredSize(WIGET_PANEL_DIM);
            this.editor.setTitle(param.getName());
        }
        this.add((Component)this.valueEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, fillConstraint, new Insets(0, 0, 0, 0), 0, 0));
        String S = "LocationParameterEditor: Constructor(): ";
    }

    public void parameterChange(ParameterChangeEvent event) {
        this.parameterChangeFlag = true;
    }

    protected void initParamListAndEditor() {
        ParameterList paramList = (ParameterList)((ParameterListParameter)this.param.getLocationParameter()).getValue();
        ListIterator it = paramList.getParametersIterator();
        while (it.hasNext()) {
            ((ParameterAPI)it.next()).addParameterChangeListener(this);
        }
        this.editor = new ParameterListEditor(paramList);
    }

    protected void button_actionPerformed(ActionEvent e) {
        if (this.parameterChangeFlag) {
            Location loc = new Location(this.param.getLatitude(), this.param.getLongitude(), this.param.getDepth());
            this.param.setValue(loc);
        }
        this.frame.dispose();
    }

    public void setEditorTitle(String title) {
        this.editor.setTitle(title);
    }

    public void setEnabled(boolean isEnabled) {
        this.editor.setEnabled(isEnabled);
    }

    public void setParameterVisible(String parameterName, boolean visible) {
        this.editor.setParameterVisible(parameterName, visible);
    }

    public void refreshParamEditor() {
        this.editor.refreshParamEditor();
    }

    public ParameterAPI getParameter(String paramName) {
        return this.editor.getParameterList().getParameter(paramName);
    }

    public ParameterList getParameterList() {
        return this.editor.getParameterList();
    }

    public void actionPerformed(ActionEvent ae) {
        this.frame = new JDialog();
        this.frame.setModal(true);
        this.frame.setSize(300, 400);
        this.frame.setTitle(this.param.getName());
        this.frame.getContentPane().setLayout(new GridBagLayout());
        this.frame.getContentPane().add((Component)this.editor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        JButton button = new JButton();
        button.setText("Update " + this.param.getName());
        button.setForeground(new Color(80, 80, 133));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LocationParameterEditor.this.button_actionPerformed(e);
            }
        });
        this.frame.getContentPane().add((Component)button, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.frame.setVisible(true);
        this.frame.pack();
    }
}

