/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterList;
import org.opensha.param.ParameterListParameter;
import org.opensha.param.editor.ParameterEditor;
import org.opensha.param.editor.ParameterListEditor;
import org.opensha.param.event.ParameterChangeEvent;
import org.opensha.param.event.ParameterChangeListener;

public class ParameterListParameterEditor
extends ParameterEditor
implements ActionListener,
ParameterChangeListener {
    protected static final String C = "ParameterListParameterEditor";
    protected static final boolean D = false;
    private Insets defaultInsets = new Insets(4, 4, 4, 4);
    protected ParameterListParameter param;
    protected ParameterListEditor editor;
    protected JDialog frame;
    protected boolean parameterChangeFlag = true;

    public ParameterListParameterEditor() {
    }

    public ParameterListParameterEditor(ParameterAPI model) {
        super(model);
    }

    public void setParameter(ParameterAPI param) {
        this.setParameterInEditor(param);
        this.valueEditor = new JButton(param.getName());
        ((JButton)this.valueEditor).addActionListener(this);
        this.add((Component)this.valueEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        String S = "ParameterListParameterEditor: Constructor(): ";
        this.param = (ParameterListParameter)param;
        this.initParamListAndEditor();
    }

    protected void initParamListAndEditor() {
        ParameterList paramList = (ParameterList)this.param.getValue();
        ListIterator it = paramList.getParametersIterator();
        while (it.hasNext()) {
            ((ParameterAPI)it.next()).addParameterChangeListener(this);
        }
        this.editor = new ParameterListEditor(paramList);
        this.editor.setTitle("Set " + this.param.getName());
    }

    public void setEnabled(boolean isEnabled) {
        this.editor.setEnabled(isEnabled);
    }

    public void setEditorTitle(String title) {
        this.editor.setTitle(title);
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
    }

    public void setParameterVisible(String parameterName, boolean visible) {
        this.editor.setParameterVisible(parameterName, visible);
    }

    public void refreshParamEditor() {
        this.editor.refreshParamEditor();
    }

    public ParameterAPI getParameter(String paramName) {
        return this.editor.getParameterList().getParameter(paramName);
    }

    public ParameterList getParameterList() {
        return this.editor.getParameterList();
    }

    public void parameterChange(ParameterChangeEvent event) {
        this.parameterChangeFlag = true;
    }

    public void actionPerformed(ActionEvent ae) {
        this.frame = new JDialog();
        this.frame.setModal(true);
        this.frame.setSize(300, 400);
        this.frame.setTitle(this.param.getName());
        this.frame.getContentPane().setLayout(new GridBagLayout());
        this.frame.getContentPane().add((Component)this.editor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        JButton button = new JButton();
        button.setText("Update " + this.param.getName());
        button.setForeground(new Color(80, 80, 133));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParameterListParameterEditor.this.button_actionPerformed(e);
            }
        });
        this.frame.getContentPane().add((Component)button, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.frame.setVisible(true);
        this.frame.pack();
    }

    protected void button_actionPerformed(ActionEvent e) {
        ParameterList paramList = this.editor.getParameterList();
        if (this.parameterChangeFlag) {
            this.param.setValue(paramList);
            this.parameterChangeFlag = false;
        }
        this.frame.dispose();
    }
}

