/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.editor;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.WarningException;
import org.opensha.param.ParameterAPI;
import org.opensha.param.StringParameter;
import org.opensha.param.editor.ParameterEditor;

public class StringParameterEditor
extends ParameterEditor {
    protected static final String C = "StringParameterEditor";
    protected static final boolean D = false;

    public StringParameterEditor() {
    }

    public StringParameterEditor(ParameterAPI model) throws Exception {
        super(model);
        if (model != null && !(model instanceof StringParameter)) {
            String S = "StringParameterEditor: Constructor(model): ";
            throw new Exception(S + "Input model parameter must be a StringParameter.");
        }
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    protected void setWidgetObject(String name, Object obj) {
        super.setWidgetObject(name, obj);
        if (obj != null && this.valueEditor != null) {
            ((JTextField)this.valueEditor).setText(obj.toString());
        }
    }

    public void setWidgetBorder(Border b) {
        ((JTextField)this.valueEditor).setBorder(b);
    }

    protected void addWidget() {
        this.valueEditor = new JTextField();
        this.valueEditor.setPreferredSize(LABEL_DIM);
        this.valueEditor.setMinimumSize(LABEL_DIM);
        this.valueEditor.setBorder(ETCHED);
        this.valueEditor.addFocusListener(this);
        this.valueEditor.addKeyListener(this);
        ((JTextField)this.valueEditor).setText("Enter data here");
        this.widgetPanel.add((Component)this.valueEditor, ParameterEditor.WIDGET_GBC);
    }

    public void keyTyped(KeyEvent e) {
        String S = "StringParameterEditor: keyTyped(): ";
        super.keyTyped(e);
        this.keyTypeProcessing = false;
        if (this.focusLostProcessing) {
            return;
        }
        if (e.getKeyChar() == '\n') {
            this.keyTypeProcessing = true;
            String value = ((JTextField)this.valueEditor).getText();
            try {
                String d = "";
                if (!value.equals("")) {
                    d = value;
                }
                this.setValue(d);
                this.refreshParamEditor();
                this.valueEditor.validate();
                this.valueEditor.repaint();
            }
            catch (ConstraintException ee) {
                Object obj = this.getValue();
                if (obj != null) {
                    ((JTextField)this.valueEditor).setText(obj.toString());
                } else {
                    ((JTextField)this.valueEditor).setText("");
                }
                if (!this.catchConstraint) {
                    this.unableToSetValue(value);
                }
                this.keyTypeProcessing = false;
            }
            catch (WarningException ee) {
                this.keyTypeProcessing = false;
                this.refreshParamEditor();
                this.valueEditor.validate();
                this.valueEditor.repaint();
            }
        }
        this.keyTypeProcessing = false;
    }

    public void focusLost(FocusEvent e) {
        String S = "StringParameterEditor: focusLost(): ";
        super.focusLost(e);
        this.focusLostProcessing = false;
        if (this.keyTypeProcessing) {
            return;
        }
        this.focusLostProcessing = true;
        String value = ((JTextField)this.valueEditor).getText();
        try {
            String d = "";
            if (!value.equals("")) {
                d = value;
            }
            this.setValue(d);
            this.refreshParamEditor();
            this.valueEditor.validate();
            this.valueEditor.repaint();
        }
        catch (ConstraintException ee) {
            Object obj = this.getValue();
            if (obj != null) {
                ((JTextField)this.valueEditor).setText(obj.toString());
            } else {
                ((JTextField)this.valueEditor).setText("");
            }
            if (!this.catchConstraint) {
                this.unableToSetValue(value);
            }
            this.focusLostProcessing = false;
        }
        catch (WarningException ee) {
            this.focusLostProcessing = false;
            this.refreshParamEditor();
            this.valueEditor.validate();
            this.valueEditor.repaint();
        }
        this.focusLostProcessing = false;
    }

    public void setParameter(ParameterAPI model) {
        String S = "StringParameterEditor: setParameter(): ";
        super.setParameter(model);
        ((JTextField)this.valueEditor).setToolTipText("No Constraints");
    }

    public void refreshParamEditor() {
        Object obj = this.model.getValue();
        if (obj != null) {
            ((JTextField)this.valueEditor).setText(obj.toString());
        }
    }
}

