/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.editor;

import javax.swing.border.Border;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.DoubleConstraint;
import org.opensha.param.ParameterAPI;
import org.opensha.param.TranslatedWarningDoubleParameter;
import org.opensha.param.WarningParameterAPI;
import org.opensha.param.editor.ConstrainedDoubleParameterEditor;
import org.opensha.param.editor.NumericTextField;
import org.opensha.param.event.ParameterChangeFailEvent;
import org.opensha.param.translate.TranslatorAPI;
import org.opensha.util.ParamUtils;

public class TranslatedWarningDoubleParameterEditor
extends ConstrainedDoubleParameterEditor {
    protected static final String C = "TranslatedWarningDoubleParameterEditor";
    protected static final boolean D = false;

    public TranslatedWarningDoubleParameterEditor() {
    }

    public TranslatedWarningDoubleParameterEditor(ParameterAPI model) throws Exception {
        super(model);
    }

    public void setParameter(ParameterAPI model) throws ParameterException {
        String S = "TranslatedWarningDoubleParameterEditor: setParameter(): ";
        if (model == null) {
            throw new NullPointerException(S + "Input Parameter data cannot be null");
        }
        this.model = model;
        String name = "";
        name = model.getName();
        Object value = model.getValue();
        this.removeWidget();
        this.addWidget();
        this.setWidgetObject(name, value);
        if (model instanceof TranslatedWarningDoubleParameter) {
            TranslatedWarningDoubleParameter param1 = (TranslatedWarningDoubleParameter)model;
            try {
                this.valueEditor.setToolTipText("Min = " + param1.getWarningMin().toString() + "; Max = " + param1.getWarningMax().toString());
                this.setNameLabelToolTip(model.getInfo());
            }
            catch (Exception e) {
                throw new ParameterException(e.toString());
            }
        } else if (ParamUtils.isWarningParameterAPI(model)) {
            DoubleConstraint constraint = (DoubleConstraint)((WarningParameterAPI)model).getWarningConstraint();
            if (constraint == null) {
                constraint = (DoubleConstraint)model.getConstraint();
            }
            this.valueEditor.setToolTipText("Min = " + constraint.getMin().toString() + "; Max = " + constraint.getMax().toString());
            this.setNameLabelToolTip(model.getInfo());
        } else {
            DoubleConstraint constraint = (DoubleConstraint)model.getConstraint();
            this.valueEditor.setToolTipText("Min = " + constraint.getMin().toString() + "; Max = " + constraint.getMax().toString());
            this.setNameLabelToolTip(model.getInfo());
        }
    }

    public void setWidgetBorder(Border b) {
        ((NumericTextField)this.valueEditor).setBorder(b);
    }

    public void unableToSetValue(Object value) throws ConstraintException {
        TranslatedWarningDoubleParameter param;
        TranslatorAPI trans;
        Object obj;
        String S = "TranslatedWarningDoubleParameterEditor: unableToSetValue():";
        if (value instanceof String) {
            try {
                value = new Double(value.toString());
            }
            catch (NumberFormatException ee) {
                // empty catch block
            }
        }
        if (value != null && this.model != null && value instanceof Double && (obj = this.model.getValue()) != null && obj instanceof Double && this.model instanceof TranslatedWarningDoubleParameter && ((trans = (param = (TranslatedWarningDoubleParameter)this.model).getTrans()) != null || param.isTranslate())) {
            Double dUntranslated = (Double)value;
            Double dTranslated = new Double(trans.translate(dUntranslated));
            Double oldUntranslated = (Double)param.getValue();
            if (!dUntranslated.toString().equals(oldUntranslated.toString())) {
                ParameterChangeFailEvent event = new ParameterChangeFailEvent(param, param.getName(), oldUntranslated, dUntranslated);
                param.firePropertyChangeFailed(event);
            }
        }
    }
}

