/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.editor.document;

import java.text.ParseException;
import java.text.ParsePosition;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntegerPlainDocument
extends PlainDocument {
    protected static final String C = "IntegerPlainDocument";
    protected static final boolean D = false;
    protected int min = Integer.MIN_VALUE;
    protected int max = Integer.MAX_VALUE;
    protected ParsePosition parsePos = new ParsePosition(0);
    protected InsertErrorListener errorListener;

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        block8: {
            String originalModel = this.getText(0, this.getLength());
            if (str != null) {
                if (this.getLength() == 0 && str.charAt(0) == '-') {
                    super.insertString(offset, str, a);
                } else {
                    try {
                        int i = new Integer(str);
                        if (i >= this.min && i <= this.max) {
                            super.insertString(offset, str, a);
                        } else if (this.errorListener != null) {
                            String s = "IntegerPlainDocument: insertString(): Integer value " + i + " > max(" + this.max + ") or min(" + this.min + ')';
                            this.errorListener.insertFailed(this, offset, str, a, s);
                        }
                    }
                    catch (NumberFormatException e) {
                        if (this.errorListener == null) break block8;
                        this.errorListener.insertFailed(this, offset, str, a, e.toString());
                    }
                }
            }
        }
    }

    public void addInsertErrorListener(InsertErrorListener l) {
        if (this.errorListener != null) {
            throw new IllegalArgumentException("IntegerPlainDocumentaddInsertErrorListenerInsert(): ErrorListener already registered");
        }
        this.errorListener = l;
    }

    public void removeInsertErrorListener(InsertErrorListener l) {
        if (this.errorListener == l) {
            this.errorListener = null;
        }
    }

    public Integer getIntegerValue() throws ParseException {
        String S = "IntegerPlainDocument: getIntegerValue(): ";
        try {
            String context = this.getText(0, this.getLength());
            this.parsePos.setIndex(0);
            Integer result = new Integer(context);
            if (this.parsePos.getIndex() != this.getLength()) {
                throw new ParseException(S + "Not a valid number: " + context, 0);
            }
            return result;
        }
        catch (BadLocationException e) {
            throw new ParseException(S + "Not a valid number: ", 0);
        }
        catch (NumberFormatException e) {
            throw new ParseException(S + "Model String cannot be converted to an Integer", 0);
        }
    }

    public static interface InsertErrorListener {
        public void insertFailed(IntegerPlainDocument var1, int var2, String var3, AttributeSet var4, String var5);
    }
}

