/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.editor.estimate;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.opensha.data.estimate.DiscreteValueEstimate;
import org.opensha.data.estimate.Estimate;
import org.opensha.data.estimate.FractileListEstimate;
import org.opensha.data.estimate.IntegerEstimate;
import org.opensha.data.estimate.InvalidParamValException;
import org.opensha.data.estimate.LogNormalEstimate;
import org.opensha.data.estimate.MinMaxPrefEstimate;
import org.opensha.data.estimate.NormalEstimate;
import org.opensha.data.estimate.PDF_Estimate;
import org.opensha.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.data.function.DiscretizedFunc;
import org.opensha.data.function.EvenlyDiscretizedFunc;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.ArbitrarilyDiscretizedFuncParameter;
import org.opensha.param.DoubleParameter;
import org.opensha.param.EvenlyDiscretizedFuncParameter;
import org.opensha.param.Parameter;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterList;
import org.opensha.param.StringParameter;
import org.opensha.param.editor.ParameterEditor;
import org.opensha.param.editor.ParameterListEditor;
import org.opensha.param.editor.estimate.HtmlEstimateSummaryListener;
import org.opensha.param.editor.estimate.TextEstimateSummaryListener;
import org.opensha.param.estimate.EstimateConstraint;
import org.opensha.param.estimate.EstimateParameter;
import org.opensha.param.event.ParameterChangeEvent;
import org.opensha.param.event.ParameterChangeFailEvent;
import org.opensha.param.event.ParameterChangeFailListener;
import org.opensha.param.event.ParameterChangeListener;
import org.opensha.sha.gui.infoTools.EstimateViewer;

public class ConstrainedEstimateParameterEditor
extends ParameterEditor
implements ParameterChangeListener,
ParameterChangeFailListener,
ActionListener {
    private EstimateParameter estimateParam;
    private ParameterList parameterList;
    private ParameterListEditor editor;
    public static final String ESTIMATE_TITLE = new String("Estimates");
    private StringParameter chooseEstimateParam;
    private static final String CHOOSE_ESTIMATE_PARAM_NAME = "Estimate Type";
    private DoubleParameter meanParam;
    private static final String MEAN_PARAM_NAME_PREFIX = "Mean ";
    private String meanParamName;
    private DoubleParameter stdDevParam;
    private static final String STD_DEV_PARAM_NAME_PREFIX = "Std Dev ";
    private String stdDevParamName;
    private DoubleParameter linearMedianParam;
    private static final String LINEAR_MEDIAN_PARAM_NAME_PREFIX = "Linear Median ";
    private String linearMedianParamName;
    private DoubleParameter sigmaLowerTruncationParam;
    private static final String LOWER_SIGMA_PARAM_NAME = "Lower Truncation (# of sigmas)";
    private DoubleParameter sigmaUpperTruncationParam;
    private static final String UPPER_SIGMA_PARAM_NAME = "Upper Truncation (# of sigmas)";
    private DoubleParameter absoluteLowerTruncationParam;
    private static final String ABOLUTE_LOWER_PARAM_NAME = "Absolute Lower Truncation";
    private DoubleParameter absoluteUpperTruncationParam;
    private static final String ABOLUTE_UPPER_PARAM_NAME = "Absolute Upper Truncation";
    private static final String TRUNCATION_TYPE_PARAM_NAME = "Truncation Type";
    private static final String TRUNCATION_NONE = "None";
    private static final String TRUNCATED_ABSOLUTE = "Truncated (absolute limits)";
    private static final String TRUNCATED_NUM_SIGMAS = "Truncated (number of sigmas)";
    private StringParameter truncationTypeParam;
    private StringParameter logBaseParam;
    private static final String LOG_BASE_PARAM_NAME = "Log Base";
    private static final String LOG_BASE_10_NAME = "10";
    private static final String NATURAL_LOG_NAME = "E";
    private ArbitrarilyDiscretizedFuncParameter arbitrarilyDiscFuncParam;
    private static final String XY_PARAM_NAME_SUFFIX = " Values/Probabilities";
    private String xyParamName;
    private EvenlyDiscretizedFuncParameter evenlyDiscFuncParam;
    private static final String PDF_PARAM_NAME_SUFFIX = "Evenly Discretized Values";
    private String pdfParamName;
    private JButton viewEstimateButton;
    private DoubleParameter minX_Param;
    private static final String MIN_X_PARAM_NAME_PREFIX = "Min ";
    private String minXParamName;
    private DoubleParameter maxX_Param;
    private static final String MAX_X_PARAM_NAME_PREFIX = "Max ";
    private String maxXParamName;
    private DoubleParameter prefferedX_Param;
    private static final String PREF_X_PARAM_NAME_PREFIX = "Preferred ";
    private String preferredXParamName;
    private DoubleParameter minProbParam;
    private String minProbParamName;
    private DoubleParameter maxProbParam;
    private String maxProbParamName;
    private DoubleParameter prefferedProbParam;
    private String prefferedProbParamName;
    private ParameterListEditor xValsParamListEditor;
    private ParameterListEditor probValsParamListEditor;
    public static final String X_TITLE_SUFFIX = new String(" Values");
    public static final String PROB_TITLE = new String("Probability this value is correct");
    protected static final Dimension WIGET_PANEL_DIM = new Dimension(140, 300);
    private JButton button;
    private JFrame frame;
    private boolean showEditorAsPanel = false;
    private EstimateConstraint estimateConstraint;
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.###");
    private static final String MSG_VALUE_MISSING_SUFFIX = " value is missing ";

    public ConstrainedEstimateParameterEditor() {
    }

    public ConstrainedEstimateParameterEditor(ParameterAPI model) {
        this(model, false);
    }

    public ConstrainedEstimateParameterEditor(ParameterAPI model, boolean showEditorAsPanel) {
        this.model = model;
        this.showEditorAsPanel = showEditorAsPanel;
        try {
            this.jbInit();
            this.setParameter(model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setParameter(ParameterAPI param) {
        Estimate estimate;
        Container container;
        String S = "ParameterEditor: Constructor(): ";
        this.estimateParam = (EstimateParameter)param;
        this.initParamListAndEditor();
        this.setLayout(GBL);
        if (!this.showEditorAsPanel) {
            this.frame = new JFrame();
            this.frame.setTitle(this.estimateParam.getName());
            this.button = new JButton(this.estimateParam.getName());
            this.button.addActionListener(this);
            this.add((Component)this.button, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            container = this.frame.getContentPane();
            container.setLayout(GBL);
        } else {
            container = this;
        }
        container.add((Component)this.editor, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)this.xValsParamListEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        container.add((Component)this.probValsParamListEditor, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        container.add((Component)this.viewEstimateButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setEstimateParams((String)this.chooseEstimateParam.getValue());
        if (this.model != null && (estimate = (Estimate)this.model.getValue()) != null) {
            this.setEstimateValue(estimate);
        }
        this.editor.refreshParamEditor();
        this.updateUI();
    }

    private void setEstimateValue(Estimate estimate) {
        if (estimate instanceof NormalEstimate) {
            this.setNormalEstimateVals((NormalEstimate)estimate);
        } else if (estimate instanceof LogNormalEstimate) {
            this.setLogNormalEstimateVals((LogNormalEstimate)estimate);
        } else if (estimate instanceof FractileListEstimate) {
            this.setFractileListVals((FractileListEstimate)estimate);
        } else if (estimate instanceof MinMaxPrefEstimate) {
            this.setMinMaxPrefVals((MinMaxPrefEstimate)estimate);
        } else if (estimate instanceof PDF_Estimate) {
            this.setPDF_EstimateVals((PDF_Estimate)estimate);
        } else if (estimate instanceof DiscreteValueEstimate) {
            this.setDiscreteEstimateVals((DiscreteValueEstimate)estimate);
        } else if (estimate instanceof IntegerEstimate) {
            this.setIntegerEstimateVals((IntegerEstimate)estimate);
        }
    }

    private void setNormalEstimateVals(NormalEstimate normalEstimate) {
        this.chooseEstimateParam.setValue("Normal (Gaussian)");
        this.meanParam.setValue(normalEstimate.getMean());
        this.stdDevParam.setValue(normalEstimate.getStdDev());
        this.absoluteLowerTruncationParam.setValue(normalEstimate.getMin());
        this.absoluteUpperTruncationParam.setValue(normalEstimate.getMax());
        Double estimateConstraintMin = this.estimateConstraint.getMin();
        Double estimateConstraintMax = this.estimateConstraint.getMax();
        if (estimateConstraintMin != null && estimateConstraintMax != null && (normalEstimate.getMin() != estimateConstraintMin.doubleValue() || normalEstimate.getMax() != estimateConstraintMax.doubleValue())) {
            this.truncationTypeParam.setValue(TRUNCATED_ABSOLUTE);
        }
        this.sigmaLowerTruncationParam.setValue(normalEstimate.getMinSigma());
        this.sigmaUpperTruncationParam.setValue(normalEstimate.getMaxSigma());
    }

    private void setLogNormalEstimateVals(LogNormalEstimate logNormalEstimate) {
        this.chooseEstimateParam.setValue("Log Normal");
        this.linearMedianParam.setValue(logNormalEstimate.getLinearMedian());
        this.stdDevParam.setValue(logNormalEstimate.getStdDev());
        this.absoluteLowerTruncationParam.setValue(logNormalEstimate.getMin());
        this.absoluteUpperTruncationParam.setValue(logNormalEstimate.getMax());
        Double estimateConstraintMin = this.estimateConstraint.getMin();
        Double estimateConstraintMax = this.estimateConstraint.getMax();
        if (estimateConstraintMin != null && estimateConstraintMax != null && (logNormalEstimate.getMin() != estimateConstraintMin.doubleValue() || logNormalEstimate.getMax() != estimateConstraintMax.doubleValue())) {
            this.truncationTypeParam.setValue(TRUNCATED_ABSOLUTE);
        }
        this.sigmaLowerTruncationParam.setValue(logNormalEstimate.getMinSigma());
        this.sigmaUpperTruncationParam.setValue(logNormalEstimate.getMaxSigma());
        if (logNormalEstimate.getIsBase10()) {
            this.logBaseParam.setValue(LOG_BASE_10_NAME);
        } else {
            this.logBaseParam.setValue(NATURAL_LOG_NAME);
        }
    }

    private void setFractileListVals(FractileListEstimate fractileListEstimate) {
        this.chooseEstimateParam.setValue("Fractile List");
        DiscretizedFunc func = fractileListEstimate.getValues();
        this.minX_Param.setValue(func.getX(0));
        this.prefferedX_Param.setValue(func.getX(1));
        this.maxX_Param.setValue(func.getX(2));
        this.minProbParam.setValue(func.getY(0));
        this.prefferedProbParam.setValue(func.getY(1));
        this.maxProbParam.setValue(func.getY(2));
        this.xValsParamListEditor.refreshParamEditor();
        this.probValsParamListEditor.refreshParamEditor();
    }

    private void setMinMaxPrefVals(MinMaxPrefEstimate minMaxPrefEstimate) {
        double maxProb;
        double prefProb;
        double minProb;
        double maxX;
        double prefX;
        this.chooseEstimateParam.setValue("Min, Max and Preferred");
        double minX = minMaxPrefEstimate.getMinimum();
        if (!Double.isNaN(minX)) {
            this.minX_Param.setValue(new Double(decimalFormat.format(minX)));
        }
        if (!Double.isNaN(prefX = minMaxPrefEstimate.getPreferred())) {
            this.prefferedX_Param.setValue(new Double(decimalFormat.format(prefX)));
        }
        if (!Double.isNaN(maxX = minMaxPrefEstimate.getMaximum())) {
            this.maxX_Param.setValue(new Double(decimalFormat.format(maxX)));
        }
        if (!Double.isNaN(minProb = minMaxPrefEstimate.getMinimumProb())) {
            this.minProbParam.setValue(new Double(decimalFormat.format(minProb)));
        }
        if (!Double.isNaN(prefProb = minMaxPrefEstimate.getPreferredProb())) {
            this.prefferedProbParam.setValue(new Double(decimalFormat.format(prefProb)));
        }
        if (!Double.isNaN(maxProb = minMaxPrefEstimate.getMaximumProb())) {
            this.maxProbParam.setValue(new Double(decimalFormat.format(maxProb)));
        }
        this.xValsParamListEditor.refreshParamEditor();
        this.probValsParamListEditor.refreshParamEditor();
    }

    private void setDiscreteEstimateVals(DiscreteValueEstimate discreteValEst) {
        this.chooseEstimateParam.setValue("Discrete Values");
        this.arbitrarilyDiscFuncParam.setValue(discreteValEst.getValues());
    }

    private void setIntegerEstimateVals(IntegerEstimate integerEst) {
        this.chooseEstimateParam.setValue("Integer");
        this.arbitrarilyDiscFuncParam.setValue(integerEst.getValues());
    }

    private void setPDF_EstimateVals(PDF_Estimate pdfEst) {
        this.evenlyDiscFuncParam.setValue(pdfEst.getValues());
    }

    protected void jbInit() {
        this.setMinimumSize(new Dimension(0, 0));
        this.setLayout(GBL);
    }

    public void refreshParamEditor() {
        Estimate estimate;
        if (this.model != null && (estimate = (Estimate)this.model.getValue()) != null) {
            this.setEstimateValue(estimate);
        }
        this.editor.refreshParamEditor();
        this.updateUI();
        if (this.frame != null) {
            this.frame.repaint();
        }
    }

    protected void initParamListAndEditor() {
        String S = "ParameterEditor: initControlsParamListAndEditor(): ";
        this.meanParamName = MEAN_PARAM_NAME_PREFIX;
        this.meanParam = new DoubleParameter(this.meanParamName);
        this.linearMedianParamName = LINEAR_MEDIAN_PARAM_NAME_PREFIX;
        this.linearMedianParam = new DoubleParameter(this.linearMedianParamName);
        this.stdDevParamName = STD_DEV_PARAM_NAME_PREFIX;
        this.stdDevParam = new DoubleParameter(this.stdDevParamName);
        ArbitrarilyDiscretizedFunc arbitraryDiscretizedFunc = new ArbitrarilyDiscretizedFunc();
        arbitraryDiscretizedFunc.setXAxisName("Values");
        arbitraryDiscretizedFunc.setYAxisName("Probabilities");
        this.xyParamName = XY_PARAM_NAME_SUFFIX;
        this.arbitrarilyDiscFuncParam = new ArbitrarilyDiscretizedFuncParameter(this.xyParamName, arbitraryDiscretizedFunc);
        EvenlyDiscretizedFunc evenlyDiscretizedFunc = new EvenlyDiscretizedFunc(1.0, 4.0, 7);
        evenlyDiscretizedFunc.setXAxisName("Value");
        evenlyDiscretizedFunc.setYAxisName("Probability");
        this.pdfParamName = PDF_PARAM_NAME_SUFFIX;
        this.evenlyDiscFuncParam = new EvenlyDiscretizedFuncParameter(this.pdfParamName, evenlyDiscretizedFunc);
        this.estimateConstraint = (EstimateConstraint)this.estimateParam.getConstraint();
        ArrayList allowedEstimatesList = this.estimateConstraint.getAllowedEstimateList();
        this.chooseEstimateParam = new StringParameter(CHOOSE_ESTIMATE_PARAM_NAME, allowedEstimatesList, (String)allowedEstimatesList.get(0));
        this.chooseEstimateParam.addParameterChangeListener(this);
        ArrayList<String> logBases = new ArrayList<String>();
        logBases.add(NATURAL_LOG_NAME);
        logBases.add(LOG_BASE_10_NAME);
        this.logBaseParam = new StringParameter(LOG_BASE_PARAM_NAME, logBases, (String)logBases.get(0));
        this.parameterList = new ParameterList();
        this.parameterList.addParameter(this.chooseEstimateParam);
        this.parameterList.addParameter(this.meanParam);
        this.parameterList.addParameter(this.stdDevParam);
        this.parameterList.addParameter(this.linearMedianParam);
        this.parameterList.addParameter(this.logBaseParam);
        this.parameterList.addParameter(this.arbitrarilyDiscFuncParam);
        this.parameterList.addParameter(this.evenlyDiscFuncParam);
        this.addMinMaxTruncationParams(this.estimateConstraint);
        this.editor = new ParameterListEditor(this.parameterList);
        String units = this.estimateParam.getUnits();
        String title = units != null && !units.equalsIgnoreCase("") ? this.estimateParam.getName() + " (" + units + ")" : this.estimateParam.getName();
        this.editor.setTitle(title);
        this.minXParamName = MIN_X_PARAM_NAME_PREFIX;
        this.minX_Param = new DoubleParameter(this.minXParamName);
        this.maxXParamName = MAX_X_PARAM_NAME_PREFIX;
        this.maxX_Param = new DoubleParameter(this.maxXParamName);
        this.preferredXParamName = PREF_X_PARAM_NAME_PREFIX;
        this.prefferedX_Param = new DoubleParameter(this.preferredXParamName);
        ParameterList xValsParamList = new ParameterList();
        xValsParamList.addParameter(this.minX_Param);
        xValsParamList.addParameter(this.prefferedX_Param);
        xValsParamList.addParameter(this.maxX_Param);
        this.xValsParamListEditor = new ParameterListEditor(xValsParamList);
        this.xValsParamListEditor.setTitle(X_TITLE_SUFFIX);
        this.minProbParamName = "Prob (\u2264 Min)";
        this.minProbParam = new DoubleParameter(this.minProbParamName, 0.0, 1.0);
        this.maxProbParamName = "Prob (\u2264 Max)";
        this.maxProbParam = new DoubleParameter(this.maxProbParamName, 0.0, 1.0);
        this.prefferedProbParamName = "Prob (\u2264 Preferred)";
        this.prefferedProbParam = new DoubleParameter(this.prefferedProbParamName, 0.0, 1.0);
        ParameterList probParamList = new ParameterList();
        probParamList.addParameter(this.minProbParam);
        probParamList.addParameter(this.prefferedProbParam);
        probParamList.addParameter(this.maxProbParam);
        this.probValsParamListEditor = new ParameterListEditor(probParamList);
        this.probValsParamListEditor.setTitle("Probability \u2264 Values");
        this.viewEstimateButton = new JButton("Plot Estimate");
        this.viewEstimateButton.addActionListener(this);
    }

    private void addMinMaxTruncationParams(EstimateConstraint estimateConstraint) throws ParameterException, ConstraintException {
        ArrayList<String> truncationTypeList = new ArrayList<String>();
        truncationTypeList.add(TRUNCATION_NONE);
        truncationTypeList.add(TRUNCATED_ABSOLUTE);
        truncationTypeList.add(TRUNCATED_NUM_SIGMAS);
        this.truncationTypeParam = new StringParameter(TRUNCATION_TYPE_PARAM_NAME, truncationTypeList, (String)truncationTypeList.get(0));
        this.truncationTypeParam.addParameterChangeListener(this);
        this.sigmaLowerTruncationParam = new DoubleParameter(LOWER_SIGMA_PARAM_NAME);
        this.sigmaUpperTruncationParam = new DoubleParameter(UPPER_SIGMA_PARAM_NAME);
        this.absoluteLowerTruncationParam = new DoubleParameter(ABOLUTE_LOWER_PARAM_NAME, estimateConstraint.getMin());
        this.absoluteUpperTruncationParam = new DoubleParameter(ABOLUTE_UPPER_PARAM_NAME, estimateConstraint.getMax());
        this.parameterList.addParameter(this.truncationTypeParam);
        this.parameterList.addParameter(this.sigmaLowerTruncationParam);
        this.parameterList.addParameter(this.sigmaUpperTruncationParam);
        this.parameterList.addParameter(this.absoluteLowerTruncationParam);
        this.parameterList.addParameter(this.absoluteUpperTruncationParam);
    }

    public void parameterChangeFailed(ParameterChangeFailEvent event) {
        throw new RuntimeException("Unsupported method");
    }

    public void parameterChange(ParameterChangeEvent event) {
        String paramName = event.getParameterName();
        if (paramName.equalsIgnoreCase(CHOOSE_ESTIMATE_PARAM_NAME)) {
            this.setEstimateParams((String)this.chooseEstimateParam.getValue());
            this.editor.refreshParamEditor();
            this.updateUI();
        } else if (paramName.equalsIgnoreCase(TRUNCATION_TYPE_PARAM_NAME)) {
            this.setTruncationParamsVisibility();
        }
    }

    private void setEstimateParams(String estimateName) {
        if (estimateName.equalsIgnoreCase("Normal (Gaussian)")) {
            this.setParamsForNormalEstimate();
        } else if (estimateName.equalsIgnoreCase("Log Normal")) {
            this.setParamsForLogNormalEstimate();
        } else if (estimateName.equalsIgnoreCase("Integer") || estimateName.equalsIgnoreCase("Discrete Values")) {
            this.setParamsForXY_Estimate();
        } else if (estimateName.equalsIgnoreCase("Fractile List")) {
            this.setParamsForFractileListEstimate();
        } else if (estimateName.equalsIgnoreCase("Min, Max and Preferred")) {
            this.setParamsForMinMaxPrefEstimate();
        } else if (estimateName.equalsIgnoreCase("PDF")) {
            this.setParamsForPDF_Estimate();
        }
    }

    private void setParamsForMinMaxPrefEstimate() {
        this.editor.setParameterVisible(CHOOSE_ESTIMATE_PARAM_NAME, true);
        this.editor.setParameterVisible(this.meanParamName, false);
        this.editor.setParameterVisible(this.stdDevParamName, false);
        this.editor.setParameterVisible(TRUNCATION_TYPE_PARAM_NAME, false);
        this.editor.setParameterVisible(this.linearMedianParamName, false);
        this.editor.setParameterVisible(LOG_BASE_PARAM_NAME, false);
        this.editor.setParameterVisible(this.pdfParamName, false);
        this.editor.setParameterVisible(this.xyParamName, false);
        this.setTruncationParamsVisibility();
        this.xValsParamListEditor.setVisible(true);
        this.probValsParamListEditor.setVisible(true);
        this.viewEstimateButton.setVisible(false);
    }

    private void setParamsForFractileListEstimate() {
        this.setParamsForXY_Estimate();
    }

    private void setParamsForNormalEstimate() {
        this.editor.setParameterVisible(CHOOSE_ESTIMATE_PARAM_NAME, true);
        this.editor.setParameterVisible(this.meanParamName, true);
        this.editor.setParameterVisible(this.stdDevParamName, true);
        this.editor.setParameterVisible(TRUNCATION_TYPE_PARAM_NAME, true);
        this.editor.setParameterVisible(this.linearMedianParamName, false);
        this.editor.setParameterVisible(LOG_BASE_PARAM_NAME, false);
        this.editor.setParameterVisible(this.pdfParamName, false);
        this.editor.setParameterVisible(this.xyParamName, false);
        this.setTruncationParamsVisibility();
        this.xValsParamListEditor.setVisible(false);
        this.probValsParamListEditor.setVisible(false);
        this.viewEstimateButton.setVisible(true);
    }

    private void setTruncationParamsVisibility() {
        String truncationType = (String)this.truncationTypeParam.getValue();
        String chosenEstimateName = (String)this.chooseEstimateParam.getValue();
        this.editor.setParameterVisible(this.sigmaLowerTruncationParam.getName(), false);
        this.editor.setParameterVisible(this.sigmaUpperTruncationParam.getName(), false);
        this.editor.setParameterVisible(this.absoluteLowerTruncationParam.getName(), false);
        this.editor.setParameterVisible(this.absoluteUpperTruncationParam.getName(), false);
        if (chosenEstimateName.equalsIgnoreCase("Normal (Gaussian)") || chosenEstimateName.equalsIgnoreCase("Log Normal")) {
            if (truncationType.equalsIgnoreCase(TRUNCATED_ABSOLUTE)) {
                this.editor.setParameterVisible(this.absoluteLowerTruncationParam.getName(), true);
                this.editor.setParameterVisible(this.absoluteUpperTruncationParam.getName(), true);
            } else if (truncationType.equalsIgnoreCase(TRUNCATED_NUM_SIGMAS)) {
                this.editor.setParameterVisible(this.sigmaLowerTruncationParam.getName(), true);
                this.editor.setParameterVisible(this.sigmaUpperTruncationParam.getName(), true);
            }
        }
    }

    private void setParamsForLogNormalEstimate() {
        this.editor.setParameterVisible(CHOOSE_ESTIMATE_PARAM_NAME, true);
        this.editor.setParameterVisible(this.meanParamName, false);
        this.editor.setParameterVisible(this.stdDevParamName, true);
        this.editor.setParameterVisible(this.linearMedianParamName, true);
        this.editor.setParameterVisible(LOG_BASE_PARAM_NAME, true);
        this.editor.setParameterVisible(TRUNCATION_TYPE_PARAM_NAME, true);
        this.editor.setParameterVisible(this.pdfParamName, false);
        this.editor.setParameterVisible(this.xyParamName, false);
        this.setTruncationParamsVisibility();
        this.xValsParamListEditor.setVisible(false);
        this.probValsParamListEditor.setVisible(false);
        this.viewEstimateButton.setVisible(true);
    }

    private void setParamsForPDF_Estimate() {
        this.editor.setParameterVisible(CHOOSE_ESTIMATE_PARAM_NAME, true);
        this.editor.setParameterVisible(this.meanParamName, false);
        this.editor.setParameterVisible(this.stdDevParamName, false);
        this.editor.setParameterVisible(this.linearMedianParamName, false);
        this.editor.setParameterVisible(TRUNCATION_TYPE_PARAM_NAME, false);
        this.editor.setParameterVisible(LOG_BASE_PARAM_NAME, false);
        this.editor.setParameterVisible(this.pdfParamName, true);
        this.editor.setParameterVisible(this.xyParamName, false);
        this.setTruncationParamsVisibility();
        this.xValsParamListEditor.setVisible(false);
        this.probValsParamListEditor.setVisible(false);
        this.viewEstimateButton.setVisible(true);
    }

    public void setEnabled(boolean isEnabled) {
        this.editor.setEnabled(isEnabled);
        this.xValsParamListEditor.setEnabled(isEnabled);
        this.probValsParamListEditor.setEnabled(isEnabled);
    }

    private void setParamsForXY_Estimate() {
        this.editor.setParameterVisible(CHOOSE_ESTIMATE_PARAM_NAME, true);
        this.editor.setParameterVisible(this.meanParamName, false);
        this.editor.setParameterVisible(this.stdDevParamName, false);
        this.editor.setParameterVisible(TRUNCATION_TYPE_PARAM_NAME, false);
        this.editor.setParameterVisible(this.linearMedianParamName, false);
        this.editor.setParameterVisible(LOG_BASE_PARAM_NAME, false);
        this.editor.setParameterVisible(this.pdfParamName, false);
        this.editor.setParameterVisible(this.xyParamName, true);
        this.setTruncationParamsVisibility();
        this.xValsParamListEditor.setVisible(false);
        this.probValsParamListEditor.setVisible(false);
        this.viewEstimateButton.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.viewEstimateButton) {
            try {
                this.setEstimateInParameter();
                this.viewEstimate();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, this.estimateParam + this.getName() + "\n" + ex.getMessage());
            }
        } else if (e.getSource() == this.button) {
            this.frame.pack();
            this.frame.setVisible(true);
        }
    }

    private void viewEstimate() {
        Estimate estimate = (Estimate)this.estimateParam.getValue();
        if (estimate != null) {
            EstimateViewer estimateViewer = new EstimateViewer(estimate);
        }
    }

    public void setEstimateInParameter() {
        Estimate estimate = null;
        String estimateName = (String)this.chooseEstimateParam.getValue();
        try {
            if (estimateName.equalsIgnoreCase("Normal (Gaussian)")) {
                estimate = this.setNormalEstimate();
            } else if (estimateName.equalsIgnoreCase("Log Normal")) {
                estimate = this.setLogNormalEstimate();
            } else if (estimateName.equalsIgnoreCase("Min, Max and Preferred")) {
                estimate = this.setMinMaxPrefEstimate();
            } else if (estimateName.equalsIgnoreCase("Fractile List")) {
                estimate = this.setFractileListEstimate();
            } else if (estimateName.equalsIgnoreCase("Integer")) {
                estimate = this.setIntegerEstimate();
            } else if (estimateName.equalsIgnoreCase("Discrete Values")) {
                estimate = this.setDiscreteValueEstimate();
            } else if (estimateName.equalsIgnoreCase("PDF")) {
                estimate = this.setPDF_Estimate();
            }
            estimate.setUnits(this.estimateParam.getUnits());
            this.estimateParam.setValue(estimate);
        }
        catch (Exception e) {
            throw new RuntimeException(this.estimateParam.getName() + "\n" + e.getMessage());
        }
    }

    private Estimate setNormalEstimate() {
        Double meanParamVal = (Double)this.meanParam.getValue();
        if (meanParamVal == null) {
            throw new RuntimeException(this.meanParam.getName() + MSG_VALUE_MISSING_SUFFIX);
        }
        double mean = meanParamVal;
        Double stdDevVal = (Double)this.stdDevParam.getValue();
        if (stdDevVal == null) {
            throw new RuntimeException(this.stdDevParam.getName() + MSG_VALUE_MISSING_SUFFIX);
        }
        double stdDev = stdDevVal;
        NormalEstimate estimate = new NormalEstimate(mean, stdDev);
        String truncationType = (String)this.truncationTypeParam.getValue();
        if (truncationType.equalsIgnoreCase(TRUNCATED_NUM_SIGMAS)) {
            Double lowerSigma = (Double)this.sigmaLowerTruncationParam.getValue();
            if (lowerSigma == null) {
                throw new RuntimeException(this.sigmaLowerTruncationParam.getName() + MSG_VALUE_MISSING_SUFFIX);
            }
            Double upperSigma = (Double)this.sigmaUpperTruncationParam.getValue();
            if (upperSigma == null) {
                throw new RuntimeException(this.sigmaUpperTruncationParam.getValue() + MSG_VALUE_MISSING_SUFFIX);
            }
            estimate.setMinMaxSigmas(lowerSigma, upperSigma);
        } else if (truncationType.equalsIgnoreCase(TRUNCATED_ABSOLUTE)) {
            Double absoluteMin = (Double)this.absoluteLowerTruncationParam.getValue();
            if (absoluteMin == null) {
                throw new RuntimeException(this.absoluteLowerTruncationParam.getName() + MSG_VALUE_MISSING_SUFFIX);
            }
            Double absoluteMax = (Double)this.absoluteUpperTruncationParam.getValue();
            if (absoluteMax == null) {
                throw new RuntimeException(this.absoluteUpperTruncationParam.getValue() + MSG_VALUE_MISSING_SUFFIX);
            }
            estimate.setMinMax(absoluteMin, absoluteMax);
        }
        return estimate;
    }

    private Estimate setLogNormalEstimate() {
        Double linearMedianVal = (Double)this.linearMedianParam.getValue();
        if (linearMedianVal == null) {
            throw new RuntimeException(this.linearMedianParam.getName() + MSG_VALUE_MISSING_SUFFIX);
        }
        double linearMedian = linearMedianVal;
        Double stdDevVal = (Double)this.stdDevParam.getValue();
        if (stdDevVal == null) {
            throw new RuntimeException(this.stdDevParam.getName() + MSG_VALUE_MISSING_SUFFIX);
        }
        double stdDev = stdDevVal;
        LogNormalEstimate estimate = new LogNormalEstimate(linearMedian, stdDev);
        if (this.logBaseParam.getValue().equals(LOG_BASE_10_NAME)) {
            estimate.setIsBase10(true);
        } else {
            estimate.setIsBase10(false);
        }
        String truncationType = (String)this.truncationTypeParam.getValue();
        if (truncationType.equalsIgnoreCase(TRUNCATED_NUM_SIGMAS)) {
            Double lowerSigma = (Double)this.sigmaLowerTruncationParam.getValue();
            if (lowerSigma == null) {
                throw new RuntimeException(this.sigmaLowerTruncationParam.getName() + MSG_VALUE_MISSING_SUFFIX);
            }
            Double upperSigma = (Double)this.sigmaUpperTruncationParam.getValue();
            if (upperSigma == null) {
                throw new RuntimeException(this.sigmaUpperTruncationParam.getValue() + MSG_VALUE_MISSING_SUFFIX);
            }
            estimate.setMinMaxSigmas(lowerSigma, upperSigma);
        } else {
            Double absoluteMin = (Double)this.absoluteLowerTruncationParam.getValue();
            if (absoluteMin == null) {
                throw new RuntimeException(this.absoluteLowerTruncationParam.getName() + MSG_VALUE_MISSING_SUFFIX);
            }
            Double absoluteMax = (Double)this.absoluteUpperTruncationParam.getValue();
            if (absoluteMax == null) {
                throw new RuntimeException(this.absoluteUpperTruncationParam.getValue() + MSG_VALUE_MISSING_SUFFIX);
            }
            estimate.setMinMax(absoluteMin, absoluteMax);
        }
        return estimate;
    }

    private Estimate setDiscreteValueEstimate() {
        ArbitrarilyDiscretizedFunc val = (ArbitrarilyDiscretizedFunc)this.arbitrarilyDiscFuncParam.getValue();
        if (val.getNum() == 0) {
            throw new RuntimeException(this.arbitrarilyDiscFuncParam.getName() + MSG_VALUE_MISSING_SUFFIX);
        }
        try {
            DiscreteValueEstimate estimate = new DiscreteValueEstimate(val, true);
            return estimate;
        }
        catch (InvalidParamValException e) {
            throw new RuntimeException(this.model.getName() + ":" + e.getMessage());
        }
    }

    private Estimate setIntegerEstimate() {
        ArbitrarilyDiscretizedFunc val = (ArbitrarilyDiscretizedFunc)this.arbitrarilyDiscFuncParam.getValue();
        if (val.getNum() == 0) {
            throw new RuntimeException(this.arbitrarilyDiscFuncParam.getName() + MSG_VALUE_MISSING_SUFFIX);
        }
        try {
            IntegerEstimate estimate = new IntegerEstimate(val, true);
            return estimate;
        }
        catch (InvalidParamValException e) {
            throw new RuntimeException(this.model.getName() + ":" + e.getMessage());
        }
    }

    private Estimate setPDF_Estimate() {
        try {
            PDF_Estimate estimate = new PDF_Estimate((EvenlyDiscretizedFunc)this.evenlyDiscFuncParam.getValue(), true);
            return estimate;
        }
        catch (InvalidParamValException e) {
            throw new RuntimeException(this.model.getName() + ":" + e.getMessage());
        }
    }

    private Estimate setMinMaxPrefEstimate() {
        double minX = this.getValueForParameter(this.minX_Param);
        double maxX = this.getValueForParameter(this.maxX_Param);
        double prefX = this.getValueForParameter(this.prefferedX_Param);
        if (Double.isNaN(minX) && Double.isNaN(maxX) && Double.isNaN(prefX)) {
            throw new RuntimeException("Enter atleast one of " + this.minX_Param.getName() + "," + this.maxX_Param.getName() + " or " + this.prefferedX_Param.getName());
        }
        double minProb = this.getValueForParameter(this.minProbParam);
        double maxProb = this.getValueForParameter(this.maxProbParam);
        double prefProb = this.getValueForParameter(this.prefferedProbParam);
        if (!(Double.isNaN(minProb) && Double.isNaN(maxProb) && Double.isNaN(prefProb))) {
            this.checkValidVals(minX, minProb, this.minX_Param.getName(), this.minProbParam.getName());
            this.checkValidVals(maxX, maxProb, this.maxX_Param.getName(), this.maxProbParam.getName());
            this.checkValidVals(prefX, prefProb, this.prefferedX_Param.getName(), this.prefferedProbParam.getName());
        }
        try {
            MinMaxPrefEstimate estimate = new MinMaxPrefEstimate(minX, maxX, prefX, minProb, maxProb, prefProb);
            return estimate;
        }
        catch (InvalidParamValException e) {
            throw new RuntimeException(this.model.getName() + ":" + e.getMessage());
        }
    }

    private Estimate setFractileListEstimate() {
        ArbitrarilyDiscretizedFunc val = (ArbitrarilyDiscretizedFunc)this.arbitrarilyDiscFuncParam.getValue();
        if (val.getNum() == 0) {
            throw new RuntimeException(this.arbitrarilyDiscFuncParam.getName() + MSG_VALUE_MISSING_SUFFIX);
        }
        try {
            DiscreteValueEstimate estimate = new DiscreteValueEstimate(val, true);
            return estimate;
        }
        catch (InvalidParamValException e) {
            throw new RuntimeException(this.model.getName() + ":" + e.getMessage());
        }
    }

    private void checkValidVals(double xVal, double probVal, String xParamName, String probParamName) {
        if (Double.isNaN(xVal) && !Double.isNaN(probVal)) {
            throw new RuntimeException("If " + xParamName + " is empty, " + probParamName + " is not allowed");
        }
        if (!Double.isNaN(xVal) && Double.isNaN(probVal)) {
            throw new RuntimeException(probParamName + MSG_VALUE_MISSING_SUFFIX);
        }
    }

    private double getValueForParameter(Parameter param) {
        Object val = param.getValue();
        if (val == null) {
            return Double.NaN;
        }
        return (Double)val;
    }

    private void copyFunction(DiscretizedFunc funcFrom, DiscretizedFunc funcTo) {
        int numVals = funcFrom.getNum();
        for (int i = 0; i < numVals; ++i) {
            funcTo.set(funcFrom.getX(i), funcFrom.getY(i));
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        JButton htmlSummaryButton = new JButton("View Estimate Summary(HTML)");
        JButton textSummaryButton = new JButton("Estimate toString()");
        frame.getContentPane().setLayout(new GridBagLayout());
        EstimateParameter estimateParam = new EstimateParameter("Slip Rate", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, EstimateConstraint.createConstraintForAllEstimates());
        ConstrainedEstimateParameterEditor estimateParameterEditor = new ConstrainedEstimateParameterEditor(estimateParam, true);
        htmlSummaryButton.addActionListener(new HtmlEstimateSummaryListener(estimateParameterEditor, "Slip Rate"));
        textSummaryButton.addActionListener(new TextEstimateSummaryListener(estimateParameterEditor, "Slip Rate"));
        frame.getContentPane().add((Component)estimateParameterEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        frame.getContentPane().add((Component)htmlSummaryButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        frame.getContentPane().add((Component)textSummaryButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        frame.pack();
        frame.setVisible(true);
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

