/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.estimate;

import java.util.ArrayList;
import org.opensha.data.estimate.Estimate;
import org.opensha.exceptions.EditableException;
import org.opensha.param.DoubleConstraint;
import org.opensha.param.StringConstraint;

public class EstimateConstraint
extends DoubleConstraint {
    protected static final String C = "DoubleEstimateConstraint";
    protected static final boolean D = false;
    protected StringConstraint allowedEstimateList = null;

    public EstimateConstraint() {
    }

    public EstimateConstraint(ArrayList allowedEstimateList) {
        this.setAllowedEstimateList(allowedEstimateList);
    }

    public EstimateConstraint(double min, double max) {
        this(min, max, (ArrayList)null);
    }

    public EstimateConstraint(double min, double max, ArrayList allowedEstimateList) {
        this(new Double(min), new Double(max), allowedEstimateList);
    }

    public EstimateConstraint(Double min, Double max, ArrayList allowedEstimateList) {
        super(min, max);
        this.setAllowedEstimateList(allowedEstimateList);
    }

    public void setAllowedEstimateList(ArrayList allowedEstimateList) throws EditableException {
        String S = "DoubleEstimateConstraint: setAllowedEstimateList(StringConstraint): ";
        this.checkEditable(S);
        this.allowedEstimateList = new StringConstraint(allowedEstimateList);
    }

    public ArrayList getAllowedEstimateList() {
        return this.allowedEstimateList.getAllowedStrings();
    }

    public boolean isAllowed(Object obj) {
        if (this.nullAllowed && obj == null) {
            return true;
        }
        if (!(obj instanceof Estimate)) {
            return false;
        }
        return this.isAllowed((Estimate)obj);
    }

    public boolean isAllowed(Estimate estimate) {
        if (this.allowedEstimateList == null) {
            return true;
        }
        ArrayList list = this.allowedEstimateList.getAllowedStrings();
        for (int i = 0; i < list.size(); ++i) {
            String name = (String)list.get(i);
            if (!estimate.getName().equalsIgnoreCase(name)) continue;
            Double estimateMinValue = new Double(estimate.getMin());
            Double estimateMaxValue = new Double(estimate.getMax());
            if (this.min == null && this.max == null) {
                return true;
            }
            if (this.min == null || this.max == null || estimateMinValue.compareTo(this.min) < 0 || estimateMaxValue.compareTo(this.max) > 0) break;
            return true;
        }
        return false;
    }

    public String toString() {
        String TAB = "    ";
        StringBuffer b = new StringBuffer();
        b.append(super.toString());
        if (this.allowedEstimateList != null) {
            b.append(TAB + "Allowed Estimates = " + this.allowedEstimateList.toString());
        }
        return b.toString();
    }

    public Object clone() {
        EstimateConstraint c1 = new EstimateConstraint(this.min, this.max, (ArrayList)this.allowedEstimateList.getAllowedStrings().clone());
        c1.setName(this.name);
        c1.setNullAllowed(this.nullAllowed);
        c1.editable = true;
        return c1;
    }

    public static ArrayList createConstraintForPositiveDoubleValues() {
        ArrayList<String> allowedEstimateTypes = new ArrayList<String>();
        allowedEstimateTypes.add("Normal (Gaussian)");
        allowedEstimateTypes.add("Fractile List");
        allowedEstimateTypes.add("Discrete Values");
        allowedEstimateTypes.add("Min, Max and Preferred");
        allowedEstimateTypes.add("PDF");
        return allowedEstimateTypes;
    }

    public static ArrayList createConstraintForPositiveIntValues() {
        ArrayList<String> allowedEstimateTypes = new ArrayList<String>();
        allowedEstimateTypes.add("Integer");
        return allowedEstimateTypes;
    }

    public static ArrayList createConstraintForAllEstimates() {
        ArrayList<String> allowedEstimateTypes = new ArrayList<String>();
        allowedEstimateTypes.add("Normal (Gaussian)");
        allowedEstimateTypes.add("Fractile List");
        allowedEstimateTypes.add("Discrete Values");
        allowedEstimateTypes.add("Integer");
        allowedEstimateTypes.add("Min, Max and Preferred");
        allowedEstimateTypes.add("PDF");
        return allowedEstimateTypes;
    }

    public static ArrayList createConstraintForDateEstimates() {
        ArrayList<String> allowedEstimateTypes = new ArrayList<String>();
        allowedEstimateTypes.add("Normal (Gaussian)");
        allowedEstimateTypes.add("Discrete Values");
        allowedEstimateTypes.add("Min, Max and Preferred");
        allowedEstimateTypes.add("PDF");
        return allowedEstimateTypes;
    }
}

