/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.param.estimate;

import java.util.ArrayList;
import org.opensha.data.estimate.Estimate;
import org.opensha.exceptions.ConstraintException;
import org.opensha.param.DependentParameter;
import org.opensha.param.DependentParameterAPI;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterConstraintAPI;
import org.opensha.param.estimate.EstimateConstraint;

public class EstimateParameter
extends DependentParameter
implements DependentParameterAPI,
ParameterAPI {
    protected static final String C = "EstimateParameter";
    protected static final boolean D = false;

    public EstimateParameter(String name) {
        super(name, null, null, null);
    }

    public EstimateParameter(String name, String units) throws ConstraintException {
        this(name, units, null);
    }

    public EstimateParameter(String name, Estimate value) {
        this(name, null, value);
    }

    public EstimateParameter(String name, EstimateConstraint constraint, String units, Estimate value) throws ConstraintException {
        super(name, constraint, units, value);
    }

    public EstimateParameter(String name, String units, Estimate value) throws ConstraintException {
        super(name, null, units, value);
    }

    public EstimateParameter(String name, double min, double max) {
        this(name, min, max, null);
    }

    public EstimateParameter(String name, double min, double max, ArrayList allowedEstimateTypes) {
        super(name, new EstimateConstraint(min, max, allowedEstimateTypes), null, null);
    }

    public EstimateParameter(String name, String units, double min, double max) throws ConstraintException {
        this(name, units, min, max, null);
    }

    public EstimateParameter(String name, String units, double min, double max, ArrayList allowedEstimateTypes) throws ConstraintException {
        super(name, new EstimateConstraint(min, max, allowedEstimateTypes), units, null);
    }

    public String getType() {
        String type = C;
        ParameterConstraintAPI constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + type;
        }
        return type;
    }

    public boolean isAllowed(Object val) {
        if (val != null && !(val instanceof Estimate)) {
            return false;
        }
        Estimate estimate = (Estimate)val;
        if (estimate.getUnits() == null && this.units != null) {
            return false;
        }
        if (this.units == null && estimate.getUnits() != null) {
            return false;
        }
        if (this.units != null && estimate.getUnits() != null && !this.units.equalsIgnoreCase(estimate.getUnits())) {
            return false;
        }
        return super.isAllowed(val);
    }

    public int compareTo(Object parm1) {
        throw new UnsupportedOperationException("Method compareTo() not yet implemented.");
    }

    public Object clone() {
        throw new UnsupportedOperationException("Method clone() not yet implemented.");
    }
}

