/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.infotools;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JLabel;
import org.opensha.data.estimate.DiscretizedFuncEstimate;
import org.opensha.data.estimate.Estimate;
import org.opensha.data.estimate.FractileListEstimate;
import org.opensha.data.estimate.LogNormalEstimate;
import org.opensha.data.estimate.MinMaxPrefEstimate;
import org.opensha.data.estimate.NormalEstimate;
import org.opensha.data.function.DiscretizedFunc;
import org.opensha.refFaultParamDb.data.ExactTime;
import org.opensha.refFaultParamDb.data.TimeAPI;
import org.opensha.refFaultParamDb.data.TimeEstimate;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;

public class InfoLabel
extends JLabel {
    private Color labelColor = new Color(80, 80, 133);
    private static final String ESTIMATE_TYPE = "Estimate Type";
    private static final String TIME = "Time";
    public static final String NOT_AVAILABLE = "NA";
    private static final String TIME_VAL = "Time Val";
    private static final String PROB = "Prob this is correct value";

    public InfoLabel() {
        this.setForeground(this.labelColor);
    }

    public InfoLabel(String paramName, String paramValue) {
        this();
        this.setTextAsHTML(paramName, paramValue);
    }

    public void setTextAsHTML(String paramName, String paramValue) {
        if (paramValue == null) {
            paramValue = NOT_AVAILABLE;
        }
        String label = "<html><b>" + paramName + ":&nbsp;</b>" + paramValue + "</html>";
        this.setText(label);
    }

    public InfoLabel(String value) {
        this();
        this.setTextAsHTML(value);
    }

    public void setTextAsHTML(String value) {
        if (value == null) {
            value = NOT_AVAILABLE;
        }
        String label = "<html>" + value + "</html>";
        this.setText(label);
    }

    public InfoLabel(ArrayList values) {
        this();
        this.setTextAsHTML(values);
    }

    public void setTextAsHTML(ArrayList values) {
        String label = "<html>";
        if (values == null || values.size() == 0) {
            label = label + NOT_AVAILABLE;
        } else {
            for (int i = 0; i < values.size(); ++i) {
                label = label + values.get(i).toString() + "<br>";
            }
        }
        label = label + "</html>";
        this.setText(label);
    }

    public InfoLabel(Estimate estimate, String xAxisName, String yAxisName) {
        this();
        this.setTextAsHTML(estimate, xAxisName, yAxisName);
    }

    public void setTextAsHTML(Estimate estimate, String xAxisName, String yAxisName) {
        String text = estimate == null ? "<html>NA</html>" : "<html>" + this.getTextForEstimate(estimate, xAxisName, yAxisName) + "</html>";
        this.setText(text);
    }

    private String getTextForEstimate(Estimate estimate, String xAxisName, String yAxisName) {
        String text = "";
        if (estimate instanceof NormalEstimate) {
            text = this.getTextForNormalEstimate((NormalEstimate)estimate);
        } else if (estimate instanceof LogNormalEstimate) {
            text = this.getTextForLogNormalEstimate((LogNormalEstimate)estimate);
        } else if (estimate instanceof DiscretizedFuncEstimate) {
            DiscretizedFuncEstimate discretizedFunEstimate = (DiscretizedFuncEstimate)estimate;
            discretizedFunEstimate.getValues().setXAxisName(xAxisName);
            discretizedFunEstimate.getValues().setYAxisName(yAxisName);
            text = this.getTextForDiscretizedFuncEstimate(discretizedFunEstimate);
        } else if (estimate instanceof FractileListEstimate) {
            FractileListEstimate fractileListEstimate = (FractileListEstimate)estimate;
            fractileListEstimate.getValues().setXAxisName(xAxisName);
            fractileListEstimate.getValues().setYAxisName(yAxisName);
            text = this.getTextForFractileListEstimate(fractileListEstimate);
        } else if (estimate instanceof MinMaxPrefEstimate) {
            MinMaxPrefEstimate minMaxPrefEstimate = (MinMaxPrefEstimate)estimate;
            text = this.getTextForMinMaxPrefEstimate(minMaxPrefEstimate, xAxisName, yAxisName);
        }
        return text;
    }

    public InfoLabel(TimeAPI time) {
        this.setForeground(this.labelColor);
        this.setTextAsHTML(time);
    }

    public void setTextAsHTML(TimeAPI time) {
        String text = "";
        if (time == null) {
            text = "<html>NA</html>";
        } else if (time instanceof TimeEstimate) {
            text = this.getTextForTimeEstimate((TimeEstimate)time);
        } else if (time instanceof ExactTime) {
            text = this.getTextForExactTime((ExactTime)time);
        }
        this.setText(text);
    }

    private String getTextForExactTime(ExactTime exactTime) {
        if (!exactTime.getIsNow()) {
            return "<html><b>Time:&nbsp;</b>Exact Time<br><b>Year:&nbsp;</b>" + exactTime.getYear() + " " + exactTime.getEra() + "<br>" + "<b>Month:&nbsp;</b>" + exactTime.getMonth() + "<br>" + "<b>Date:&nbsp;</b>" + exactTime.getDay() + "<br>" + "<b>Hour:&nbsp;</b>" + exactTime.getHour() + "<br>" + "<b>Second:&nbsp;</b>" + exactTime.getSecond() + "<br></html>";
        }
        return "<html><b>Time:&nbsp;</b>Now";
    }

    private String getTextForTimeEstimate(TimeEstimate timeEstimate) {
        boolean isKaSelected = timeEstimate.isKaSelected();
        String text = "";
        text = isKaSelected ? "<html><b>Time:&nbsp;</b>Time Estimate<br><html><b>Units:&nbsp;</b>ka<br><b>Zero Year:&nbsp;</b>" + timeEstimate.getZeroYear() + " AD<br>" + this.getTextForEstimate(timeEstimate.getEstimate(), TIME_VAL, PROB) + "</html>" : "<html><b>Time:&nbsp;</b>Time Estimate<br><html><b>Units:&nbsp;</b>Calendar Years<br>" + this.getTextForEstimate(timeEstimate.getEstimate(), TIME_VAL, PROB) + "</html>";
        return text;
    }

    private String getTextForNormalEstimate(NormalEstimate estimate) {
        String text = "<b>Estimate Type:&nbsp;</b>" + estimate.getName() + "<br>" + "<b>Mean =&nbsp;</b>" + GUI_Utils.decimalFormat.format(estimate.getMean()) + "<br>" + "<b>StdDev =&nbsp;</b>" + GUI_Utils.decimalFormat.format(estimate.getStdDev()) + "<br>";
        if (!Double.isInfinite(estimate.getMin())) {
            text = text + "<b>Lower Truncation(absolute):&nbsp;</b>" + GUI_Utils.decimalFormat.format(estimate.getMin()) + "<br>" + "<b>Lower Truncation(# of sigmas):&nbsp;</b>" + GUI_Utils.decimalFormat.format(estimate.getMinSigma()) + "<br>";
        }
        if (!Double.isInfinite(estimate.getMax())) {
            text = text + "<b>Upper Truncation(absolute):&nbsp;</b>" + GUI_Utils.decimalFormat.format(estimate.getMax()) + "<br>" + "<b>Upper Truncation(# of sigmas):&nbsp;</b>" + GUI_Utils.decimalFormat.format(estimate.getMaxSigma());
        }
        if (Double.isInfinite(estimate.getMin()) && Double.isInfinite(estimate.getMax())) {
            text = text + "<b>No Truncation";
        }
        return text;
    }

    private String getTextForLogNormalEstimate(LogNormalEstimate estimate) {
        return "<b>Estimate Type:&nbsp;</b>" + estimate.getName() + "<br>" + "<b>Linear Median:&nbsp;</b>" + GUI_Utils.decimalFormat.format(estimate.getLinearMedian()) + "<br>" + "<b>StdDev:&nbsp;</b>" + GUI_Utils.decimalFormat.format(estimate.getStdDev()) + "<br>" + "<b>Lower Truncation(absolute):&nbsp;</b>" + GUI_Utils.decimalFormat.format(estimate.getMin()) + "<br>" + "<b>Upper Truncation(absolute):&nbsp;</b>" + GUI_Utils.decimalFormat.format(estimate.getMax()) + "<br>" + "<b>Lower Truncation(# of sigmas):&nbsp;</b>" + GUI_Utils.decimalFormat.format(estimate.getMinSigma()) + "<br>" + "<b>Upper Truncation(# of sigmas):&nbsp;</b>" + GUI_Utils.decimalFormat.format(estimate.getMaxSigma());
    }

    private String getTextForDiscretizedFuncEstimate(DiscretizedFuncEstimate estimate) {
        DiscretizedFunc func = estimate.getValues();
        String text = "<b>Estimate Type:&nbsp;</b>" + estimate.getName() + "<br>" + "<b>Value&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Probability</b> <br>";
        for (int i = 0; i < func.getNum(); ++i) {
            text = text + GUI_Utils.decimalFormat.format(func.getX(i)) + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + GUI_Utils.decimalFormat.format(func.getY(i)) + "<br>";
        }
        return text;
    }

    private String getTextForFractileListEstimate(FractileListEstimate estimate) {
        DiscretizedFunc func = estimate.getValues();
        String text = "<b>Estimate Type:&nbsp;</b>" + estimate.getName() + "<br>" + "<b>" + func.getXAxisName() + "&nbsp;&nbsp;" + func.getYAxisName() + "</b> <br>";
        for (int i = 0; i < func.getNum(); ++i) {
            text = text + GUI_Utils.decimalFormat.format(func.getX(i)) + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + GUI_Utils.decimalFormat.format(func.getY(i)) + "<br>";
        }
        return text;
    }

    private String getTextForMinMaxPrefEstimate(MinMaxPrefEstimate estimate, String xAxisName, String yAxisName) {
        String text = "<b>Estimate Type:&nbsp;</b>" + estimate.getName() + "<br>";
        double minX = estimate.getMinimum();
        double maxX = estimate.getMaximum();
        double prefX = estimate.getPreferred();
        double minProb = estimate.getMinimumProb();
        double maxProb = estimate.getMaximumProb();
        double prefProb = estimate.getPreferredProb();
        String minXStr = "";
        String maxXStr = "";
        String prefXStr = "";
        String minProbStr = "";
        String maxProbStr = "";
        String prefProbStr = "";
        minXStr = !Double.isNaN(minX) ? GUI_Utils.decimalFormat.format(minX) : NOT_AVAILABLE;
        maxXStr = !Double.isNaN(maxX) ? GUI_Utils.decimalFormat.format(maxX) : NOT_AVAILABLE;
        prefXStr = !Double.isNaN(prefX) ? GUI_Utils.decimalFormat.format(prefX) : NOT_AVAILABLE;
        minProbStr = !Double.isNaN(minProb) ? GUI_Utils.decimalFormat.format(minProb) : NOT_AVAILABLE;
        maxProbStr = !Double.isNaN(maxProb) ? GUI_Utils.decimalFormat.format(maxProb) : NOT_AVAILABLE;
        prefProbStr = !Double.isNaN(prefProb) ? GUI_Utils.decimalFormat.format(prefProb) : NOT_AVAILABLE;
        text = text + "Min =&nbsp;&nbsp;" + minXStr + "  [" + minProbStr + "]<br>";
        text = text + "Pref =&nbsp;&nbsp;" + prefXStr + "  [" + prefProbStr + "]<br>";
        text = text + "Max =&nbsp;&nbsp;" + maxXStr + "  [" + maxProbStr + "]<br>";
        text = text + "<br> Numbers in brackets are probabilities that " + xAxisName + " is \u2264 each value.<br>";
        return text;
    }
}

