/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSetCalc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.opensha.calc.RelativeLocation;
import org.opensha.data.Location;
import org.opensha.data.LocationList;
import org.opensha.data.Site;
import org.opensha.param.ParameterAPI;
import org.opensha.param.WarningParameterAPI;
import org.opensha.param.event.ParameterChangeWarningEvent;
import org.opensha.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupForecastAPI;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel02.Frankel02_AdjustableEqkRupForecast;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF1.WGCEP_UCERF1_EqkRupForecast;
import org.opensha.sha.gui.infoTools.ConnectToCVM;
import org.opensha.sha.imr.AttenuationRelationshipAPI;
import org.opensha.sha.param.PropagationEffect;
import org.opensha.sha.util.SiteTranslator;
import org.opensha.util.FileUtils;
import org.opensha.util.SystemPropertiesUtils;

public class IM_EventSetCalc
implements ParameterChangeWarningListener {
    protected ArrayList willsSiteClassVals;
    protected LocationList locList;
    protected EqkRupForecastAPI forecast;
    protected ArrayList supportedAttenuationsList;
    protected static final String MEAN = "mean";
    protected static final String SIGMA = "sigma";
    protected ArrayList supportedIMTs;
    protected double sourceCutOffDistance;
    protected static final double MIN_DIST = 200.0;
    protected Site siteForSourceCutOff;
    private SiteTranslator siteTranslator = new SiteTranslator();
    private DecimalFormat format = new DecimalFormat("0.000##");
    protected String inputFileName = "MeanSigmaCalc_InputFile.txt";
    protected String dirName = "MeanSigma";

    public IM_EventSetCalc(String inpFile, String outDir) {
        this.inputFileName = inpFile;
        this.dirName = outDir;
    }

    protected void parseFile() throws FileNotFoundException, IOException {
        ArrayList fileLines = null;
        fileLines = FileUtils.loadFile(this.inputFileName);
        int j = 0;
        int numIMRdone = 0;
        int numIMRs = 0;
        int numIMTdone = 0;
        int numIMTs = 0;
        int numSitesDone = 0;
        int numSites = 0;
        int i = 0;
        while (i < fileLines.size()) {
            String line = ((String)fileLines.get(i)).trim();
            if (!line.startsWith("#") && !line.equals("")) {
                if (j == 0) {
                    this.getERF(line);
                }
                if (j == 1) {
                    if (line.trim().equals("true")) {
                        this.toApplyBackGroud(true);
                    } else {
                        this.toApplyBackGroud(false);
                    }
                }
                if (j == 2) {
                    double rupOffset = Double.parseDouble(line.trim());
                    this.setRupOffset(rupOffset);
                }
                if (j == 3) {
                    numIMRs = Integer.parseInt(line.trim());
                }
                if (j == 4) {
                    this.setIMR(line.trim());
                    if (++numIMRdone == numIMRs) {
                        ++j;
                    }
                } else {
                    if (j == 5) {
                        numIMTs = Integer.parseInt(line.trim());
                    }
                    if (j == 6) {
                        this.setIMT(line.trim());
                        if (++numIMTdone == numIMTs) {
                            ++j;
                        }
                    } else {
                        if (j == 7) {
                            numSites = Integer.parseInt(line.trim());
                        }
                        if (j == 8) {
                            this.setSite(line.trim());
                            if (++numSitesDone == numSites) {
                                ++j;
                            }
                        } else {
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void setSite(String line) {
        StringTokenizer st;
        int tokens;
        if (this.locList == null) {
            this.locList = new LocationList();
        }
        if ((tokens = (st = new StringTokenizer(line)).countTokens()) > 3 || tokens < 2) {
            throw new RuntimeException("Must Enter valid Lat Lon in each line in the file");
        }
        double lat = Double.parseDouble(st.nextToken().trim());
        double lon = Double.parseDouble(st.nextToken().trim());
        Location loc = new Location(lat, lon);
        this.locList.addLocation(loc);
        String willsClass = "";
        if (tokens == 3) {
            double vs30 = Double.parseDouble(st.nextToken().trim());
            willsClass = SiteTranslator.getWillsSiteClassForVs30(vs30);
        } else if (tokens == 2) {
            LocationList siteLocListForWillsSiteClass = new LocationList();
            siteLocListForWillsSiteClass.addLocation(loc);
            try {
                willsClass = (String)ConnectToCVM.getWillsSiteTypeFromCVM(siteLocListForWillsSiteClass).get(0);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.willsSiteClassVals == null) {
            this.willsSiteClassVals = new ArrayList();
        }
        this.willsSiteClassVals.add(willsClass);
    }

    private void setIMT(String line) {
        if (this.supportedIMTs == null) {
            this.supportedIMTs = new ArrayList();
        }
        this.supportedIMTs.add(line.trim());
    }

    private void setIMR(String str) {
        if (this.supportedAttenuationsList == null) {
            this.supportedAttenuationsList = new ArrayList();
        }
        this.createIMRClassInstance(str.trim());
    }

    protected void createIMRClassInstance(String AttenRelClassName) {
        String attenRelClassPackage = "org.opensha.sha.imr.attenRelImpl.";
        try {
            Class<?> listenerClass = Class.forName("org.opensha.param.event.ParameterChangeWarningListener");
            Object[] paramObjects = new Object[]{this};
            Class[] params = new Class[]{listenerClass};
            Class<?> imrClass = Class.forName(String.valueOf(attenRelClassPackage) + AttenRelClassName);
            Constructor<?> con = imrClass.getConstructor(params);
            AttenuationRelationshipAPI attenRel = (AttenuationRelationshipAPI)con.newInstance(paramObjects);
            if (attenRel.getName().equals("USGS Combined (2004)")) {
                throw new RuntimeException("Cannot use USGS Combined (2004) in calculation of Mean and Sigma");
            }
            attenRel.setParamDefaults();
            this.supportedAttenuationsList.add(attenRel);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    private void getERF(String line) {
        if (line.trim().equals(Frankel02_AdjustableEqkRupForecast.NAME)) {
            this.createFrankel02Forecast();
        } else {
            this.createUCERF_Forecast();
        }
    }

    private void createFrankel02Forecast() {
        this.forecast = new Frankel02_AdjustableEqkRupForecast();
        this.forecast.getAdjustableParameterList().getParameter(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_NAME).setValue(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_EXCLUDE);
        this.forecast.getTimeSpan().setDuration(1.0);
    }

    private void createUCERF_Forecast() {
        this.forecast = new WGCEP_UCERF1_EqkRupForecast();
        this.forecast.getAdjustableParameterList().getParameter(WGCEP_UCERF1_EqkRupForecast.BACK_SEIS_NAME).setValue(WGCEP_UCERF1_EqkRupForecast.BACK_SEIS_EXCLUDE);
        this.forecast.getAdjustableParameterList().getParameter("Time Dependent").setValue(new Boolean(false));
        this.forecast.getTimeSpan().setDuration(1.0);
    }

    private void toApplyBackGroud(boolean toApply) {
        if (toApply) {
            if (this.forecast instanceof Frankel02_AdjustableEqkRupForecast) {
                this.forecast.getAdjustableParameterList().getParameter(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_NAME).setValue(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_INCLUDE);
                this.forecast.getAdjustableParameterList().getParameter(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_RUP_NAME).setValue(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_RUP_FINITE);
            } else {
                this.forecast.getAdjustableParameterList().getParameter(WGCEP_UCERF1_EqkRupForecast.BACK_SEIS_NAME).setValue(WGCEP_UCERF1_EqkRupForecast.BACK_SEIS_INCLUDE);
                this.forecast.getAdjustableParameterList().getParameter(WGCEP_UCERF1_EqkRupForecast.BACK_SEIS_RUP_NAME).setValue(WGCEP_UCERF1_EqkRupForecast.BACK_SEIS_RUP_FINITE);
            }
        } else if (this.forecast instanceof Frankel02_AdjustableEqkRupForecast) {
            this.forecast.getAdjustableParameterList().getParameter(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_NAME).setValue(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_EXCLUDE);
        } else {
            this.forecast.getAdjustableParameterList().getParameter(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_NAME).setValue(Frankel02_AdjustableEqkRupForecast.BACK_SEIS_EXCLUDE);
        }
    }

    private void setRupOffset(double rupOffset) {
        if (this.forecast instanceof Frankel02_AdjustableEqkRupForecast) {
            this.forecast.getAdjustableParameterList().getParameter("Rupture Offset").setValue(new Double(rupOffset));
            this.forecast.updateForecast();
        } else {
            this.forecast.getAdjustableParameterList().getParameter("Rupture Offset").setValue(new Double(rupOffset));
            this.forecast.updateForecast();
        }
    }

    protected void getMeanSigma() {
        int numIMRs = this.supportedAttenuationsList.size();
        File file = new File(this.dirName);
        file.mkdirs();
        this.generateSrcRupMetadataFile(this.forecast, String.valueOf(this.dirName) + SystemPropertiesUtils.getSystemFileSeparator());
        this.generateRupSiteDistFile(this.forecast, String.valueOf(this.dirName) + SystemPropertiesUtils.getSystemFileSeparator());
        int numIMTs = this.supportedIMTs.size();
        int i = 0;
        while (i < numIMRs) {
            AttenuationRelationshipAPI attenRel = (AttenuationRelationshipAPI)this.supportedAttenuationsList.get(i);
            attenRel.setUserMaxDistance(this.sourceCutOffDistance);
            int j = 0;
            while (j < numIMTs) {
                String imtLine = (String)this.supportedIMTs.get(j);
                this.generateMeanAndSigmaFile(attenRel, imtLine, String.valueOf(this.dirName) + SystemPropertiesUtils.getSystemFileSeparator());
                ++j;
            }
            ++i;
        }
    }

    private void setSiteParamsInIMR(AttenuationRelationshipAPI imr, String willsClass) {
        ListIterator it = imr.getSiteParamsIterator();
        while (it.hasNext()) {
            ParameterAPI tempParam = (ParameterAPI)it.next();
            boolean flag = this.siteTranslator.setParameterValue(tempParam, willsClass, Double.NaN);
            if (flag) continue;
            String string = "cannot set the site parameter \"" + tempParam.getName() + "\" from Wills class \"" + willsClass + "\"" + "\n (no known, sanctioned translation - please set by hand)";
        }
    }

    protected void createSiteList() {
        double minLon = Double.MAX_VALUE;
        double maxLon = Double.NEGATIVE_INFINITY;
        double minLat = Double.MAX_VALUE;
        double maxLat = Double.NEGATIVE_INFINITY;
        int numSites = this.locList.size();
        int i = 0;
        while (i < numSites) {
            Location loc = this.locList.getLocationAt(i);
            double lon = loc.getLongitude();
            double lat = loc.getLatitude();
            if (lon > maxLon) {
                maxLon = lon;
            }
            if (lon < minLon) {
                minLon = lon;
            }
            if (lat > maxLat) {
                maxLat = lat;
            }
            if (lat < minLat) {
                minLat = lat;
            }
            ++i;
        }
        double middleLon = (minLon + maxLon) / 2.0;
        double middleLat = (minLat + maxLat) / 2.0;
        this.sourceCutOffDistance = (double)((float)RelativeLocation.getHorzDistance(middleLat, middleLon, minLat, minLon)) + 200.0;
        this.siteForSourceCutOff = new Site(new Location(middleLat, middleLon));
    }

    private void generateMeanAndSigmaFile(AttenuationRelationshipAPI imr, String imtLine, String dirName) {
        int numSources = this.forecast.getNumSources();
        int currRuptures = 0;
        try {
            FileWriter meanSigmaFile;
            String fileNamePrefixCommon = String.valueOf(dirName) + SystemPropertiesUtils.getSystemFileSeparator() + imr.getShortName();
            StringTokenizer st = new StringTokenizer(imtLine);
            int numTokens = st.countTokens();
            String imt = st.nextToken().trim();
            imr.setIntensityMeasure(imt);
            String pd = "";
            if (numTokens == 2) {
                pd = st.nextToken().trim();
                if (pd != null && !pd.equals("")) {
                    imr.getParameter("SA Period").setValue(new Double(Double.parseDouble(pd)));
                }
                meanSigmaFile = new FileWriter(String.valueOf(fileNamePrefixCommon) + "_" + imt + "_" + pd + ".txt");
            } else {
                meanSigmaFile = new FileWriter(String.valueOf(fileNamePrefixCommon) + "_" + imt + ".txt");
            }
            int sourceIndex = 0;
            while (sourceIndex < numSources) {
                ProbEqkSource source = this.forecast.getSource(sourceIndex);
                double sourceDistFromSite = source.getMinDistance(this.siteForSourceCutOff);
                if (!(sourceDistFromSite > this.sourceCutOffDistance)) {
                    int numRuptures = source.getNumRuptures();
                    int n = 0;
                    while (n < numRuptures) {
                        ProbEqkRupture rupture = source.getRupture(n);
                        imr.setEqkRupture(rupture);
                        meanSigmaFile.write(String.valueOf(sourceIndex) + "  " + n + "  ");
                        int numSites = this.locList.size();
                        int j = 0;
                        while (j < numSites) {
                            this.setSiteParamsInIMR(imr, (String)this.willsSiteClassVals.get(j));
                            imr.setSiteLocation(this.locList.getLocationAt(j));
                            meanSigmaFile.write(String.valueOf(this.format.format(imr.getMean())) + " ");
                            meanSigmaFile.write(String.valueOf(this.format.format(imr.getStdDev())) + " ");
                            ++j;
                        }
                        meanSigmaFile.write("\n");
                        ++n;
                        ++currRuptures;
                    }
                }
                ++sourceIndex;
            }
            meanSigmaFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateSrcRupMetadataFile(EqkRupForecastAPI eqkRupForecast, String dirName) {
        String outFileName = String.valueOf(dirName) + "src_rup_metadata.txt";
        int numSources = eqkRupForecast.getNumSources();
        int currRuptures = 0;
        try {
            File fw = new File(outFileName);
            if (!fw.exists()) {
                FileWriter fwRup = new FileWriter(outFileName);
                double duration = eqkRupForecast.getTimeSpan().getDuration();
                int sourceIndex = 0;
                while (sourceIndex < numSources) {
                    ProbEqkSource source = eqkRupForecast.getSource(sourceIndex);
                    double sourceDistFromSite = source.getMinDistance(this.siteForSourceCutOff);
                    if (!(sourceDistFromSite > this.sourceCutOffDistance)) {
                        int numRuptures = source.getNumRuptures();
                        int n = 0;
                        while (n < numRuptures) {
                            ProbEqkRupture rupture = source.getRupture(n);
                            double rate = -Math.log(1.0 - rupture.getProbability()) / duration;
                            fwRup.write(String.valueOf(sourceIndex) + "  " + n + " " + (float)rate + "  " + (float)rupture.getMag() + "  " + source.getName() + "\n");
                            ++n;
                            ++currRuptures;
                        }
                    }
                    ++sourceIndex;
                }
                fwRup.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateRupSiteDistFile(EqkRupForecastAPI eqkRupForecast, String dirName) {
        String outFileName = String.valueOf(dirName) + "rup_dist_info.txt";
        int numSources = eqkRupForecast.getNumSources();
        int currRuptures = 0;
        try {
            File fw = new File(outFileName);
            if (!fw.exists()) {
                FileWriter fwRup = new FileWriter(outFileName);
                int sourceIndex = 0;
                while (sourceIndex < numSources) {
                    ProbEqkSource source = eqkRupForecast.getSource(sourceIndex);
                    double sourceDistFromSite = source.getMinDistance(this.siteForSourceCutOff);
                    if (!(sourceDistFromSite > this.sourceCutOffDistance)) {
                        int numRuptures = source.getNumRuptures();
                        int n = 0;
                        while (n < numRuptures) {
                            ProbEqkRupture rupture = source.getRupture(n);
                            fwRup.write(String.valueOf(sourceIndex) + "  " + n + " ");
                            int numSites = this.locList.size();
                            int s = 0;
                            while (s < numSites) {
                                Location loc = this.locList.getLocationAt(s);
                                Site site = new Site(loc);
                                PropagationEffect propEffect = new PropagationEffect(site, rupture);
                                double rupDist = (Double)propEffect.getParamValue("DistanceRup");
                                fwRup.write(String.valueOf((float)rupDist) + "  ");
                                ++s;
                            }
                            fwRup.write("\n");
                            ++n;
                            ++currRuptures;
                        }
                    }
                    ++sourceIndex;
                }
                fwRup.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parameterChangeWarning(ParameterChangeWarningEvent e) {
        String S = " : parameterChangeWarning(): ";
        WarningParameterAPI param = e.getWarningParameter();
        param.setValueIgnoreWarning(e.getNewValue());
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage :\n\tjava -jar [jarfileName] [inputFileName] [output directory name]\n\n");
            System.out.println("jarfileName : Name of the executable jar file, by default it is IM_EventSetCalc.jar");
            System.out.println("inputFileName :Name of the input file For eg: see \"IM_EventSetCalc_InputFile.txt\". ");
            System.out.println("output directory name : Name of the output directory where all the output files will be generated");
            System.exit(0);
        }
        IM_EventSetCalc calc = new IM_EventSetCalc(args[0], args[1]);
        try {
            calc.parseFile();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        calc.createSiteList();
        calc.getMeanSigma();
    }
}

