/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.ListIterator;
import org.opensha.data.Location;
import org.opensha.data.TimeSpan;
import org.opensha.data.region.GeographicRegion;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterList;
import org.opensha.param.event.ParameterChangeEvent;
import org.opensha.param.event.ParameterChangeListener;
import org.opensha.param.event.TimeSpanChangeListener;
import org.opensha.sha.earthquake.ERF_API;
import org.opensha.sha.earthquake.ERF_ListAPI;
import org.opensha.sha.earthquake.EqkRupForecast;
import org.opensha.sha.earthquake.EqkRupForecastAPI;
import org.opensha.sha.earthquake.rupForecastImpl.remote.RemoteEqkRupForecastAPI;

public abstract class ERF_List
implements ERF_ListAPI,
TimeSpanChangeListener,
ParameterChangeListener {
    protected ArrayList erf_List = new ArrayList();
    private ArrayList relativeWeight = new ArrayList();
    protected boolean parameterChangeFlag = true;
    protected ParameterList adjustableParams = new ParameterList();
    protected TimeSpan timeSpan;

    protected void addERF(EqkRupForecast eqkRupForecast, double relWeight) {
        this.erf_List.add(eqkRupForecast);
        this.relativeWeight.add(new Double(relWeight));
    }

    public int getNumERFs() {
        return this.erf_List.size();
    }

    public EqkRupForecastAPI getERF(int index) {
        ERF_API eqkRupForecast = (ERF_API)this.erf_List.get(index);
        eqkRupForecast.setTimeSpan(this.timeSpan);
        return (EqkRupForecastAPI)eqkRupForecast;
    }

    public double getERF_RelativeWeight(int index) {
        return (Double)this.relativeWeight.get(index);
    }

    public ArrayList getRelativeWeightsList() {
        return this.relativeWeight;
    }

    public ListIterator getAdjustableParamsIterator() {
        return this.adjustableParams.getParametersIterator();
    }

    public String getName() {
        return "List of Earthquake Rupture Forecasts";
    }

    public boolean isLocWithinApplicableRegion(Location loc) {
        return true;
    }

    public void updateForecast() {
        if (this.parameterChangeFlag) {
            int num = this.erf_List.size();
            for (int i = 0; i < num; ++i) {
                this.getERF(i).updateForecast();
            }
        }
        this.parameterChangeFlag = false;
    }

    public GeographicRegion getApplicableRegion() {
        return null;
    }

    public void setTimeSpan(TimeSpan time) {
        this.timeSpan = time;
    }

    public ParameterList getAdjustableParameterList() {
        return this.adjustableParams;
    }

    public TimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    public void timeSpanChange(EventObject event) {
        this.parameterChangeFlag = true;
    }

    public void parameterChange(ParameterChangeEvent event) {
        this.parameterChangeFlag = true;
    }

    public void setParameterChangeFlag(boolean flag) {
        this.parameterChangeFlag = flag;
    }

    public String updateAndSaveForecast() {
        throw new UnsupportedOperationException("updateAndSaveForecast() not supported");
    }

    public ParameterAPI getParameter(String paramName) {
        return this.adjustableParams.getParameter(paramName);
    }

    public boolean setParameter(String name, Object value) {
        if (this.getAdjustableParameterList().containsParameter(name)) {
            this.getAdjustableParameterList().getParameter(name).setValue(value);
            return true;
        }
        if (this.timeSpan.getAdjustableParams().containsParameter(name)) {
            this.timeSpan.getAdjustableParams().getParameter(name).setValue(value);
            return true;
        }
        return false;
    }

    public RemoteEqkRupForecastAPI getRemoteERF(int index) {
        return null;
    }
}

