/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.data.Location;
import org.opensha.data.TimeSpan;
import org.opensha.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.data.region.EvenlyGriddedGeographicRegionAPI;
import org.opensha.data.region.GeographicRegion;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterList;
import org.opensha.param.event.ParameterChangeEvent;
import org.opensha.param.event.ParameterChangeListener;
import org.opensha.param.event.TimeSpanChangeListener;
import org.opensha.sha.calc.ERF2GriddedSeisRatesCalc;
import org.opensha.sha.earthquake.EqkRupForecastAPI;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;

public abstract class EqkRupForecast
implements EqkRupForecastAPI,
TimeSpanChangeListener,
ParameterChangeListener {
    protected ParameterList adjustableParams = new ParameterList();
    protected TimeSpan timeSpan;
    protected boolean parameterChangeFlag = true;

    public ListIterator getAdjustableParamsIterator() {
        return this.adjustableParams.getParametersIterator();
    }

    public boolean isLocWithinApplicableRegion(Location loc) {
        return true;
    }

    public GeographicRegion getApplicableRegion() {
        return null;
    }

    public ParameterAPI getParameter(String paramName) {
        return this.adjustableParams.getParameter(paramName);
    }

    public void setTimeSpan(TimeSpan time) {
        if (!time.getStartTimePrecision().equalsIgnoreCase("None")) {
            this.timeSpan.setStartTime(time.getStartTimeCalendar());
        }
        this.timeSpan.setDuration(time.getDuration(), time.getDurationUnits());
    }

    public TimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    public boolean setParameter(String name, Object value) {
        if (this.getAdjustableParameterList().containsParameter(name)) {
            this.getAdjustableParameterList().getParameter(name).setValue(value);
            return true;
        }
        if (this.timeSpan.getAdjustableParams().containsParameter(name)) {
            this.timeSpan.getAdjustableParams().getParameter(name).setValue(value);
            return true;
        }
        return false;
    }

    public void timeSpanChange(EventObject event) {
        this.parameterChangeFlag = true;
    }

    public void parameterChange(ParameterChangeEvent event) {
        this.parameterChangeFlag = true;
    }

    public abstract int getNumSources();

    public abstract ProbEqkSource getSource(int var1);

    public abstract ArrayList getSourceList();

    public int getNumRuptures(int iSource) {
        return this.getSource(iSource).getNumRuptures();
    }

    public ProbEqkRupture getRuptureClone(int iSource, int nRupture) {
        return this.getSource(iSource).getRuptureClone(nRupture);
    }

    public ProbEqkRupture getRupture(int iSource, int nRupture) {
        return this.getSource(iSource).getRupture(nRupture);
    }

    public Iterator getSourcesIterator() {
        Iterator i = this.getSourceList().iterator();
        return i;
    }

    public ProbEqkSource getSourceClone(int iSource) {
        return null;
    }

    public ParameterList getAdjustableParameterList() {
        return this.adjustableParams;
    }

    public void setParameterChangeFlag(boolean flag) {
        this.parameterChangeFlag = flag;
    }

    public String updateAndSaveForecast() {
        throw new UnsupportedOperationException("updateAndSaveForecast() not supported");
    }

    public double getTotalProbAbove(double minMag, GeographicRegion region) {
        ERF2GriddedSeisRatesCalc seisRates = new ERF2GriddedSeisRatesCalc();
        return seisRates.getTotalProbAbove(this, minMag, region);
    }

    public double getTotalRateAbove(double minMag, GeographicRegion region) {
        ERF2GriddedSeisRatesCalc seisRates = new ERF2GriddedSeisRatesCalc();
        return seisRates.getTotalSeisRateInRegion(minMag, this, region);
    }

    public ArrayList getMagRateDistForEachLocationInRegion(double minMag, EvenlyGriddedGeographicRegionAPI region) {
        ERF2GriddedSeisRatesCalc seisRates = new ERF2GriddedSeisRatesCalc();
        return seisRates.calcCumMFD_ForGriddedRegion(minMag, this, region);
    }

    public double[] getTotalSeisRateAtEachLocationInRegion(double minMag, EvenlyGriddedGeographicRegionAPI region) {
        ERF2GriddedSeisRatesCalc seisRates = new ERF2GriddedSeisRatesCalc();
        return seisRates.getTotalSeisRateAtEachLocationInRegion(minMag, this, region);
    }

    public ArbDiscrEmpiricalDistFunc getMagRateDistForRegion(double minMag, GeographicRegion region) {
        ERF2GriddedSeisRatesCalc seisRates = new ERF2GriddedSeisRatesCalc();
        return seisRates.getMagRateDistForRegion(minMag, this, region);
    }
}

