/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.opensha.sha.earthquake.EqkRupForecast;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF1.WGCEP_UCERF1_EqkRupForecast;

public class GenerateSourceRuptureInfoFiles {
    private String createDirectory(String dirName) {
        File f = new File(dirName);
        boolean success = f.mkdir();
        if (success) {
            return f.getAbsolutePath();
        }
        return null;
    }

    public void createERF_MetadataFile(String directoryPath, EqkRupForecast forecast) {
        String forecastMetadata = "EqkRupForecast Name= " + forecast.getName() + "\n";
        forecastMetadata = forecastMetadata + forecast.adjustableParams.getParameterListMetadataString();
        String timeSpanMetadata = forecast.getTimeSpan().getAdjustableParams().getParameterListMetadataString();
        FileWriter fw = null;
        try {
            fw = new FileWriter(directoryPath + "/ERF_Metadata.txt");
            fw.write(forecastMetadata + "\n");
            fw.write(timeSpanMetadata);
            fw.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void createSourceListFile(String directoryPath, EqkRupForecast forecast) {
        FileWriter fw = null;
        FileWriter fw_rupture = null;
        try {
            fw = new FileWriter(directoryPath + "/sourceList.txt");
            fw_rupture = new FileWriter(directoryPath + "/ruptureList.txt");
            int numSources = forecast.getNumSources();
            for (int i = 0; i < numSources; ++i) {
                ProbEqkSource source = forecast.getSource(i);
                fw.write(source.getSourceMetadata() + "\n");
                this.createRuptureListFile(fw_rupture, source, i);
            }
            fw_rupture.close();
            fw.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void createRuptureListFile(FileWriter rupfile, ProbEqkSource source, int sourceIndex) {
        int numRuptures = source.getNumRuptures();
        try {
            for (int i = 0; i < numRuptures; ++i) {
                ProbEqkRupture rupture = source.getRupture(i);
                rupture.setRuptureIndexAndSourceInfo(sourceIndex, source.getName(), i);
                rupfile.write(rupture.getRuptureMetadata() + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createRuptureSurfaceFile(String sourceDir, ProbEqkRupture rupture) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(sourceDir + "/" + rupture.getRuptureIndex() + ".txt");
            fw.write(rupture.getRuptureSurface().getSurfaceMetadata());
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createReadMeFile(String directoryPath) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(directoryPath + "/" + "Readme.txt");
            fw.write("This file explains the information contained in each of the other files here.\n1) ERF_Metadata.txt - The gives the name of the Earthquake Rupture Forecast (ERF) and how any adjustable parameters were set.\n2) sourceList.txt - This contains information about each source in the Earthquake Rupture Forecast.  After a header line, the info for each source is on a separate line as follows (tab delimited):\n\n\t\tSource-Index   NumRuptures    IsPoission    Total-Prob.   Src-Name. \n\n3) ruptureList.txt - This contains the following information for each rupture (tab delimited):\n\t\tSrc-Index  Rup-Index  Mag  Prob.  Ave.Rake  Ave. Dip  \"Source-Name\" \n\nWe don't yet include the rupture surfaces because it is not yet clear how users want this represented (there are several options, most of which consume a great deal of disk space).\n");
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        GenerateSourceRuptureInfoFiles generatesourceruptureinfofiles = new GenerateSourceRuptureInfoFiles();
        String directoryPath = generatesourceruptureinfofiles.createDirectory("WGCEP_UCERF_5yrs");
        if (directoryPath != null || !directoryPath.trim().equals("")) {
            WGCEP_UCERF1_EqkRupForecast ucerf = null;
            ucerf = new WGCEP_UCERF1_EqkRupForecast();
            ucerf.getAdjustableParameterList().getParameter(WGCEP_UCERF1_EqkRupForecast.BACK_SEIS_NAME).setValue(WGCEP_UCERF1_EqkRupForecast.BACK_SEIS_EXCLUDE);
            ucerf.getAdjustableParameterList().getParameter(WGCEP_UCERF1_EqkRupForecast.BACK_SEIS_RUP_NAME).setValue(WGCEP_UCERF1_EqkRupForecast.BACK_SEIS_RUP_POINT);
            ucerf.getAdjustableParameterList().getParameter(WGCEP_UCERF1_EqkRupForecast.FAULT_MODEL_NAME).setValue(WGCEP_UCERF1_EqkRupForecast.FAULT_MODEL_STIRLING);
            ucerf.getAdjustableParameterList().getParameter("Rupture Offset").setValue(new Double(5.0));
            ucerf.getTimeSpan().setDuration(5.0);
            ucerf.updateForecast();
            generatesourceruptureinfofiles.createERF_MetadataFile(directoryPath, ucerf);
            generatesourceruptureinfofiles.createSourceListFile(directoryPath, ucerf);
            generatesourceruptureinfofiles.createReadMeFile(directoryPath);
        }
    }
}

