/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import java.util.ArrayList;
import java.util.Iterator;
import org.opensha.data.NamedObjectAPI;
import org.opensha.data.Site;
import org.opensha.sha.earthquake.EqkSourceAPI;
import org.opensha.sha.earthquake.ProbEqkRupture;

public abstract class ProbEqkSource
implements EqkSourceAPI,
NamedObjectAPI {
    protected String name = new String("ProbEqkSource");
    protected ProbEqkRupture probEqkRupture;
    private int sourceIndex;
    protected boolean isPoissonian = true;
    private String info;

    public boolean isSourcePoissonian() {
        return this.isPoissonian;
    }

    public Iterator getRupturesIterator() {
        ArrayList v = this.getRuptureList();
        return v.iterator();
    }

    public boolean isPoissonianSource() {
        return this.isPoissonian;
    }

    public abstract double getMinDistance(Site var1);

    public abstract int getNumRuptures();

    public abstract ProbEqkRupture getRupture(int var1);

    public ProbEqkRupture getRuptureClone(int nRupture) {
        ProbEqkRupture eqkRupture = this.getRupture(nRupture);
        ProbEqkRupture eqkRuptureClone = (ProbEqkRupture)eqkRupture.clone();
        return eqkRuptureClone;
    }

    public ArrayList getRuptureList() {
        ArrayList<ProbEqkRupture> v = new ArrayList<ProbEqkRupture>();
        for (int i = 0; i < this.getNumRuptures(); ++i) {
            v.add(this.getRuptureClone(i));
        }
        return v;
    }

    public String getName() {
        return this.name;
    }

    public void setInfo(String infoString) {
        this.info = new String(infoString);
    }

    public String getInfo() {
        return this.info;
    }

    public String getSourceMetadata() {
        String sourceMetadata = this.sourceIndex + "\t";
        sourceMetadata = sourceMetadata + this.getNumRuptures() + "\t";
        sourceMetadata = sourceMetadata + this.isPoissonian + "\t";
        sourceMetadata = sourceMetadata + (float)this.computeTotalProb() + "\t";
        sourceMetadata = sourceMetadata + "\"" + this.getName() + "\"";
        return sourceMetadata;
    }

    public double computeTotalProb() {
        return this.computeTotalProbAbove(-10.0);
    }

    public double computeTotalProbAbove(double mag) {
        double totProb = 0.0;
        if (this.isPoissonian) {
            for (int i = 0; i < this.getNumRuptures(); ++i) {
                ProbEqkRupture tempRup = this.getRupture(i);
                if (!(tempRup.getMag() >= mag)) continue;
                totProb += Math.log(1.0 - tempRup.getProbability());
            }
            totProb = 1.0 - Math.exp(totProb);
        } else {
            for (int i = 0; i < this.getNumRuptures(); ++i) {
                ProbEqkRupture tempRup = this.getRupture(i);
                if (!(tempRup.getMag() >= mag)) continue;
                totProb += tempRup.getProbability();
            }
        }
        return totProb;
    }
}

