/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.util.ArrayList;
import org.opensha.calc.magScalingRelations.MagScalingRelationship;
import org.opensha.calc.magScalingRelations.magScalingRelImpl.PEER_testsMagAreaRelationship;
import org.opensha.calc.magScalingRelations.magScalingRelImpl.WC1994_MagAreaRelationship;
import org.opensha.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.data.TimeSpan;
import org.opensha.param.DoubleParameter;
import org.opensha.param.StringParameter;
import org.opensha.sha.earthquake.EqkRupForecast;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.FloatingPoissonFaultSource;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SingleMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.magdist.YC_1985_CharMagFreqDist;
import org.opensha.sha.param.MagFreqDistParameter;
import org.opensha.sha.param.SimpleFaultParameter;
import org.opensha.sha.surface.EvenlyGriddedSurface;

public class FloatingPoissonFaultERF
extends EqkRupForecast {
    private static String C = new String("FloatingPoissonFaultERF");
    private boolean D = false;
    public static final String NAME = "Floating Poisson Fault ERF";
    private FloatingPoissonFaultSource source;
    public static final String MAG_DIST_PARAM_NAME = "Mag Freq Dist";
    public static final String FAULT_PARAM_NAME = "Fault Parameter";
    public static final String OFFSET_PARAM_NAME = "Rupture Offset";
    private static final String OFFSET_PARAM_INFO = "The amount floating ruptures are offset along the fault";
    private static final String OFFSET_PARAM_UNITS = "km";
    private static final double OFFSET_PARAM_MIN = 0.01;
    private static final double OFFSET_PARAM_MAX = 100.0;
    private Double OFFSET_PARAM_DEFAULT = new Double(1.0);
    public static final String MAG_SCALING_REL_PARAM_NAME = "Mag-Scaling Relationship";
    private static final String MAG_SCALING_REL_PARAM_INFO = "Relationship to use for Area(Mag) or Area(Length) calculations";
    private ArrayList magScalingRelOptions;
    public static final String SIGMA_PARAM_NAME = "Mag Scaling Sigma";
    private static final String SIGMA_PARAM_INFO = "The standard deviation of the Area(mag) or Length(M) relationship";
    private Double SIGMA_PARAM_MIN = new Double(0.0);
    private Double SIGMA_PARAM_MAX = new Double(1.0);
    private Double SIGMA_PARAM_DEFAULT = new Double(0.0);
    public static final String ASPECT_RATIO_PARAM_NAME = "Rupture Aspect Ratio";
    private static final String ASPECT_RATIO_PARAM_INFO = "The ratio of rupture length to rupture width";
    private Double ASPECT_RATIO_PARAM_MIN = new Double(Double.MIN_VALUE);
    private Double ASPECT_RATIO_PARAM_MAX = new Double(Double.MAX_VALUE);
    private Double ASPECT_RATIO_PARAM_DEFAULT = new Double(1.0);
    public static final String RAKE_PARAM_NAME = "Rake";
    private static final String RAKE_PARAM_INFO = "The rake of the rupture (direction of slip)";
    private static final String RAKE_PARAM_UNITS = "degrees";
    private Double RAKE_PARAM_MIN = new Double(-180.0);
    private Double RAKE_PARAM_MAX = new Double(180.0);
    private Double RAKE_PARAM_DEFAULT = new Double(0.0);
    public static final String MIN_MAG_PARAM_NAME = "Min Mag";
    private static final String MIN_MAG_PARAM_INFO = "The minimum mag to be considered from the mag freq dist";
    private Double MIN_MAG_PARAM_MIN = new Double(0.0);
    private Double MIN_MAG_PARAM_MAX = new Double(10.0);
    private Double MIN_MAG_PARAM_DEFAULT = new Double(5.0);
    MagFreqDistParameter magDistParam;
    SimpleFaultParameter faultParam;
    DoubleParameter rupOffsetParam;
    StringParameter magScalingRelParam;
    DoubleParameter sigmaParam;
    DoubleParameter aspectRatioParam;
    DoubleParameter rakeParam;
    DoubleParameter minMagParam;

    public FloatingPoissonFaultERF() {
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.addParameterChangeListener(this);
        ArrayList<String> supportedMagDists = new ArrayList<String>();
        supportedMagDists.add(GaussianMagFreqDist.NAME);
        supportedMagDists.add(SingleMagFreqDist.NAME);
        supportedMagDists.add(GutenbergRichterMagFreqDist.NAME);
        supportedMagDists.add(YC_1985_CharMagFreqDist.NAME);
        supportedMagDists.add(SummedMagFreqDist.NAME);
        supportedMagDists.add(ArbIncrementalMagFreqDist.NAME);
        this.magDistParam = new MagFreqDistParameter(MAG_DIST_PARAM_NAME, supportedMagDists);
        this.faultParam = new SimpleFaultParameter(FAULT_PARAM_NAME);
        this.rupOffsetParam = new DoubleParameter(OFFSET_PARAM_NAME, 0.01, 100.0, OFFSET_PARAM_UNITS, this.OFFSET_PARAM_DEFAULT);
        this.rupOffsetParam.setInfo(OFFSET_PARAM_INFO);
        this.magScalingRelOptions = new ArrayList();
        this.magScalingRelOptions.add("W&C 1994 Mag-Area Rel.");
        this.magScalingRelOptions.add("W&C 1994 Mag-Length Rel.");
        this.magScalingRelOptions.add("PEER Tests Mag-Area Rel.");
        this.magScalingRelParam = new StringParameter(MAG_SCALING_REL_PARAM_NAME, this.magScalingRelOptions, "W&C 1994 Mag-Area Rel.");
        this.magScalingRelParam.setInfo(MAG_SCALING_REL_PARAM_INFO);
        this.sigmaParam = new DoubleParameter(SIGMA_PARAM_NAME, this.SIGMA_PARAM_MIN, this.SIGMA_PARAM_MAX, this.SIGMA_PARAM_DEFAULT);
        this.sigmaParam.setInfo(SIGMA_PARAM_INFO);
        this.rakeParam = new DoubleParameter(RAKE_PARAM_NAME, this.RAKE_PARAM_MIN, this.RAKE_PARAM_MAX, RAKE_PARAM_UNITS, this.RAKE_PARAM_DEFAULT);
        this.rakeParam.setInfo(RAKE_PARAM_INFO);
        this.aspectRatioParam = new DoubleParameter(ASPECT_RATIO_PARAM_NAME, this.ASPECT_RATIO_PARAM_MIN, this.ASPECT_RATIO_PARAM_MAX, this.ASPECT_RATIO_PARAM_DEFAULT);
        this.aspectRatioParam.setInfo(ASPECT_RATIO_PARAM_INFO);
        this.minMagParam = new DoubleParameter(MIN_MAG_PARAM_NAME, this.MIN_MAG_PARAM_MIN, this.MIN_MAG_PARAM_MAX, this.MIN_MAG_PARAM_DEFAULT);
        this.minMagParam.setInfo(MIN_MAG_PARAM_INFO);
        this.adjustableParams.addParameter(this.rupOffsetParam);
        this.adjustableParams.addParameter(this.magScalingRelParam);
        this.adjustableParams.addParameter(this.sigmaParam);
        this.adjustableParams.addParameter(this.rakeParam);
        this.adjustableParams.addParameter(this.aspectRatioParam);
        this.adjustableParams.addParameter(this.minMagParam);
        this.adjustableParams.addParameter(this.faultParam);
        this.adjustableParams.addParameter(this.magDistParam);
        this.rupOffsetParam.addParameterChangeListener(this);
        this.magScalingRelParam.addParameterChangeListener(this);
        this.sigmaParam.addParameterChangeListener(this);
        this.rakeParam.addParameterChangeListener(this);
        this.aspectRatioParam.addParameterChangeListener(this);
        this.minMagParam.addParameterChangeListener(this);
        this.faultParam.addParameterChangeListener(this);
        this.magDistParam.addParameterChangeListener(this);
    }

    public void updateForecast() {
        String S = C + "updateForecast::";
        if (this.parameterChangeFlag) {
            String magScalingRelString = (String)this.magScalingRelParam.getValue();
            if (this.D) {
                System.out.println(S + "  " + magScalingRelString);
            }
            MagScalingRelationship magScalingRel = magScalingRelString.equals("W&C 1994 Mag-Area Rel.") ? new WC1994_MagAreaRelationship() : (magScalingRelString.equals("W&C 1994 Mag-Length Rel.") ? new WC1994_MagLengthRelationship() : new PEER_testsMagAreaRelationship());
            if (this.D) {
                System.out.println(S + "  " + magScalingRel.getName());
            }
            this.source = new FloatingPoissonFaultSource((IncrementalMagFreqDist)this.magDistParam.getValue(), (EvenlyGriddedSurface)this.faultParam.getValue(), magScalingRel, (Double)this.sigmaParam.getValue(), (Double)this.aspectRatioParam.getValue(), (Double)this.rupOffsetParam.getValue(), (Double)this.rakeParam.getValue(), this.timeSpan.getDuration(), (Double)this.minMagParam.getValue());
            this.parameterChangeFlag = false;
        }
    }

    public ProbEqkSource getSource(int iSource) {
        if (iSource != 0) {
            throw new RuntimeException("Only 1 source available, iSource should be equal to 0");
        }
        return this.source;
    }

    public int getNumSources() {
        return 1;
    }

    public ArrayList getSourceList() {
        ArrayList<FloatingPoissonFaultSource> v = new ArrayList<FloatingPoissonFaultSource>();
        v.add(this.source);
        return v;
    }

    public String getName() {
        return NAME;
    }
}

