/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.io.Serializable;
import java.util.ArrayList;
import org.opensha.data.LocationList;
import org.opensha.data.Site;
import org.opensha.data.region.EvenlyGriddedGeographicRegionAPI;
import org.opensha.data.region.GeographicRegion;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class GriddedRegionPoissonEqkSource
extends ProbEqkSource
implements Serializable {
    private static String C = new String("GriddedRegionPoissonEqkSource");
    private boolean D = false;
    private IncrementalMagFreqDist magFreqDist;
    private EvenlyGriddedGeographicRegionAPI region;
    private double aveDip = Double.NaN;
    private double aveRake = Double.NaN;
    private double duration;
    int numLocs;
    int numMags;
    private double minMag = 0.0;
    private ArrayList mags;
    private ArrayList rates;

    public GriddedRegionPoissonEqkSource(EvenlyGriddedGeographicRegionAPI region, IncrementalMagFreqDist magFreqDist, double duration, double aveRake, double aveDip, double minMag) {
        this.region = region;
        this.numLocs = region.getNumGridLocs();
        this.duration = duration;
        this.aveRake = aveRake;
        this.aveDip = aveDip;
        this.minMag = minMag;
        this.setMagFreqDist(magFreqDist);
        this.probEqkRupture = new ProbEqkRupture();
        this.probEqkRupture.setAveRake(aveRake);
        if (this.D) {
            System.out.println("GriddedRegionPoissonEqkSource Constructor: numLocs=" + this.numLocs + "; numMags=" + this.numMags + "; aveDip=" + aveDip + "; aveRake=" + this.probEqkRupture.getAveRake());
        }
    }

    public GriddedRegionPoissonEqkSource(EvenlyGriddedGeographicRegionAPI region, IncrementalMagFreqDist magFreqDist, double duration, double aveRake, double aveDip) {
        this(region, magFreqDist, duration, aveRake, aveDip, 0.0);
    }

    public LocationList getAllSourceLocs() {
        return this.region.getGridLocationsList();
    }

    public void setMagFreqDist(IncrementalMagFreqDist magFreqDist) {
        this.magFreqDist = magFreqDist;
        this.mags = new ArrayList();
        this.rates = new ArrayList();
        for (int i = 0; i < magFreqDist.getNum(); ++i) {
            if (!(magFreqDist.getY(i) > 0.0) || !(magFreqDist.getX(i) >= this.minMag)) continue;
            this.mags.add(new Double(magFreqDist.getX(i)));
            this.rates.add(new Double(magFreqDist.getY(i) / (double)this.numLocs));
        }
        this.numMags = this.mags.size();
    }

    public int getNumRuptures() {
        return this.numMags * this.numLocs;
    }

    public ProbEqkRupture getRupture(int nthRupture) {
        int ithMag = nthRupture / this.numLocs;
        int ithLoc = nthRupture % this.numLocs;
        if (this.D) {
            System.out.println(nthRupture + "th rupture; " + ithMag + "th mag; " + ithLoc + "th loc");
        }
        this.probEqkRupture.setMag((Double)this.mags.get(ithMag));
        this.probEqkRupture.setPointSurface(this.region.getGridLocation(ithLoc), this.aveDip);
        double prob = 1.0 - Math.exp(-this.duration * (Double)this.rates.get(ithMag));
        this.probEqkRupture.setProbability(prob);
        return this.probEqkRupture;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public void setMinMag(double minMag) {
        this.minMag = minMag;
        this.setMagFreqDist(this.magFreqDist);
    }

    public double getDuration() {
        return this.duration;
    }

    public EvenlyGriddedGeographicRegionAPI getRegion() {
        return this.region;
    }

    public double getMinMag() {
        return this.minMag;
    }

    public double getMinDistance(Site site) {
        return ((GeographicRegion)((Object)this.region)).getMinHorzDistToRegion(site.getLocation());
    }

    public String getName() {
        return C;
    }
}

