/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.io.Serializable;
import java.util.ArrayList;
import org.opensha.calc.RelativeLocation;
import org.opensha.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.calc.magScalingRelations.MagScalingRelationship;
import org.opensha.calc.magScalingRelations.magScalingRelImpl.WC1994_MagAreaRelationship;
import org.opensha.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.data.Direction;
import org.opensha.data.Location;
import org.opensha.data.LocationList;
import org.opensha.data.Site;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.fault.FaultTrace;
import org.opensha.sha.surface.EvenlyGriddedSurfaceAPI;
import org.opensha.sha.surface.FrankelGriddedSurface;

public class Point2MultVertSS_FaultSource
extends ProbEqkSource
implements Serializable {
    private static String C = new String("Point2MultVertSS_FaultSource");
    private boolean D = false;
    double rupLength;
    double upperSeisDepth;
    double lowerSeisDepth;
    private Location loc;
    private ArrayList faultTraces = new ArrayList();
    private ProbEqkRupture probEqkRupture = new ProbEqkRupture();
    private FrankelGriddedSurface frankelFaultSurface;

    public Point2MultVertSS_FaultSource(double lat, double lon, double magnitude, double probability, MagScalingRelationship magScalingRel, double upperSeisDepth, double lowerSeisDepth, double maxRupOffset, double deltaStrike) {
        this.probEqkRupture.setAveRake(0.0);
        this.probEqkRupture.setMag(magnitude);
        this.isPoissonian = false;
        this.upperSeisDepth = upperSeisDepth;
        this.lowerSeisDepth = lowerSeisDepth;
        if (magScalingRel instanceof MagAreaRelationship) {
            this.rupLength = magScalingRel.getMedianScale(magnitude) / (lowerSeisDepth - upperSeisDepth);
        } else if (magScalingRel instanceof MagLengthRelationship) {
            this.rupLength = magScalingRel.getMedianScale(magnitude);
        } else {
            throw new RuntimeException("bad type of MagScalingRelationship");
        }
        this.loc = new Location(lat, lon, 0.0);
        this.mkFaultTraces(this.loc, this.rupLength, maxRupOffset, deltaStrike);
        if (this.D) {
            System.out.println("num ruptures=" + this.faultTraces.size());
        }
        this.probEqkRupture.setProbability(probability / (double)this.faultTraces.size());
        if (this.D) {
            System.out.println("prob=" + this.probEqkRupture.getProbability());
        }
    }

    private void mkFaultTraces(Location loc, double rupLength, double maxDeltaRupOffset, double deltaStrike) {
        int numRupAlong = (int)(rupLength / maxDeltaRupOffset) + 2;
        double deltaRupOffset = rupLength / (double)(numRupAlong - 1);
        int numStrikes = (int)(180.0 / deltaStrike);
        if (this.D) {
            System.out.println("rupLength=" + rupLength + "; maxDeltaRupOffset=" + maxDeltaRupOffset + ";  numRupAlong=" + numRupAlong + ";  deltaRupOffset=" + deltaRupOffset);
        }
        if (this.D) {
            System.out.println("lon1\tlat1\tlon2\tlat2\tstike\toffSet");
        }
        for (double strike = 0.0; strike < 180.0; strike += deltaStrike) {
            for (double offSet = 0.0; offSet < rupLength + deltaRupOffset / 2.0; offSet += deltaRupOffset) {
                Direction dir = new Direction(0.0, offSet, strike, Double.NaN);
                Location loc1 = RelativeLocation.getLocation(loc, dir);
                dir = new Direction(0.0, rupLength - offSet, strike + 180.0, Double.NaN);
                Location loc2 = RelativeLocation.getLocation(loc, dir);
                FaultTrace fltTrace = new FaultTrace(null);
                fltTrace.addLocation(loc1);
                fltTrace.addLocation(loc2);
                this.faultTraces.add(fltTrace);
            }
        }
    }

    public int getNumRuptures() {
        return this.faultTraces.size();
    }

    public ProbEqkRupture getRupture(int nthRupture) {
        this.probEqkRupture.setRuptureSurface(this.getRuptureSurface(nthRupture));
        return this.probEqkRupture;
    }

    private EvenlyGriddedSurfaceAPI getRuptureSurface(int nthRupture) {
        this.frankelFaultSurface = new FrankelGriddedSurface((FaultTrace)this.faultTraces.get(nthRupture), 90.0, this.upperSeisDepth, this.lowerSeisDepth, 1.0);
        return this.frankelFaultSurface;
    }

    public LocationList getAllSourceLocs() {
        int numRuptures = this.getNumRuptures();
        LocationList locList = new LocationList();
        for (int i = 0; i < numRuptures; ++i) {
            LocationList rupLocList = this.getRuptureSurface(i).getLocationList();
            for (int j = 0; j < rupLocList.size(); ++j) {
                locList.addLocation(rupLocList.getLocationAt(j));
            }
        }
        return locList;
    }

    public double getMinDistance(Site site) {
        return RelativeLocation.getHorzDistance(site.getLocation(), this.loc) - this.rupLength;
    }

    public String getName() {
        return C;
    }

    public static void main(String[] args) {
        WC1994_MagLengthRelationship magLengthRel = new WC1994_MagLengthRelationship();
        WC1994_MagAreaRelationship magAreaRel = new WC1994_MagAreaRelationship();
        double mag = 7.0;
        System.out.println("Length(mag)=" + magLengthRel.getMedianScale(mag) + ";  Area(mag)=" + magAreaRel.getMedianScale(mag));
        Point2MultVertSS_FaultSource src = new Point2MultVertSS_FaultSource(34.0, -118.0, mag, 1.0, magLengthRel, 0.0, 10.0, 2.0, 5.0);
        System.out.println("numRuptures=" + src.getNumRuptures());
        for (int r = 0; r < src.getNumRuptures(); ++r) {
            int lastCol = src.getRupture(r).getRuptureSurface().getNumCols() - 1;
        }
    }
}

