/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.remote;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.data.Location;
import org.opensha.data.TimeSpan;
import org.opensha.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.data.region.EvenlyGriddedGeographicRegionAPI;
import org.opensha.data.region.GeographicRegion;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterList;
import org.opensha.sha.earthquake.EqkRupForecast;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.remote.RemoteEqkRupForecastAPI;
import org.opensha.util.ClassUtils;
import org.opensha.util.FileUtils;

public class RemoteEqkRupForecast_Impl
extends UnicastRemoteObject
implements RemoteEqkRupForecastAPI {
    private EqkRupForecast eqkRupForecast = null;
    private static final boolean D = false;

    public RemoteEqkRupForecast_Impl(String className) throws RemoteException, IOException {
        this.eqkRupForecast = (EqkRupForecast)ClassUtils.createNoArgConstructorClassInstance(className);
    }

    public RemoteEqkRupForecast_Impl(ArrayList params, ArrayList paramTypes, String className) throws RemoteException, IOException {
        this.eqkRupForecast = (EqkRupForecast)ClassUtils.createNoArgConstructorClassInstance(params, paramTypes, className);
    }

    public void updateForecast() throws RemoteException {
        this.eqkRupForecast.updateForecast();
    }

    public boolean setParameter(String name, Object value) throws RemoteException {
        return this.eqkRupForecast.setParameter(name, value);
    }

    public String saveForecast() throws RemoteException {
        String urlPrefix = "http://gravity.usc.edu/";
        String parentDir = "/opt/install/jakarta-tomcat-4.1.24/webapps/";
        String subDir = "OpenSHA/HazardMapDatasets/savedERFs/";
        String fileName = System.currentTimeMillis() + ".javaobject";
        FileUtils.saveObjectInFile(parentDir + subDir + fileName, this.eqkRupForecast);
        return parentDir + subDir + fileName;
    }

    public String getName() throws RemoteException {
        return this.eqkRupForecast.getName();
    }

    public void setTimeSpan(TimeSpan time) throws RemoteException {
        this.eqkRupForecast.setTimeSpan(time);
    }

    public TimeSpan getTimeSpan() throws RemoteException {
        TimeSpan timeSpan = this.eqkRupForecast.getTimeSpan();
        return timeSpan;
    }

    public ListIterator getAdjustableParamsIterator() throws RemoteException {
        return this.eqkRupForecast.getAdjustableParamsIterator();
    }

    public boolean isLocWithinApplicableRegion(Location loc) throws RemoteException {
        return this.eqkRupForecast.isLocWithinApplicableRegion(loc);
    }

    public GeographicRegion getApplicableRegion() throws RemoteException {
        return this.eqkRupForecast.getApplicableRegion();
    }

    public ParameterList getAdjustableParameterList() throws RemoteException {
        return this.eqkRupForecast.getAdjustableParameterList();
    }

    public int getNumSources() throws RemoteException {
        return this.eqkRupForecast.getNumSources();
    }

    public ArrayList getSourceList() throws RemoteException {
        return this.eqkRupForecast.getSourceList();
    }

    public ProbEqkSource getSource(int iSource) throws RemoteException {
        return this.eqkRupForecast.getSource(iSource);
    }

    public ProbEqkSource getSourceClone(int iSource) throws RemoteException {
        return this.eqkRupForecast.getSourceClone(iSource);
    }

    public int getNumRuptures(int iSource) throws RemoteException {
        return this.eqkRupForecast.getNumRuptures(iSource);
    }

    public ProbEqkRupture getRupture(int iSource, int nRupture) throws RemoteException {
        return this.eqkRupForecast.getRupture(iSource, nRupture);
    }

    public ParameterAPI getParameter(String paramName) throws RemoteException {
        return this.eqkRupForecast.getParameter(paramName);
    }

    public ProbEqkRupture getRuptureClone(int iSource, int nRupture) throws RemoteException {
        return this.eqkRupForecast.getRuptureClone(iSource, nRupture);
    }

    public double getTotalProbAbove(double minMag, GeographicRegion region) throws RemoteException {
        return this.eqkRupForecast.getTotalProbAbove(minMag, region);
    }

    public double getTotalRateAbove(double minMag, GeographicRegion region) throws RemoteException {
        return this.eqkRupForecast.getTotalRateAbove(minMag, region);
    }

    public ArrayList getMagRateDistForEachLocationInRegion(double minMag, EvenlyGriddedGeographicRegionAPI region) throws RemoteException {
        return this.eqkRupForecast.getMagRateDistForEachLocationInRegion(minMag, region);
    }

    public double[] getTotalSeisRateAtEachLocationInRegion(double minMag, EvenlyGriddedGeographicRegionAPI region) throws RemoteException {
        return this.eqkRupForecast.getTotalSeisRateAtEachLocationInRegion(minMag, region);
    }

    public ArbDiscrEmpiricalDistFunc getMagRateDistForRegion(double minMag, GeographicRegion region) throws RemoteException {
        return this.eqkRupForecast.getMagRateDistForRegion(minMag, region);
    }
}

