/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.infoTools;

import java.text.DecimalFormat;
import org.opensha.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.param.ParameterAPI;

public final class IMT_Info {
    private String S = "IMT_Info()";
    public static final double MIN_SA = 1.0E-4;
    public static final double MAX_SA = 10.0;
    public static final double NUM_SA = 51.0;
    public static final double DEFAULT_SA = 0.1;
    public static final double MIN_PGA = 1.0E-4;
    public static final double MAX_PGA = 10.0;
    public static final double NUM_PGA = 51.0;
    public static final double DEFAULT_PGA = 0.1;
    public static final double MIN_PGV = 0.01;
    public static final double MAX_PGV = 1000.0;
    public static final double NUM_PGV = 51.0;
    public static final double DEFAULT_PGV = 50.0;
    public static final double MIN_FAULT_DISPL = 0.001;
    public static final double MAX_FAULT_DISPL = 100.0;
    public static final double NUM_FAULT_DISPL = 51.0;
    public static final double DEFAULT_FAULT_DISPL = 1.0;
    public static final double MIN_MMI = 1.0;
    public static final double MAX_MMI = 10.0;
    public static final double NUM_MMI = 51.0;
    public static final double DEFAULT_MMI = 7.0;
    public double discretization_pga;
    public double discretization_sa;
    public double discretization_pgv;
    public double discretization_fault_displ;
    public double discretization_mmi;
    private DecimalFormat format = new DecimalFormat("0.00000##");

    public IMT_Info() {
        this.discretization_pga = (Math.log(10.0) - Math.log(1.0E-4)) / 50.0;
        this.discretization_sa = (Math.log(10.0) - Math.log(1.0E-4)) / 50.0;
        this.discretization_pgv = (Math.log(1000.0) - Math.log(0.01)) / 50.0;
        this.discretization_fault_displ = (Math.log(100.0) - Math.log(0.001)) / 50.0;
        this.discretization_mmi = (Math.log(10.0) - Math.log(1.0)) / 50.0;
        this.format.setMaximumFractionDigits(5);
    }

    public ArbitrarilyDiscretizedFunc getDefaultHazardCurve(ParameterAPI imtParam) {
        String paramVal = (String)imtParam.getValue();
        return this.getDefaultHazardCurve(paramVal);
    }

    public ArbitrarilyDiscretizedFunc getDefaultHazardCurve(String imtName) {
        ArbitrarilyDiscretizedFunc function = new ArbitrarilyDiscretizedFunc();
        if (imtName.equals("SA")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(1.0E-4) + (double)i * this.discretization_sa)));
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("PGA")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(1.0E-4) + (double)i * this.discretization_pga)));
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("PGV")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(0.01) + (double)i * this.discretization_pgv)));
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("Fault Displacement")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(0.001) + (double)i * this.discretization_fault_displ)));
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("MMI")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(1.0) + (double)i * this.discretization_mmi)));
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        return null;
    }

    public static double getMinIMT_Val(String imt) {
        if (imt.equals("SA")) {
            return 1.0E-4;
        }
        if (imt.equals("PGA")) {
            return 1.0E-4;
        }
        if (imt.equals("PGV")) {
            return 0.01;
        }
        if (imt.equals("Fault Displacement")) {
            return 0.001;
        }
        if (imt.equals("MMI")) {
            return 1.0;
        }
        return 0.0;
    }

    public static double getMaxIMT_Val(String imt) {
        if (imt.equals("SA")) {
            return 10.0;
        }
        if (imt.equals("PGA")) {
            return 10.0;
        }
        if (imt.equals("PGV")) {
            return 1000.0;
        }
        if (imt.equals("Fault Displacement")) {
            return 100.0;
        }
        if (imt.equals("MMI")) {
            return 10.0;
        }
        return 0.0;
    }

    public static double getNumIMT_Val(String imt) {
        if (imt.equals("SA")) {
            return 51.0;
        }
        if (imt.equals("PGA")) {
            return 51.0;
        }
        if (imt.equals("PGV")) {
            return 51.0;
        }
        if (imt.equals("Fault Displacement")) {
            return 51.0;
        }
        if (imt.equals("MMI")) {
            return 51.0;
        }
        return 0.0;
    }

    public static double getDefaultIMT_VAL(String imt) {
        if (imt.equals("SA")) {
            return 0.1;
        }
        if (imt.equals("PGA")) {
            return 0.1;
        }
        if (imt.equals("PGV")) {
            return 50.0;
        }
        if (imt.equals("Fault Displacement")) {
            return 1.0;
        }
        if (imt.equals("MMI")) {
            return 7.0;
        }
        return 0.0;
    }

    public static boolean isIMT_LogNormalDist(String imt) {
        return imt.equalsIgnoreCase("PGA") || imt.equalsIgnoreCase("PGV") || imt.equalsIgnoreCase("SA") || imt.equalsIgnoreCase("MMI") || imt.equalsIgnoreCase("Fault Displacement");
    }

    public static boolean isIMT_LogNormalDist(ParameterAPI imtParam) {
        String paramVal = (String)imtParam.getValue();
        return IMT_Info.isIMT_LogNormalDist(paramVal);
    }

    public static void main(String[] args) {
        IMT_Info hazardCurve = new IMT_Info();
        ArbitrarilyDiscretizedFunc func = hazardCurve.getDefaultHazardCurve("SA");
        System.out.println("For SA and PGA: ");
        System.out.println("Dis: " + hazardCurve.discretization_pga);
        System.out.println(func.toString());
        func = hazardCurve.getDefaultHazardCurve("PGV");
        System.out.println("For PGV: ");
        System.out.println("Dis: " + hazardCurve.discretization_pgv);
        System.out.println(func.toString());
    }
}

