/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.calc.GaussianDistCalc;
import org.opensha.data.DataPoint2D;
import org.opensha.data.Location;
import org.opensha.data.Site;
import org.opensha.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.data.function.DiscretizedFuncAPI;
import org.opensha.exceptions.IMRException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.DependentParameter;
import org.opensha.param.DoubleConstraint;
import org.opensha.param.DoubleDiscreteConstraint;
import org.opensha.param.DoubleDiscreteParameter;
import org.opensha.param.DoubleParameter;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterList;
import org.opensha.param.StringConstraint;
import org.opensha.param.StringParameter;
import org.opensha.param.WarningDoubleParameter;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.rupForecastImpl.PointEqkSource;
import org.opensha.sha.imr.AttenuationRelationshipAPI;
import org.opensha.sha.imr.IntensityMeasureRelationship;

public abstract class AttenuationRelationship
extends IntensityMeasureRelationship
implements AttenuationRelationshipAPI {
    public static final String C = "AttenuationRelationship";
    protected static final boolean D = false;
    protected WarningDoubleParameter pgaParam = null;
    public static final String PGA_NAME = "PGA";
    public static final String PGA_UNITS = "g";
    protected static final Double PGA_DEFAULT = new Double(Math.log(0.1));
    public static final String PGA_INFO = "Peak Ground Acceleration";
    protected static final Double PGA_MIN = new Double(Math.log(Double.MIN_VALUE));
    protected static final Double PGA_MAX = new Double(Double.MAX_VALUE);
    protected static final Double PGA_WARN_MIN = new Double(Math.log(Double.MIN_VALUE));
    protected static final Double PGA_WARN_MAX = new Double(Math.log(2.5));
    protected WarningDoubleParameter pgvParam = null;
    public static final String PGV_NAME = "PGV";
    public static final String PGV_UNITS = "cm/sec";
    protected static final Double PGV_DEFAULT = new Double(Math.log(0.1));
    public static final String PGV_INFO = "Peak Ground Velocity";
    protected static final Double PGV_MIN = new Double(Math.log(Double.MIN_VALUE));
    protected static final Double PGV_MAX = new Double(Double.MAX_VALUE);
    protected static final Double PGV_WARN_MIN = new Double(Math.log(Double.MIN_VALUE));
    protected static final Double PGV_WARN_MAX = new Double(Math.log(500.0));
    protected WarningDoubleParameter saParam = null;
    public static final String SA_NAME = "SA";
    public static final String SA_UNITS = "g";
    protected static final Double SA_DEFAULT = new Double(Math.log(0.5));
    public static final String SA_INFO = "Response Spectral Acceleration";
    protected static final Double SA_MIN = new Double(Math.log(Double.MIN_VALUE));
    protected static final Double SA_MAX = new Double(Double.MAX_VALUE);
    protected static final Double SA_WARN_MIN = new Double(Math.log(Double.MIN_VALUE));
    protected static final Double SA_WARN_MAX = new Double(Math.log(3.0));
    protected DoubleDiscreteParameter periodParam = null;
    public static final String PERIOD_NAME = "SA Period";
    public static final String PERIOD_UNITS = "sec";
    protected static final Double PERIOD_DEFAULT = new Double(0.0);
    public static final String PERIOD_INFO = "Oscillator Period for SA";
    protected DoubleDiscreteParameter dampingParam = null;
    protected DoubleDiscreteConstraint dampingConstraint = null;
    public static final String DAMPING_NAME = "SA Damping";
    public static final String DAMPING_UNITS = " % ";
    protected static final Double DAMPING_DEFAULT = new Double(5.0);
    public static final String DAMPING_INFO = "Oscillator Damping for SA";
    protected WarningDoubleParameter magParam = null;
    public static final String MAG_NAME = "Magnitude";
    public static final String MAG_INFO = "Earthquake Moment Magnatude";
    protected static final Double MAG_DEFAULT = new Double(5.5);
    protected static final Double MAG_MIN = new Double(0.0);
    protected static final Double MAG_MAX = new Double(10.0);
    protected DoubleParameter rakeParam = null;
    public static final String RAKE_NAME = "Rake";
    public static final String RAKE_UNITS = "degrees";
    public static final String RAKE_INFO = "Average rake of earthquake rupture";
    public static final Double RAKE_DEFAULT = new Double("0");
    protected static final Double RAKE_MIN = new Double(-180.0);
    protected static final Double RAKE_MAX = new Double(180.0);
    protected DoubleParameter dipParam = null;
    public static final String DIP_NAME = "Dip";
    public static final String DIP_UNITS = "degrees";
    public static final String DIP_INFO = "Average dip of earthquake rupture";
    public static final Double DIP_DEFAULT = new Double("90");
    protected static final Double DIP_MIN = new Double(0.0);
    protected static final Double DIP_MAX = new Double(90.0);
    protected DoubleParameter rupTopDepthParam = null;
    public static final String RUP_TOP_NAME = "Rupture Top Depth";
    public static final String RUP_TOP_UNITS = "km";
    public static final String RUP_TOP_INFO = "The depth to the shallowest point on the earthquake rupture surface";
    public static final Double RUP_TOP_DEFAULT = new Double(0.0);
    protected static final Double RUP_TOP_MIN = new Double(0.0);
    protected static final Double RUP_TOP_MAX = new Double(20.0);
    protected StringParameter componentParam = null;
    public static final String COMPONENT_NAME = "Component";
    public static final String COMPONENT_DEFAULT = "Average Horizontal";
    public static final String COMPONENT_AVE_HORZ = "Average Horizontal";
    public static final String COMPONENT_RANDOM_HORZ = "Random Horizontal";
    public static final String COMPONENT_VERT = "Vertical";
    public static final String COMPONENT_INFO = "Component of shaking";
    protected WarningDoubleParameter vs30Param = null;
    public static final String VS30_NAME = "Vs30";
    public static final String VS30_UNITS = "m/sec";
    public static final String VS30_INFO = "The average shear-wave velocity between 0 and 30-meters depth";
    public static final Double VS30_DEFAULT = new Double("760");
    protected static final Double VS30_MIN = new Double(0.0);
    protected static final Double VS30_MAX = new Double(5000.0);
    protected WarningDoubleParameter depthTo2pt5kmPerSecParam = null;
    public static final String DEPTH_2pt5_NAME = "Depth 2.5 km/sec";
    public static final String DEPTH_2pt5_UNITS = "km";
    public static final String DEPTH_2pt5_INFO = "The depth to where shear-wave velocity = 2.5 km/sec";
    public static final Double DEPTH_2pt5_DEFAULT = new Double("1.0");
    protected static final Double DEPTH_2pt5_MIN = new Double(0.0);
    protected static final Double DEPTH_2pt5_MAX = new Double(30000.0);
    protected StringParameter stdDevTypeParam = null;
    public static final String STD_DEV_TYPE_NAME = "Std Dev Type";
    public static final String STD_DEV_TYPE_INFO = "Type of Standard Deviation";
    public static final String STD_DEV_TYPE_DEFAULT = "Total";
    public static final String STD_DEV_TYPE_TOTAL = "Total";
    public static final String STD_DEV_TYPE_INTER = "Inter-Event";
    public static final String STD_DEV_TYPE_INTRA = "Intra-Event";
    public static final String STD_DEV_TYPE_NONE = "None (zero)";
    public static final String STD_DEV_TYPE_TOTAL_MAG_DEP = "Total (Mag Dependent)";
    public static final String STD_DEV_TYPE_TOTAL_PGA_DEP = "Total (PGA Dependent)";
    public static final String STD_DEV_TYPE_INTRA_MAG_DEP = "Intra-Event (Mag Dependent)";
    protected StringParameter fltTypeParam = null;
    public static final String FLT_TYPE_NAME = "Fault Type";
    public static final String FLT_TYPE_INFO = "Style of faulting";
    protected StringParameter sigmaTruncTypeParam = null;
    public static final String SIGMA_TRUNC_TYPE_NAME = "Gaussian Truncation";
    public static final String SIGMA_TRUNC_TYPE_INFO = "Type of distribution truncation to apply when computing exceedance probabilities";
    public static final String SIGMA_TRUNC_TYPE_NONE = "None";
    public static final String SIGMA_TRUNC_TYPE_1SIDED = "1 Sided";
    public static final String SIGMA_TRUNC_TYPE_2SIDED = "2 Sided";
    public static final String SIGMA_TRUNC_TYPE_DEFAULT = "None";
    protected DoubleParameter sigmaTruncLevelParam = null;
    public static final String SIGMA_TRUNC_LEVEL_NAME = "Truncation Level";
    public static final String SIGMA_TRUNC_LEVEL_UNITS = "Std Dev";
    public static final String SIGMA_TRUNC_LEVEL_INFO = "The number of standard deviations, from the mean, where truncation occurs";
    public static final Double SIGMA_TRUNC_LEVEL_DEFAULT = new Double(2.0);
    public static final Double SIGMA_TRUNC_LEVEL_MIN = new Double(Double.MIN_VALUE);
    public static final Double SIGMA_TRUNC_LEVEL_MAX = new Double(Double.MAX_VALUE);
    protected double USER_MAX_DISTANCE = Double.MAX_VALUE;
    protected static final double VERY_SMALL_MEAN = -35.0;
    protected static final String ERR = "Not all parameters have been set";
    protected ParameterList meanIndependentParams = new ParameterList();
    protected ParameterList stdDevIndependentParams = new ParameterList();
    protected ParameterList exceedProbIndependentParams = new ParameterList();
    protected ParameterList imlAtExceedProbIndependentParams = new ParameterList();

    public void setUserMaxDistance(double maxDist) {
        this.USER_MAX_DISTANCE = maxDist;
    }

    public void setIntensityMeasureLevel(Object iml) throws ParameterException {
        if (!(iml instanceof Double)) {
            throw new ParameterException("AttenuationRelationship: setIntensityMeasureLevel(): Object not a DoubleParameter, unable to set.");
        }
        this.setIntensityMeasureLevel((Double)iml);
    }

    public void setIntensityMeasureLevel(Double iml) throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("AttenuationRelationship: setIntensityMeasureLevel(): Intensity Measure is null, unable to set.");
        }
        this.im.setValue(iml);
    }

    public void setSiteLocation(Location loc) {
        if (this.site == null) {
            this.site = new Site();
        }
        this.site.setLocation(loc);
        this.setPropagationEffectParams();
    }

    protected abstract void setPropagationEffectParams();

    public double getExceedProbability() throws ParameterException, IMRException {
        if (this.im == null || this.im.getValue() == null) {
            throw new ParameterException("AttenuationRelationship: getExceedProbability(): Intensity measure or value is null, unable to run this calculation.");
        }
        double iml = (Double)this.im.getValue();
        double stdDev = this.getStdDev();
        double mean = this.getMean();
        return this.getExceedProbability(mean, stdDev, iml);
    }

    public double getExceedProbability(double iml) throws ParameterException, IMRException {
        this.im.setValue(new Double(iml));
        return this.getExceedProbability();
    }

    public DiscretizedFuncAPI getSA_ExceedProbSpectrum(double iml) throws ParameterException, IMRException {
        this.setIntensityMeasure(SA_NAME);
        this.im.setValue(new Double(iml));
        ArbitrarilyDiscretizedFunc exeedProbFunction = new ArbitrarilyDiscretizedFunc();
        ArrayList allowedSA_Periods = this.periodParam.getAllowedDoubles();
        int size = allowedSA_Periods.size();
        for (int i = 0; i < size; ++i) {
            Double saPeriod = (Double)allowedSA_Periods.get(i);
            this.getParameter(PERIOD_NAME).setValue(saPeriod);
            exeedProbFunction.set(saPeriod, this.getExceedProbability());
        }
        return exeedProbFunction;
    }

    public DiscretizedFuncAPI getSA_IML_AtExceedProbSpectrum(double exceedProb) throws ParameterException, IMRException {
        this.setIntensityMeasure(SA_NAME);
        this.exceedProbParam.setValue(exceedProb);
        ArbitrarilyDiscretizedFunc imlFunction = new ArbitrarilyDiscretizedFunc();
        ArrayList allowedSA_Periods = this.periodParam.getAllowedDoubles();
        int size = allowedSA_Periods.size();
        for (int i = 0; i < size; ++i) {
            Double saPeriod = (Double)allowedSA_Periods.get(i);
            this.getParameter(PERIOD_NAME).setValue(saPeriod);
            imlFunction.set(saPeriod, this.getIML_AtExceedProb());
        }
        return imlFunction;
    }

    public double getEpsilon() {
        double iml = (Double)this.im.getValue();
        return (iml - this.getMean()) / this.getStdDev();
    }

    public double getEpsilon(double iml) {
        this.im.setValue(new Double(iml));
        return this.getEpsilon();
    }

    protected double getExceedProbability(double mean, double stdDev, double iml) throws ParameterException, IMRException {
        if (stdDev != 0.0) {
            double stRndVar = (iml - mean) / stdDev;
            if (this.sigmaTruncTypeParam.getValue().equals("None")) {
                return GaussianDistCalc.getExceedProb(stRndVar);
            }
            double numSig = (Double)this.sigmaTruncLevelParam.getValue();
            if (this.sigmaTruncTypeParam.getValue().equals(SIGMA_TRUNC_TYPE_1SIDED)) {
                return GaussianDistCalc.getExceedProb(stRndVar, 1, numSig);
            }
            return GaussianDistCalc.getExceedProb(stRndVar, 2, numSig);
        }
        if (iml > mean) {
            return 0.0;
        }
        return 1.0;
    }

    public DiscretizedFuncAPI getExceedProbabilities(DiscretizedFuncAPI intensityMeasureLevels) throws ParameterException {
        double stdDev = this.getStdDev();
        double mean = this.getMean();
        Iterator it = intensityMeasureLevels.getPointsIterator();
        while (it.hasNext()) {
            DataPoint2D point = (DataPoint2D)it.next();
            point.setY(this.getExceedProbability(mean, stdDev, point.getX()));
        }
        return intensityMeasureLevels;
    }

    public double getTotExceedProbability(PointEqkSource ptSrc, double iml) {
        double totProb = 1.0;
        this.im.setValue(new Double(iml));
        this.setEqkRupture(ptSrc.getRupture(0));
        for (int i = 0; i < ptSrc.getNumRuptures(); ++i) {
            ProbEqkRupture tempRup = ptSrc.getRupture(i);
            this.magParam.setValueIgnoreWarning(new Double(tempRup.getMag()));
            double qkProb = tempRup.getProbability();
            if (Math.log(1.0 - qkProb) < -30.0) {
                throw new RuntimeException("Error: The probability for this ProbEqkRupture (" + qkProb + ") is too high for a Possion source (~infinite number of events)");
            }
            totProb *= Math.pow(1.0 - qkProb, this.getExceedProbability());
        }
        return 1.0 - totProb;
    }

    public double getIML_AtExceedProb() throws ParameterException {
        double stRndVar;
        if (this.exceedProbParam.getValue() == null) {
            throw new ParameterException("AttenuationRelationship: getExceedProbability(): exceedProbParam or its value is null, unable to run this calculation.");
        }
        double exceedProb = (Double)this.exceedProbParam.getValue();
        String sigTrType = (String)this.sigmaTruncTypeParam.getValue();
        if (!sigTrType.equals(SIGMA_TRUNC_TYPE_1SIDED) && exceedProb == 0.5) {
            return this.getMean();
        }
        if (sigTrType.equals("None")) {
            stRndVar = GaussianDistCalc.getStandRandVar(exceedProb, 0, 0.0, 1.0E-6);
        } else {
            double numSig = (Double)this.sigmaTruncLevelParam.getValue();
            stRndVar = sigTrType.equals(SIGMA_TRUNC_TYPE_1SIDED) ? GaussianDistCalc.getStandRandVar(exceedProb, 1, numSig, 1.0E-6) : GaussianDistCalc.getStandRandVar(exceedProb, 2, numSig, 1.0E-6);
        }
        return this.getMean() + stRndVar * this.getStdDev();
    }

    public double getIML_AtExceedProb(double exceedProb) throws ParameterException {
        this.exceedProbParam.setValue(exceedProb);
        return this.getIML_AtExceedProb();
    }

    public ListIterator getMeanIndependentParamsIterator() {
        return this.meanIndependentParams.getParametersIterator();
    }

    public ListIterator getStdDevIndependentParamsIterator() {
        return this.stdDevIndependentParams.getParametersIterator();
    }

    public ListIterator getExceedProbIndependentParamsIterator() {
        return this.exceedProbIndependentParams.getParametersIterator();
    }

    public ListIterator getIML_AtExceedProbIndependentParamsIterator() {
        return this.imlAtExceedProbIndependentParams.getParametersIterator();
    }

    public String getAllParamMetadata() {
        String metadata = this.imlAtExceedProbIndependentParams.getParameterListMetadataString();
        metadata = metadata + "; " + this.im.getMetadataString() + " [ ";
        ListIterator it = ((DependentParameter)this.im).getIndependentParametersIterator();
        while (it.hasNext()) {
            metadata = metadata + ((ParameterAPI)it.next()).getMetadataString() + "; ";
        }
        metadata = metadata.substring(0, metadata.length() - 2);
        metadata = metadata + " ]";
        return metadata;
    }

    protected void initSupportedIntensityMeasureParams() {
        DoubleConstraint saConstraint = new DoubleConstraint(SA_MIN, SA_MAX);
        saConstraint.setNonEditable();
        this.saParam = new WarningDoubleParameter(SA_NAME, saConstraint, "g");
        this.saParam.setInfo(SA_INFO);
        DoubleConstraint warn1 = new DoubleConstraint(SA_WARN_MIN, SA_WARN_MAX);
        warn1.setNonEditable();
        this.saParam.setWarningConstraint(warn1);
        this.dampingConstraint = new DoubleDiscreteConstraint();
        this.dampingConstraint.addDouble(DAMPING_DEFAULT);
        this.dampingParam = new DoubleDiscreteParameter(DAMPING_NAME, this.dampingConstraint, DAMPING_UNITS, DAMPING_DEFAULT);
        this.dampingParam.setInfo(DAMPING_INFO);
        this.dampingParam.setNonEditable();
        DoubleConstraint pgaConstraint = new DoubleConstraint(PGA_MIN, PGA_MAX);
        pgaConstraint.setNonEditable();
        this.pgaParam = new WarningDoubleParameter(PGA_NAME, pgaConstraint, "g");
        this.pgaParam.setInfo(PGA_INFO);
        DoubleConstraint warn2 = new DoubleConstraint(PGA_WARN_MIN, PGA_WARN_MAX);
        warn2.setNonEditable();
        this.pgaParam.setWarningConstraint(warn2);
        this.pgaParam.setNonEditable();
    }

    protected void initSiteParams() {
        DoubleConstraint vs30Constraint = new DoubleConstraint(VS30_MIN, VS30_MAX);
        vs30Constraint.setNonEditable();
        this.vs30Param = new WarningDoubleParameter(VS30_NAME, vs30Constraint, VS30_UNITS);
        this.vs30Param.setInfo(VS30_INFO);
        DoubleConstraint c = new DoubleConstraint(DEPTH_2pt5_MIN, DEPTH_2pt5_MAX);
        c.setNullAllowed(true);
        c.setNonEditable();
        this.depthTo2pt5kmPerSecParam = new WarningDoubleParameter(DEPTH_2pt5_NAME, c, "km");
        this.depthTo2pt5kmPerSecParam.setInfo(DEPTH_2pt5_INFO);
    }

    protected void initEqkRuptureParams() {
        DoubleConstraint magConstraint = new DoubleConstraint(MAG_MIN, MAG_MAX);
        magConstraint.setNonEditable();
        this.magParam = new WarningDoubleParameter(MAG_NAME, magConstraint);
        this.magParam.setInfo(MAG_INFO);
        DoubleConstraint dipConstraint = new DoubleConstraint(DIP_MIN, DIP_MAX);
        dipConstraint.setNonEditable();
        this.dipParam = new DoubleParameter(DIP_NAME, dipConstraint);
        this.dipParam.setInfo(DIP_INFO);
        DoubleConstraint rakeConstraint = new DoubleConstraint(RAKE_MIN, RAKE_MAX);
        rakeConstraint.setNonEditable();
        this.rakeParam = new DoubleParameter(RAKE_NAME, rakeConstraint);
        this.rakeParam.setInfo(RAKE_INFO);
        DoubleConstraint c = new DoubleConstraint(RUP_TOP_MIN, RUP_TOP_MAX);
        this.rupTopDepthParam = new DoubleParameter(RUP_TOP_NAME, c, "km");
        this.rupTopDepthParam.setInfo(RUP_TOP_INFO);
    }

    protected abstract void initPropagationEffectParams();

    protected void initParameterEventListeners() {
    }

    public void resetParameterEventListeners() {
    }

    protected void initOtherParams() {
        StringConstraint sigmaTruncTypeConstraint = new StringConstraint();
        sigmaTruncTypeConstraint.addString("None");
        sigmaTruncTypeConstraint.addString(SIGMA_TRUNC_TYPE_1SIDED);
        sigmaTruncTypeConstraint.addString(SIGMA_TRUNC_TYPE_2SIDED);
        sigmaTruncTypeConstraint.setNonEditable();
        this.sigmaTruncTypeParam = new StringParameter(SIGMA_TRUNC_TYPE_NAME, sigmaTruncTypeConstraint, "None");
        this.sigmaTruncTypeParam.setInfo(SIGMA_TRUNC_TYPE_INFO);
        this.sigmaTruncTypeParam.setNonEditable();
        DoubleConstraint sigmaTruncLevelConstraint = new DoubleConstraint(SIGMA_TRUNC_LEVEL_MIN, SIGMA_TRUNC_LEVEL_MAX);
        sigmaTruncLevelConstraint.setNonEditable();
        this.sigmaTruncLevelParam = new DoubleParameter(SIGMA_TRUNC_LEVEL_NAME, sigmaTruncLevelConstraint, SIGMA_TRUNC_LEVEL_UNITS, SIGMA_TRUNC_LEVEL_DEFAULT);
        this.sigmaTruncLevelParam.setInfo(SIGMA_TRUNC_LEVEL_INFO);
        this.sigmaTruncLevelParam.setNonEditable();
        this.otherParams.clear();
        this.otherParams.addParameter(this.sigmaTruncTypeParam);
        this.otherParams.addParameter(this.sigmaTruncLevelParam);
    }
}

