/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr;

import java.util.ListIterator;
import org.opensha.data.Site;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.IMRException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.DependentParameterAPI;
import org.opensha.param.DoubleParameter;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterList;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.IntensityMeasureRelationshipAPI;
import org.opensha.sha.param.PropagationEffect;

public abstract class IntensityMeasureRelationship
implements IntensityMeasureRelationshipAPI {
    private static final String NAME = "Intensity Measure Relationship";
    protected static final String C = "IntensityMeasureRelationship";
    protected static final boolean D = false;
    protected DoubleParameter exceedProbParam = null;
    public static final String EXCEED_PROB_NAME = "Exceed. Prob.";
    protected static final Double EXCEED_PROB_DEFAULT = new Double(0.5);
    public static final String EXCEED_PROB_INFO = "Exceedance Probability";
    public static final Double EXCEED_PROB_MIN = new Double(1.0E-6);
    public static final Double EXCEED_PROB_MAX = new Double(0.999999);
    protected ParameterList siteParams = new ParameterList();
    protected ParameterList eqkRuptureParams = new ParameterList();
    protected ParameterList propagationEffectParams = new ParameterList();
    protected ParameterList supportedIMParams = new ParameterList();
    protected ParameterList otherParams = new ParameterList();
    protected Site site;
    protected EqkRupture eqkRupture;
    protected PropagationEffect propEffect;
    protected ParameterAPI im;
    protected boolean intensityMeasureChanged;

    public IntensityMeasureRelationship() {
        this.exceedProbParam = new DoubleParameter(EXCEED_PROB_NAME, EXCEED_PROB_MIN, EXCEED_PROB_MAX, EXCEED_PROB_DEFAULT);
        this.exceedProbParam.setInfo(EXCEED_PROB_INFO);
        this.exceedProbParam.setNonEditable();
    }

    public String getName() {
        return NAME;
    }

    public void setSite(Site site) {
        this.site = site;
    }

    public void setPropagationEffect(PropagationEffect propEffect) {
        this.setSite(propEffect.getSite());
        this.setEqkRupture(propEffect.getEqkRupture());
    }

    public Site getSite() {
        return this.site;
    }

    public EqkRupture getEqkRupture() {
        return this.eqkRupture;
    }

    public void setEqkRupture(EqkRupture eqkRupture) {
        this.eqkRupture = eqkRupture;
    }

    public Object getIntensityMeasureLevel() {
        return this.im.getValue();
    }

    public void setIntensityMeasureLevel(Object iml) throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("IntensityMeasureRelationship: setIntensityMeasureLevel(): The Intensity Measure has not been set yet, unable to set the level.");
        }
        this.im.setValue(iml);
    }

    public ParameterAPI getIntensityMeasure() {
        return this.im;
    }

    public void setIntensityMeasure(ParameterAPI intensityMeasure) throws ParameterException, ConstraintException {
        if (this.isIntensityMeasureSupported(intensityMeasure)) {
            this.setIntensityMeasure(intensityMeasure.getName());
            ListIterator it = ((DependentParameterAPI)intensityMeasure).getIndependentParametersIterator();
            while (it.hasNext()) {
                ParameterAPI param = (ParameterAPI)it.next();
                this.getParameter(param.getName()).setValue(param.getValue());
            }
        } else {
            throw new ParameterException("This im is not supported, name = " + intensityMeasure.getName());
        }
    }

    public void setIntensityMeasure(String intensityMeasureName) throws ParameterException {
        this.im = this.supportedIMParams.getParameter(intensityMeasureName);
        this.intensityMeasureChanged = true;
    }

    public void setExceedProb(double prob) throws ParameterException {
        this.exceedProbParam.setValue(prob);
    }

    public boolean isIntensityMeasureSupported(ParameterAPI intensityMeasure) {
        if (this.supportedIMParams.containsParameter(intensityMeasure)) {
            ListIterator it = ((DependentParameterAPI)intensityMeasure).getIndependentParametersIterator();
            while (it.hasNext()) {
                ParameterAPI param = (ParameterAPI)it.next();
                if (this.getParameter(param.getName()).isAllowed(param.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isIntensityMeasureSupported(String intensityMeasure) {
        return this.supportedIMParams.containsParameter(intensityMeasure);
    }

    public void setAll(EqkRupture eqkRupture, Site site, ParameterAPI intensityMeasure) throws ParameterException, IMRException, ConstraintException {
        this.setSite(site);
        this.setEqkRupture(eqkRupture);
        this.setIntensityMeasure(intensityMeasure);
    }

    public ParameterAPI getParameter(String name) throws ParameterException {
        if (name.equals(EXCEED_PROB_NAME)) {
            return this.exceedProbParam;
        }
        try {
            return this.siteParams.getParameter(name);
        }
        catch (ParameterException e) {
            try {
                return this.eqkRuptureParams.getParameter(name);
            }
            catch (ParameterException e2) {
                try {
                    return this.propagationEffectParams.getParameter(name);
                }
                catch (ParameterException e3) {
                    try {
                        return this.supportedIMParams.getParameter(name);
                    }
                    catch (ParameterException e4) {
                        ListIterator it = this.supportedIMParams.getParametersIterator();
                        while (it.hasNext()) {
                            DependentParameterAPI param = (DependentParameterAPI)it.next();
                            if (!param.containsIndependentParameter(name)) continue;
                            return param.getIndependentParameter(name);
                        }
                        try {
                            return this.otherParams.getParameter(name);
                        }
                        catch (ParameterException parameterException) {
                            throw new ParameterException("IntensityMeasureRelationship: getParameter(): Parameter doesn't exist named " + name);
                        }
                    }
                }
            }
        }
    }

    public ListIterator getSiteParamsIterator() {
        return this.siteParams.getParametersIterator();
    }

    public ListIterator getOtherParamsIterator() {
        return this.otherParams.getParametersIterator();
    }

    public ListIterator getEqkRuptureParamsIterator() {
        return this.eqkRuptureParams.getParametersIterator();
    }

    public ListIterator getPropagationEffectParamsIterator() {
        return this.propagationEffectParams.getParametersIterator();
    }

    public ListIterator getSupportedIntensityMeasuresIterator() {
        return this.supportedIMParams.getParametersIterator();
    }
}

