/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.awt.Polygon;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.opensha.calc.RelativeLocation;
import org.opensha.data.Direction;
import org.opensha.data.Location;
import org.opensha.data.NamedObjectAPI;
import org.opensha.data.Site;
import org.opensha.exceptions.IMRException;
import org.opensha.exceptions.InvalidRangeException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.DoubleConstraint;
import org.opensha.param.DoubleDiscreteConstraint;
import org.opensha.param.DoubleDiscreteParameter;
import org.opensha.param.StringConstraint;
import org.opensha.param.StringParameter;
import org.opensha.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.AttenuationRelationshipAPI;
import org.opensha.sha.param.DistanceJBParameter;
import org.opensha.sha.param.DistanceRupParameter;
import org.opensha.sha.param.PropagationEffect;
import org.opensha.sha.surface.EvenlyGriddedSurfaceAPI;
import org.opensha.util.FaultUtils;

public class AS_1997_AttenRel
extends AttenuationRelationship
implements AttenuationRelationshipAPI,
NamedObjectAPI {
    private static final String C = "AS_1997_AttenRel";
    private static final boolean D = false;
    public static final String SHORT_NAME = "AS1997";
    public static final String NAME = "Abrahamson & Silva (1997)";
    public static final String FLT_TYPE_REVERSE = "Reverse";
    public static final String FLT_TYPE_REV_OBL = "Reverse-Oblique";
    public static final String FLT_TYPE_OTHER = "Other";
    public static final String FLT_TYPE_DEFAULT = "Other";
    private StringParameter siteTypeParam = null;
    public static final String SITE_TYPE_NAME = "AS Site Type";
    public static final String SITE_TYPE_INFO = "Geological conditions at the site";
    public static final String SITE_TYPE_ROCK = "Rock/Shallow-Soil";
    public static final String SITE_TYPE_SOIL = "Deep-Soil";
    public static final String SITE_TYPE_DEFAULT = "Rock/Shallow-Soil";
    private StringParameter isOnHangingWallParam = null;
    public static final String IS_ON_HANGING_WALL_NAME = "On Hanging Wall?";
    public static final String IS_ON_HANGING_WALL_INFO = "Is site directly over rupture?";
    public static final String IS_ON_HANGING_WALL_TRUE = "Yes";
    public static final String IS_ON_HANGING_WALL_FALSE = "No";
    public static final String IS_ON_HANGING_WALL_DEFAULT = "No";
    protected static final Double MAG_WARN_MIN = new Double(4.5);
    protected static final Double MAG_WARN_MAX = new Double(8.0);
    protected static final Double DISTANCE_RUP_WARN_MIN = new Double(0.0);
    protected static final Double DISTANCE_RUP_WARN_MAX = new Double(200.0);
    private DistanceRupParameter distanceRupParam = null;
    private static final Double DISTANCE_RUP_DEFAULT = new Double(0.0);
    private DistanceJBParameter distanceJBParam = null;
    private static final Double DISTANCE_JB_DEFAULT = new Double(0.0);
    private AS_1997_AttenRelCoefficients coeff = null;
    protected Hashtable horzCoeffs = new Hashtable();
    protected Hashtable vertCoeffs = new Hashtable();
    private double a2;
    private double a4;
    private double a13;
    private double c1;
    private double c5;
    private double n;
    private transient ParameterChangeWarningListener warningListener = null;

    public AS_1997_AttenRel(ParameterChangeWarningListener warningListener) {
        this.warningListener = warningListener;
        this.initCoefficients();
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    protected void setFaultTypeFromRake(double rake) throws InvalidRangeException {
        FaultUtils.assertValidRake(rake);
        if (rake >= 67.5 && rake <= 112.5) {
            this.fltTypeParam.setValue(FLT_TYPE_REVERSE);
        } else if (rake < 67.5 && rake >= 22.5) {
            this.fltTypeParam.setValue(FLT_TYPE_REV_OBL);
        } else if (rake <= 157.5 && rake > 112.5) {
            this.fltTypeParam.setValue(FLT_TYPE_REV_OBL);
        } else {
            this.fltTypeParam.setValue("Other");
        }
    }

    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(new Double(eqkRupture.getMag()));
        this.setFaultTypeFromRake(eqkRupture.getAveRake());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    public void setSite(Site site) throws ParameterException {
        this.siteTypeParam.setValue(site.getParameter(SITE_TYPE_NAME).getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    public void setPropagationEffect(PropagationEffect propEffect) throws ParameterException, InvalidRangeException {
        this.site = propEffect.getSite();
        this.eqkRupture = propEffect.getEqkRupture();
        this.siteTypeParam.setValue(this.site.getParameter(SITE_TYPE_NAME).getValue());
        this.magParam.setValueIgnoreWarning(new Double(this.eqkRupture.getMag()));
        this.setFaultTypeFromRake(this.eqkRupture.getAveRake());
        propEffect.setParamValue(this.distanceRupParam);
        int numPts = this.eqkRupture.getRuptureSurface().getNumCols();
        if (this.eqkRupture.getRuptureSurface().getAveDip() <= 70.0 && this.isOnHangingWall() && numPts > 1) {
            this.isOnHangingWallParam.setValue(IS_ON_HANGING_WALL_TRUE);
        } else {
            this.isOnHangingWallParam.setValue("No");
        }
    }

    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
            int numPts = this.eqkRupture.getRuptureSurface().getNumCols();
            if (this.eqkRupture.getRuptureSurface().getAveDip() <= 70.0 && this.isOnHangingWall() && numPts > 1) {
                this.isOnHangingWallParam.setValue(IS_ON_HANGING_WALL_TRUE);
            } else {
                this.isOnHangingWallParam.setValue("No");
            }
        }
    }

    protected boolean isOnHangingWall() {
        Location loc;
        double toIntFactor = 1.0E7;
        EvenlyGriddedSurfaceAPI surface = this.eqkRupture.getRuptureSurface();
        int numCols = surface.getNumCols();
        int[] xVals = new int[numCols + 2];
        int[] yVals = new int[numCols + 2];
        for (int c = 0; c < numCols; ++c) {
            loc = surface.getLocation(0, c);
            xVals[c] = (int)(loc.getLongitude() * toIntFactor);
            yVals[c] = (int)(loc.getLatitude() * toIntFactor);
        }
        loc = surface.getLocation(0, numCols - 1);
        Location loc2 = surface.getLocation(surface.getNumRows() - 1, numCols - 1);
        Direction dir = RelativeLocation.getDirection(loc, loc2);
        dir.setHorzDistance(100.0);
        Location loc3 = RelativeLocation.getLocation(loc, dir);
        xVals[numCols] = (int)(loc3.getLongitude() * toIntFactor);
        yVals[numCols] = (int)(loc3.getLatitude() * toIntFactor);
        loc = surface.getLocation(0, 0);
        loc2 = surface.getLocation(surface.getNumRows() - 1, 0);
        dir = RelativeLocation.getDirection(loc, loc2);
        dir.setHorzDistance(100.0);
        loc3 = RelativeLocation.getLocation(loc, dir);
        xVals[numCols + 1] = (int)(loc3.getLongitude() * toIntFactor);
        yVals[numCols + 1] = (int)(loc3.getLatitude() * toIntFactor);
        Polygon polygon = new Polygon(xVals, yVals, numCols + 2);
        Location siteLoc = this.site.getLocation();
        int siteX = (int)(siteLoc.getLongitude() * toIntFactor);
        int siteY = (int)(siteLoc.getLatitude() * toIntFactor);
        return polygon.contains(siteX, siteY);
    }

    protected void updateCoefficients() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("AS_1997_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        StringBuffer key = new StringBuffer(this.im.getName());
        if (this.im.getName().equalsIgnoreCase("SA")) {
            key.append("/" + this.periodParam.getValue());
        }
        if (this.componentParam.getValue().toString().equals("Average Horizontal")) {
            this.a2 = 0.512;
            this.a4 = -0.144;
            this.a13 = 0.17;
            this.c1 = 6.4;
            this.c5 = 0.03;
            this.n = 2.0;
            this.coeff = (AS_1997_AttenRelCoefficients)this.horzCoeffs.get(key.toString());
        } else {
            this.a2 = 0.909;
            this.a4 = 0.275;
            this.a13 = 0.06;
            this.c1 = 6.4;
            this.c5 = 0.3;
            this.n = 3.0;
            this.coeff = (AS_1997_AttenRelCoefficients)this.vertCoeffs.get(key.toString());
        }
    }

    public double getMean() throws IMRException {
        double mean;
        String isHW;
        String siteType;
        String fltType;
        double dist;
        double mag;
        try {
            mag = (Double)this.magParam.getValue();
            dist = (Double)this.distanceRupParam.getValue();
            fltType = this.fltTypeParam.getValue().toString();
            siteType = this.siteTypeParam.getValue().toString();
            isHW = this.isOnHangingWallParam.getValue().toString();
            String component = this.componentParam.getValue().toString();
        }
        catch (NullPointerException e) {
            throw new IMRException("AS_1997_AttenRel: getMean(): Not all parameters have been set");
        }
        if (dist > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        double F = fltType.equals(FLT_TYPE_REVERSE) ? 1.0 : (fltType.equals(FLT_TYPE_REV_OBL) ? 0.5 : 0.0);
        int HW = isHW.equals(IS_ON_HANGING_WALL_TRUE) ? 1 : 0;
        if (this.componentParam.getValue().toString().equals("Average Horizontal")) {
            this.coeff = (AS_1997_AttenRelCoefficients)this.horzCoeffs.get("PGA");
            this.a2 = 0.512;
            this.a4 = -0.144;
            this.a13 = 0.17;
            this.c1 = 6.4;
            this.c5 = 0.03;
            this.n = 2.0;
        } else {
            this.coeff = (AS_1997_AttenRelCoefficients)this.vertCoeffs.get("PGA");
            this.a2 = 0.909;
            this.a4 = 0.275;
            this.a13 = 0.06;
            this.c1 = 6.4;
            this.c5 = 0.3;
            this.n = 3.0;
        }
        double rockMeanPGA = this.calcRockMean(mag, dist, F, HW);
        this.updateCoefficients();
        double rockMean = this.calcRockMean(mag, dist, F, HW);
        if (siteType.equals(SITE_TYPE_SOIL)) {
            double f5 = this.coeff.a10 + this.coeff.a11 * Math.log(Math.exp(rockMeanPGA) + this.c5);
            mean = rockMean + f5;
        } else {
            mean = rockMean;
        }
        return mean;
    }

    private double calcRockMean(double mag, double dist, double F, int HW) {
        double R = Math.sqrt(dist * dist + this.coeff.c4 * this.coeff.c4);
        double f1 = mag <= this.c1 ? this.coeff.a1 + this.a2 * (mag - this.c1) + this.coeff.a12 * Math.pow(8.5 - mag, this.n) + Math.log(R) * (this.coeff.a3 + this.a13 * (mag - this.c1)) : this.coeff.a1 + this.a4 * (mag - this.c1) + this.coeff.a12 * Math.pow(8.5 - mag, this.n) + Math.log(R) * (this.coeff.a3 + this.a13 * (mag - this.c1));
        double f3 = mag <= 5.8 ? this.coeff.a5 : (mag > 5.8 && mag < this.c1 ? this.coeff.a5 + (this.coeff.a6 - this.coeff.a5) * (mag - 5.8) / (this.c1 - 5.8) : this.coeff.a6);
        if (HW == 1) {
            double fHWM = mag <= 5.5 ? 0.0 : (mag > 5.5 && mag < 6.5 ? mag - 5.5 : 1.0);
            double fHWRrup = dist <= 4.0 ? 0.0 : (dist > 4.0 && dist <= 8.0 ? this.coeff.a9 * (dist - 4.0) / 4.0 : (dist > 8.0 && dist <= 18.0 ? this.coeff.a9 : (dist > 18.0 && dist <= 25.0 ? this.coeff.a9 * (1.0 - (dist - 18.0) / 7.0) : 0.0)));
            return f1 + F * f3 + fHWM * fHWRrup;
        }
        return f1 + F * f3;
    }

    public double getStdDev() throws IMRException {
        if (this.stdDevTypeParam.getValue().equals("None (zero)")) {
            return 0.0;
        }
        this.updateCoefficients();
        double mag = (Double)this.magParam.getValue();
        if (mag <= 5.0) {
            return this.coeff.b5;
        }
        if (mag > 5.0 && mag < 7.0) {
            return this.coeff.b5 - this.coeff.b6 * (mag - 5.0);
        }
        return this.coeff.b5 - 2.0 * this.coeff.b6;
    }

    public void setParamDefaults() {
        this.siteTypeParam.setValue("Rock/Shallow-Soil");
        this.magParam.setValue(MAG_DEFAULT);
        this.fltTypeParam.setValue("Other");
        this.distanceRupParam.setValue(DISTANCE_RUP_DEFAULT);
        this.saParam.setValue(SA_DEFAULT);
        this.periodParam.setValue(PERIOD_DEFAULT);
        this.dampingParam.setValue(DAMPING_DEFAULT);
        this.pgaParam.setValue(PGA_DEFAULT);
        this.componentParam.setValue("Average Horizontal");
        this.stdDevTypeParam.setValue("Total");
        this.isOnHangingWallParam.setValue("No");
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.siteTypeParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.isOnHangingWallParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.magParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameter(this.distanceRupParam);
        this.exceedProbIndependentParams.addParameter(this.siteTypeParam);
        this.exceedProbIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.addParameter(this.fltTypeParam);
        this.exceedProbIndependentParams.addParameter(this.isOnHangingWallParam);
        this.exceedProbIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    protected void initSiteParams() {
        StringConstraint siteConstraint = new StringConstraint();
        siteConstraint.addString("Rock/Shallow-Soil");
        siteConstraint.addString(SITE_TYPE_SOIL);
        siteConstraint.setNonEditable();
        this.siteTypeParam = new StringParameter(SITE_TYPE_NAME, siteConstraint, null);
        this.siteTypeParam.setInfo(SITE_TYPE_INFO);
        this.siteTypeParam.setNonEditable();
        this.siteParams.clear();
        this.siteParams.addParameter(this.siteTypeParam);
    }

    protected void initEqkRuptureParams() {
        super.initEqkRuptureParams();
        DoubleConstraint warn = new DoubleConstraint(MAG_WARN_MIN, MAG_WARN_MAX);
        warn.setNonEditable();
        this.magParam.setWarningConstraint(warn);
        this.magParam.addParameterChangeWarningListener(this.warningListener);
        this.magParam.setNonEditable();
        StringConstraint constraint = new StringConstraint();
        constraint.addString(FLT_TYPE_REVERSE);
        constraint.addString(FLT_TYPE_REV_OBL);
        constraint.addString("Other");
        constraint.setNonEditable();
        this.fltTypeParam = new StringParameter("Fault Type", constraint, null);
        this.fltTypeParam.setInfo("Style of faulting");
        this.fltTypeParam.setNonEditable();
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
    }

    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter();
        this.distanceRupParam.addParameterChangeWarningListener(this.warningListener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.setNonEditable();
        StringConstraint HW_Constraint = new StringConstraint();
        HW_Constraint.addString(IS_ON_HANGING_WALL_TRUE);
        HW_Constraint.addString("No");
        HW_Constraint.setNonEditable();
        this.isOnHangingWallParam = new StringParameter(IS_ON_HANGING_WALL_NAME, HW_Constraint, "No");
        this.isOnHangingWallParam.setInfo(IS_ON_HANGING_WALL_INFO);
        this.isOnHangingWallParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
        this.propagationEffectParams.addParameter(this.isOnHangingWallParam);
        this.distanceJBParam = new DistanceJBParameter();
    }

    protected void initSupportedIntensityMeasureParams() {
        super.initSupportedIntensityMeasureParams();
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        TreeSet<Double> set = new TreeSet<Double>();
        Enumeration keys = this.horzCoeffs.keys();
        while (keys.hasMoreElements()) {
            AS_1997_AttenRelCoefficients coeff = (AS_1997_AttenRelCoefficients)this.horzCoeffs.get(keys.nextElement());
            if (!(coeff.period >= 0.0)) continue;
            set.add(new Double(coeff.period));
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            periodConstraint.addDouble((Double)it.next());
        }
        periodConstraint.setNonEditable();
        this.periodParam = new DoubleDiscreteParameter("SA Period", periodConstraint, "sec", null);
        this.periodParam.setInfo("Oscillator Period for SA");
        this.periodParam.setNonEditable();
        this.dampingConstraint.setNonEditable();
        this.saParam.addIndependentParameter(this.dampingParam);
        this.saParam.addIndependentParameter(this.periodParam);
        this.saParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint constraint = new StringConstraint();
        constraint.addString("Average Horizontal");
        constraint.addString("Vertical");
        constraint.setNonEditable();
        this.componentParam = new StringParameter("Component", constraint, "Average Horizontal");
        this.componentParam.setInfo("Component of shaking");
        this.componentParam.setNonEditable();
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StringParameter("Std Dev Type", stdDevTypeConstraint, "Total");
        this.stdDevTypeParam.setInfo("Type of Standard Deviation");
        this.stdDevTypeParam.setNonEditable();
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    protected void initCoefficients() {
        String S = "AS_1997_AttenRel: initCoefficients():";
        this.horzCoeffs.clear();
        AS_1997_AttenRelCoefficients coeff = new AS_1997_AttenRelCoefficients("PGA", 0.0, 5.6, 1.64, -1.145, 0.61, 0.26, 0.37, -0.417, -0.23, 0.0, 0.7, 0.135);
        AS_1997_AttenRelCoefficients coeff0 = new AS_1997_AttenRelCoefficients("SA/" + new Double("5.00"), 5.0, 3.5, -1.46, -0.725, 0.4, -0.2, 0.0, 0.664, 0.04, -0.215, 0.89, 0.087);
        AS_1997_AttenRelCoefficients coeff1 = new AS_1997_AttenRelCoefficients("SA/" + new Double("4.00"), 4.0, 3.5, -1.13, -0.725, 0.4, -0.2, 0.039, 0.64, 0.04, -0.1956, 0.88, 0.092);
        AS_1997_AttenRelCoefficients coeff2 = new AS_1997_AttenRelCoefficients("SA/" + new Double("3.00"), 3.0, 3.5, -0.69, -0.725, 0.4, -0.156, 0.089, 0.63, 0.04, -0.1726, 0.87, 0.097);
        AS_1997_AttenRelCoefficients coeff3 = new AS_1997_AttenRelCoefficients("SA/" + new Double("2.00"), 2.0, 3.5, -0.15, -0.725, 0.4, -0.094, 0.16, 0.61, 0.04, -0.14, 0.85, 0.105);
        AS_1997_AttenRelCoefficients coeff4 = new AS_1997_AttenRelCoefficients("SA/" + new Double("1.50"), 1.5, 3.55, 0.26, -0.7721, 0.438, -0.049, 0.21, 0.6, 0.04, -0.12, 0.84, 0.11);
        AS_1997_AttenRelCoefficients coeff5 = new AS_1997_AttenRelCoefficients("SA/" + new Double("1.00"), 1.0, 3.7, 0.828, -0.8383, 0.49, 0.013, 0.281, 0.423, 0.0, -0.102, 0.83, 0.118);
        AS_1997_AttenRelCoefficients coeff6 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.85"), 0.85, 3.81, 1.02, -0.8648, 0.512, 0.038, 0.309, 0.37, -0.028, -0.0927, 0.82, 0.121);
        AS_1997_AttenRelCoefficients coeff7 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.75"), 0.75, 3.9, 1.16, -0.8852, 0.528, 0.057, 0.331, 0.32, -0.05, -0.0862, 0.81, 0.123);
        AS_1997_AttenRelCoefficients coeff8 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.60"), 0.6, 4.12, 1.428, -0.9218, 0.557, 0.091, 0.37, 0.194, -0.089, -0.074, 0.81, 0.127);
        AS_1997_AttenRelCoefficients coeff9 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.50"), 0.5, 4.3, 1.615, -0.9515, 0.581, 0.119, 0.37, 0.085, -0.121, -0.0635, 0.8, 0.13);
        AS_1997_AttenRelCoefficients coeff10 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.46"), 0.46, 4.38, 1.717, -0.9652, 0.592, 0.132, 0.37, 0.02, -0.136, -0.0594, 0.8, 0.132);
        AS_1997_AttenRelCoefficients coeff11 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.40"), 0.4, 4.52, 1.86, -0.988, 0.61, 0.154, 0.37, -0.065, -0.16, -0.0518, 0.79, 0.135);
        AS_1997_AttenRelCoefficients coeff12 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.36"), 0.36, 4.62, 1.955, -1.0052, 0.61, 0.17, 0.37, -0.123, -0.173, -0.046, 0.79, 0.135);
        AS_1997_AttenRelCoefficients coeff13 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.30"), 0.3, 4.8, 2.114, -1.035, 0.61, 0.198, 0.37, -0.219, -0.195, -0.036, 0.78, 0.135);
        AS_1997_AttenRelCoefficients coeff14 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.24"), 0.24, 4.97, 2.293, -1.079, 0.61, 0.232, 0.37, -0.35, -0.223, -0.0238, 0.77, 0.135);
        AS_1997_AttenRelCoefficients coeff15 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.20"), 0.2, 5.1, 2.406, -1.115, 0.61, 0.26, 0.37, -0.445, -0.245, -0.0138, 0.77, 0.135);
        AS_1997_AttenRelCoefficients coeff16 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.17"), 0.17, 5.19, 2.43, -1.135, 0.61, 0.26, 0.37, -0.522, -0.265, -0.004, 0.76, 0.135);
        AS_1997_AttenRelCoefficients coeff17 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.15"), 0.15, 5.27, 2.407, -1.145, 0.61, 0.26, 0.37, -0.577, -0.28, 0.005, 0.75, 0.135);
        AS_1997_AttenRelCoefficients coeff18 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.12"), 0.12, 5.39, 2.272, -1.145, 0.61, 0.26, 0.37, -0.591, -0.28, 0.018, 0.75, 0.135);
        AS_1997_AttenRelCoefficients coeff19 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.10"), 0.1, 5.5, 2.16, -1.145, 0.61, 0.26, 0.37, -0.598, -0.28, 0.028, 0.74, 0.135);
        AS_1997_AttenRelCoefficients coeff20 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.09"), 0.09, 5.54, 2.1, -1.145, 0.61, 0.26, 0.37, -0.609, -0.28, 0.03, 0.74, 0.135);
        AS_1997_AttenRelCoefficients coeff21 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.075"), 0.075, 5.58, 2.037, -1.145, 0.61, 0.26, 0.37, -0.628, -0.28, 0.03, 0.73, 0.135);
        AS_1997_AttenRelCoefficients coeff22 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.06"), 0.06, 5.6, 1.94, -1.145, 0.61, 0.26, 0.37, -0.665, -0.28, 0.03, 0.72, 0.135);
        AS_1997_AttenRelCoefficients coeff23 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.05"), 0.05, 5.6, 1.87, -1.145, 0.61, 0.26, 0.37, -0.62, -0.267, 0.028, 0.71, 0.135);
        AS_1997_AttenRelCoefficients coeff24 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.04"), 0.04, 5.6, 1.78, -1.145, 0.61, 0.26, 0.37, -0.555, -0.251, 0.0245, 0.71, 0.135);
        AS_1997_AttenRelCoefficients coeff25 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.03"), 0.03, 5.6, 1.69, -1.145, 0.61, 0.26, 0.37, -0.47, -0.23, 0.0143, 0.7, 0.135);
        AS_1997_AttenRelCoefficients coeff26 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.02"), 0.02, 5.6, 1.64, -1.145, 0.61, 0.26, 0.37, -0.417, -0.23, 0.0, 0.7, 0.135);
        AS_1997_AttenRelCoefficients coeff27 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.01"), 0.01, 5.6, 1.64, -1.145, 0.61, 0.26, 0.37, -0.417, -0.23, 0.0, 0.7, 0.135);
        AS_1997_AttenRelCoefficients coeff28 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.0"), 0.0, 5.6, 1.64, -1.145, 0.61, 0.26, 0.37, -0.417, -0.23, 0.0, 0.7, 0.135);
        this.horzCoeffs.put(coeff.getName(), coeff);
        this.horzCoeffs.put(coeff0.getName(), coeff0);
        this.horzCoeffs.put(coeff1.getName(), coeff1);
        this.horzCoeffs.put(coeff2.getName(), coeff2);
        this.horzCoeffs.put(coeff3.getName(), coeff3);
        this.horzCoeffs.put(coeff4.getName(), coeff4);
        this.horzCoeffs.put(coeff5.getName(), coeff5);
        this.horzCoeffs.put(coeff6.getName(), coeff6);
        this.horzCoeffs.put(coeff7.getName(), coeff7);
        this.horzCoeffs.put(coeff8.getName(), coeff8);
        this.horzCoeffs.put(coeff9.getName(), coeff9);
        this.horzCoeffs.put(coeff10.getName(), coeff10);
        this.horzCoeffs.put(coeff11.getName(), coeff11);
        this.horzCoeffs.put(coeff12.getName(), coeff12);
        this.horzCoeffs.put(coeff13.getName(), coeff13);
        this.horzCoeffs.put(coeff14.getName(), coeff14);
        this.horzCoeffs.put(coeff15.getName(), coeff15);
        this.horzCoeffs.put(coeff16.getName(), coeff16);
        this.horzCoeffs.put(coeff17.getName(), coeff17);
        this.horzCoeffs.put(coeff18.getName(), coeff18);
        this.horzCoeffs.put(coeff19.getName(), coeff19);
        this.horzCoeffs.put(coeff20.getName(), coeff20);
        this.horzCoeffs.put(coeff21.getName(), coeff21);
        this.horzCoeffs.put(coeff22.getName(), coeff22);
        this.horzCoeffs.put(coeff23.getName(), coeff23);
        this.horzCoeffs.put(coeff24.getName(), coeff24);
        this.horzCoeffs.put(coeff25.getName(), coeff25);
        this.horzCoeffs.put(coeff26.getName(), coeff26);
        this.horzCoeffs.put(coeff27.getName(), coeff27);
        this.horzCoeffs.put(coeff28.getName(), coeff28);
        this.vertCoeffs.clear();
        coeff = new AS_1997_AttenRelCoefficients("PGA", 0.0, 6.0, 1.642, -1.252, 0.39, -0.05, 0.63, -0.14, -0.22, -0.0, 0.76, 0.085);
        coeff0 = new AS_1997_AttenRelCoefficients("SA/" + new Double("5.00"), 5.0, 2.5, -2.053, -0.72, 0.26, -0.1, 0.24, 0.04, -0.22, -0.067, 0.78, 0.05);
        coeff1 = new AS_1997_AttenRelCoefficients("SA/" + new Double("4.00"), 4.0, 2.5, -1.857, -0.72, 0.26, -0.1, 0.24, 0.04, -0.22, -0.0565, 0.75, 0.05);
        coeff2 = new AS_1997_AttenRelCoefficients("SA/" + new Double("3.00"), 3.0, 2.5, -1.581, -0.72, 0.26, -0.1, 0.24, 0.04, -0.22, -0.0431, 0.72, 0.05);
        coeff3 = new AS_1997_AttenRelCoefficients("SA/" + new Double("2.00"), 2.0, 2.5, -1.224, -0.72, 0.26, -0.008, 0.24, 0.04, -0.22, -0.024, 0.69, 0.05);
        coeff4 = new AS_1997_AttenRelCoefficients("SA/" + new Double("1.50"), 1.5, 2.5, -0.966, -0.7285, 0.26, 0.058, 0.24, 0.025, -0.22, -0.018, 0.69, 0.05);
        coeff5 = new AS_1997_AttenRelCoefficients("SA/" + new Double("1.00"), 1.0, 2.5, -0.602, -0.7404, 0.26, 0.15, 0.24, 0.004, -0.22, -0.0115, 0.69, 0.05);
        coeff6 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.85"), 0.85, 2.5, -0.469, -0.7451, 0.309, 0.15, 0.273, -0.004, -0.22, -0.0097, 0.69, 0.05);
        coeff7 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.75"), 0.75, 2.5, -0.344, -0.7488, 0.348, 0.15, 0.299, -0.01, -0.22, -0.0083, 0.69, 0.05);
        coeff8 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.60"), 0.6, 2.85, -0.087, -0.7896, 0.416, 0.15, 0.345, -0.022, -0.22, -0.0068, 0.69, 0.05);
        coeff9 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.50"), 0.5, 3.26, 0.145, -0.8291, 0.471, 0.15, 0.383, -0.031, -0.22, -0.006, 0.69, 0.05);
        coeff10 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.46"), 0.46, 3.45, 0.271, -0.8472, 0.497, 0.15, 0.4, -0.035, -0.22, -0.0056, 0.69, 0.05);
        coeff11 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.40"), 0.4, 3.77, 0.478, -0.8776, 0.539, 0.15, 0.428, -0.043, -0.22, -0.005, 0.69, 0.05);
        coeff12 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.36"), 0.36, 4.01, 0.617, -0.9004, 0.571, 0.15, 0.45, -0.048, -0.22, -0.0047, 0.69, 0.05);
        coeff13 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.30"), 0.3, 4.42, 0.878, -0.94, 0.58, 0.15, 0.488, -0.057, -0.22, -0.0042, 0.69, 0.05);
        coeff14 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.24"), 0.24, 4.93, 1.312, -1.0274, 0.58, 0.109, 0.533, -0.069, -0.22, -0.0035, 0.69, 0.05);
        coeff15 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.20"), 0.2, 5.35, 1.648, -1.0987, 0.58, 0.076, 0.571, -0.078, -0.22, -0.003, 0.69, 0.05);
        coeff16 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.17"), 0.17, 5.72, 1.96, -1.1623, 0.58, 0.047, 0.604, -0.087, -0.22, -0.0025, 0.7, 0.056);
        coeff17 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.15"), 0.15, 6.0, 2.17, -1.2113, 0.58, 0.024, 0.63, -0.093, -0.22, -0.0022, 0.72, 0.063);
        coeff18 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.12"), 0.12, 6.0, 2.48, -1.2986, 0.58, -0.017, 0.63, -0.104, -0.22, -0.0015, 0.74, 0.075);
        coeff19 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.10"), 0.1, 6.0, 2.7, -1.37, 0.58, -0.05, 0.63, -0.114, -0.22, -0.001, 0.76, 0.085);
        coeff20 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.09"), 0.09, 6.0, 2.73, -1.37, 0.567, -0.05, 0.63, -0.119, -0.22, -9.0E-4, 0.76, 0.085);
        coeff21 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.075"), 0.075, 6.0, 2.75, -1.37, 0.545, -0.05, 0.63, -0.129, -0.22, -7.0E-4, 0.76, 0.085);
        coeff22 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.06"), 0.06, 6.0, 2.71, -1.37, 0.518, -0.05, 0.63, -0.14, -0.22, -4.0E-4, 0.76, 0.085);
        coeff23 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.05"), 0.05, 6.0, 2.62, -1.37, 0.496, -0.05, 0.63, -0.14, -0.22, -2.0E-4, 0.76, 0.085);
        coeff24 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.04"), 0.04, 6.0, 2.42, -1.37, 0.469, -0.05, 0.63, -0.14, -0.22, -0.0, 0.76, 0.085);
        coeff25 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.03"), 0.03, 6.0, 2.1, -1.3168, 0.432, -0.05, 0.63, -0.14, -0.22, -0.0, 0.76, 0.085);
        coeff26 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.02"), 0.02, 6.0, 1.642, -1.252, 0.39, -0.05, 0.63, -0.14, -0.22, -0.0, 0.76, 0.085);
        coeff27 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.01"), 0.01, 6.0, 1.642, -1.252, 0.39, -0.05, 0.63, -0.14, -0.22, -0.0, 0.76, 0.085);
        coeff28 = new AS_1997_AttenRelCoefficients("SA/" + new Double("0.0"), 0.0, 6.0, 1.642, -1.252, 0.39, -0.05, 0.63, -0.14, -0.22, -0.0, 0.76, 0.085);
        this.vertCoeffs.put(coeff.getName(), coeff);
        this.vertCoeffs.put(coeff0.getName(), coeff0);
        this.vertCoeffs.put(coeff1.getName(), coeff1);
        this.vertCoeffs.put(coeff2.getName(), coeff2);
        this.vertCoeffs.put(coeff3.getName(), coeff3);
        this.vertCoeffs.put(coeff4.getName(), coeff4);
        this.vertCoeffs.put(coeff5.getName(), coeff5);
        this.vertCoeffs.put(coeff6.getName(), coeff6);
        this.vertCoeffs.put(coeff7.getName(), coeff7);
        this.vertCoeffs.put(coeff8.getName(), coeff8);
        this.vertCoeffs.put(coeff9.getName(), coeff9);
        this.vertCoeffs.put(coeff10.getName(), coeff10);
        this.vertCoeffs.put(coeff11.getName(), coeff11);
        this.vertCoeffs.put(coeff12.getName(), coeff12);
        this.vertCoeffs.put(coeff13.getName(), coeff13);
        this.vertCoeffs.put(coeff14.getName(), coeff14);
        this.vertCoeffs.put(coeff15.getName(), coeff15);
        this.vertCoeffs.put(coeff16.getName(), coeff16);
        this.vertCoeffs.put(coeff17.getName(), coeff17);
        this.vertCoeffs.put(coeff18.getName(), coeff18);
        this.vertCoeffs.put(coeff19.getName(), coeff19);
        this.vertCoeffs.put(coeff20.getName(), coeff20);
        this.vertCoeffs.put(coeff21.getName(), coeff21);
        this.vertCoeffs.put(coeff22.getName(), coeff22);
        this.vertCoeffs.put(coeff23.getName(), coeff23);
        this.vertCoeffs.put(coeff24.getName(), coeff24);
        this.vertCoeffs.put(coeff25.getName(), coeff25);
        this.vertCoeffs.put(coeff26.getName(), coeff26);
        this.vertCoeffs.put(coeff27.getName(), coeff27);
        this.vertCoeffs.put(coeff28.getName(), coeff28);
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return SHORT_NAME;
    }

    class AS_1997_AttenRelCoefficients
    implements NamedObjectAPI {
        protected static final String C = "AS_1997_AttenRelCoefficients";
        protected static final boolean D = true;
        private static final long serialVersionUID = 1234567890987654322L;
        protected String name;
        protected double period = -1.0;
        protected double c4;
        protected double a1;
        protected double a3;
        protected double a5;
        protected double a6;
        protected double a9;
        protected double a10;
        protected double a11;
        protected double a12;
        protected double b5;
        protected double b6;

        public AS_1997_AttenRelCoefficients(String name) {
            this.name = name;
        }

        public AS_1997_AttenRelCoefficients(String name, double period, double c4, double a1, double a3, double a5, double a6, double a9, double a10, double a11, double a12, double b5, double b6) {
            this.name = name;
            this.period = period;
            this.c4 = c4;
            this.a1 = a1;
            this.a3 = a3;
            this.a5 = a5;
            this.a6 = a6;
            this.a9 = a9;
            this.a10 = a10;
            this.a11 = a11;
            this.a12 = a12;
            this.b5 = b5;
            this.b6 = b6;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(C);
            b.append("\n  Period = " + this.period);
            b.append("\n  c4 = " + this.c4);
            b.append("\n  a1 = " + this.a1);
            b.append("\n  a2 = " + AS_1997_AttenRel.this.a2);
            b.append("\n  a3 = " + this.a3);
            b.append("\n  a4 = " + AS_1997_AttenRel.this.a4);
            b.append("\n  a5 = " + this.a5);
            b.append("\n  a6 = " + this.a6);
            b.append("\n  a9 = " + this.a9);
            b.append("\n  a10 = " + this.a10);
            b.append("\n  a11 = " + this.a11);
            b.append("\n  a12 = " + this.a12);
            b.append("\n  a13 = " + AS_1997_AttenRel.this.a13);
            b.append("\n  c1 = " + AS_1997_AttenRel.this.c1);
            b.append("\n  c5 = " + AS_1997_AttenRel.this.c5);
            b.append("\n  n = " + AS_1997_AttenRel.this.n);
            b.append("\n  b5 = " + this.b5);
            b.append("\n  b6 = " + this.b6);
            return b.toString();
        }
    }
}

