/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.util.HashMap;
import org.opensha.data.NamedObjectAPI;
import org.opensha.data.Site;
import org.opensha.exceptions.InvalidRangeException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.DoubleConstraint;
import org.opensha.param.DoubleDiscreteConstraint;
import org.opensha.param.DoubleDiscreteParameter;
import org.opensha.param.StringConstraint;
import org.opensha.param.StringParameter;
import org.opensha.param.event.ParameterChangeEvent;
import org.opensha.param.event.ParameterChangeListener;
import org.opensha.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.AttenuationRelationshipAPI;
import org.opensha.sha.param.DistRupMinusJB_OverRupParameter;
import org.opensha.sha.param.DistanceRupParameter;
import org.opensha.sha.surface.EvenlyGriddedSurfaceAPI;

public class CY_2005_prelim_AttenRel
extends AttenuationRelationship
implements AttenuationRelationshipAPI,
NamedObjectAPI,
ParameterChangeListener {
    private static final String C = "CY_2005_prelim_AttenRel";
    private static final boolean D = false;
    public static final String NAME = "Chiou & Youngs (2005 prelim)";
    public static final String SHORT_NAME = "CY2005";
    double[] period = new double[]{0.01, 0.029, 0.05, 0.075, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5, 0.6, 0.75, 0.85, 1.0, 1.5, 2.0, 3.0};
    double[] c1 = new double[]{0.4831, 0.5923, 0.8209, 1.1083, 1.2562, 1.3946, 1.3379, 1.1409, 0.9347, 0.7252, 0.5265, 0.3121, 0.2299, 0.0531, -0.2847, -0.5664, -0.7916};
    double[] c2 = new double[]{-0.45, -0.45, -0.45, -0.45, -0.45, -0.45, -0.45, -0.45, -0.45, -0.45, -0.45, -0.45, -0.45, -0.45, -0.45, -0.45, -0.45};
    double[] cm = new double[]{-0.38, -0.38, -0.38, -0.38, -0.38, -0.38, -0.38, -0.38, -0.38, -0.38, -0.38, -0.38, -0.38, -0.38, -0.38, -0.38, -0.38};
    double[] mc = new double[]{5.0, 5.0, 5.0, 5.0, 5.0, 5.35, 5.6, 6.0, 6.2, 6.4, 6.55, 6.75, 6.85, 7.0, 7.35, 7.6, 8.0};
    double[] c4 = new double[]{-1.05, -1.05, -1.05, -1.05, -1.05, -1.05, -1.05, -1.05, -1.05, -1.05, -1.05, -1.05, -1.05, -1.05, -1.05, -1.05, -1.05};
    double[] c5 = new double[]{0.35, 0.35, 0.35, 0.35, 0.35, 0.35, 0.35, 0.35, 0.35, 0.35, 0.35, 0.35, 0.35, 0.35, 0.35, 0.35, 0.35};
    double[] H = new double[]{1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5};
    double[] Frv = new double[]{0.14, 0.14, 0.14, 0.139, 0.138, 0.137, 0.134, 0.127, 0.118, 0.108, 0.098, 0.082, 0.073, 0.06, 0.029, 0.014, 0.0};
    double[] Ftor = new double[]{0.055, 0.055, 0.055, 0.055, 0.055, 0.055, 0.055, 0.055, 0.055, 0.055, 0.054, 0.052, 0.049, 0.044, 0.026, 0.013, 0.003};
    double[] Fhw = new double[]{0.9, 0.9, 0.9, 0.9, 0.89, 0.87, 0.85, 0.81, 0.77, 0.725, 0.69, 0.65, 0.625, 0.59, 0.49, 0.38, 0.15};
    double[] gamma = new double[]{-0.007134285, -0.007652814, -0.008450043, -0.00931877, -0.009461162, -0.008840156, -0.007485059, -0.006085877, -0.005305312, -0.004750315, -0.004177759, -0.003691066, -0.003520939, -0.003382255, -0.003092895, -0.002646036, -0.002516161};
    double[] phi1 = new double[]{-0.489, -0.479, -0.457, -0.425, -0.433, -0.425, -0.459, -0.537, -0.576, -0.62, -0.659, -0.703, -0.713, -0.764, -0.835, -0.885, -0.873};
    double[] phi2 = new double[]{-0.264, -0.281, -0.3145, -0.3158, -0.2915, -0.2215, -0.1709, -0.1181, -0.087, -0.0688, -0.0567, -0.0424, -0.0343, -0.0247, -0.0065, -0.0013, 0.0};
    double[] phi3 = new double[]{-0.00409, -0.004, -0.00387, -0.00384, -0.00402, -0.00489, -0.00635, -0.00837, -0.00978, -0.0107, -0.01117, -0.01162, -0.01182, -0.012, -0.01231, -0.01238, -0.0124};
    double[] phi4 = new double[]{0.1003, 0.1106, 0.1326, 0.1646, 0.1896, 0.2192, 0.223, 0.2001, 0.172, 0.1486, 0.1243, 0.0999, 0.0886, 0.0747, 0.0428, 0.0301, 0.0151};
    double[] tau = new double[]{0.331, 0.345, 0.374, 0.396, 0.391, 0.363, 0.351, 0.349, 0.394, 0.395, 0.399, 0.396, 0.356, 0.355, 0.373, 0.422, 0.549};
    double[] sigma = new double[]{0.493, 0.501, 0.512, 0.526, 0.531, 0.533, 0.527, 0.54, 0.539, 0.551, 0.56, 0.572, 0.58, 0.595, 0.612, 0.614, 0.575};
    protected static final Double PERIOD_DEFAULT = new Double(1.0);
    private HashMap indexFromPerHashMap;
    private int iper;
    private double vs30;
    private double rjb;
    private double rRup;
    private double distRupJB_Fraction;
    private double rake;
    private double dip;
    private double mag;
    private double depthTop;
    private String stdDevType;
    private boolean parameterChange;
    protected static final Double MAG_WARN_MIN = new Double(4.5);
    protected static final Double MAG_WARN_MAX = new Double(8.5);
    protected static final Double DISTANCE_RUP_WARN_MIN = new Double(0.0);
    protected static final Double DISTANCE_RUP_WARN_MAX = new Double(200.0);
    protected static final Double VS30_WARN_MIN = new Double(120.0);
    protected static final Double VS30_WARN_MAX = new Double(2000.0);
    private DistanceRupParameter distanceRupParam = null;
    private static final Double DISTANCE_RUP_DEFAULT = new Double(0.0);
    private DistRupMinusJB_OverRupParameter distRupMinusJB_OverRupParam = null;
    private static final Double DISTANCE_RUP_MINUS_JB_DEFAULT = new Double(0.0);
    private transient ParameterChangeWarningListener warningListener = null;

    public CY_2005_prelim_AttenRel(ParameterChangeWarningListener warningListener) {
        this.warningListener = warningListener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = new HashMap();
        for (int i = 0; i < this.period.length; ++i) {
            this.indexFromPerHashMap.put(new Double(this.period[i]), new Integer(i));
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
    }

    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(new Double(eqkRupture.getMag()));
        this.rakeParam.setValue(eqkRupture.getAveRake());
        EvenlyGriddedSurfaceAPI surface = eqkRupture.getRuptureSurface();
        this.dipParam.setValue(surface.getAveDip());
        double depth = surface.getLocation(0, 0).getDepth();
        this.rupTopDepthParam.setValue(depth);
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    public void setSite(Site site) throws ParameterException {
        this.vs30Param.setValue(site.getParameter("Vs30").getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
            this.distRupMinusJB_OverRupParam.setValue(this.eqkRupture, this.site);
        }
    }

    protected void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("CY_2005_prelim_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        this.iper = this.im.getName().equalsIgnoreCase("SA") ? (Integer)this.indexFromPerHashMap.get(this.periodParam.getValue()) : 0;
        this.parameterChange = true;
        this.intensityMeasureChanged = false;
    }

    public double getMean() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.parameterChange) {
            return this.getMean(this.iper, this.vs30, this.rRup, this.distRupJB_Fraction, this.dip, this.rake, this.mag, this.depthTop);
        }
        return 0.0;
    }

    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getStdDev(this.iper, this.stdDevType);
    }

    public void setParamDefaults() {
        this.vs30Param.setValue(VS30_DEFAULT);
        this.magParam.setValue(MAG_DEFAULT);
        this.rakeParam.setValue(RAKE_DEFAULT);
        this.dipParam.setValue(DIP_DEFAULT);
        this.rupTopDepthParam.setValue(RUP_TOP_DEFAULT);
        this.distanceRupParam.setValue(DISTANCE_RUP_DEFAULT);
        this.distRupMinusJB_OverRupParam.setValue(DISTANCE_RUP_MINUS_JB_DEFAULT);
        this.saParam.setValue(SA_DEFAULT);
        this.periodParam.setValue(PERIOD_DEFAULT);
        this.dampingParam.setValue(DAMPING_DEFAULT);
        this.pgaParam.setValue(PGA_DEFAULT);
        this.componentParam.setValue("Average Horizontal");
        this.stdDevTypeParam.setValue("Total");
        this.vs30 = (Double)this.vs30Param.getValue();
        this.distRupJB_Fraction = (Double)this.distRupMinusJB_OverRupParam.getValue();
        this.rRup = (Double)this.distanceRupParam.getValue();
        this.rake = (Double)this.rakeParam.getValue();
        this.mag = (Double)this.magParam.getValue();
        this.depthTop = (Double)this.rupTopDepthParam.getValue();
        this.stdDevType = (String)this.stdDevTypeParam.getValue();
        this.dip = (Double)this.dipParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.distRupMinusJB_OverRupParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.rakeParam);
        this.meanIndependentParams.addParameter(this.dipParam);
        this.meanIndependentParams.addParameter(this.rupTopDepthParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    protected void initSiteParams() {
        super.initSiteParams();
        DoubleConstraint warn = new DoubleConstraint(VS30_WARN_MIN, VS30_WARN_MAX);
        warn.setNonEditable();
        this.vs30Param.setWarningConstraint(warn);
        this.vs30Param.addParameterChangeWarningListener(this.warningListener);
        this.vs30Param.setNonEditable();
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
    }

    protected void initEqkRuptureParams() {
        super.initEqkRuptureParams();
        DoubleConstraint warn = new DoubleConstraint(MAG_WARN_MIN, MAG_WARN_MAX);
        warn.setNonEditable();
        this.magParam.setWarningConstraint(warn);
        this.magParam.addParameterChangeWarningListener(this.warningListener);
        this.magParam.setNonEditable();
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.dipParam);
        this.eqkRuptureParams.addParameter(this.rakeParam);
        this.eqkRuptureParams.addParameter(this.rupTopDepthParam);
    }

    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter();
        this.distanceRupParam.addParameterChangeWarningListener(this.warningListener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.setNonEditable();
        this.distRupMinusJB_OverRupParam = new DistRupMinusJB_OverRupParameter();
        this.distRupMinusJB_OverRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
        this.propagationEffectParams.addParameter(this.distRupMinusJB_OverRupParam);
    }

    protected void initSupportedIntensityMeasureParams() {
        super.initSupportedIntensityMeasureParams();
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        for (int i = 0; i < this.period.length; ++i) {
            periodConstraint.addDouble(new Double(this.period[i]));
        }
        periodConstraint.setNonEditable();
        this.periodParam = new DoubleDiscreteParameter("SA Period", periodConstraint, "sec", null);
        this.periodParam.setInfo("Oscillator Period for SA");
        this.periodParam.setNonEditable();
        this.dampingConstraint.setNonEditable();
        this.saParam.addIndependentParameter(this.dampingParam);
        this.saParam.addIndependentParameter(this.periodParam);
        this.saParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint constraint = new StringConstraint();
        constraint.addString("Average Horizontal");
        constraint.setNonEditable();
        this.componentParam = new StringParameter("Component", constraint, "Average Horizontal");
        this.componentParam.setInfo("Component of shaking");
        this.componentParam.setNonEditable();
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StringParameter("Std Dev Type", stdDevTypeConstraint, "Total");
        this.stdDevTypeParam.setInfo("Type of Standard Deviation");
        this.stdDevTypeParam.setNonEditable();
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return SHORT_NAME;
    }

    private double getYref(int iper, double vs30, double rRup, double distRupJB_Fraction, double dip, double rake, double mag, double depthTop) {
        double rjb = rRup - distRupJB_Fraction * rRup;
        double SOF = rake > 30.0 && rake < 150.0 ? 1.0 : 0.0;
        double r = Math.sqrt(rRup * rRup + Math.pow(Math.exp(this.H[iper]), 2.0));
        double r1 = Math.min(r, 50.0);
        double r2 = Math.max(r / 50.0, 1.0);
        double hw = Math.pow(Math.cos(dip), 2.0) * (1.0 - rjb / (rRup + 1.0E-4));
        double yRef = this.c1[iper] + this.c2[iper] * (mag - 6.0) + this.cm[iper] * Math.pow(Math.max(this.mc[iper] - mag, 0.0), 1.5) + this.Frv[iper] * SOF + (this.c4[iper] + this.c5[iper] * (mag - 6.0)) * (Math.log(r1) + Math.log(r2) / 2.0) + this.gamma[iper] * rRup + this.Ftor[iper] * depthTop + this.Fhw[iper] * hw;
        return yRef;
    }

    private double getLnAmp(double vs30, double yRef) {
        return this.phi1[this.iper] * Math.log(vs30 / 1130.0) + this.phi2[this.iper] * Math.exp(this.phi3[this.iper] * (vs30 - 360.0)) * Math.log((Math.exp(yRef) + this.phi4[this.iper]) / this.phi4[this.iper]);
    }

    public double getMean(int iper, double vs30, double rRup, double distRupJB_Fraction, double dip, double rake, double mag, double depthTop) {
        double yRef = this.getYref(iper, vs30, rRup, distRupJB_Fraction, dip, rake, mag, depthTop);
        return yRef + this.getLnAmp(vs30, yRef);
    }

    public double getStdDev(int iper, String stdDevType) {
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        if (stdDevType.equals("Intra-Event")) {
            return this.tau[iper];
        }
        if (stdDevType.equals("Inter-Event")) {
            return this.sigma[iper];
        }
        return Math.sqrt(this.tau[iper] * this.tau[iper] + this.sigma[iper] * this.sigma[iper]);
    }

    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        this.parameterChange = true;
        if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals("(distRup-distJB)/distRup")) {
            this.distRupJB_Fraction = (Double)val;
        } else if (pName.equals("Vs30")) {
            this.vs30 = (Double)val;
        } else if (pName.equals("Dip")) {
            this.dip = (Double)val;
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("Rake")) {
            this.rake = (Double)val;
        } else if (pName.equals("Rupture Top Depth")) {
            this.depthTop = (Double)val;
        } else if (pName.equals("Std Dev Type")) {
            this.stdDevType = (String)val;
        } else if (pName.equals("SA Period") && this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
    }

    public void resetParameterEventListeners() {
        this.distanceRupParam.removeParameterChangeListener(this);
        this.distRupMinusJB_OverRupParam.removeParameterChangeListener(this);
        this.vs30Param.removeParameterChangeListener(this);
        this.dipParam.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.rakeParam.removeParameterChangeListener(this);
        this.rupTopDepthParam.removeParameterChangeListener(this);
        this.stdDevTypeParam.removeParameterChangeListener(this);
        this.periodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    protected void initParameterEventListeners() {
        this.distanceRupParam.addParameterChangeListener(this);
        this.distRupMinusJB_OverRupParam.addParameterChangeListener(this);
        this.vs30Param.addParameterChangeListener(this);
        this.dipParam.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.rakeParam.addParameterChangeListener(this);
        this.rupTopDepthParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
        this.periodParam.addParameterChangeListener(this);
    }
}

