/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.opensha.data.NamedObjectAPI;
import org.opensha.data.Site;
import org.opensha.exceptions.IMRException;
import org.opensha.exceptions.InvalidRangeException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.DoubleConstraint;
import org.opensha.param.DoubleDiscreteConstraint;
import org.opensha.param.DoubleDiscreteParameter;
import org.opensha.param.StringConstraint;
import org.opensha.param.StringParameter;
import org.opensha.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.AttenuationRelationshipAPI;
import org.opensha.sha.param.DistanceRupParameter;

public class DahleEtAl_1995_AttenRel
extends AttenuationRelationship
implements AttenuationRelationshipAPI,
NamedObjectAPI {
    private static final String C = "DahleEtAl_1995_AttenRel";
    private static final boolean D = false;
    public static final String NAME = "Dahle et al. (1995)";
    public static final String SHORT_NAME = "Dahle1995";
    public static final String COMPONENT_UNKNOWN_HORZ = "Unknown Horizontal";
    public static final String COMPONENT_DEFAULT = "Unknown Horizontal";
    protected static final Double MAG_WARN_MIN = new Double(5.0);
    protected static final Double MAG_WARN_MAX = new Double(8.0);
    public static final String STD_DEV_TYPE_BAY = "Bayesian";
    public static final String STD_DEV_TYPE_LS = "Least Squares";
    public static final String STD_DEV_TYPE_DEFAULT = "Bayesian";
    private DistanceRupParameter distanceRupParam = null;
    private static final Double DISTANCE_RUP_DEFAULT = new Double(0.0);
    protected static final Double DISTANCE_RUP_WARN_MIN = new Double(0.0);
    protected static final Double DISTANCE_RUP_WARN_MAX = new Double(400.0);
    private StringParameter siteTypeParam = null;
    public static final String SITE_TYPE_NAME = "Dahle Site Type";
    public static final String SITE_TYPE_INFO = "Geological conditions at the site";
    public static final String SITE_TYPE_ROCK = "Rock";
    public static final String SITE_TYPE_SOIL = "Soil";
    public static final String SITE_TYPE_DEFAULT = "Rock";
    private DahleEtAl_AttenRelCoefficients coeff = null;
    protected Hashtable coefficients = new Hashtable();
    private transient ParameterChangeWarningListener warningListener = null;

    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(new Double(eqkRupture.getMag()));
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    public void setSite(Site site) throws ParameterException {
        this.siteTypeParam.setValue(site.getParameter(SITE_TYPE_NAME).getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
        }
    }

    protected void updateCoefficients() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("DahleEtAl_1995_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        StringBuffer key = new StringBuffer(this.im.getName());
        if (this.im.getName().equalsIgnoreCase("SA")) {
            key.append("/" + this.periodParam.getValue());
        }
        if (!this.coefficients.containsKey(key.toString())) {
            throw new ParameterException("DahleEtAl_1995_AttenRel: setIntensityMeasureType(): Unable to locate coefficients with key = " + key);
        }
        this.coeff = (DahleEtAl_AttenRelCoefficients)this.coefficients.get(key.toString());
    }

    public DahleEtAl_1995_AttenRel(ParameterChangeWarningListener warningListener) {
        this.warningListener = warningListener;
        this.initCoefficients();
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    public double getMean() throws IMRException {
        String siteTypeValue;
        double distanceRup;
        double mag;
        try {
            mag = (Double)this.magParam.getValue();
            distanceRup = (Double)this.distanceRupParam.getValue();
            siteTypeValue = this.siteTypeParam.getValue().toString();
        }
        catch (NullPointerException e) {
            throw new IMRException("DahleEtAl_1995_AttenRel: getMean(): Not all parameters have been set");
        }
        if (distanceRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        this.updateCoefficients();
        double R = Math.sqrt(distanceRup * distanceRup + this.coeff.rh * this.coeff.rh);
        boolean S = !siteTypeValue.equals("Rock");
        double mean = this.coeff.c1 + this.coeff.c2 * mag + this.coeff.c3 * Math.log(R) + this.coeff.c4 * R + this.coeff.c5 * (double)S;
        String tempName = this.coeff.name;
        mean = tempName.equals("PGA") || tempName.equals("SA/0.0") ? (mean -= Math.log(9.8)) : (mean += Math.log(6.28318 / this.coeff.period / 9.8));
        return mean;
    }

    public double getStdDev() throws IMRException {
        String stdDevType = (String)this.stdDevTypeParam.getValue();
        this.updateCoefficients();
        if (stdDevType.equals("Bayesian")) {
            return this.coeff.sigmaBay;
        }
        return this.coeff.sigmaLs;
    }

    public void setParamDefaults() {
        this.siteTypeParam.setValue("Rock");
        this.magParam.setValue(MAG_DEFAULT);
        this.distanceRupParam.setValue(DISTANCE_RUP_DEFAULT);
        this.saParam.setValue(SA_DEFAULT);
        this.periodParam.setValue(PERIOD_DEFAULT);
        this.dampingParam.setValue(DAMPING_DEFAULT);
        this.pgaParam.setValue(PGA_DEFAULT);
        this.componentParam.setValue("Unknown Horizontal");
        this.stdDevTypeParam.setValue("Bayesian");
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.siteTypeParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameter(this.distanceRupParam);
        this.exceedProbIndependentParams.addParameter(this.siteTypeParam);
        this.exceedProbIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    protected void initSiteParams() {
        StringConstraint siteConstraint = new StringConstraint();
        siteConstraint.addString("Rock");
        siteConstraint.addString(SITE_TYPE_SOIL);
        siteConstraint.setNonEditable();
        this.siteTypeParam = new StringParameter(SITE_TYPE_NAME, siteConstraint, null);
        this.siteTypeParam.setInfo(SITE_TYPE_INFO);
        this.siteTypeParam.setNonEditable();
        this.siteParams.clear();
        this.siteParams.addParameter(this.siteTypeParam);
    }

    protected void initEqkRuptureParams() {
        super.initEqkRuptureParams();
        DoubleConstraint warn = new DoubleConstraint(MAG_WARN_MIN, MAG_WARN_MAX);
        warn.setNonEditable();
        this.magParam.setWarningConstraint(warn);
        this.magParam.addParameterChangeWarningListener(this.warningListener);
        this.magParam.setNonEditable();
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
    }

    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter();
        this.distanceRupParam.addParameterChangeWarningListener(this.warningListener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
    }

    protected void initSupportedIntensityMeasureParams() {
        super.initSupportedIntensityMeasureParams();
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        TreeSet<Double> set = new TreeSet<Double>();
        Enumeration keys = this.coefficients.keys();
        while (keys.hasMoreElements()) {
            DahleEtAl_AttenRelCoefficients coeff = (DahleEtAl_AttenRelCoefficients)this.coefficients.get(keys.nextElement());
            if (!(coeff.period >= 0.0)) continue;
            set.add(new Double(coeff.period));
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            periodConstraint.addDouble((Double)it.next());
        }
        periodConstraint.setNonEditable();
        this.periodParam = new DoubleDiscreteParameter("SA Period", periodConstraint, "sec", null);
        this.periodParam.setInfo("Oscillator Period for SA");
        this.periodParam.setNonEditable();
        this.dampingConstraint.setNonEditable();
        this.saParam.addIndependentParameter(this.dampingParam);
        this.saParam.addIndependentParameter(this.periodParam);
        this.saParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint constraint = new StringConstraint();
        constraint.addString("Unknown Horizontal");
        constraint.setNonEditable();
        this.componentParam = new StringParameter("Component", constraint, "Unknown Horizontal");
        this.componentParam.setInfo("Component of shaking");
        this.componentParam.setNonEditable();
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Bayesian");
        stdDevTypeConstraint.addString(STD_DEV_TYPE_LS);
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StringParameter("Std Dev Type", stdDevTypeConstraint, "Bayesian");
        this.stdDevTypeParam.setInfo("Type of Standard Deviation");
        this.stdDevTypeParam.setNonEditable();
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return SHORT_NAME;
    }

    protected void initCoefficients() {
        String S = "DahleEtAl_1995_AttenRel: initCoefficients():";
        this.coefficients.clear();
        DahleEtAl_AttenRelCoefficients coeff = new DahleEtAl_AttenRelCoefficients("PGA", 0.0, -1.579, 0.554, -0.56, -0.00302, 0.326, 6.0, 0.75, 0.73);
        DahleEtAl_AttenRelCoefficients coeff0 = new DahleEtAl_AttenRelCoefficients("SA/" + new Double("0.00"), 0.0, -1.579, 0.554, -0.56, -0.00302, 0.326, 6.0, 0.75, 0.73);
        DahleEtAl_AttenRelCoefficients coeff1 = new DahleEtAl_AttenRelCoefficients("SA/" + new Double("0.025"), 0.025, -7.106, 0.554, -0.56, -0.00302, 0.326, 6.0, 0.75, 0.73);
        DahleEtAl_AttenRelCoefficients coeff2 = new DahleEtAl_AttenRelCoefficients("SA/" + new Double("0.05"), 0.05, -5.375, 0.449, -0.575, -0.00246, 0.308, 6.0, 0.78, 0.76);
        DahleEtAl_AttenRelCoefficients coeff3 = new DahleEtAl_AttenRelCoefficients("SA/" + new Double("0.1"), 0.1, -4.608, 0.486, -0.609, -0.00198, 0.381, 6.0, 0.81, 0.79);
        DahleEtAl_AttenRelCoefficients coeff4 = new DahleEtAl_AttenRelCoefficients("SA/" + new Double("0.2"), 0.2, -4.746, 0.645, -0.674, -0.00155, 0.47, 6.0, 0.82, 0.8);
        DahleEtAl_AttenRelCoefficients coeff5 = new DahleEtAl_AttenRelCoefficients("SA/" + new Double("0.5"), 0.5, -5.717, 0.92, -0.761, -0.00106, 0.566, 6.0, 0.83, 0.81);
        DahleEtAl_AttenRelCoefficients coeff6 = new DahleEtAl_AttenRelCoefficients("SA/" + new Double("1.0"), 1.0, -6.595, 1.084, -0.792, -7.5E-4, 0.588, 6.0, 0.82, 0.79);
        DahleEtAl_AttenRelCoefficients coeff7 = new DahleEtAl_AttenRelCoefficients("SA/" + new Double("2.0"), 2.0, -7.205, 1.131, -0.762, -5.1E-4, 0.536, 6.0, 0.79, 0.75);
        DahleEtAl_AttenRelCoefficients coeff8 = new DahleEtAl_AttenRelCoefficients("SA/" + new Double("4.0"), 4.0, -7.324, 1.009, -0.629, -3.8E-4, 0.496, 6.0, 0.73, 0.67);
        this.coefficients.put(coeff.getName(), coeff);
        this.coefficients.put(coeff0.getName(), coeff0);
        this.coefficients.put(coeff1.getName(), coeff1);
        this.coefficients.put(coeff2.getName(), coeff2);
        this.coefficients.put(coeff3.getName(), coeff3);
        this.coefficients.put(coeff4.getName(), coeff4);
        this.coefficients.put(coeff5.getName(), coeff5);
        this.coefficients.put(coeff6.getName(), coeff6);
        this.coefficients.put(coeff7.getName(), coeff7);
        this.coefficients.put(coeff8.getName(), coeff8);
    }

    class DahleEtAl_AttenRelCoefficients
    implements NamedObjectAPI {
        protected static final String C = "DahleEtAl_AttenRelCoefficients";
        protected static final boolean D = false;
        private static final long serialVersionUID = 1234567890987654326L;
        protected String name;
        protected double period = -1.0;
        protected double c1;
        protected double c2;
        protected double c3;
        protected double c4;
        protected double c5;
        protected double rh;
        protected double sigmaBay;
        protected double sigmaLs;

        public DahleEtAl_AttenRelCoefficients(String name) {
            this.name = name;
        }

        public DahleEtAl_AttenRelCoefficients(String name, double period, double c1, double c2, double c3, double c4, double c5, double rh, double sigmaBay, double sigmaLs) {
            this.name = name;
            this.period = period;
            this.c1 = c1;
            this.c2 = c2;
            this.c3 = c3;
            this.c4 = c4;
            this.c5 = c5;
            this.rh = rh;
            this.sigmaBay = sigmaBay;
            this.sigmaLs = sigmaLs;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(C);
            b.append("\n  Period = " + this.period);
            b.append("\n  c1 = " + this.c1);
            b.append("\n  c2 = " + this.c2);
            b.append("\n  c3 = " + this.c3);
            b.append("\n  c4 = " + this.c4);
            b.append("\n  c5 = " + this.c5);
            b.append("\n  rh = " + this.rh);
            b.append("\n  sigmaBay = " + this.sigmaBay);
            b.append("\n  sigmaLs = " + this.sigmaLs);
            return b.toString();
        }
    }
}

