/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.opensha.data.NamedObjectAPI;
import org.opensha.data.Site;
import org.opensha.exceptions.IMRException;
import org.opensha.exceptions.InvalidRangeException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.DoubleConstraint;
import org.opensha.param.DoubleDiscreteConstraint;
import org.opensha.param.DoubleDiscreteParameter;
import org.opensha.param.DoubleParameter;
import org.opensha.param.StringConstraint;
import org.opensha.param.StringParameter;
import org.opensha.param.WarningDoubleParameter;
import org.opensha.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.AttenuationRelationshipAPI;
import org.opensha.sha.imr.attenRelImpl.calc.Wald_MMI_Calc;
import org.opensha.sha.param.DistanceJBParameter;
import org.opensha.sha.param.PropagationEffect;
import org.opensha.util.FaultUtils;

public class ShakeMap_2003_AttenRel
extends AttenuationRelationship
implements AttenuationRelationshipAPI,
NamedObjectAPI {
    private static final String C = "ShakeMap_2003_AttenRel";
    private static final boolean D = false;
    public static final String NAME = "ShakeMap (2003)";
    public static final String SHORT_NAME = "ShakeMap2003";
    private static final double pga_low = -1.87692;
    private static final double pga_mid = -1.36609;
    private static final double pga_high = -1.02962;
    public static final String FLT_TYPE_UNKNOWN = "Unknown";
    public static final String FLT_TYPE_STRIKE_SLIP = "Strike-Slip";
    public static final String FLT_TYPE_REVERSE = "Reverse";
    public static final String FLT_TYPE_DEFAULT = "Unknown";
    protected static final Double MAG_WARN_MIN = new Double(3.3);
    protected static final Double MAG_WARN_MAX = new Double(7.5);
    public static final String COMPONENT_GREATER_OF_TWO_HORZ = "Greater of Two Horz.";
    private DistanceJBParameter distanceJBParam = null;
    private static final Double DISTANCE_JB_DEFAULT = new Double(0.0);
    protected static final Double DISTANCE_JB_WARN_MIN = new Double(0.0);
    protected static final Double DISTANCE_JB_WARN_MAX = new Double(80.0);
    private StringParameter willsSiteParam = null;
    public static final String WILLS_SITE_NAME = "Wills Site Class";
    public static final String WILLS_SITE_INFO = "Site classification defined by Wills et al. (2000, BSSA)";
    public static final String WILLS_SITE_B = "B";
    public static final String WILLS_SITE_BC = "BC";
    public static final String WILLS_SITE_C = "C";
    public static final String WILLS_SITE_CD = "CD";
    public static final String WILLS_SITE_D = "D";
    public static final String WILLS_SITE_DE = "DE";
    public static final String WILLS_SITE_E = "E";
    public static final String WILLS_SITE_DEFAULT = "BC";
    protected DoubleParameter mmiParam = null;
    public static final String MMI_NAME = "MMI";
    protected static final Double MMI_DEFAULT = new Double(Math.log(5.0));
    public static final String MMI_INFO = "Modified Mercalli Intensity";
    protected static final Double MMI_MIN = new Double(Math.log(1.0));
    protected static final Double MMI_MAX = new Double(Math.log(10.0));
    public static final String MMI_ERROR_STRING = "Problem: ShakeMap (2003) cannot complete\n the requested computation for MMI.\n\nThis has occurred because you attempted to compute the\nstandard deviation (or something else such as probability \nof exceedance which depends on the standard deviation).  \nThe inability to compute these will remain until someone comes up\nwith the probability distribution for MMI (when computed from\nPGA or PGV).  For now you can compute the median or the\nIML that has exactly a 0.5 chance of being exceeded (assuming\nthis application supports such computations).\n";
    private BJF_1997_AttenRelCoefficients coeffBJF = null;
    private BJF_1997_AttenRelCoefficients coeffSM = null;
    protected Hashtable coefficientsBJF = new Hashtable();
    protected Hashtable coefficientsSM = new Hashtable();
    private transient ParameterChangeWarningListener warningListener = null;

    protected void setFaultTypeFromRake(double rake) throws InvalidRangeException {
        FaultUtils.assertValidRake(rake);
        if (Math.abs(Math.sin(rake * Math.PI / 180.0)) <= 0.5) {
            this.fltTypeParam.setValue(FLT_TYPE_STRIKE_SLIP);
        } else if (rake >= 30.0 && rake <= 150.0) {
            this.fltTypeParam.setValue(FLT_TYPE_REVERSE);
        } else {
            this.fltTypeParam.setValue("Unknown");
        }
    }

    public ShakeMap_2003_AttenRel(ParameterChangeWarningListener warningListener) {
        this.warningListener = warningListener;
        this.initCoefficients();
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(new Double(eqkRupture.getMag()));
        this.setFaultTypeFromRake(eqkRupture.getAveRake());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    public void setSite(Site site) throws ParameterException {
        this.willsSiteParam.setValue(site.getParameter(WILLS_SITE_NAME).getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    public void setPropagationEffect(PropagationEffect propEffect) throws ParameterException, InvalidRangeException {
        this.site = propEffect.getSite();
        this.eqkRupture = propEffect.getEqkRupture();
        this.willsSiteParam.setValue(this.site.getParameter(WILLS_SITE_NAME).getValue());
        this.magParam.setValueIgnoreWarning(new Double(this.eqkRupture.getMag()));
        this.setFaultTypeFromRake(this.eqkRupture.getAveRake());
        propEffect.setParamValue(this.distanceJBParam);
    }

    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceJBParam.setValue(this.eqkRupture, this.site);
        }
    }

    protected void updateCoefficients() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("ShakeMap_2003_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        StringBuffer key = new StringBuffer(this.im.getName());
        if (this.im.getName().equalsIgnoreCase("SA")) {
            key.append("/" + this.periodParam.getValue());
        }
        if (!this.coefficientsBJF.containsKey(key.toString())) {
            throw new ParameterException("ShakeMap_2003_AttenRel: setIntensityMeasureType(): Unable to locate coefficients with key = " + key);
        }
        this.coeffBJF = (BJF_1997_AttenRelCoefficients)this.coefficientsBJF.get(key.toString());
        this.coeffSM = (BJF_1997_AttenRelCoefficients)this.coefficientsSM.get(key.toString());
    }

    public double getMean() throws IMRException {
        String imt = this.im.getName();
        if (!imt.equals(MMI_NAME)) {
            this.updateCoefficients();
            double b_mean = this.getRockMean();
            if (imt.equals("PGA")) {
                return b_mean + Math.log(this.getAmpFactor(this.im.getName(), b_mean));
            }
            return b_mean + Math.log(this.getAmpFactor(this.im.getName()));
        }
        return Math.log(this.getMMI());
    }

    private double getAmpFactor(String imt) {
        String S = ".getAmpFactor()";
        this.coeffBJF = (BJF_1997_AttenRelCoefficients)this.coefficientsBJF.get("PGA");
        this.coeffSM = (BJF_1997_AttenRelCoefficients)this.coefficientsSM.get("PGA");
        return this.getAmpFactor(imt, this.getRockMean());
    }

    private double getAmpFactor(String imt, double b_pga) {
        boolean shortPeriod;
        String S = ".getAmpFactor()";
        if (imt.equals("PGA")) {
            shortPeriod = true;
        } else if (imt.equals("PGV")) {
            shortPeriod = false;
        } else if (imt.equals("SA")) {
            double per = (Double)this.periodParam.getValue();
            shortPeriod = per <= 0.45;
        } else {
            throw new RuntimeException("ShakeMap_2003_AttenRelIMT not supported");
        }
        String sType = (String)this.willsSiteParam.getValue();
        double amp = 0.0;
        if (shortPeriod) {
            if (b_pga <= -1.87692) {
                if (sType.equals(WILLS_SITE_E)) {
                    amp = 1.65;
                } else if (sType.equals(WILLS_SITE_DE)) {
                    amp = 1.34;
                } else if (sType.equals(WILLS_SITE_D)) {
                    amp = 1.33;
                } else if (sType.equals(WILLS_SITE_CD)) {
                    amp = 1.24;
                } else if (sType.equals(WILLS_SITE_C)) {
                    amp = 1.15;
                } else if (sType.equals("BC")) {
                    amp = 0.98;
                } else if (sType.equals(WILLS_SITE_B)) {
                    amp = 1.0;
                }
            } else if (b_pga <= -1.36609) {
                if (sType.equals(WILLS_SITE_E)) {
                    amp = 1.43;
                } else if (sType.equals(WILLS_SITE_DE)) {
                    amp = 1.23;
                } else if (sType.equals(WILLS_SITE_D)) {
                    amp = 1.23;
                } else if (sType.equals(WILLS_SITE_CD)) {
                    amp = 1.17;
                } else if (sType.equals(WILLS_SITE_C)) {
                    amp = 1.1;
                } else if (sType.equals("BC")) {
                    amp = 0.99;
                } else if (sType.equals(WILLS_SITE_B)) {
                    amp = 1.0;
                }
            } else if (b_pga <= -1.02962) {
                if (sType.equals(WILLS_SITE_E)) {
                    amp = 1.15;
                } else if (sType.equals(WILLS_SITE_DE)) {
                    amp = 1.09;
                } else if (sType.equals(WILLS_SITE_D)) {
                    amp = 1.09;
                } else if (sType.equals(WILLS_SITE_CD)) {
                    amp = 1.06;
                } else if (sType.equals(WILLS_SITE_C)) {
                    amp = 1.04;
                } else if (sType.equals("BC")) {
                    amp = 0.99;
                } else if (sType.equals(WILLS_SITE_B)) {
                    amp = 1.0;
                }
            } else if (sType.equals(WILLS_SITE_E)) {
                amp = 0.93;
            } else if (sType.equals(WILLS_SITE_DE)) {
                amp = 0.96;
            } else if (sType.equals(WILLS_SITE_D)) {
                amp = 0.96;
            } else if (sType.equals(WILLS_SITE_CD)) {
                amp = 0.97;
            } else if (sType.equals(WILLS_SITE_C)) {
                amp = 0.98;
            } else if (sType.equals("BC")) {
                amp = 1.0;
            } else if (sType.equals(WILLS_SITE_B)) {
                amp = 1.0;
            }
        } else if (b_pga <= -1.87692) {
            if (sType.equals(WILLS_SITE_E)) {
                amp = 2.55;
            } else if (sType.equals(WILLS_SITE_DE)) {
                amp = 1.72;
            } else if (sType.equals(WILLS_SITE_D)) {
                amp = 1.71;
            } else if (sType.equals(WILLS_SITE_CD)) {
                amp = 1.49;
            } else if (sType.equals(WILLS_SITE_C)) {
                amp = 1.29;
            } else if (sType.equals("BC")) {
                amp = 0.97;
            } else if (sType.equals(WILLS_SITE_B)) {
                amp = 1.0;
            }
        } else if (b_pga <= -1.36609) {
            if (sType.equals(WILLS_SITE_E)) {
                amp = 2.37;
            } else if (sType.equals(WILLS_SITE_DE)) {
                amp = 1.65;
            } else if (sType.equals(WILLS_SITE_D)) {
                amp = 1.64;
            } else if (sType.equals(WILLS_SITE_CD)) {
                amp = 1.44;
            } else if (sType.equals(WILLS_SITE_C)) {
                amp = 1.26;
            } else if (sType.equals("BC")) {
                amp = 0.97;
            } else if (sType.equals(WILLS_SITE_B)) {
                amp = 1.0;
            }
        } else if (b_pga <= -1.02962) {
            if (sType.equals(WILLS_SITE_E)) {
                amp = 2.14;
            } else if (sType.equals(WILLS_SITE_DE)) {
                amp = 1.56;
            } else if (sType.equals(WILLS_SITE_D)) {
                amp = 1.55;
            } else if (sType.equals(WILLS_SITE_CD)) {
                amp = 1.38;
            } else if (sType.equals(WILLS_SITE_C)) {
                amp = 1.23;
            } else if (sType.equals("BC")) {
                amp = 0.97;
            } else if (sType.equals(WILLS_SITE_B)) {
                amp = 1.0;
            }
        } else if (sType.equals(WILLS_SITE_E)) {
            amp = 1.91;
        } else if (sType.equals(WILLS_SITE_DE)) {
            amp = 1.46;
        } else if (sType.equals(WILLS_SITE_D)) {
            amp = 1.45;
        } else if (sType.equals(WILLS_SITE_CD)) {
            amp = 1.32;
        } else if (sType.equals(WILLS_SITE_C)) {
            amp = 1.19;
        } else if (sType.equals("BC")) {
            amp = 0.98;
        } else if (sType.equals(WILLS_SITE_B)) {
            amp = 1.0;
        }
        return amp;
    }

    private double getMMI() {
        String S = ".getMMI()";
        this.coeffBJF = (BJF_1997_AttenRelCoefficients)this.coefficientsBJF.get("PGA");
        this.coeffSM = (BJF_1997_AttenRelCoefficients)this.coefficientsSM.get("PGA");
        double b_pga = this.getRockMean();
        double pga = b_pga + Math.log(this.getAmpFactor("PGA"));
        pga = Math.exp(pga);
        this.coeffBJF = (BJF_1997_AttenRelCoefficients)this.coefficientsBJF.get("PGV");
        this.coeffSM = (BJF_1997_AttenRelCoefficients)this.coefficientsSM.get("PGV");
        double b_pgv = this.getRockMean();
        double pgv = b_pgv + Math.log(this.getAmpFactor("PGV"));
        pgv = Math.exp(pgv);
        return Wald_MMI_Calc.getMMI(pga, pgv);
    }

    private double getRockMean() {
        double b1_SM;
        double b1_BJF;
        String fltTypeValue;
        double distanceJB;
        double mag;
        double rockVs30_SM = 620.0;
        double rockVs30_BJF = 724.0;
        try {
            mag = (Double)this.magParam.getValue();
            distanceJB = (Double)this.distanceJBParam.getValue();
            fltTypeValue = this.fltTypeParam.getValue().toString();
        }
        catch (NullPointerException e) {
            throw new IMRException("ShakeMap_2003_AttenRel: getMean(): Not all parameters have been set");
        }
        if (distanceJB > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (fltTypeValue.equals(FLT_TYPE_STRIKE_SLIP)) {
            b1_BJF = this.coeffBJF.b1ss;
            b1_SM = this.coeffSM.b1ss;
        } else if (fltTypeValue.equals(FLT_TYPE_REVERSE)) {
            b1_BJF = this.coeffBJF.b1rv;
            b1_SM = this.coeffSM.b1rv;
        } else if (fltTypeValue.equals("Unknown")) {
            b1_BJF = this.coeffBJF.b1all;
            b1_SM = this.coeffSM.b1all;
        } else {
            throw new ParameterException("ShakeMap_2003_AttenRel: getMean(): Invalid EqkRupture Parameter value for : FaultType");
        }
        double meanBJF = b1_BJF + this.coeffBJF.b2 * (mag - 6.0) + this.coeffBJF.b3 * Math.pow(mag - 6.0, 2.0) + this.coeffBJF.b5 * Math.log(Math.pow(distanceJB * distanceJB + this.coeffBJF.h * this.coeffBJF.h, 0.5)) + this.coeffBJF.bv * Math.log(rockVs30_BJF / (double)this.coeffBJF.va);
        double meanSM = b1_SM + this.coeffSM.b2 * (mag - 6.0) + this.coeffSM.b3 * Math.pow(mag - 6.0, 2.0) + this.coeffSM.b5 * Math.log(Math.pow(distanceJB * distanceJB + this.coeffSM.h * this.coeffSM.h, 0.5)) + this.coeffSM.bv * Math.log(rockVs30_SM / (double)this.coeffSM.va);
        String component = (String)this.componentParam.getValue();
        if (component.equals(COMPONENT_GREATER_OF_TWO_HORZ)) {
            meanSM += 0.139762;
            meanBJF += 0.139762;
        }
        if (mag <= 5.0) {
            return meanSM;
        }
        if (mag <= 5.5) {
            return meanBJF + (mag - 5.5) * (meanBJF - meanSM) / 0.5;
        }
        return meanBJF;
    }

    public double getIML_AtExceedProb() throws ParameterException {
        if (this.im.getName().equals(MMI_NAME)) {
            double exceedProb = (Double)this.exceedProbParam.getValue();
            if (exceedProb == 0.5) {
                if (this.sigmaTruncTypeParam.getValue().equals("1 Sided")) {
                    throw new RuntimeException(MMI_ERROR_STRING);
                }
                return this.getMean();
            }
            throw new RuntimeException(MMI_ERROR_STRING);
        }
        return super.getIML_AtExceedProb();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getStdDev() throws IMRException {
        double stdevSM;
        double stdevBJF;
        double mag;
        if (this.im.getName().equals(MMI_NAME)) {
            throw new RuntimeException(MMI_ERROR_STRING);
        }
        String stdDevType = this.stdDevTypeParam.getValue().toString();
        String component = this.componentParam.getValue().toString();
        try {
            mag = (Double)this.magParam.getValue();
        }
        catch (NullPointerException e) {
            throw new IMRException("ShakeMap_2003_AttenRel: getMean(): Not all parameters have been set");
        }
        this.updateCoefficients();
        if (component.equals("Average Horizontal") || component.equals(COMPONENT_GREATER_OF_TWO_HORZ)) {
            if (stdDevType.equals("Total")) {
                stdevBJF = Math.pow(this.coeffBJF.sigmaE * this.coeffBJF.sigmaE + this.coeffBJF.sigma1 * this.coeffBJF.sigma1, 0.5);
                stdevSM = Math.pow(this.coeffSM.sigmaE * this.coeffSM.sigmaE + this.coeffSM.sigma1 * this.coeffSM.sigma1, 0.5);
            } else if (stdDevType.equals("Inter-Event")) {
                stdevBJF = this.coeffBJF.sigmaE;
                stdevSM = this.coeffSM.sigmaE;
            } else if (stdDevType.equals("Intra-Event")) {
                stdevBJF = this.coeffBJF.sigma1;
                stdevSM = this.coeffSM.sigma1;
            } else {
                if (!stdDevType.equals("None (zero)")) throw new ParameterException("ShakeMap_2003_AttenRel: getStdDev(): Invalid StdDevType");
                stdevBJF = 0.0;
                stdevSM = 0.0;
            }
        } else {
            if (!component.equals("Random Horizontal")) throw new ParameterException("ShakeMap_2003_AttenRel: getStdDev(): Invalid component type");
            if (stdDevType.equals("Total")) {
                stdevBJF = this.coeffBJF.sigmaLnY;
                stdevSM = this.coeffSM.sigmaLnY;
            } else if (stdDevType.equals("Inter-Event")) {
                stdevBJF = this.coeffBJF.sigmaE;
                stdevSM = this.coeffSM.sigmaE;
            } else if (stdDevType.equals("Intra-Event")) {
                stdevBJF = this.coeffBJF.sigmaR;
                stdevSM = this.coeffSM.sigmaR;
            } else {
                if (!stdDevType.equals("None (zero)")) throw new ParameterException("ShakeMap_2003_AttenRel: getStdDev(): Invalid StdDevType");
                stdevBJF = 0.0;
                stdevSM = 0.0;
            }
        }
        if (mag <= 5.0) {
            return stdevSM;
        }
        if (!(mag <= 5.5)) return stdevBJF;
        return stdevBJF + (mag - 5.5) * (stdevBJF - stdevSM) / 0.5;
    }

    public void setParamDefaults() {
        this.willsSiteParam.setValue("BC");
        this.magParam.setValue(MAG_DEFAULT);
        this.fltTypeParam.setValue("Unknown");
        this.distanceJBParam.setValue(DISTANCE_JB_DEFAULT);
        this.saParam.setValue(SA_DEFAULT);
        this.periodParam.setValue(PERIOD_DEFAULT);
        this.dampingParam.setValue(DAMPING_DEFAULT);
        this.pgaParam.setValue(PGA_DEFAULT);
        this.pgvParam.setValue(PGV_DEFAULT);
        this.mmiParam.setValue(MMI_DEFAULT);
        this.componentParam.setValue("Average Horizontal");
        this.stdDevTypeParam.setValue("Total");
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceJBParam);
        this.meanIndependentParams.addParameter(this.willsSiteParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameter(this.distanceJBParam);
        this.exceedProbIndependentParams.addParameter(this.willsSiteParam);
        this.exceedProbIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.addParameter(this.fltTypeParam);
        this.exceedProbIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    protected void initSiteParams() {
        super.initSiteParams();
        ArrayList<String> willsSiteTypes = new ArrayList<String>();
        willsSiteTypes.add(WILLS_SITE_B);
        willsSiteTypes.add("BC");
        willsSiteTypes.add(WILLS_SITE_C);
        willsSiteTypes.add(WILLS_SITE_CD);
        willsSiteTypes.add(WILLS_SITE_D);
        willsSiteTypes.add(WILLS_SITE_DE);
        willsSiteTypes.add(WILLS_SITE_E);
        this.willsSiteParam = new StringParameter(WILLS_SITE_NAME, willsSiteTypes, "BC");
        this.willsSiteParam.setInfo(WILLS_SITE_INFO);
        this.willsSiteParam.setNonEditable();
        this.siteParams.clear();
        this.siteParams.addParameter(this.willsSiteParam);
    }

    protected void initEqkRuptureParams() {
        super.initEqkRuptureParams();
        DoubleConstraint warn = new DoubleConstraint(MAG_WARN_MIN, MAG_WARN_MAX);
        warn.setNonEditable();
        this.magParam.setWarningConstraint(warn);
        this.magParam.addParameterChangeWarningListener(this.warningListener);
        this.magParam.setNonEditable();
        StringConstraint constraint = new StringConstraint();
        constraint.addString("Unknown");
        constraint.addString(FLT_TYPE_STRIKE_SLIP);
        constraint.addString(FLT_TYPE_REVERSE);
        constraint.setNonEditable();
        this.fltTypeParam = new StringParameter("Fault Type", constraint, null);
        this.fltTypeParam.setInfo("Style of faulting");
        this.fltTypeParam.setNonEditable();
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
    }

    protected void initPropagationEffectParams() {
        this.distanceJBParam = new DistanceJBParameter();
        this.distanceJBParam.addParameterChangeWarningListener(this.warningListener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_JB_WARN_MIN, DISTANCE_JB_WARN_MAX);
        warn.setNonEditable();
        this.distanceJBParam.setWarningConstraint(warn);
        this.distanceJBParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceJBParam);
    }

    protected void initSupportedIntensityMeasureParams() {
        super.initSupportedIntensityMeasureParams();
        this.supportedIMParams.clear();
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        TreeSet<Double> set = new TreeSet<Double>();
        Enumeration keys = this.coefficientsBJF.keys();
        while (keys.hasMoreElements()) {
            BJF_1997_AttenRelCoefficients coeff = (BJF_1997_AttenRelCoefficients)this.coefficientsBJF.get(keys.nextElement());
            if (!(coeff.period >= 0.0)) continue;
            set.add(new Double(coeff.period));
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            periodConstraint.addDouble((Double)it.next());
        }
        periodConstraint.setNonEditable();
        this.periodParam = new DoubleDiscreteParameter("SA Period", periodConstraint, "sec", null);
        this.periodParam.setInfo("Oscillator Period for SA");
        this.periodParam.setNonEditable();
        this.dampingConstraint.setNonEditable();
        this.saParam.addIndependentParameter(this.dampingParam);
        this.saParam.addIndependentParameter(this.periodParam);
        this.saParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.addParameter(this.saParam);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.setNonEditable();
        this.supportedIMParams.addParameter(this.pgaParam);
        DoubleConstraint pgvConstraint = new DoubleConstraint(PGV_MIN, PGV_MAX);
        pgvConstraint.setNonEditable();
        this.pgvParam = new WarningDoubleParameter("PGV", pgvConstraint, "cm/sec");
        this.pgvParam.setInfo("Peak Ground Velocity");
        DoubleConstraint warn = new DoubleConstraint(PGV_WARN_MIN, PGV_WARN_MAX);
        warn.setNonEditable();
        this.pgvParam.setWarningConstraint(warn);
        this.pgvParam.addParameterChangeWarningListener(this.warningListener);
        this.pgvParam.setNonEditable();
        this.supportedIMParams.addParameter(this.pgvParam);
        this.mmiParam = new DoubleParameter(MMI_NAME, MMI_MIN, MMI_MAX);
        this.mmiParam.setInfo(MMI_INFO);
        this.mmiParam.setNonEditable();
        this.supportedIMParams.addParameter(this.mmiParam);
    }

    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint constraint = new StringConstraint();
        constraint.addString("Average Horizontal");
        constraint.addString("Random Horizontal");
        constraint.addString(COMPONENT_GREATER_OF_TWO_HORZ);
        constraint.setNonEditable();
        this.componentParam = new StringParameter("Component", constraint, "Average Horizontal");
        this.componentParam.setInfo("Component of shaking");
        this.componentParam.setNonEditable();
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StringParameter("Std Dev Type", stdDevTypeConstraint, "Total");
        this.stdDevTypeParam.setInfo("Type of Standard Deviation");
        this.stdDevTypeParam.setNonEditable();
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return SHORT_NAME;
    }

    protected void initCoefficients() {
        String S = "ShakeMap_2003_AttenRel: initCoefficients():";
        this.coefficientsSM.clear();
        BJF_1997_AttenRelCoefficients coeffSM0 = new BJF_1997_AttenRelCoefficients("PGA", -1.0, 2.408, 2.408, 2.408, 1.3171, 0.0, -1.757, -0.473, 760, 6.0, 0.66, 0.328, 0.737, 0.3948, 0.836);
        BJF_1997_AttenRelCoefficients coeffSM1 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.00"), 0.0, 2.408, 2.408, 2.408, 1.3171, 0.0, -1.757, -0.473, 760, 6.0, 0.66, 0.328, 0.737, 0.3948, 0.836);
        BJF_1997_AttenRelCoefficients coeffSM2 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.30"), 0.3, 0.835318, 0.835318, 0.835318, 1.71773, 0.0, -1.827, -0.608, 760, 6.0, 0.6647368421052632, 0.33035406698564596, 0.7422894736842105, 0.3976334928229665, 0.842);
        BJF_1997_AttenRelCoefficients coeffSM3 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("1.00"), 1.0, -1.82877, -1.82877, -1.82877, 2.20818, 0.0, -1.211, -0.974, 760, 6.0, 0.78, 0.38763636363636367, 0.871, 0.4665818181818182, 0.988);
        BJF_1997_AttenRelCoefficients coeffSM4 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("3.00"), 3.0, -4.63102, -4.63102, -4.63102, 2.09305, 0.0, -0.848, -0.89, 760, 6.0, 0.8542105263157896, 0.4245167464114833, 0.9538684210526317, 0.5109732057416269, 1.082);
        BJF_1997_AttenRelCoefficients coeffSM5 = new BJF_1997_AttenRelCoefficients("PGV", -1.0, 5.1186, 5.1186, 5.1186, 1.70391, 0.0, -1.386, -0.668, 760, 6.0, 0.5944736842105264, 0.2954354066985646, 0.6638289473684211, 0.35560334928229664, 0.753);
        this.coefficientsSM.put(coeffSM0.getName(), coeffSM0);
        this.coefficientsSM.put(coeffSM1.getName(), coeffSM1);
        this.coefficientsSM.put(coeffSM2.getName(), coeffSM2);
        this.coefficientsSM.put(coeffSM3.getName(), coeffSM3);
        this.coefficientsSM.put(coeffSM4.getName(), coeffSM4);
        this.coefficientsSM.put(coeffSM5.getName(), coeffSM5);
        this.coefficientsBJF.clear();
        BJF_1997_AttenRelCoefficients coeff0 = new BJF_1997_AttenRelCoefficients("PGA", -1.0, -0.313, -0.117, -0.242, 0.527, 0.0, -0.778, -0.371, 1396, 5.57, 0.431, 0.226, 0.486, 0.184, 0.52);
        BJF_1997_AttenRelCoefficients coeff1 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.00"), 0.0, -0.313, -0.117, -0.242, 0.527, 0.0, -0.778, -0.371, 1396, 5.57, 0.431, 0.226, 0.486, 0.184, 0.52);
        BJF_1997_AttenRelCoefficients coeff2 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.30"), 0.3, 0.598, 0.803, 0.7, 0.769, -0.161, -0.893, -0.401, 2133, 5.94, 0.44, 0.276, 0.519, 0.048, 0.522);
        BJF_1997_AttenRelCoefficients coeff3 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("1.00"), 1.0, -1.133, -1.009, -1.08, 1.036, -0.032, -0.798, -0.698, 1406, 2.9, 0.474, 0.325, 0.575, 0.214, 0.613);
        BJF_1997_AttenRelCoefficients coeff4 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("3.00"), 3.0, -1.699, -1.801, -1.743, 1.085, -0.085, -0.812, -0.655, 1795, 5.85, 0.495, 0.362, 0.613, 0.276, 0.672);
        double SA10toPGV = Math.log(94.62484798372687);
        BJF_1997_AttenRelCoefficients coeff5 = new BJF_1997_AttenRelCoefficients("PGV", -1.0, -1.133 + SA10toPGV, -1.009 + SA10toPGV, -1.08 + SA10toPGV, 1.036, -0.032, -0.798, -0.698, 1406, 2.9, 0.474, 0.325, 0.575, 0.214, 0.613);
        this.coefficientsBJF.put(coeff0.getName(), coeff0);
        this.coefficientsBJF.put(coeff1.getName(), coeff1);
        this.coefficientsBJF.put(coeff2.getName(), coeff2);
        this.coefficientsBJF.put(coeff3.getName(), coeff3);
        this.coefficientsBJF.put(coeff4.getName(), coeff4);
        this.coefficientsBJF.put(coeff5.getName(), coeff5);
    }

    public static void main(String[] args) {
        System.out.println(94.62484798372687);
        ShakeMap_2003_AttenRel ar = new ShakeMap_2003_AttenRel(null);
    }

    class BJF_1997_AttenRelCoefficients
    implements NamedObjectAPI {
        protected static final String C = "BJF_1997_AttenRelCoefficients";
        protected static final boolean D = false;
        private static final long serialVersionUID = 1234567890987654320L;
        protected String name;
        protected double period = -1.0;
        protected double b1all;
        protected double b1ss;
        protected double b1rv;
        protected double b2;
        protected double b3;
        protected double b5;
        protected double bv;
        protected int va;
        protected double h;
        protected double sigma1;
        protected double sigmaC;
        protected double sigmaR;
        protected double sigmaE;
        protected double sigmaLnY;

        public BJF_1997_AttenRelCoefficients(String name) {
            this.name = name;
        }

        public BJF_1997_AttenRelCoefficients(String name, double period, double b1ss, double b1rv, double b1all, double b2, double b3, double b5, double bv, int va, double h, double sigma1, double sigmaC, double sigmaR, double sigmaE, double sigmaLnY) {
            this.period = period;
            this.b1ss = b1ss;
            this.b1rv = b1rv;
            this.b1all = b1all;
            this.b2 = b2;
            this.b3 = b3;
            this.b5 = b5;
            this.bv = bv;
            this.va = va;
            this.h = h;
            this.name = name;
            this.sigma1 = sigma1;
            this.sigmaC = sigmaC;
            this.sigmaR = sigmaR;
            this.sigmaE = sigmaE;
            this.sigmaLnY = sigmaLnY;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(C);
            b.append("\n  Period = " + this.period);
            b.append("\n  b1all = " + this.b1all);
            b.append("\n  b1ss = " + this.b1ss);
            b.append("\n  b1rv = " + this.b1rv);
            b.append("\n  b2 = " + this.b2);
            b.append("\n  b3 = " + this.b3);
            b.append("\n  b5 = " + this.b5);
            b.append("\n  bv = " + this.bv);
            b.append("\n va = " + this.va);
            b.append("\n  h = " + this.h);
            b.append("\n  sigma1 = " + this.sigma1);
            b.append("\n  sigmaC = " + this.sigmaC);
            b.append("\n  sigmaR = " + this.sigmaR);
            b.append("\n  sigmaE = " + this.sigmaE);
            b.append("\n  sigmaLnY = " + this.sigmaLnY);
            return b.toString();
        }
    }
}

