/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.magdist;

import java.util.ArrayList;
import org.opensha.data.DataPoint2D;
import org.opensha.data.function.DiscretizedFuncList;
import org.opensha.exceptions.DataPoint2DException;
import org.opensha.exceptions.DiscretizedFuncException;
import org.opensha.exceptions.InvalidRangeException;
import org.opensha.exceptions.MagFreqDistException;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class SummedMagFreqDist
extends IncrementalMagFreqDist {
    private boolean saveMagFreqDists = false;
    private boolean saveAllInfo = false;
    private DiscretizedFuncList savedMagFreqDists;
    private ArrayList savedInfoList;
    public static String NAME = "Summed Dist";

    public SummedMagFreqDist(double min, int num, double delta) throws InvalidRangeException {
        super(min, num, delta);
    }

    public SummedMagFreqDist(double min, double max, int num) throws DiscretizedFuncException, InvalidRangeException {
        super(min, max, num);
    }

    public SummedMagFreqDist(double min, int num, double delta, boolean saveMagFreqDist, boolean saveAllInfo) throws InvalidRangeException {
        super(min, num, delta);
        this.saveMagFreqDists = saveMagFreqDist;
        this.saveAllInfo = saveAllInfo;
        if (this.saveMagFreqDists) {
            this.savedMagFreqDists = new DiscretizedFuncList();
        } else if (saveAllInfo) {
            this.savedInfoList = new ArrayList();
        }
    }

    public SummedMagFreqDist(double min, double max, int num, boolean saveMagFreqDist, boolean saveAllInfo) throws DiscretizedFuncException, InvalidRangeException {
        super(min, max, num);
        this.saveMagFreqDists = saveMagFreqDist;
        this.saveAllInfo = saveAllInfo;
        if (this.saveMagFreqDists) {
            this.savedMagFreqDists = new DiscretizedFuncList();
        } else if (saveAllInfo) {
            this.savedInfoList = new ArrayList();
        }
    }

    public void addIncrementalMagFreqDist(IncrementalMagFreqDist magFreqDist) throws DiscretizedFuncException, DataPoint2DException {
        if (magFreqDist.getMinX() != this.minX || magFreqDist.getDelta() != this.delta || magFreqDist.getNum() != this.num) {
            throw new DiscretizedFuncException("addIncrementalMagFreqDist invalid value of min, num or delta of new distribution");
        }
        for (int i = 0; i < this.num; ++i) {
            super.set(i, this.getY(i) + magFreqDist.getY(i));
        }
        if (this.saveMagFreqDists) {
            this.savedMagFreqDists.add(magFreqDist);
        } else if (this.saveAllInfo) {
            this.savedInfoList.add(magFreqDist.getInfo());
        }
    }

    public void set(DataPoint2D point) throws MagFreqDistException {
        throw new MagFreqDistException("Cannot Access the set function of the SummedMagFreqDist from outside this class");
    }

    public void set(double x, double y) throws MagFreqDistException {
        throw new MagFreqDistException("Cannot Access the set function of the SummedMagFreqDist from outside this class");
    }

    public void set(int index, double y) throws MagFreqDistException {
        throw new MagFreqDistException("Cannot Access the set function of the SummedMagFreqDist from outside this class");
    }

    public void removeIncrementalMagFreqDist(IncrementalMagFreqDist magFreqDist) throws DiscretizedFuncException, DataPoint2DException {
        int index;
        if (this.saveMagFreqDists) {
            index = this.savedMagFreqDists.indexOf(magFreqDist);
            if (index == -1) {
                throw new DiscretizedFuncException("this distribution does not exist");
            }
            this.savedMagFreqDists.remove(magFreqDist);
        } else if (this.saveAllInfo) {
            index = this.savedInfoList.indexOf(magFreqDist.getInfo());
            if (index == -1) {
                throw new DiscretizedFuncException("this distribution does not exist");
            }
            this.savedInfoList.remove(magFreqDist.getInfo());
        } else {
            throw new DiscretizedFuncException("Distributions are not saved");
        }
        for (int i = 0; i < this.num; ++i) {
            super.set(i, this.getY(i) - magFreqDist.getY(i));
        }
    }

    public ArrayList getAllInfo() {
        if (this.saveMagFreqDists) {
            ArrayList<String> infoVector = new ArrayList<String>();
            for (int i = 0; i < this.savedMagFreqDists.size(); ++i) {
                infoVector.add(this.savedMagFreqDists.get(i).getInfo());
            }
            return infoVector;
        }
        if (this.saveAllInfo) {
            return this.savedInfoList;
        }
        return null;
    }

    public DiscretizedFuncList getMagFreqDists() {
        return this.savedMagFreqDists;
    }

    public String getDefaultName() {
        return NAME;
    }

    public String getDefaultInfo() {
        return "Sum of these Incremental Mag-Freq Dists";
    }
}

