/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.param;

import java.util.ListIterator;
import org.opensha.calc.RelativeLocation;
import org.opensha.data.Location;
import org.opensha.exceptions.ConstraintException;
import org.opensha.param.DoubleConstraint;
import org.opensha.param.ParameterConstraintAPI;
import org.opensha.param.WarningParameterAPI;
import org.opensha.sha.param.WarningDoublePropagationEffectParameter;

public class DistanceRupParameter
extends WarningDoublePropagationEffectParameter
implements WarningParameterAPI {
    protected static final String C = "DistanceRupParameter";
    protected static final boolean D = false;
    public static final String NAME = "DistanceRup";
    public static final String UNITS = "km";
    public static final String INFO = "Rupture Distance (closest distance to fault surface)";
    private static final Double MIN = new Double(0.0);
    private static final Double MAX = new Double(Double.MAX_VALUE);

    public DistanceRupParameter() {
        this.init();
    }

    public DistanceRupParameter(ParameterConstraintAPI warningConstraint) throws ConstraintException {
        if (warningConstraint != null && !(warningConstraint instanceof DoubleConstraint)) {
            throw new ConstraintException("DistanceRupParameter : Constructor(): Input constraint must be a DoubleConstraint");
        }
        this.init((DoubleConstraint)warningConstraint);
    }

    protected void init(DoubleConstraint warningConstraint) {
        this.warningConstraint = warningConstraint;
        this.constraint = new DoubleConstraint(MIN, MAX);
        this.constraint.setNullAllowed(false);
        this.name = NAME;
        this.constraint.setName(this.name);
        this.units = UNITS;
        this.info = INFO;
    }

    protected void init() {
        this.init(null);
    }

    protected void calcValueFromSiteAndEqkRup() {
        if (this.site != null && this.eqkRupture != null) {
            Location loc1 = this.site.getLocation();
            double minDistance = 999999.0;
            ListIterator it = this.eqkRupture.getRuptureSurface().getLocationsIterator();
            while (it.hasNext()) {
                double vertDist;
                Location loc2 = (Location)it.next();
                double horzDist = RelativeLocation.getHorzDistance(loc1, loc2);
                double totalDist = horzDist * horzDist + (vertDist = RelativeLocation.getVertDistance(loc1, loc2)) * vertDist;
                if (!(totalDist < minDistance)) continue;
                minDistance = totalDist;
            }
            this.setValueIgnoreWarning(new Double(Math.pow(minDistance, 0.5)));
        } else {
            this.value = null;
        }
    }

    public String getType() {
        String type = "DoubleParameter";
        ParameterConstraintAPI constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + type;
        }
        return type;
    }

    public Object clone() {
        DoubleConstraint c1 = null;
        DoubleConstraint c2 = null;
        if (this.constraint != null) {
            c1 = (DoubleConstraint)this.constraint.clone();
        }
        if (this.warningConstraint != null) {
            c2 = (DoubleConstraint)this.warningConstraint.clone();
        }
        Double val = null;
        Double val2 = null;
        if (this.value != null) {
            val = (Double)this.value;
            val2 = new Double(val);
        }
        DistanceRupParameter param = new DistanceRupParameter();
        param.value = val2;
        param.constraint = c1;
        param.warningConstraint = c2;
        param.name = this.name;
        param.info = this.info;
        param.site = this.site;
        param.eqkRupture = this.eqkRupture;
        if (!this.editable) {
            param.setNonEditable();
        }
        return param;
    }
}

