/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.param;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.data.function.EvenlyDiscretizedFunc;
import org.opensha.exceptions.ConstraintException;
import org.opensha.exceptions.EditableException;
import org.opensha.exceptions.ParameterException;
import org.opensha.param.DependentParameter;
import org.opensha.param.DoubleParameter;
import org.opensha.param.EvenlyDiscretizedFuncParameter;
import org.opensha.param.IntegerParameter;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterConstraintAPI;
import org.opensha.param.ParameterList;
import org.opensha.param.StringConstraint;
import org.opensha.param.StringParameter;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SingleMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.magdist.YC_1985_CharMagFreqDist;
import org.opensha.sha.param.MagDistStringParameter;
import org.opensha.sha.param.MagFreqDistConstraint;

public class MagFreqDistParameter
extends DependentParameter
implements Serializable {
    protected static final String C = "MagFreqDistParameter";
    protected static final boolean D = false;
    public static final String DISTRIBUTION_NAME = "Distribution Type";
    public static final String MIN = new String("Min");
    public static final String MIN_INFO = new String("Minimum magnitude of the discetized function");
    public static final String MAX = new String("Max");
    public static final String MAX_INFO = new String("Maximum magnitude of the discetized function");
    public static final String NUM = new String("Num");
    public static final String NUM_INFO = new String("Number of points in  the discetized function");
    public static final String TOT_MO_RATE = new String("Total Moment Rate");
    public static final String MO_RATE_UNITS = new String("Nm/yr");
    public static final String TOT_CUM_RATE = new String("Total Cumulative Rate");
    public static final String RATE_UNITS = new String("/yr");
    public static final String GR_MAG_UPPER = new String("Mag Upper");
    public static final String GR_MAG_UPPER_INFO = new String("Magnitude of the last non-zero rate");
    public static final String GR_MAG_LOWER = new String("Mag Lower");
    public static final String GR_MAG_LOWER_INFO = new String("Magnitude of the first non-zero rate");
    public static final String GR_BVALUE = new String("b Value");
    public static final String BVALUE_INFO = new String("b in: log(rate) = a-b*magnitude");
    public static final String SET_ALL_PARAMS_BUT = new String("Set All Params But");
    public static final String FIX = new String("Constrain");
    public static final String FIX_INFO = new String("Only one of these can be matched exactly due to mag discretization");
    public static final String FIX_TOT_MO_RATE = new String("Total Moment Rate");
    public static final String FIX_TO_CUM_RATE = new String("Total Cum. Rate");
    public static final String FIX_RATE = new String("Rate");
    public static final String RATE = new String("Rate");
    public static final String MAG = new String("Mag");
    public static final String MO_RATE = new String("Moment Rate");
    public static final String SINGLE_PARAMS_TO_SET = new String("Params To Set");
    public static final String RATE_AND_MAG = new String("Rate & Mag");
    public static final String MAG_AND_MO_RATE = new String("Mag & Moment Rate");
    public static final String RATE_AND_MO_RATE = new String("Rate & Moment Rate");
    public static final String YC_DELTA_MAG_CHAR = new String("Delta Mag Char");
    public static final String YC_DELTA_MAG_CHAR_INFO = new String("Width of the characteristic part (below Mag Upper)");
    public static final String YC_MAG_PRIME = new String("Mag Prime");
    public static final String YC_MAG_PRIME_INFO = new String("Last magnitude of the GR part");
    public static final String YC_DELTA_MAG_PRIME = new String("Delta Mag Prime");
    public static final String YC_DELTA_MAG_PRIME_INFO = new String("Distance below Mag Prime where rate on GR equals that on the char. part");
    public static final String YC_TOT_CHAR_RATE = new String("Total Char. Rate");
    public static final String YC_TOT_CHAR_RATE_INFO = new String("Total rate of events above (magUpper-deltaMagChar)");
    public static final String MEAN = new String("Mean");
    public static final String STD_DEV = new String("Std Dev");
    public static final String TRUNCATION_REQ = new String("Truncation Type");
    public static final String TRUNCATE_UPPER_ONLY = new String("Upper");
    public static final String TRUNCATE_ON_BOTH_SIDES = new String("Upper and Lower");
    public static final String TRUNCATE_NUM_OF_STD_DEV = new String("Truncation Level(# of Std Devs)");
    public static final String NONE = new String("None");
    private StringConstraint sdFixOptions;
    private StringConstraint grSetAllButOptions;
    private StringConstraint grFixOptions;
    private StringConstraint ycSetAllButOptions;
    private StringConstraint gdSetAllButOptions;
    private boolean summedMagDistSelected;
    private SummedMagFreqDist summedMagDist;
    private String summedMagDistMetadata;
    private EvenlyDiscretizedFuncParameter evenlyDiscrtizedFunc;
    public static final String ARB_INCR_PARAM_NAME = " Arb. Incremental Mag Dist";
    private ParameterList parameterList = new ParameterList();

    public MagFreqDistParameter(String name) {
        super(name, null, null, null);
        this.initAdjustableParams();
    }

    public MagFreqDistParameter(String name, ArrayList allowedMagDists) throws ConstraintException {
        super(name, new MagFreqDistConstraint(allowedMagDists), null, null);
        this.initAdjustableParams();
    }

    public MagFreqDistParameter(String name, MagFreqDistConstraint constraint) throws ConstraintException {
        super(name, constraint, null, null);
        this.initAdjustableParams();
    }

    public MagFreqDistParameter(String name, IncrementalMagFreqDist value) {
        super(name, null, null, value);
        this.initAdjustableParams();
    }

    public MagFreqDistParameter(String name, ArrayList allowedMagDists, IncrementalMagFreqDist value) throws ConstraintException {
        super(name, new MagFreqDistConstraint(allowedMagDists), null, value);
        this.initAdjustableParams();
    }

    public MagFreqDistParameter(String name, MagFreqDistConstraint constraint, IncrementalMagFreqDist value) throws ConstraintException {
        super(name, constraint, null, value);
        this.initAdjustableParams();
    }

    public void setConstraint(ParameterConstraintAPI constraint) throws ParameterException, EditableException {
        String S = "MagFreqDistParameter: setConstraint(): ";
        this.checkEditable(S);
        if (!(constraint instanceof MagFreqDistConstraint)) {
            throw new ParameterException(S + "This parameter only accepts a MagFreqDistConstraint, unable to set the constraint.");
        }
        super.setConstraint(constraint);
    }

    public ArrayList getAllowedMagDists() {
        if (this.constraint != null) {
            return ((MagFreqDistConstraint)this.constraint).getAllowedMagDists();
        }
        return null;
    }

    public int compareTo(Object obj) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method not implemented yet");
    }

    public void setValue(IncrementalMagFreqDist value) throws ConstraintException, ParameterException {
        this.setValue((Object)value);
    }

    public boolean isAllowed(IncrementalMagFreqDist d) {
        return this.isAllowed((Object)d);
    }

    public boolean equals(Object obj) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method not implemented yet");
    }

    public Object clone() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method not implemented yet");
    }

    public String getType() {
        String type = C;
        return type;
    }

    public ParameterList getAdjustableParams() {
        return this.parameterList;
    }

    private void initAdjustableParams() {
        MagDistStringParameter distributionName = new MagDistStringParameter(DISTRIBUTION_NAME, this.getAllowedMagDists(), (String)this.getAllowedMagDists().get(0));
        DoubleParameter minParameter = new DoubleParameter(MIN, new Double(0.0));
        minParameter.setInfo(MIN_INFO);
        DoubleParameter maxParameter = new DoubleParameter(MAX, new Double(10.0));
        maxParameter.setInfo(MAX_INFO);
        IntegerParameter numParameter = new IntegerParameter(NUM, 0, Integer.MAX_VALUE, new Integer(101));
        numParameter.setInfo(NUM_INFO);
        DoubleParameter totMoRate = new DoubleParameter(TOT_MO_RATE, 0.0, Double.POSITIVE_INFINITY, MO_RATE_UNITS, new Double(1.0E19));
        DoubleParameter magLower = new DoubleParameter(GR_MAG_LOWER, new Double(5.0));
        magLower.setInfo(GR_MAG_LOWER_INFO);
        DoubleParameter magUpper = new DoubleParameter(GR_MAG_UPPER, new Double(8.0));
        magUpper.setInfo(GR_MAG_UPPER_INFO);
        DoubleParameter bValue = new DoubleParameter(GR_BVALUE, 0.0, Double.POSITIVE_INFINITY, new Double(1.0));
        bValue.setInfo(BVALUE_INFO);
        DoubleParameter totCumRate = new DoubleParameter(TOT_CUM_RATE, 0.0, Double.POSITIVE_INFINITY, RATE_UNITS, new Double(3.33));
        DoubleParameter rate = new DoubleParameter(RATE, 0.0, Double.POSITIVE_INFINITY, RATE_UNITS, new Double(0.005));
        DoubleParameter moRate = new DoubleParameter(MO_RATE, 0.0, Double.POSITIVE_INFINITY, MO_RATE_UNITS, new Double(1.0E19));
        DoubleParameter mag = new DoubleParameter(MAG, new Double(8.0));
        ArrayList<String> vStrings = new ArrayList<String>();
        vStrings.add(RATE_AND_MAG);
        vStrings.add(MAG_AND_MO_RATE);
        vStrings.add(RATE_AND_MO_RATE);
        StringParameter singleParamsToSet = new StringParameter(SINGLE_PARAMS_TO_SET, vStrings, (String)vStrings.get(0));
        ArrayList<String> vStrings3 = new ArrayList<String>();
        vStrings3.add(FIX_RATE);
        vStrings3.add(FIX_TOT_MO_RATE);
        this.sdFixOptions = new StringConstraint(vStrings3);
        DoubleParameter mean = new DoubleParameter(MEAN, new Double(8.0));
        DoubleParameter stdDev = new DoubleParameter(STD_DEV, 0.0, Double.POSITIVE_INFINITY, new Double(0.25));
        vStrings = new ArrayList();
        vStrings.add(TOT_CUM_RATE);
        vStrings.add(TOT_MO_RATE);
        this.gdSetAllButOptions = new StringConstraint(vStrings);
        vStrings = new ArrayList();
        vStrings.add(NONE);
        vStrings.add(TRUNCATE_UPPER_ONLY);
        vStrings.add(TRUNCATE_ON_BOTH_SIDES);
        StringParameter truncType = new StringParameter(TRUNCATION_REQ, vStrings, TRUNCATE_UPPER_ONLY);
        DoubleParameter truncLevel = new DoubleParameter(TRUNCATE_NUM_OF_STD_DEV, 0.0, Double.POSITIVE_INFINITY, new Double(1.0));
        ArrayList<String> vStrings1 = new ArrayList<String>();
        vStrings1.add(FIX_TO_CUM_RATE);
        vStrings1.add(FIX_TOT_MO_RATE);
        this.grFixOptions = new StringConstraint(vStrings1);
        DoubleParameter deltaMagChar = new DoubleParameter(YC_DELTA_MAG_CHAR, 0.0, Double.POSITIVE_INFINITY, new Double(1.0));
        deltaMagChar.setInfo(YC_DELTA_MAG_CHAR_INFO);
        DoubleParameter magPrime = new DoubleParameter(YC_MAG_PRIME, new Double(7.0));
        magPrime.setInfo(YC_MAG_PRIME_INFO);
        DoubleParameter deltaMagPrime = new DoubleParameter(YC_DELTA_MAG_PRIME, 0.0, Double.POSITIVE_INFINITY, new Double(1.0));
        deltaMagPrime.setInfo(YC_DELTA_MAG_PRIME_INFO);
        DoubleParameter totCharRate = new DoubleParameter(YC_TOT_CHAR_RATE, 0.0, Double.POSITIVE_INFINITY, new Double(0.01));
        totCharRate.setInfo(YC_TOT_CHAR_RATE_INFO);
        vStrings = new ArrayList();
        vStrings.add(YC_TOT_CHAR_RATE);
        vStrings.add(TOT_MO_RATE);
        this.ycSetAllButOptions = new StringConstraint(vStrings);
        StringParameter setAllBut = new StringParameter(SET_ALL_PARAMS_BUT, this.ycSetAllButOptions, (String)this.ycSetAllButOptions.getAllowedStrings().get(0));
        StringParameter fixParam = new StringParameter(FIX, this.grFixOptions, FIX_TO_CUM_RATE);
        fixParam.setInfo(FIX_INFO);
        vStrings = new ArrayList();
        vStrings.add(TOT_MO_RATE);
        vStrings.add(TOT_CUM_RATE);
        vStrings.add(GR_MAG_UPPER);
        this.grSetAllButOptions = new StringConstraint(vStrings);
        this.parameterList.addParameter(distributionName);
        this.parameterList.addParameter(minParameter);
        this.parameterList.addParameter(numParameter);
        this.parameterList.addParameter(maxParameter);
        this.parameterList.addParameter(magLower);
        this.parameterList.addParameter(magUpper);
        this.parameterList.addParameter(bValue);
        this.parameterList.addParameter(deltaMagChar);
        this.parameterList.addParameter(magPrime);
        this.parameterList.addParameter(deltaMagPrime);
        this.parameterList.addParameter(mean);
        this.parameterList.addParameter(stdDev);
        this.parameterList.addParameter(truncType);
        this.parameterList.addParameter(truncLevel);
        this.parameterList.addParameter(setAllBut);
        this.parameterList.addParameter(singleParamsToSet);
        this.parameterList.addParameter(totCharRate);
        this.parameterList.addParameter(mag);
        this.parameterList.addParameter(rate);
        this.parameterList.addParameter(moRate);
        this.parameterList.addParameter(totMoRate);
        this.parameterList.addParameter(totCumRate);
        this.parameterList.addParameter(fixParam);
        this.initArbIncrementalMagFreqDist();
        this.parameterList.addParameter(this.evenlyDiscrtizedFunc);
    }

    private void initArbIncrementalMagFreqDist() {
        ArbIncrementalMagFreqDist arbIncrDist = new ArbIncrementalMagFreqDist(0.0, 10.0, 101);
        this.evenlyDiscrtizedFunc = new EvenlyDiscretizedFuncParameter(ARB_INCR_PARAM_NAME, arbIncrDist);
    }

    public EvenlyDiscretizedFuncParameter getArbIncrementalMagFreqDist() {
        return this.evenlyDiscrtizedFunc;
    }

    public void setMagDist(ParameterList newParamList) {
        this.parameterList.replaceParameter(SET_ALL_PARAMS_BUT, newParamList.getParameter(SET_ALL_PARAMS_BUT));
        this.parameterList.replaceParameter(FIX, newParamList.getParameter(FIX));
        ListIterator it = newParamList.getParametersIterator();
        while (it.hasNext()) {
            ParameterAPI tempParam = (ParameterAPI)it.next();
            this.parameterList.getParameter(tempParam.getName()).setValue(tempParam.getValue());
        }
        this.setMagDist();
    }

    public void setMagDistAsSummedMagDist(SummedMagFreqDist magDist, String metadata) {
        this.summedMagDist = magDist;
        this.summedMagDistMetadata = metadata;
    }

    public void setSummedDistPlotted(boolean sumDistPlotted) {
        this.summedMagDistSelected = sumDistPlotted;
    }

    public void setMagDist() {
        IncrementalMagFreqDist magDist;
        ParameterList independentParamList;
        block62: {
            String S = "MagFreqDistParameter: getMagDist():";
            if (this.summedMagDistSelected) {
                this.setValue(this.summedMagDist);
                this.setDependentParamMetadataString(this.summedMagDistMetadata);
                this.setIndependentParameters(null);
                return;
            }
            String distributionName = this.parameterList.getParameter(DISTRIBUTION_NAME).getValue().toString();
            independentParamList = new ParameterList();
            independentParamList.addParameter(this.parameterList.getParameter(DISTRIBUTION_NAME));
            magDist = null;
            if (distributionName.equals(ArbIncrementalMagFreqDist.NAME)) {
                EvenlyDiscretizedFunc func = (EvenlyDiscretizedFunc)this.evenlyDiscrtizedFunc.getValue();
                double min = func.getMinX();
                double max = func.getMaxX();
                int num = func.getNum();
                ArbIncrementalMagFreqDist arbMagDist = new ArbIncrementalMagFreqDist(min, max, num);
                for (int i = 0; i < num; ++i) {
                    arbMagDist.set(func.getX(i), func.getY(i));
                }
                magDist = arbMagDist;
                this.setValue(magDist);
                this.setIndependentParameters(null);
                return;
            }
            try {
                int trialInt;
                Double min = (Double)this.parameterList.getParameter(MIN).getValue();
                Double max = (Double)this.parameterList.getParameter(MAX).getValue();
                Integer num = (Integer)this.parameterList.getParameter(NUM).getValue();
                if (min > max) {
                    throw new RuntimeException("Min Value cannot be less than the Max Value");
                }
                independentParamList.addParameter(this.parameterList.getParameter(MIN));
                independentParamList.addParameter(this.parameterList.getParameter(MAX));
                independentParamList.addParameter(this.parameterList.getParameter(NUM));
                if (distributionName.equalsIgnoreCase(SingleMagFreqDist.NAME)) {
                    SingleMagFreqDist single = new SingleMagFreqDist((double)min, max, num);
                    String paramToSet = this.parameterList.getParameter(SINGLE_PARAMS_TO_SET).getValue().toString();
                    independentParamList.addParameter(this.parameterList.getParameter(SINGLE_PARAMS_TO_SET));
                    if (paramToSet.equalsIgnoreCase(RATE_AND_MAG)) {
                        Double rate = (Double)this.parameterList.getParameter(RATE).getValue();
                        Double mag = (Double)this.parameterList.getParameter(MAG).getValue();
                        if (mag > max || mag < min) {
                            throw new RuntimeException("Value of Mag must lie between the min and max value");
                        }
                        independentParamList.addParameter(this.parameterList.getParameter(RATE));
                        independentParamList.addParameter(this.parameterList.getParameter(MAG));
                        try {
                            single.setMagAndRate(mag, rate);
                        }
                        catch (RuntimeException e) {
                            throw new RuntimeException("The chosen magnitude must fall on one of the discrete x-axis values");
                        }
                    } else if (paramToSet.equalsIgnoreCase(MAG_AND_MO_RATE)) {
                        Double mag = (Double)this.parameterList.getParameter(MAG).getValue();
                        Double moRate = (Double)this.parameterList.getParameter(MO_RATE).getValue();
                        if (mag > max || mag < min) {
                            throw new RuntimeException("Value of Mag must lie between the min and max value");
                        }
                        independentParamList.addParameter(this.parameterList.getParameter(MO_RATE));
                        independentParamList.addParameter(this.parameterList.getParameter(MAG));
                        try {
                            single.setMagAndMomentRate(mag, moRate);
                        }
                        catch (RuntimeException e) {
                            throw new RuntimeException("The chosen magnitude must fall on one of the discrete x-axis values");
                        }
                    } else if (paramToSet.equalsIgnoreCase(RATE_AND_MO_RATE)) {
                        String fix = this.parameterList.getParameter(FIX).getValue().toString();
                        Double rate = (Double)this.parameterList.getParameter(RATE).getValue();
                        Double moRate = (Double)this.parameterList.getParameter(MO_RATE).getValue();
                        if (fix.equals(FIX_RATE)) {
                            single.setRateAndMomentRate(rate, moRate, true);
                        } else {
                            single.setRateAndMomentRate(rate, moRate, false);
                        }
                        independentParamList.addParameter(this.parameterList.getParameter(FIX));
                        independentParamList.addParameter(this.parameterList.getParameter(MO_RATE));
                        independentParamList.addParameter(this.parameterList.getParameter(RATE));
                    }
                    magDist = single;
                    break block62;
                }
                if (distributionName.equalsIgnoreCase(GaussianMagFreqDist.NAME)) {
                    Double mean = (Double)this.parameterList.getParameter(MEAN).getValue();
                    Double stdDev = (Double)this.parameterList.getParameter(STD_DEV).getValue();
                    String truncTypeValue = this.parameterList.getParameter(TRUNCATION_REQ).getValue().toString();
                    if (mean > max || mean < min) {
                        throw new RuntimeException("Value of Mean must lie between the min and max value");
                    }
                    independentParamList.addParameter(this.parameterList.getParameter(MEAN));
                    independentParamList.addParameter(this.parameterList.getParameter(STD_DEV));
                    independentParamList.addParameter(this.parameterList.getParameter(TRUNCATION_REQ));
                    int truncType = 0;
                    if (truncTypeValue.equalsIgnoreCase(TRUNCATE_UPPER_ONLY)) {
                        truncType = 1;
                    } else if (truncTypeValue.equalsIgnoreCase(TRUNCATE_ON_BOTH_SIDES)) {
                        truncType = 2;
                    }
                    Double truncLevel = new Double(Double.NaN);
                    if (truncType != 0) {
                        truncLevel = (Double)this.parameterList.getParameter(TRUNCATE_NUM_OF_STD_DEV).getValue();
                        if (truncLevel < 0.0) {
                            throw new RuntimeException("Value of " + TRUNCATE_NUM_OF_STD_DEV + " must be  positive");
                        }
                        independentParamList.addParameter(this.parameterList.getParameter(TRUNCATE_NUM_OF_STD_DEV));
                    }
                    String setAllParamsBut = this.parameterList.getParameter(SET_ALL_PARAMS_BUT).getValue().toString();
                    independentParamList.addParameter(this.parameterList.getParameter(SET_ALL_PARAMS_BUT));
                    GaussianMagFreqDist gaussian = new GaussianMagFreqDist((double)min, max, num);
                    if (setAllParamsBut.equalsIgnoreCase(TOT_CUM_RATE)) {
                        Double totMoRate = (Double)this.parameterList.getParameter(TOT_MO_RATE).getValue();
                        independentParamList.addParameter(this.parameterList.getParameter(TOT_MO_RATE));
                        gaussian.setAllButCumRate(mean, stdDev, totMoRate, truncLevel, truncType);
                    } else {
                        Double totCumRate = (Double)this.parameterList.getParameter(TOT_CUM_RATE).getValue();
                        independentParamList.addParameter(this.parameterList.getParameter(TOT_CUM_RATE));
                        gaussian.setAllButTotMoRate(mean, stdDev, totCumRate, truncLevel, truncType);
                    }
                    magDist = gaussian;
                    break block62;
                }
                if (distributionName.equalsIgnoreCase(GutenbergRichterMagFreqDist.NAME)) {
                    GutenbergRichterMagFreqDist gR = new GutenbergRichterMagFreqDist((double)min, max, num);
                    Double magLower = (Double)this.parameterList.getParameter(GR_MAG_LOWER).getValue();
                    Double bValue = (Double)this.parameterList.getParameter(GR_BVALUE).getValue();
                    String setAllParamsBut = this.parameterList.getParameter(SET_ALL_PARAMS_BUT).getValue().toString();
                    if (magLower > max || magLower < min) {
                        throw new RuntimeException("Value of MagLower must lie between the min and max value");
                    }
                    independentParamList.addParameter(this.parameterList.getParameter(GR_MAG_LOWER));
                    independentParamList.addParameter(this.parameterList.getParameter(GR_BVALUE));
                    independentParamList.addParameter(this.parameterList.getParameter(SET_ALL_PARAMS_BUT));
                    if (setAllParamsBut.equalsIgnoreCase(TOT_MO_RATE)) {
                        Double magUpper = (Double)this.parameterList.getParameter(GR_MAG_UPPER).getValue();
                        Double totCumRate = (Double)this.parameterList.getParameter(TOT_CUM_RATE).getValue();
                        if (magUpper > max || magUpper < min) {
                            throw new RuntimeException("Value of MagUpper must lie between the min and max value");
                        }
                        if (magLower > magUpper) {
                            throw new RuntimeException("Value of MagLower must be <= to MagUpper");
                        }
                        try {
                            gR.setAllButTotMoRate(magLower, magUpper, totCumRate, bValue);
                        }
                        catch (RuntimeException e) {
                            throw new RuntimeException("magUpper and MagLower must fall on one of the discrete x-axis values");
                        }
                        independentParamList.addParameter(this.parameterList.getParameter(GR_MAG_UPPER));
                        independentParamList.addParameter(this.parameterList.getParameter(TOT_CUM_RATE));
                    } else if (setAllParamsBut.equalsIgnoreCase(TOT_CUM_RATE)) {
                        Double magUpper = (Double)this.parameterList.getParameter(GR_MAG_UPPER).getValue();
                        Double toMoRate = (Double)this.parameterList.getParameter(TOT_MO_RATE).getValue();
                        if (magUpper > max || magUpper < min) {
                            throw new RuntimeException("Value of MagUpper must lie between the min and max value");
                        }
                        if (magLower > magUpper) {
                            throw new RuntimeException("Value of MagLower must be <= to MagUpper");
                        }
                        try {
                            gR.setAllButTotCumRate(magLower, magUpper, toMoRate, bValue);
                        }
                        catch (RuntimeException e) {
                            throw new RuntimeException("magUpper and MagLower must fall on one of the discrete x-axis values");
                        }
                        independentParamList.addParameter(this.parameterList.getParameter(GR_MAG_UPPER));
                        independentParamList.addParameter(this.parameterList.getParameter(TOT_MO_RATE));
                    } else if (setAllParamsBut.equalsIgnoreCase(GR_MAG_UPPER)) {
                        Double toCumRate = (Double)this.parameterList.getParameter(TOT_CUM_RATE).getValue();
                        Double toMoRate = (Double)this.parameterList.getParameter(TOT_MO_RATE).getValue();
                        String fix = this.parameterList.getParameter(FIX).getValue().toString();
                        boolean relaxTotMoRate = true;
                        if (fix.equalsIgnoreCase(FIX_TOT_MO_RATE)) {
                            relaxTotMoRate = false;
                        }
                        try {
                            gR.setAllButMagUpper(magLower, toMoRate, toCumRate, bValue, relaxTotMoRate);
                        }
                        catch (RuntimeException e) {
                            throw new RuntimeException("MagLower must fall on one of the discrete x-axis values");
                        }
                        independentParamList.addParameter(this.parameterList.getParameter(TOT_CUM_RATE));
                        independentParamList.addParameter(this.parameterList.getParameter(TOT_MO_RATE));
                        independentParamList.addParameter(this.parameterList.getParameter(FIX));
                    }
                    magDist = gR;
                    break block62;
                }
                if (!distributionName.equalsIgnoreCase(YC_1985_CharMagFreqDist.NAME)) break block62;
                double magLower = (Double)this.parameterList.getParameter(GR_MAG_LOWER).getValue();
                double magUpper = (Double)this.parameterList.getParameter(GR_MAG_UPPER).getValue();
                double deltaMagChar = (Double)this.parameterList.getParameter(YC_DELTA_MAG_CHAR).getValue();
                double magPrime = (Double)this.parameterList.getParameter(YC_MAG_PRIME).getValue();
                double deltaMagPrime = (Double)this.parameterList.getParameter(YC_DELTA_MAG_PRIME).getValue();
                double bValue = (Double)this.parameterList.getParameter(GR_BVALUE).getValue();
                if (magLower > max || magLower < min) {
                    throw new RuntimeException("Value of MagLower must lie between the min and max value");
                }
                if (magUpper > max || magUpper < min) {
                    throw new RuntimeException("Value of MagUpper must lie between the min and max value");
                }
                YC_1985_CharMagFreqDist yc = new YC_1985_CharMagFreqDist((double)min, max, num);
                try {
                    trialInt = yc.getXIndex(magLower);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("MagLower must fall on one of the discrete x-axis values");
                }
                try {
                    trialInt = yc.getXIndex(magUpper);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("MagUpper must fall on one of the discrete x-axis values");
                }
                try {
                    trialInt = yc.getXIndex(magPrime);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("MagPrime must fall on one of the discrete x-axis values");
                }
                try {
                    trialInt = yc.getXIndex(magPrime - deltaMagPrime);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("MagPrime-DeltaMagPrime must fall on one of the discrete x-axis values");
                }
                try {
                    trialInt = yc.getXIndex(magUpper - deltaMagChar);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("MagUpper-DeltaMagChar must fall on one of the discrete x-axis values");
                }
                independentParamList.addParameter(this.parameterList.getParameter(GR_MAG_LOWER));
                independentParamList.addParameter(this.parameterList.getParameter(GR_MAG_UPPER));
                independentParamList.addParameter(this.parameterList.getParameter(YC_DELTA_MAG_CHAR));
                independentParamList.addParameter(this.parameterList.getParameter(YC_MAG_PRIME));
                independentParamList.addParameter(this.parameterList.getParameter(YC_DELTA_MAG_PRIME));
                independentParamList.addParameter(this.parameterList.getParameter(GR_BVALUE));
                String setAllParamsBut = this.parameterList.getParameter(SET_ALL_PARAMS_BUT).getValue().toString();
                independentParamList.addParameter(this.parameterList.getParameter(SET_ALL_PARAMS_BUT));
                if (setAllParamsBut.equalsIgnoreCase(YC_TOT_CHAR_RATE)) {
                    double totMoRate = (Double)this.parameterList.getParameter(TOT_MO_RATE).getValue();
                    yc.setAllButTotCharRate(magLower, magUpper, deltaMagChar, magPrime, deltaMagPrime, bValue, totMoRate);
                    independentParamList.addParameter(this.parameterList.getParameter(TOT_MO_RATE));
                } else {
                    double totCharRate = (Double)this.parameterList.getParameter(YC_TOT_CHAR_RATE).getValue();
                    yc.setAllButTotMoRate(magLower, magUpper, deltaMagChar, magPrime, deltaMagPrime, bValue, totCharRate);
                    independentParamList.addParameter(this.parameterList.getParameter(YC_TOT_CHAR_RATE));
                }
                magDist = yc;
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Value entered must be a valid Numerical Value");
            }
            catch (NullPointerException e) {
                throw new NullPointerException("Enter All values");
            }
        }
        this.setValue(magDist);
        this.setIndependentParameters(independentParamList);
    }

    public String getMetadataString() {
        return this.getDependentParamMetadataString();
    }

    public StringConstraint getSingleDistFixOptions() {
        return this.sdFixOptions;
    }

    public StringConstraint getGRSetAllButOptions() {
        return this.grSetAllButOptions;
    }

    public StringConstraint getGRFixOptions() {
        return this.grFixOptions;
    }

    public StringConstraint getYCSetAllButOptions() {
        return this.ycSetAllButOptions;
    }

    public StringConstraint getGaussianDistSetAllButOptions() {
        return this.gdSetAllButOptions;
    }
}

