/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.param;

import java.io.Serializable;
import java.util.ListIterator;
import org.opensha.calc.RelativeLocation;
import org.opensha.data.Location;
import org.opensha.data.Site;
import org.opensha.param.BooleanParameter;
import org.opensha.param.ParameterAPI;
import org.opensha.param.ParameterList;
import org.opensha.param.event.ParameterChangeEvent;
import org.opensha.param.event.ParameterChangeListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.param.WarningDoublePropagationEffectParameter;
import org.opensha.sha.surface.EvenlyGriddedSurfaceAPI;

public class PropagationEffect
implements Serializable,
ParameterChangeListener {
    private static final String C = "PropagationEffect";
    private static final boolean D = false;
    private boolean APPROX_HORZ_DIST = true;
    private boolean POINT_SRC_CORR = true;
    double seisDepth = 3.0;
    public static final String APPROX_DIST_PARAM_NAME = "Use Approximate Distance";
    private static final String APPROX_DIST_PARAM_INFO = "Horz. dist. calculated as: 111 * ( (lat1-lat2)^2 + (cos(0.5*(lat1+lat2))*(lon1-lon2))^2 )^0.5";
    BooleanParameter approxDistParam = new BooleanParameter("Use Approximate Distance", new Boolean(this.APPROX_HORZ_DIST));
    public static final String POINT_SRC_CORR_PARAM_NAME = "Point-Source Correction";
    private static final String POINT_SRC_CORR_PARAM_INFO = "Use median distance correction for point sources";
    BooleanParameter pointSrcCorrParam;
    protected ParameterList adjustableParams;
    protected Site site = null;
    protected EqkRupture eqkRupture = null;
    protected double distanceRup;
    protected double distanceJB;
    protected double distanceSeis;
    protected boolean STALE = true;

    public PropagationEffect() {
        this.approxDistParam.setInfo(APPROX_DIST_PARAM_INFO);
        this.approxDistParam.addParameterChangeListener(this);
        this.pointSrcCorrParam = new BooleanParameter(POINT_SRC_CORR_PARAM_NAME, new Boolean(this.POINT_SRC_CORR));
        this.pointSrcCorrParam.setInfo(POINT_SRC_CORR_PARAM_INFO);
        this.pointSrcCorrParam.addParameterChangeListener(this);
        this.adjustableParams = new ParameterList();
        this.adjustableParams.addParameter(this.approxDistParam);
        this.adjustableParams.addParameter(this.pointSrcCorrParam);
    }

    public PropagationEffect(Site site, EqkRupture eqkRupture) {
        this();
        this.site = site;
        this.eqkRupture = eqkRupture;
    }

    public Site getSite() {
        return this.site;
    }

    public EqkRupture getEqkRupture() {
        return this.eqkRupture;
    }

    public void setSite(Site site) {
        this.site = site;
        this.STALE = true;
    }

    public void setEqkRupture(EqkRupture eqkRupture) {
        this.eqkRupture = eqkRupture;
        this.STALE = true;
    }

    public void setAll(EqkRupture eqkRupture, Site site) {
        this.eqkRupture = eqkRupture;
        this.site = site;
        this.STALE = true;
    }

    public Object getParamValue(String paramName) {
        if (this.STALE) {
            this.computeParamValues();
        }
        if (paramName.equals("DistanceRup")) {
            return new Double(this.distanceRup);
        }
        if (paramName.equals("DistanceJB")) {
            return new Double(this.distanceJB);
        }
        if (paramName.equals("DistanceSeis")) {
            return new Double(this.distanceSeis);
        }
        throw new RuntimeException("Parameter not supported");
    }

    public void setParamValue(ParameterAPI param) {
        if (param instanceof WarningDoublePropagationEffectParameter) {
            ((WarningDoublePropagationEffectParameter)param).setValueIgnoreWarning(this.getParamValue(param.getName()));
        } else {
            param.setValue(this.getParamValue(param.getName()));
        }
    }

    public boolean isParamSupported(String paramName) {
        if (paramName.equals("DistanceRup")) {
            return true;
        }
        if (paramName.equals("DistanceJB")) {
            return true;
        }
        return paramName.equals("DistanceSeis");
    }

    public boolean isParamSupported(ParameterAPI param) {
        return this.isParamSupported(param.getName());
    }

    private void computeParamValues() {
        if (this.site != null && this.eqkRupture != null) {
            Location loc1 = this.site.getLocation();
            this.distanceJB = Double.MAX_VALUE;
            this.distanceSeis = Double.MAX_VALUE;
            this.distanceRup = Double.MAX_VALUE;
            EvenlyGriddedSurfaceAPI rupSurf = this.eqkRupture.getRuptureSurface();
            boolean projectToDepth = false;
            if (rupSurf.getNumRows() == 1 && rupSurf.getLocation(0, 0).getDepth() < this.seisDepth) {
                projectToDepth = true;
            }
            ListIterator it = rupSurf.getLocationsIterator();
            while (it.hasNext()) {
                double rupDist;
                Location loc2 = (Location)it.next();
                double vertDist = RelativeLocation.getVertDistance(loc1, loc2);
                double horzDist = this.APPROX_HORZ_DIST ? RelativeLocation.getApproxHorzDistance(loc1, loc2) : RelativeLocation.getHorzDistance(loc1, loc2);
                if (this.eqkRupture.getRuptureSurface().getNumCols() == 1 && this.eqkRupture.getRuptureSurface().getNumRows() == 1 && this.POINT_SRC_CORR) {
                    double rupLen = Math.pow(10.0, -3.22 + 0.69 * this.eqkRupture.getMag());
                    double corr = 0.7071 + 0.29290000000000005 / (1.0 + Math.pow(rupLen / (horzDist * 0.87), 1.1));
                    horzDist *= corr;
                }
                if (horzDist < this.distanceJB) {
                    this.distanceJB = horzDist;
                }
                if ((rupDist = horzDist * horzDist + vertDist * vertDist) < this.distanceRup) {
                    this.distanceRup = rupDist;
                }
                if (loc2.getDepth() >= this.seisDepth) {
                    if (!(rupDist < this.distanceSeis)) continue;
                    this.distanceSeis = rupDist;
                    continue;
                }
                if (!projectToDepth || !((rupDist = horzDist * horzDist + this.seisDepth * this.seisDepth) < this.distanceSeis)) continue;
                this.distanceSeis = rupDist;
            }
        } else {
            throw new RuntimeException("Site or EqkRupture is null");
        }
        this.distanceRup = Math.pow(this.distanceRup, 0.5);
        this.distanceSeis = Math.pow(this.distanceSeis, 0.5);
        this.STALE = false;
    }

    public void parameterChange(ParameterChangeEvent event) {
        this.APPROX_HORZ_DIST = (Boolean)this.approxDistParam.getValue();
        this.POINT_SRC_CORR = (Boolean)this.pointSrcCorrParam.getValue();
    }

    public ParameterList getAdjustableParameterList() {
        return this.adjustableParams;
    }

    public ListIterator getAdjustableParamsIterator() {
        return this.adjustableParams.getParametersIterator();
    }
}

