/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.param.editor.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opensha.param.ParameterAPI;
import org.opensha.sha.fault.FaultTrace;
import org.opensha.sha.param.SimpleFaultParameter;
import org.opensha.sha.param.editor.gui.SimpleFaultParameterEditorPanel;

public class SimpleFaultParameterGUI
extends JDialog {
    private JPanel evenlyGriddedSurfacePanel = new JPanel();
    private JScrollPane evenlyGriddedParamsScroll = new JScrollPane();
    private JButton button = new JButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel parameterPanel = new JPanel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    SimpleFaultParameterEditorPanel faultEditorPanel;

    public SimpleFaultParameterGUI(ParameterAPI surfaceParam) {
        this.setModal(true);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.faultEditorPanel = new SimpleFaultParameterEditorPanel(surfaceParam);
        this.parameterPanel.add((Component)this.faultEditorPanel, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 11, 1, new Insets(4, 4, 4, 4), 0, 0));
    }

    public static void main(String[] args) {
        SimpleFaultParameter surfaceParam = new SimpleFaultParameter("Fault-1", null);
        SimpleFaultParameterGUI simpleFaultParameterGUI = new SimpleFaultParameterGUI(surfaceParam);
        simpleFaultParameterGUI.setVisible(true);
        simpleFaultParameterGUI.pack();
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.evenlyGriddedSurfacePanel.setLayout(this.gridBagLayout1);
        this.parameterPanel.setLayout(this.gridBagLayout2);
        this.evenlyGriddedSurfacePanel.setPreferredSize(new Dimension(300, 450));
        this.evenlyGriddedParamsScroll.setPreferredSize(new Dimension(300, 450));
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.evenlyGriddedSurfacePanel, "Center");
        this.evenlyGriddedSurfacePanel.add((Component)this.evenlyGriddedParamsScroll, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 11, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.evenlyGriddedSurfacePanel.add((Component)this.button, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.button.setText("Make Simple Fault");
        this.button.setForeground(new Color(80, 80, 133));
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimpleFaultParameterGUI.this.button_actionPerformed(e);
            }
        });
        this.evenlyGriddedParamsScroll.getViewport().add((Component)this.parameterPanel, null);
        this.setSize(300, 450);
        this.setTitle("Simple Fault Parameter Settings");
    }

    void button_actionPerformed(ActionEvent e) {
        boolean disposeFlag = true;
        try {
            this.faultEditorPanel.setEvenlyGriddedSurfaceFromParams();
        }
        catch (RuntimeException ee) {
            disposeFlag = false;
            ee.printStackTrace();
            JOptionPane.showMessageDialog(this, ee.getMessage(), "Incorrect Input Parameters", 0);
        }
        if (disposeFlag) {
            this.dispose();
        }
    }

    public FaultTrace getFaultTrace() {
        return ((SimpleFaultParameter)this.faultEditorPanel.getParameter()).getFaultTrace();
    }

    public double getUpperSies() {
        return ((SimpleFaultParameter)this.faultEditorPanel.getParameter()).getUpperSiesmogenicDepth();
    }

    public double getLowerSies() {
        return ((SimpleFaultParameter)this.faultEditorPanel.getParameter()).getLowerSiesmogenicDepth();
    }

    public String getFaultName() {
        return ((SimpleFaultParameter)this.faultEditorPanel.getParameter()).getFaultName();
    }

    public void refreshParamEditor() {
        this.faultEditorPanel.refreshParamEditor();
    }

    public void setParameter(ParameterAPI param) {
        this.faultEditorPanel.setParameter(param);
    }

    public SimpleFaultParameterEditorPanel getSimpleFaultEditorPanel() {
        return this.faultEditorPanel;
    }
}

