/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.opensha.util.SystemPropertiesUtils;

public class FileUtils {
    protected static final String C = "FileUtils";
    protected static final boolean D = false;
    static /* synthetic */ Class class$org$opensha$util$FileUtils;

    public static ArrayList loadFile(String fileName) throws FileNotFoundException, IOException {
        String S = "FileUtils: loadFile(): ";
        ArrayList<String> list = new ArrayList<String>();
        File f = new File(fileName);
        if (f.exists()) {
            boolean ok = true;
            boolean counter = false;
            FileReader in = new FileReader(fileName);
            LineNumberReader lin = new LineNumberReader(in);
            while (ok) {
                try {
                    String str = lin.readLine();
                    if (str != null) {
                        if (str.trim().equals("")) continue;
                        list.add(str);
                        continue;
                    }
                    ok = false;
                }
                catch (IOException e) {
                    ok = false;
                }
            }
            lin.close();
            in.close();
        }
        return list;
    }

    public static ArrayList loadFile(URL url) throws Exception {
        URLConnection uc = url.openConnection();
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader tis = new BufferedReader(new InputStreamReader((InputStream)uc.getContent()));
        String str = tis.readLine();
        while (str != null) {
            list.add(str);
            str = tis.readLine();
        }
        tis.close();
        return list;
    }

    public static ArrayList loadJarFile(String fileName) throws FileNotFoundException, IOException {
        try {
            return FileUtils.loadFile((class$org$opensha$util$FileUtils == null ? (class$org$opensha$util$FileUtils = FileUtils.class$("org.opensha.util.FileUtils")) : class$org$opensha$util$FileUtils).getResource("/" + fileName));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveObjectInFile(String fileName, Object obj) {
        try {
            FileOutputStream fileOut = new FileOutputStream(fileName);
            ObjectOutputStream objectStream = new ObjectOutputStream(fileOut);
            objectStream.writeObject(obj);
            objectStream.close();
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object loadObjectFromURL(String url) {
        try {
            URL forecastURL = new URL(url);
            URLConnection uc = forecastURL.openConnection();
            ObjectInputStream tis = new ObjectInputStream((InputStream)uc.getContent());
            Object obj = tis.readObject();
            tis.close();
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void createZipFile(String filesPath) {
        int BUFFER = 8192;
        String zipFileName = "allFiles.zip";
        if (!filesPath.endsWith(SystemPropertiesUtils.getSystemFileSeparator())) {
            filesPath = filesPath + SystemPropertiesUtils.getSystemFileSeparator();
        }
        try {
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(filesPath + zipFileName);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            out.setMethod(8);
            byte[] data = new byte[BUFFER];
            File f = new File(filesPath);
            String[] files = f.list();
            for (int i = 0; i < files.length; ++i) {
                int count;
                if (files[i].equals(zipFileName)) continue;
                System.out.println("Adding: " + files[i]);
                FileInputStream fi = new FileInputStream(filesPath + files[i]);
                origin = new BufferedInputStream(fi, BUFFER);
                ZipEntry entry = new ZipEntry(files[i]);
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, BUFFER)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object loadObject(String fileName) {
        try {
            FileInputStream fin = new FileInputStream(fileName);
            ObjectInputStream tis = new ObjectInputStream(fin);
            Object obj = tis.readObject();
            tis.close();
            fin.close();
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

