/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client;

import com.sun.xml.rpc.client.HandlerChainInfoImpl;
import com.sun.xml.rpc.client.ServiceExceptionImpl;
import com.sun.xml.rpc.client.dii.BasicCall;
import com.sun.xml.rpc.client.dii.CallEx;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistryImpl;
import com.sun.xml.rpc.encoding.SerializerConstants;
import com.sun.xml.rpc.encoding.StandardTypeMappings;
import com.sun.xml.rpc.encoding.TypeMappingImpl;
import com.sun.xml.rpc.encoding.TypeMappingRegistryImpl;
import com.sun.xml.rpc.naming.ServiceReferenceResolver;
import com.sun.xml.rpc.soap.SOAPVersion;
import java.net.URL;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;

public class BasicService
implements Service,
SerializerConstants,
Referenceable {
    protected static final String DEFAULT_OPERATION_STYLE = "rpc";
    protected QName name;
    protected List ports;
    protected TypeMappingRegistry typeRegistry;
    protected InternalTypeMappingRegistry internalTypeRegistry;
    private HandlerRegistry handlerRegistry;

    protected QName[] getPortsAsArray() {
        return this.ports.toArray(new QName[this.ports.size()]);
    }

    protected void init(QName name, TypeMappingRegistry registry) {
        this.init();
        this.name = name;
        this.typeRegistry = registry;
        this.internalTypeRegistry = new InternalTypeMappingRegistryImpl(registry);
    }

    protected void init() {
        this.ports = new ArrayList();
        this.handlerRegistry = null;
    }

    public BasicService(QName name, TypeMappingRegistry registry) {
        this.init(name, registry);
    }

    public BasicService(QName name) {
        this.init(name, BasicService.createStandardTypeMappingRegistry());
    }

    public BasicService(QName name, QName[] ports) {
        this(name);
        this.addPorts(ports);
    }

    public BasicService(QName name, QName[] ports, TypeMappingRegistry registry) {
        this(name, registry);
        this.addPorts(ports);
    }

    protected void addPorts(QName[] ports) {
        if (ports != null) {
            int i = 0;
            while (i < ports.length) {
                this.addPort(ports[i]);
                ++i;
            }
        }
    }

    public BasicService(QName name, Iterator eachPort) {
        this(name);
        while (eachPort.hasNext()) {
            this.addPort((QName)eachPort.next());
        }
    }

    protected void addPort(QName port) {
        this.ports.add(port);
    }

    public Remote getPort(Class portInterface) throws ServiceException {
        throw this.noWsdlException();
    }

    protected ServiceException noWsdlException() {
        return new ServiceExceptionImpl("dii.service.no.wsdl.available");
    }

    public Remote getPort(QName portName, Class portInterface) throws ServiceException {
        throw this.noWsdlException();
    }

    public Call[] getCalls(QName portName) throws ServiceException {
        throw this.noWsdlException();
    }

    public Call createCall(QName portName) throws ServiceException {
        if (!this.ports.contains(portName)) {
            this.addPort(portName);
        }
        CallEx newCall = (CallEx)this.createCall();
        newCall.setPortName(portName);
        return newCall;
    }

    public Call createCall(QName portName, String operationName) throws ServiceException {
        return this.createCall(portName, new QName(operationName));
    }

    public Call createCall(QName portName, QName operationName) throws ServiceException {
        Call newCall = this.createCall(portName);
        newCall.setOperationName(operationName);
        return newCall;
    }

    public Call createCall() throws ServiceException {
        BasicCall call = new BasicCall(this.internalTypeRegistry, this.getHandlerRegistry());
        call.setProperty("javax.xml.rpc.soap.operation.style", DEFAULT_OPERATION_STYLE);
        return call;
    }

    public QName getServiceName() {
        return this.name;
    }

    public Iterator getPorts() throws ServiceException {
        throw this.noWsdlException();
    }

    public URL getWSDLDocumentLocation() {
        return null;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.typeRegistry;
    }

    public HandlerRegistry getHandlerRegistry() {
        if (this.handlerRegistry == null) {
            this.handlerRegistry = new HandlerRegistryImpl();
        }
        return this.handlerRegistry;
    }

    public static TypeMappingRegistry createStandardTypeMappingRegistry() {
        TypeMappingRegistryImpl registry = new TypeMappingRegistryImpl();
        try {
            TypeMapping soapMappings = BasicService.createSoapMappings(SOAPVersion.SOAP_11);
            registry.register("http://schemas.xmlsoap.org/soap/encoding/", soapMappings);
            TypeMapping soap12Mappings = BasicService.createSoapMappings(SOAPVersion.SOAP_12);
            registry.register("http://www.w3.org/2002/06/soap-encoding", soap12Mappings);
            TypeMapping literalMappings = BasicService.createLiteralMappings();
            registry.register("", literalMappings);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return registry;
    }

    protected static TypeMapping createSoapMappings() {
        return BasicService.createSoapMappings(SOAPVersion.SOAP_11);
    }

    protected static TypeMapping createSoapMappings(SOAPVersion ver) {
        TypeMappingImpl soapMappings = new TypeMappingImpl(StandardTypeMappings.getSoap(ver));
        if (ver == SOAPVersion.SOAP_11) {
            soapMappings.setSupportedEncodings(new String[]{"http://schemas.xmlsoap.org/soap/encoding/"});
        } else if (ver == SOAPVersion.SOAP_12) {
            soapMappings.setSupportedEncodings(new String[]{"http://www.w3.org/2002/06/soap-encoding"});
        }
        return soapMappings;
    }

    protected static TypeMapping createLiteralMappings() {
        TypeMappingImpl rpcLiteralMappings = new TypeMappingImpl(StandardTypeMappings.getRPCLiteral());
        rpcLiteralMappings.setSupportedEncodings(new String[]{""});
        return rpcLiteralMappings;
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "com.sun.xml.rpc.naming.ServiceReferenceResolver", null);
        String serviceName = ServiceReferenceResolver.registerService(this);
        reference.add(new StringRefAddr("ServiceName", serviceName));
        return reference;
    }

    protected static class HandlerRegistryImpl
    implements HandlerRegistry {
        Map handlerChainsForPorts;

        public HandlerRegistryImpl() {
            this.init();
        }

        protected void init() {
            this.handlerChainsForPorts = new HashMap();
        }

        public List getHandlerChain(QName portName) {
            if (this.handlerChainsForPorts.get(portName) == null) {
                this.setHandlerChain(portName, new HandlerChainInfoImpl());
            }
            return (List)this.handlerChainsForPorts.get(portName);
        }

        public void setHandlerChain(QName portName, List chainInfo) {
            this.handlerChainsForPorts.put(portName, chainInfo);
        }
    }
}

