/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client;

import com.sun.xml.rpc.client.BasicService;
import com.sun.xml.rpc.client.ServiceExceptionImpl;
import com.sun.xml.rpc.client.dii.ConfiguredService;
import com.sun.xml.rpc.processor.modeler.ModelerException;
import java.net.URL;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.ServiceFactory;

public class ServiceFactoryImpl
extends ServiceFactory {
    static /* synthetic */ Class class$javax$xml$rpc$Service;
    static /* synthetic */ Class class$com$sun$xml$rpc$client$BasicService;

    public Service createService(URL wsdlDocumentLocation, QName name) throws ServiceException {
        if (wsdlDocumentLocation == null) {
            throw new IllegalArgumentException("wsdlDocumentLocation must not be null");
        }
        try {
            ConfiguredService service = new ConfiguredService(name, wsdlDocumentLocation);
            if (service.getServiceException() != null) {
                throw service.getServiceException();
            }
            return service;
        }
        catch (ModelerException ex) {
            throw new ServiceException((Throwable)((Object)ex));
        }
    }

    public Service createService(QName name) throws ServiceException {
        return new BasicService(name);
    }

    public Service createService(Class serviceInterface, QName name) throws ServiceException {
        if (!(class$javax$xml$rpc$Service == null ? (class$javax$xml$rpc$Service = ServiceFactoryImpl.class$("javax.xml.rpc.Service")) : class$javax$xml$rpc$Service).isAssignableFrom(serviceInterface)) {
            throw new ServiceExceptionImpl("service.interface.required", serviceInterface.getName());
        }
        String serviceImplementationName = serviceInterface.getName() + "_Impl";
        Service service = this.createService(serviceImplementationName);
        if (service.getServiceName().equals(name)) {
            return service;
        }
        throw new ServiceExceptionImpl("service.implementation.not.found", serviceInterface.getName());
    }

    private Service createService(String serviceImplementationName) throws ServiceException {
        if (serviceImplementationName == null) {
            throw new IllegalArgumentException();
        }
        try {
            Class<?> serviceImplementationClass = Thread.currentThread().getContextClassLoader().loadClass(serviceImplementationName);
            if (!(class$com$sun$xml$rpc$client$BasicService == null ? (class$com$sun$xml$rpc$client$BasicService = ServiceFactoryImpl.class$("com.sun.xml.rpc.client.BasicService")) : class$com$sun$xml$rpc$client$BasicService).isAssignableFrom(serviceImplementationClass)) {
                throw new ServiceExceptionImpl("service.implementation.not.found", serviceImplementationName);
            }
            try {
                Service service = (Service)serviceImplementationClass.newInstance();
                if (service.getServiceName() != null) {
                    return service;
                }
                throw new ServiceExceptionImpl("service.implementation.not.found", serviceImplementationName);
            }
            catch (InstantiationException e) {
                throw new ServiceExceptionImpl("service.implementation.cannot.create", serviceImplementationClass.getName());
            }
            catch (IllegalAccessException e) {
                throw new ServiceExceptionImpl("service.implementation.cannot.create", serviceImplementationClass.getName());
            }
        }
        catch (ClassNotFoundException e) {
            throw new ServiceExceptionImpl("service.implementation.not.found", serviceImplementationName);
        }
    }

    public Service loadService(Class serviceInterface) throws ServiceException {
        if (serviceInterface == null) {
            throw new IllegalArgumentException();
        }
        if (!(class$javax$xml$rpc$Service == null ? (class$javax$xml$rpc$Service = ServiceFactoryImpl.class$("javax.xml.rpc.Service")) : class$javax$xml$rpc$Service).isAssignableFrom(serviceInterface)) {
            throw new ServiceExceptionImpl("service.interface.required", serviceInterface.getName());
        }
        String serviceImplementationName = serviceInterface.getName() + "_Impl";
        Service service = this.createService(serviceImplementationName);
        return service;
    }

    public Service loadService(URL wsdlDocumentLocation, Class serviceInterface, Properties properties) throws ServiceException {
        if (wsdlDocumentLocation == null) {
            throw new IllegalArgumentException("wsdlDocumentLocation must not be null");
        }
        if (serviceInterface == null) {
            throw new IllegalArgumentException();
        }
        if (!(class$javax$xml$rpc$Service == null ? (class$javax$xml$rpc$Service = ServiceFactoryImpl.class$("javax.xml.rpc.Service")) : class$javax$xml$rpc$Service).isAssignableFrom(serviceInterface)) {
            throw new ServiceExceptionImpl("service.interface.required", serviceInterface.getName());
        }
        String serviceImplementationName = serviceInterface.getName() + "_Impl";
        Service service = this.createService(serviceImplementationName);
        return service;
    }

    public Service loadService(URL wsdlDocumentLocation, QName ServiceName, Properties properties) throws ServiceException {
        if (wsdlDocumentLocation == null) {
            throw new IllegalArgumentException("wsdlDocumentLocation must not be null");
        }
        String serviceImplementationName = properties.getProperty("serviceImplementationName");
        Service service = this.createService(serviceImplementationName);
        if (service.getServiceName().equals(ServiceName)) {
            return service;
        }
        throw new ServiceExceptionImpl("service.implementation.not.found", serviceImplementationName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

