/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client;

import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.rpc.client.ClientTransport;
import com.sun.xml.rpc.client.HandlerChainImpl;
import com.sun.xml.rpc.client.SenderException;
import com.sun.xml.rpc.client.StreamingSenderState;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.ReferenceableSerializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPFaultInfoSerializer;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.soap.message.SOAPBlockInfo;
import com.sun.xml.rpc.soap.message.SOAPFaultInfo;
import com.sun.xml.rpc.soap.message.SOAPHeaderBlockInfo;
import com.sun.xml.rpc.soap.message.SOAPMessageContext;
import com.sun.xml.rpc.soap.streaming.SOAPProtocolViolationException;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.PrefixFactoryImpl;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderFactory;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterFactory;
import com.sun.xml.rpc.util.HeaderFaultException;
import com.sun.xml.rpc.util.xml.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public abstract class StreamingSender {
    private static final SOAPFaultInfoSerializer faultInfoSerializer = new SOAPFaultInfoSerializer(true, false);
    private static final QName QNAME_SOAP_FAULT = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
    private static final String MUST_UNDERSTAND_FAULT_MESSAGE_STRING = "SOAP must understand error";

    protected StreamingSender() {
    }

    protected StreamingSenderState _start(HandlerChain handlerChain) {
        SOAPMessageContext messageContext = new SOAPMessageContext();
        ((HandlerChainImpl)handlerChain).addUnderstoodHeaders(this._getUnderstoodHeaders());
        return new StreamingSenderState(messageContext, handlerChain);
    }

    protected String _getActor() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _send(String endpoint, StreamingSenderState state) throws Exception {
        this._preSendingHook(state);
        this._preRequestWritingHook(state);
        this._writeRequest(state);
        this._postRequestWritingHook(state);
        boolean invoke = this._preRequestSendingHook(state);
        if (invoke) {
            this._getTransport().invoke(endpoint, state.getMessageContext());
        }
        this._postRequestSendingHook(state);
        XMLReader reader = null;
        try {
            SOAPFaultInfo fault = null;
            this._preHandlingHook(state);
            InputStream istream = null;
            Source source = state.getResponse().getMessage().getSOAPPart().getContent();
            if (source instanceof StreamSource && ((StreamSource)source).getInputStream() != null) {
                istream = ((StreamSource)source).getInputStream();
            } else {
                Transformer transformer = XmlUtil.newTransformer();
                ByteOutputStream bos = new ByteOutputStream();
                transformer.transform(source, new StreamResult((OutputStream)bos));
                istream = new ByteInputStream(bos.getBytes(), bos.getCount());
            }
            reader = this._getXMLReaderFactory().createXMLReader(istream, true);
            this._preEnvelopeReadingHook(state);
            reader.nextElementContent();
            SOAPDeserializationContext deserializationContext = new SOAPDeserializationContext();
            deserializationContext.setMessage(state.getResponse().getMessage());
            if (reader.getState() == 1 && "http://schemas.xmlsoap.org/soap/envelope/".equals(reader.getURI()) && "Envelope".equals(reader.getLocalName())) {
                boolean envelopePushedEncodingStyle = deserializationContext.processEncodingStyle(reader);
                this._preHeaderReadingHook(state);
                if (state.isFailure()) {
                    return;
                }
                reader.nextElementContent();
                if (reader.getState() != 1 || !"http://schemas.xmlsoap.org/soap/envelope/".equals(reader.getURI())) throw new SOAPProtocolViolationException("soap.protocol.invalidEnvelopeContent");
                if ("Header".equals(reader.getLocalName())) {
                    boolean headerPushedEncodingStyle = deserializationContext.processEncodingStyle(reader);
                    this._processHeaders(reader, deserializationContext, state);
                    this._postHeaderReadingHook(state);
                    if (headerPushedEncodingStyle) {
                        deserializationContext.popEncodingStyle();
                    }
                    reader.nextElementContent();
                }
                if (reader.getState() != 1 || !"http://schemas.xmlsoap.org/soap/envelope/".equals(reader.getURI()) || !"Body".equals(reader.getLocalName())) throw new SOAPProtocolViolationException("soap.protocol.missingBody");
                boolean bodyPushedEncodingStyle = deserializationContext.processEncodingStyle(reader);
                Object faultOrFaultState = null;
                if (reader.nextElementContent() == 2) {
                    this._handleEmptyBody(reader, deserializationContext, state);
                    if (state.isFailure()) {
                        return;
                    }
                    this._preBodyReadingHook(state);
                    if (state.isFailure()) {
                        return;
                    }
                } else {
                    this._preBodyReadingHook(state);
                    if (state.isFailure()) {
                        return;
                    }
                    if (reader.getName().equals(QNAME_SOAP_FAULT)) {
                        faultOrFaultState = this._readBodyFaultElement(reader, deserializationContext, state);
                    } else {
                        this._readFirstBodyElement(reader, deserializationContext, state);
                    }
                    if (state.isFailure()) {
                        return;
                    }
                    deserializationContext.deserializeMultiRefObjects(reader);
                    deserializationContext.runPostDeserializationAction();
                }
                this._postBodyReadingHook(state);
                while (reader.nextElementContent() == 1) {
                    reader.skipElement();
                }
                deserializationContext.doneDeserializing();
                if (bodyPushedEncodingStyle) {
                    deserializationContext.popEncodingStyle();
                }
                if (faultOrFaultState != null) {
                    if (faultOrFaultState instanceof SOAPFaultInfo) {
                        fault = (SOAPFaultInfo)faultOrFaultState;
                    } else {
                        if (!(faultOrFaultState instanceof SOAPDeserializationState)) throw new SenderException("sender.response.unrecognizedFault");
                        fault = (SOAPFaultInfo)((SOAPDeserializationState)faultOrFaultState).getInstance();
                    }
                }
                if (envelopePushedEncodingStyle) {
                    deserializationContext.popEncodingStyle();
                }
            } else {
                if (reader.getState() != 1 || !"Envelope".equals(reader.getLocalName())) throw new SOAPProtocolViolationException("soap.protocol.notAnEnvelope");
                throw new SOAPProtocolViolationException("soap.protocol.envelopeVersionMismatch");
            }
            if (state.isFailure()) {
                return;
            }
            this._postEnvelopeReadingHook(state);
            if (fault == null) return;
            this._raiseFault(fault, state);
            return;
        }
        catch (SOAPFaultException e) {
            throw e;
        }
        catch (RuntimeException rex) {
            this._handleRuntimeExceptionInSend(rex);
            return;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            try {
                this._postHandlingHook(state);
                Object var25_36 = null;
            }
            catch (Throwable throwable) {
                Object var25_37 = null;
                this._postSendingHook(state);
                throw throwable;
            }
            this._postSendingHook(state);
        }
    }

    protected void _handleRuntimeExceptionInSend(RuntimeException rex) throws Exception {
        throw new RemoteException("Runtime exception", rex);
    }

    protected void _sendOneWay(String endpoint, StreamingSenderState state) throws Exception {
        this._preSendingHook(state);
        this._preRequestWritingHook(state);
        this._writeRequest(state);
        this._postRequestWritingHook(state);
        boolean invoke = this._preRequestSendingHook(state);
        if (invoke) {
            this._getTransport().invokeOneWay(endpoint, state.getMessageContext());
        }
        this._postRequestSendingHook(state);
        this._postSendingHook(state);
    }

    protected void _processHeaders(XMLReader reader, SOAPDeserializationContext deserializationContext, StreamingSenderState state) throws Exception {
        while (reader.nextElementContent() != 2) {
            this._processHeaderElement(reader, deserializationContext, state);
        }
    }

    protected void _processHeaderElement(XMLReader reader, SOAPDeserializationContext deserializationContext, StreamingSenderState state) throws Exception {
        Attributes attributes = reader.getAttributes();
        String actorAttr = attributes.getValue("http://schemas.xmlsoap.org/soap/envelope/", "actor");
        String mustUnderstandAttr = attributes.getValue("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
        boolean mustUnderstand = false;
        if (mustUnderstandAttr != null) {
            if (mustUnderstandAttr.equals("1") || mustUnderstandAttr.equals("true")) {
                mustUnderstand = true;
            } else if (!mustUnderstandAttr.equals("0") && !mustUnderstandAttr.equals("false")) {
                throw new SenderException("sender.response.illegalValueOfMustUnderstandAttribute", mustUnderstandAttr);
            }
        }
        if (this._getActor() == null && (actorAttr == null || actorAttr.equals("http://schemas.xmlsoap.org/soap/actor/next")) || this._getActor() != null && this._getActor().equals(actorAttr)) {
            SOAPHeaderBlockInfo headerInfo = new SOAPHeaderBlockInfo(reader.getName(), actorAttr, mustUnderstand);
            boolean succeeded = this._readHeaderElement(headerInfo, reader, deserializationContext, state);
            if (!succeeded && mustUnderstand) {
                throw new SOAPFaultException(SOAPConstants.FAULT_CODE_MUST_UNDERSTAND, MUST_UNDERSTAND_FAULT_MESSAGE_STRING, this._getActor(), null);
            }
        } else {
            reader.skipElement();
            return;
        }
    }

    protected boolean _readHeaderElement(SOAPHeaderBlockInfo headerInfo, XMLReader reader, SOAPDeserializationContext deserializationContext, StreamingSenderState state) throws Exception {
        reader.skipElement();
        return false;
    }

    protected Object _readBodyFaultElement(XMLReader reader, SOAPDeserializationContext deserializationContext, StreamingSenderState state) throws Exception {
        return faultInfoSerializer.deserialize(null, reader, deserializationContext);
    }

    protected void _readFirstBodyElement(XMLReader reader, SOAPDeserializationContext deserializationContext, StreamingSenderState state) throws Exception {
        reader.skipElement();
    }

    protected void _handleEmptyBody(XMLReader reader, SOAPDeserializationContext deserializationContext, StreamingSenderState state) throws Exception {
        throw new SOAPProtocolViolationException("soap.protocol.emptyBody");
    }

    protected void _raiseFault(SOAPFaultInfo fault, StreamingSenderState state) throws Exception {
        Object obj;
        if (fault.getDetail() != null && fault.getDetail() instanceof Exception) {
            throw (Exception)fault.getDetail();
        }
        Object detail = fault.getDetail();
        if (detail != null && detail instanceof Detail) {
            throw new SOAPFaultException(fault.getCode(), fault.getString(), fault.getActor(), (Detail)detail);
        }
        if (detail == null) {
            obj = null;
            if (state.getResponse().headers().hasNext()) {
                obj = state.getResponse().headers().next();
                throw new RemoteException(fault.getString(), new HeaderFaultException(fault.getString(), (Object)obj));
            }
        }
        if (fault.getCode().equals(SOAPConstants.FAULT_CODE_SERVER)) {
            throw new ServerException(fault.getString());
        }
        if (fault.getCode().equals(SOAPConstants.FAULT_CODE_DATA_ENCODING_UNKNOWN)) {
            throw new MarshalException(fault.getString());
        }
        if (fault.getCode().equals(SOAPConstants.FAULT_CODE_PROCEDURE_NOT_PRESENT) || fault.getCode().equals(SOAPConstants.FAULT_CODE_BAD_ARGUMENTS)) {
            throw new RemoteException(fault.getString());
        }
        obj = null;
        if (state.getResponse().headers().hasNext()) {
            obj = state.getResponse().headers().next();
        }
        throw new SOAPFaultException(fault.getCode(), fault.getString(), fault.getActor(), (Detail)detail);
    }

    protected void _writeRequest(StreamingSenderState state) throws Exception {
        SOAPBlockInfo bodyInfo = state.getRequest().getBody();
        boolean pushedEncodingStyle = false;
        if (bodyInfo == null || bodyInfo.getSerializer() == null) {
            throw new SenderException("sender.request.missingBodyInfo");
        }
        ByteArrayOutputStream bufferedStream = new ByteArrayOutputStream();
        XMLWriter writer = this._getXMLWriterFactory().createXMLWriter(bufferedStream, this._getPreferredCharacterEncoding());
        writer.setPrefixFactory(new PrefixFactoryImpl("ans"));
        SOAPSerializationContext serializationContext = new SOAPSerializationContext("ID");
        serializationContext.setMessage(state.getRequest().getMessage());
        writer.startElement("Envelope", "http://schemas.xmlsoap.org/soap/envelope/", "env");
        writer.writeNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        writer.writeNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.writeNamespaceDeclaration("enc", "http://schemas.xmlsoap.org/soap/encoding/");
        String[] namespaceDeclarations = this._getNamespaceDeclarations();
        if (namespaceDeclarations != null) {
            int i = 0;
            while (i < namespaceDeclarations.length) {
                writer.writeNamespaceDeclaration(namespaceDeclarations[i], namespaceDeclarations[i + 1]);
                i += 2;
            }
        }
        if (this._getDefaultEnvelopeEncodingStyle() != null) {
            pushedEncodingStyle = serializationContext.pushEncodingStyle(this._getDefaultEnvelopeEncodingStyle(), writer);
        } else if (this._getImplicitEnvelopeEncodingStyle() != null) {
            pushedEncodingStyle = serializationContext.setImplicitEncodingStyle(this._getImplicitEnvelopeEncodingStyle());
        }
        boolean wroteHeader = false;
        Iterator iter = state.getRequest().headers();
        while (iter.hasNext()) {
            SOAPHeaderBlockInfo headerInfo = (SOAPHeaderBlockInfo)iter.next();
            if (headerInfo.getValue() == null || headerInfo.getSerializer() == null) continue;
            if (!wroteHeader) {
                writer.startElement("Header", "http://schemas.xmlsoap.org/soap/envelope/");
                wroteHeader = true;
            }
            serializationContext.beginFragment();
            JAXRPCSerializer serializer = headerInfo.getSerializer();
            if (serializer instanceof ReferenceableSerializer) {
                ((ReferenceableSerializer)serializer).serializeInstance(headerInfo.getValue(), headerInfo.getName(), false, writer, serializationContext);
            } else {
                serializer.serialize(headerInfo.getValue(), headerInfo.getName(), null, writer, serializationContext);
            }
            serializationContext.endFragment();
        }
        if (wroteHeader) {
            writer.endElement();
        }
        writer.startElement("Body", "http://schemas.xmlsoap.org/soap/envelope/", "env");
        serializationContext.beginFragment();
        bodyInfo.getSerializer().serialize(bodyInfo.getValue(), bodyInfo.getName(), null, writer, serializationContext);
        serializationContext.serializeMultiRefObjects(writer);
        serializationContext.endFragment();
        writer.endElement();
        writer.endElement();
        if (pushedEncodingStyle) {
            serializationContext.popEncodingStyle();
        }
        writer.close();
        byte[] data = bufferedStream.toByteArray();
        state.getRequest().getMessage().getSOAPPart().setContent((Source)new StreamSource((InputStream)new ByteInputStream(data, data.length)));
    }

    protected String[] _getNamespaceDeclarations() {
        return null;
    }

    public QName[] _getUnderstoodHeaders() {
        return new QName[0];
    }

    protected String _getDefaultEnvelopeEncodingStyle() {
        return "http://schemas.xmlsoap.org/soap/encoding/";
    }

    protected String _getImplicitEnvelopeEncodingStyle() {
        return null;
    }

    protected String _getPreferredCharacterEncoding() {
        return "UTF-8";
    }

    protected void _preSendingHook(StreamingSenderState state) throws Exception {
    }

    protected void _postSendingHook(StreamingSenderState state) throws Exception {
    }

    protected void _preHandlingHook(StreamingSenderState state) throws Exception {
        this._callResponseHandlers(state);
    }

    protected void _postHandlingHook(StreamingSenderState state) throws Exception {
    }

    protected void _preRequestWritingHook(StreamingSenderState state) throws Exception {
    }

    protected void _postRequestWritingHook(StreamingSenderState state) throws Exception {
    }

    protected boolean _preRequestSendingHook(StreamingSenderState state) throws Exception {
        return this._callRequestHandlers(state);
    }

    protected void _postRequestSendingHook(StreamingSenderState state) throws Exception {
    }

    protected void _preEnvelopeReadingHook(StreamingSenderState state) throws Exception {
    }

    protected void _preHeaderReadingHook(StreamingSenderState state) throws Exception {
    }

    protected void _postHeaderReadingHook(StreamingSenderState state) throws Exception {
    }

    protected void _preBodyReadingHook(StreamingSenderState state) throws Exception {
    }

    protected void _postBodyReadingHook(StreamingSenderState state) throws Exception {
    }

    protected void _postEnvelopeReadingHook(StreamingSenderState state) throws Exception {
    }

    protected boolean _callRequestHandlers(StreamingSenderState state) throws Exception {
        HandlerChain handlerChain = state.getHandlerChain();
        if (handlerChain != null) {
            try {
                return handlerChain.handleRequest((MessageContext)state.getMessageContext());
            }
            catch (RuntimeException e) {
                throw new RemoteException("request handler error: ", e);
            }
        }
        return true;
    }

    protected void _callResponseHandlers(StreamingSenderState state) throws Exception {
        HandlerChainImpl handlerChain = (HandlerChainImpl)state.getHandlerChain();
        if (this.hasNonEmptyHandlerChain(handlerChain)) {
            boolean allUnderstood = handlerChain.checkMustUnderstand((MessageContext)state.getMessageContext());
            if (!allUnderstood) {
                throw new SOAPFaultException(SOAPConstants.FAULT_CODE_MUST_UNDERSTAND, MUST_UNDERSTAND_FAULT_MESSAGE_STRING, this._getActor(), null);
            }
            try {
                handlerChain.handleResponse((MessageContext)state.getMessageContext());
            }
            catch (RuntimeException e) {
                throw new RemoteException("response handler error: ", e);
            }
        }
    }

    private boolean hasNonEmptyHandlerChain(HandlerChain chain) {
        return chain != null && !chain.isEmpty();
    }

    protected abstract ClientTransport _getTransport();

    protected XMLReaderFactory _getXMLReaderFactory() {
        return XMLReaderFactory.newInstance();
    }

    protected XMLWriterFactory _getXMLWriterFactory() {
        return XMLWriterFactory.newInstance();
    }
}

