/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.util.IntegerArrayList;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;

public class SOAPDeserializationState {
    private static final boolean writeDebug = false;
    private static final int CREATION_GATES_CONSTRUCTION = 5;
    private static final int INITIALIZATION_GATES_CONSTRUCTION = 17;
    private static final int COMPLETION_GATES_CONSTRUCTION = 9;
    private static final int CREATION_GATES_INITIALIZATION = 6;
    private static final int INITIALIZATION_GATES_INITIALIZATION = 10;
    private static final int COMPLETION_GATES_INITIALIZATION = 18;
    private static final int NO_STATE = 0;
    private static final int CREATED_STATE = 4;
    private static final int INITIALIZED_STATE = 8;
    private static final int COMPLETE_STATE = 16;
    private static final int CREATION_EVENT = 4;
    private static final int INITIALIZATION_EVENT = 8;
    private static final int COMPLETION_EVENT = 16;
    private static final int EVENT_BIT_MASK = 28;
    private static final int CREATION_GATE = 1;
    private static final int INITIALIZATION_GATE = 2;
    private static final int GATE_BIT_MASK = 3;
    private JAXRPCDeserializer deserializer = null;
    private SOAPInstanceBuilder builder = null;
    private List listeners = new ArrayList();
    private IntegerArrayList listenerMembers = new IntegerArrayList();
    private int constructionGates = 0;
    private int initializationGates = 0;
    private int completionGates = 0;
    private boolean hasBeenRead = false;
    private int state = 0;
    private Object instance = null;
    private XMLReader recordedElement = null;
    private QName recordedElementExpectedName = null;
    private SOAPDeserializationContext recordedElementDeserialzationContext;

    public boolean isCompleteForKnownMembers() {
        return this.completionGates == 0;
    }

    public boolean isComplete() {
        return this.state == 16;
    }

    public void promoteToCompleteOrFail() {
        switch (this.state) {
            case 0: {
                return;
            }
            case 16: {
                return;
            }
            case 8: {
                this.state = 16;
                return;
            }
        }
        throw new DeserializationException("soap.incompleteObject");
    }

    public void registerListener(SOAPDeserializationState parentState, int memberIndex) {
        if (this.deserializer == null) {
            throw new DeserializationException("soap.state.wont.notify.without.deserializer");
        }
        this.listeners.add(parentState);
        this.listenerMembers.add(memberIndex);
        parentState.waitFor(memberIndex);
        this.sendPastEventsTo(parentState, memberIndex);
    }

    public void sendPastEventsTo(SOAPDeserializationState listener, int memberIndex) {
        int pastState = 0;
        while (pastState != this.state) {
            switch (pastState) {
                case 0: {
                    listener.setMember(memberIndex, this.getInstance());
                    pastState = 4;
                    break;
                }
                case 4: {
                    pastState = 8;
                    break;
                }
                case 8: {
                    pastState = 16;
                }
            }
            listener.beNotified(memberIndex, pastState);
        }
    }

    private void waitFor(int memberIndex) {
        switch (this.memberGateType(memberIndex)) {
            case 5: 
            case 9: 
            case 17: {
                ++this.constructionGates;
                break;
            }
            case 6: 
            case 10: 
            case 18: {
                ++this.initializationGates;
            }
        }
        ++this.completionGates;
    }

    public void beNotified(int memberIndex, int event) {
        int gateType = this.memberGateType(memberIndex);
        int watchedEvent = gateType & 0x1C;
        if (event == watchedEvent) {
            int gatedState = gateType & 3;
            switch (gatedState) {
                case 1: {
                    --this.constructionGates;
                    break;
                }
                case 2: {
                    --this.initializationGates;
                }
            }
        }
        if (event == 16) {
            --this.completionGates;
        }
        this.updateState();
    }

    private void updateState() {
        switch (this.state) {
            case 0: {
                if (this.constructionGates > 0) {
                    return;
                }
                if (this.instance == null && this.builder != null) {
                    this.builder.construct();
                }
                this.changeStateTo(4);
            }
            case 4: {
                if (this.initializationGates > 0 || !this.hasBeenRead) {
                    return;
                }
                if (this.builder != null) {
                    this.builder.initialize();
                }
                this.changeStateTo(8);
            }
            case 8: {
                if (this.completionGates > 0) {
                    return;
                }
                this.changeStateTo(16);
            }
        }
    }

    private void changeStateTo(int newState) {
        this.state = newState;
        this.notifyListeners();
    }

    private void notifyListeners() {
        int i = 0;
        while (i < this.listeners.size()) {
            SOAPDeserializationState eachListener = (SOAPDeserializationState)this.listeners.get(i);
            int listenerMember = this.listenerMembers.get(i);
            if (this.state == 4) {
                eachListener.setMember(listenerMember, this.getInstance());
            }
            eachListener.beNotified(listenerMember, this.state);
            ++i;
        }
    }

    public int memberGateType(int memberIndex) {
        if (this.builder == null) {
            throw new IllegalStateException();
        }
        return this.builder.memberGateType(memberIndex);
    }

    public void setInstance(Object instance) {
        this.instance = instance;
        if (this.builder != null) {
            this.builder.setInstance(instance);
        }
    }

    protected void setMember(int memberIndex, Object value) {
        if (this.builder == null) {
            throw new IllegalStateException();
        }
        this.builder.setMember(memberIndex, value);
    }

    public void setBuilder(SOAPInstanceBuilder newBuilder) {
        if (newBuilder == null) {
            throw new IllegalArgumentException();
        }
        if (this.builder != null && this.builder != newBuilder) {
            throw new IllegalStateException();
        }
        this.builder = newBuilder;
        this.builder.setInstance(this.instance);
    }

    public SOAPInstanceBuilder getBuilder() {
        return this.builder;
    }

    public void setDeserializer(JAXRPCDeserializer deserializer) {
        try {
            if (deserializer == null) {
                return;
            }
            if (this.deserializer != null) {
                return;
            }
            this.deserializer = deserializer;
            if (this.recordedElement != null) {
                this.deserialize(this.recordedElementExpectedName, this.recordedElement, this.recordedElementDeserialzationContext);
            }
        }
        catch (JAXRPCExceptionBase e) {
            throw new DeserializationException(e);
        }
        catch (Exception e) {
            throw new DeserializationException(new LocalizableExceptionAdapter(e));
        }
    }

    public void doneReading() {
        this.hasBeenRead = true;
        this.updateState();
    }

    public Object getInstance() {
        if (this.builder == null) {
            return this.instance;
        }
        return this.builder.getInstance();
    }

    public void deserialize(QName name, XMLReader reader, SOAPDeserializationContext context) {
        try {
            if (this.deserializer == null) {
                this.recordedElementExpectedName = name;
                this.recordedElement = reader.recordElement();
                this.recordedElementDeserialzationContext = context;
                return;
            }
            this.deserializer.deserialize(name, reader, context);
        }
        catch (DeserializationException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new DeserializationException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeserializationException(new LocalizableExceptionAdapter(e));
        }
    }

    public void deserialize(DataHandler dataHandler, SOAPDeserializationContext context) throws DeserializationException {
        try {
            if (this.deserializer == null) {
                throw new DeserializationException("deserializationstate.deserialize.no.deserializer");
            }
            this.deserializer.deserialize(dataHandler, context);
        }
        catch (JAXRPCExceptionBase e) {
            throw new DeserializationException(e);
        }
        catch (Exception e) {
            throw new DeserializationException(new LocalizableExceptionAdapter(e));
        }
    }

    private String stringRep() {
        int lastDotLoc;
        StringBuffer rep = new StringBuffer("" + this.hashCode() + ":");
        if (this.getInstance() != null) {
            String instanceClassName = this.getInstance().getClass().getName();
            lastDotLoc = instanceClassName.lastIndexOf(46);
            rep.append(instanceClassName.substring(lastDotLoc));
        }
        rep.append(":");
        if (this.deserializer != null) {
            String deserializerClassName = this.deserializer.getClass().getName();
            lastDotLoc = deserializerClassName.lastIndexOf(46);
            rep.append(deserializerClassName.substring(lastDotLoc));
        }
        return rep.toString();
    }
}

