/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.ArraySerializerBase;
import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SimpleTypeSerializer;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.lang.reflect.Array;
import javax.xml.namespace.QName;

public class SimpleTypeArraySerializer
extends ArraySerializerBase {
    protected SimpleTypeSerializer elemSer;
    protected Class encoderElemClass;

    public SimpleTypeArraySerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName elemName, QName elemType, Class elemClass, int rank, int[] dims, SimpleTypeSerializer elemSer) {
        this(type, encodeType, isNullable, encodingStyle, elemName, elemType, elemClass, rank, dims, elemSer, SOAPVersion.SOAP_11);
    }

    public SimpleTypeArraySerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName elemName, QName elemType, Class elemClass, int rank, int[] dims, SimpleTypeSerializer elemSer, SOAPVersion version) {
        super(type, encodeType, isNullable, encodingStyle, elemName, elemType, elemClass, rank, dims, version);
        this.elemSer = elemSer;
    }

    protected void serializeArrayInstance(Object obj, int[] dims, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        this.serializeArrayElements(obj, 0, dims, writer, context);
    }

    protected void serializeArrayElements(Object obj, int level, int[] dims, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        if (obj == null || Array.getLength(obj) != dims[level]) {
            throw new SerializationException("soap.irregularMultiDimensionalArray");
        }
        boolean serializeLeaves = level == dims.length - 1;
        int i = 0;
        while (i < dims[level]) {
            if (serializeLeaves) {
                this.serializeElement(obj, i, writer, context);
            } else {
                this.serializeArrayElements(Array.get(obj, i), level + 1, dims, writer, context);
            }
            ++i;
        }
    }

    protected void serializeElement(Object obj, int index, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        Object elem = Array.get(obj, index);
        this.elemSer.serialize(elem, this.elemName, null, writer, context);
    }

    protected Object deserializeArrayInstance(XMLReader reader, SOAPDeserializationContext context, int[] dims) throws Exception {
        boolean emptyDims = ArraySerializerBase.isEmptyDimensions(dims);
        int[] offset = ArraySerializerBase.getArrayOffset(reader, dims);
        if (offset == null) {
            offset = new int[emptyDims ? 1 : dims.length];
        }
        Object value = null;
        int maxPosition = 0;
        int length = 0;
        if (reader.nextElementContent() != 2) {
            Object newValue;
            int newLength;
            boolean isSparseArray;
            int[] position = ArraySerializerBase.getArrayElementPosition(reader, dims);
            boolean bl = isSparseArray = position != null;
            if (!isSparseArray) {
                position = offset;
            }
            if (emptyDims) {
                maxPosition = position[0];
                length = Math.max(maxPosition * 2, 1024);
                value = Array.newInstance(this.elemClass, length);
            } else {
                value = Array.newInstance(this.elemClass, dims);
            }
            while (true) {
                if (!emptyDims && !ArraySerializerBase.isPositionWithinBounds(position, dims)) {
                    if (isSparseArray) {
                        throw new DeserializationException("soap.outOfBoundsArrayElementPosition", ArraySerializerBase.encodeArrayDimensions(position));
                    }
                    throw new DeserializationException("soap.tooManyArrayElements");
                }
                if (emptyDims && position[0] >= length) {
                    newLength = length * 2;
                    while (position[0] >= newLength) {
                        newLength *= 2;
                    }
                    newValue = Array.newInstance(this.elemClass, newLength);
                    System.arraycopy(value, 0, newValue, 0, length);
                    value = newValue;
                    length = newLength;
                }
                this.deserializeElement(value, position, reader, context);
                if (reader.nextElementContent() == 2) break;
                if (isSparseArray) {
                    position = ArraySerializerBase.getArrayElementPosition(reader, dims);
                    if (position == null) {
                        throw new DeserializationException("soap.missingArrayElementPosition");
                    }
                } else if (emptyDims) {
                    position[0] = position[0] + 1;
                } else {
                    ArraySerializerBase.incrementPosition(position, dims);
                }
                if (!emptyDims) continue;
                maxPosition = Math.max(position[0], maxPosition);
            }
            if (emptyDims && length != maxPosition + 1) {
                newLength = maxPosition + 1;
                newValue = Array.newInstance(this.elemClass, newLength);
                System.arraycopy(value, 0, newValue, 0, newLength);
                value = newValue;
                length = newLength;
            }
        } else {
            value = emptyDims ? Array.newInstance(this.elemClass, 0) : Array.newInstance(this.elemClass, dims);
        }
        return value;
    }

    protected void deserializeElement(Object value, int[] position, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        Object arr = value;
        int i = 0;
        while (i < position.length - 1) {
            arr = Array.get(arr, position[i]);
            ++i;
        }
        this.deserializeElement(arr, position[position.length - 1], reader, context);
    }

    protected void deserializeElement(Object value, int position, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        Array.set(value, position, this.elemSer.deserialize(null, reader, context));
    }
}

