/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.literal;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.EncodingException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.literal.LiteralObjectSerializerBase;
import com.sun.xml.rpc.processor.modeler.rmi.LiteralSimpleTypeCreator;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPEncodingConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class GenericLiteralObjectSerializer
extends LiteralObjectSerializerBase
implements Initializable {
    protected Class targetClass = null;
    protected List members = new ArrayList();
    protected Map xmlToJavaType = new HashMap();
    protected Map javaToXmlType = new HashMap();
    protected InternalTypeMappingRegistry registry;
    protected Collection memberOrder;
    private SOAPEncodingConstants soapEncodingConstants = null;

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    public GenericLiteralObjectSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle) {
        this(type, encodeType, isNullable, encodingStyle, SOAPVersion.SOAP_11);
    }

    public GenericLiteralObjectSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, SOAPVersion ver) {
        super(type, isNullable, encodingStyle, encodeType);
        this.init(ver);
        LiteralSimpleTypeCreator typeCreator = new LiteralSimpleTypeCreator();
        typeCreator.initializeJavaToXmlTypeMap(this.javaToXmlType);
    }

    public void addTypeRelation(Class javaType, QName xmlType) {
        if (javaType == null || xmlType == null) {
            throw new IllegalArgumentException("Neither javaType nor xmlType may be null");
        }
        this.javaToXmlType.put(javaType, xmlType);
        this.xmlToJavaType.put(xmlType, javaType);
    }

    public void setTargetClass(Class targetClass) {
        this.clearMembers();
        this.doSetTargetClass(targetClass);
        this.targetClass = targetClass;
    }

    protected void doSetTargetClass(Class targetClass) {
    }

    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        this.registry = registry;
        Iterator eachMember = this.members.iterator();
        while (eachMember.hasNext()) {
            MemberInfo currentMember = (MemberInfo)eachMember.next();
            if (currentMember.xmlType == null && currentMember.javaType.isArray()) {
                currentMember.xmlType = currentMember.name != null ? currentMember.name : currentMember.xmlType;
            }
            currentMember.serializer = (JAXRPCSerializer)registry.getSerializer(this.encodingStyle, currentMember.javaType, currentMember.xmlType);
            currentMember.deserializer = (JAXRPCDeserializer)registry.getDeserializer(this.encodingStyle, currentMember.javaType, currentMember.xmlType);
        }
    }

    public void clearMembers() {
        this.members.clear();
    }

    public void addMember(MemberInfo member) throws Exception {
        Iterator eachMember = this.members.iterator();
        while (eachMember.hasNext()) {
            MemberInfo existingMember = (MemberInfo)eachMember.next();
            if (!existingMember.name.equals(member.name)) continue;
            throw new EncodingException("soap.duplicate.data.member", new Object[]{member.name});
        }
        if (member.xmlType == null) {
            member.xmlType = (QName)this.javaToXmlType.get(member.javaType);
        }
        if (member.javaType == null) {
            member.javaType = (Class)this.xmlToJavaType.get(member.xmlType);
        }
        this.members.add(member);
    }

    protected void doSerialize(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        this.doSerializeInstance(obj, writer, context);
    }

    protected void doSerializeAttributes(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {
    }

    protected Object doDeserialize(XMLReader reader, SOAPDeserializationContext context) throws Exception {
        return this.doDeserialize(null, reader, context);
    }

    protected void doSerializeInstance(Object instance, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        this.members = this.memberOrder == null || this.memberOrder.size() == 0 ? this.getMemberOrder(instance, this.members) : this.checkFieldCase(this.members);
        int i = 0;
        while (i < this.members.size()) {
            MemberInfo currentMember = (MemberInfo)this.members.get(i);
            if (currentMember.serializer == null) {
                Class<?> javaType = instance.getClass();
                currentMember.serializer = (JAXRPCSerializer)this.registry.getSerializer(this.encodingStyle, javaType, currentMember.xmlType);
            }
            currentMember.serializer.serialize(currentMember.getter.get(instance), currentMember.name, null, writer, context);
            ++i;
        }
    }

    protected Object doDeserialize(SOAPDeserializationState state, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        Object instance = this.targetClass.newInstance();
        this.members = this.memberOrder == null || this.memberOrder.size() == 0 ? this.getMemberOrder(instance, this.members) : this.checkFieldCase(this.members);
        SOAPGenericObjectInstanceBuilder builder = null;
        boolean isComplete = true;
        int lastMemberIndex = this.members.size() - 1;
        reader.nextElementContent();
        int memberCount = 0;
        while (memberCount <= lastMemberIndex) {
            int memberIndex = memberCount;
            do {
                QName elementName = reader.getName();
                MemberInfo currentMember = (MemberInfo)this.members.get(memberIndex);
                int i = 0;
                while (reader.getState() == 2 && i < lastMemberIndex) {
                    reader.nextElementContent();
                }
                if (reader.getState() != 1) continue;
                if (currentMember.serializer != null && currentMember.javaType.isArray()) {
                    currentMember.name = ((LiteralObjectSerializerBase)currentMember.serializer).getXmlType();
                }
                if (reader.getName().equals(currentMember.name)) {
                    Object member;
                    if (currentMember.deserializer == null) {
                        QName xmlType = currentMember.xmlType != null ? currentMember.xmlType : SerializerBase.getType(reader);
                        currentMember.deserializer = (JAXRPCDeserializer)this.registry.getDeserializer(this.encodingStyle, currentMember.javaType, currentMember.name);
                    }
                    if ((member = currentMember.deserializer.deserialize(currentMember.name, reader, context)) instanceof SOAPDeserializationState) {
                        if (builder == null) {
                            builder = new SOAPGenericObjectInstanceBuilder(instance);
                        }
                        state = LiteralObjectSerializerBase.registerWithMemberState(instance, state, member, memberIndex, builder);
                        isComplete = false;
                        break;
                    }
                    currentMember.setter.set(instance, member);
                    break;
                }
                if (memberIndex == lastMemberIndex) {
                    memberIndex = 0;
                    continue;
                }
                ++memberIndex;
            } while (memberIndex != memberCount);
            ++memberCount;
        }
        XMLReaderUtil.verifyReaderState(reader, 2);
        return isComplete ? instance : state;
    }

    protected void verifyType(XMLReader reader) throws Exception {
        QName actualType = LiteralObjectSerializerBase.getType(reader);
        if (actualType != null) {
            // empty if block
        }
    }

    private List checkFieldCase(List members) {
        Iterator iter = this.memberOrder.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            int i = 0;
            while (i < members.size()) {
                MemberInfo info = (MemberInfo)members.get(i);
                if (name.equalsIgnoreCase(info.name.getLocalPart()) && !name.equals(info.name.getLocalPart())) {
                    String ns = info.name.getNamespaceURI();
                    info.name = new QName(ns, name);
                    info.xmlType = new QName(ns, name);
                }
                ++i;
            }
        }
        return members;
    }

    protected List getMemberOrder(Object instance, List membersAlphabetically) {
        if (membersAlphabetically == null) {
            return null;
        }
        ArrayList<String> members = new ArrayList<String>();
        Class<?> targetClass = instance.getClass();
        int introspectedSize = membersAlphabetically.size();
        Field[] fields = targetClass.getDeclaredFields();
        int flen = fields != null ? fields.length : 0;
        ArrayList<Field> fieldList = new ArrayList<Field>(Arrays.asList(fields));
        if (flen < introspectedSize) {
            Class<?> superClass = targetClass.getSuperclass();
            while (superClass != null) {
                ArrayList<Field> superList = null;
                Field[] superFields = superClass.getDeclaredFields();
                if (superFields != null) {
                    superList = new ArrayList<Field>(Arrays.asList(superFields));
                    int i = 0;
                    while (i < superList.size()) {
                        Field obj = superList.get(i);
                        fieldList.add(i, obj);
                        ++i;
                    }
                }
                superClass = superClass.getSuperclass();
            }
        }
        fields = null;
        fields = fieldList.toArray(new Field[fieldList.size()]);
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            int fieldModifiers = field.getModifiers();
            if (!Modifier.isTransient(fieldModifiers) && !Modifier.isFinal(fieldModifiers)) {
                String name = field.getName();
                members.add(name);
            }
            ++i;
        }
        if (members.size() == 0) {
            return membersAlphabetically;
        }
        ArrayList<MemberInfo> orderedMembers = new ArrayList<MemberInfo>();
        int i2 = 0;
        while (i2 < members.size()) {
            String name = (String)members.get(i2);
            int j = 0;
            while (j < membersAlphabetically.size()) {
                MemberInfo info = (MemberInfo)membersAlphabetically.get(j);
                if (name.equalsIgnoreCase(info.name.getLocalPart())) {
                    if (!name.equals(info.name.getLocalPart())) {
                        String ns = info.name.getNamespaceURI();
                        info.name = new QName(ns, name);
                        info.xmlType = new QName(ns, name);
                    }
                    orderedMembers.add(info);
                }
                ++j;
            }
            ++i2;
        }
        if (orderedMembers.size() == 0) {
            return membersAlphabetically;
        }
        return orderedMembers;
    }

    protected class SOAPGenericObjectInstanceBuilder
    implements SOAPInstanceBuilder {
        Object instance;

        SOAPGenericObjectInstanceBuilder(Object instance) {
            this.instance = instance;
        }

        public int memberGateType(int memberIndex) {
            return 6;
        }

        public void construct() {
        }

        public void setMember(int index, Object memberValue) {
            try {
                ((MemberInfo)GenericLiteralObjectSerializer.this.members.get((int)index)).setter.set(this.instance, memberValue);
            }
            catch (Exception e) {
                throw new DeserializationException("nestedSerializationError", new LocalizableExceptionAdapter(e));
            }
        }

        public void initialize() {
        }

        public void setInstance(Object instance) {
        }

        public Object getInstance() {
            return this.instance;
        }
    }

    public static class MemberInfo {
        QName name = null;
        QName xmlType = null;
        Class javaType = null;
        JAXRPCSerializer serializer = null;
        JAXRPCDeserializer deserializer = null;
        GetterMethod getter = null;
        SetterMethod setter = null;
    }

    public static interface SetterMethod {
        public void set(Object var1, Object var2) throws Exception;
    }

    public static interface GetterMethod {
        public Object get(Object var1) throws Exception;
    }
}

