/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.soap;

import com.sun.xml.rpc.encoding.CombinedSerializer;
import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InterfaceSerializerBase;
import com.sun.xml.rpc.encoding.InternalEncodingConstants;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPEncodingConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.xml.namespace.QName;

public class MapInterfaceSerializer
extends InterfaceSerializerBase
implements Initializable,
InternalEncodingConstants {
    private CombinedSerializer hashMapSerializer;
    private CombinedSerializer treeMapSerializer;
    private CombinedSerializer hashtableSerializer;
    private CombinedSerializer propertiesSerializer;
    private SOAPEncodingConstants soapEncodingConstants = null;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$TreeMap;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$util$Properties;

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    public MapInterfaceSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle) {
        this(type, encodeType, isNullable, encodingStyle, SOAPVersion.SOAP_11);
    }

    public MapInterfaceSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, SOAPVersion ver) {
        super(type, encodeType, isNullable, encodingStyle);
        this.init(ver);
    }

    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        this.hashMapSerializer = (CombinedSerializer)registry.getSerializer(this.encodingStyle, class$java$util$HashMap == null ? (class$java$util$HashMap = MapInterfaceSerializer.class$("java.util.HashMap")) : class$java$util$HashMap, InternalEncodingConstants.QNAME_TYPE_HASH_MAP);
        this.hashMapSerializer = this.hashMapSerializer.getInnermostSerializer();
        this.treeMapSerializer = (CombinedSerializer)registry.getSerializer(this.encodingStyle, class$java$util$TreeMap == null ? (class$java$util$TreeMap = MapInterfaceSerializer.class$("java.util.TreeMap")) : class$java$util$TreeMap, InternalEncodingConstants.QNAME_TYPE_TREE_MAP);
        this.treeMapSerializer = this.treeMapSerializer.getInnermostSerializer();
        this.hashtableSerializer = (CombinedSerializer)registry.getSerializer(this.encodingStyle, class$java$util$Hashtable == null ? (class$java$util$Hashtable = MapInterfaceSerializer.class$("java.util.Hashtable")) : class$java$util$Hashtable, InternalEncodingConstants.QNAME_TYPE_HASHTABLE);
        this.hashtableSerializer = this.hashtableSerializer.getInnermostSerializer();
        this.propertiesSerializer = (CombinedSerializer)registry.getSerializer(this.encodingStyle, class$java$util$Properties == null ? (class$java$util$Properties = MapInterfaceSerializer.class$("java.util.Properties")) : class$java$util$Properties, InternalEncodingConstants.QNAME_TYPE_PROPERTIES);
        this.propertiesSerializer = this.propertiesSerializer.getInnermostSerializer();
    }

    public Object doDeserialize(QName name, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        QName elementType = SerializerBase.getType(reader);
        if (elementType.equals(InternalEncodingConstants.QNAME_TYPE_MAP) || elementType.equals(InternalEncodingConstants.QNAME_TYPE_HASH_MAP)) {
            return this.hashMapSerializer.deserialize(name, reader, context);
        }
        if (elementType.equals(InternalEncodingConstants.QNAME_TYPE_TREE_MAP)) {
            return this.treeMapSerializer.deserialize(name, reader, context);
        }
        if (elementType.equals(InternalEncodingConstants.QNAME_TYPE_HASHTABLE)) {
            return this.hashtableSerializer.deserialize(name, reader, context);
        }
        if (elementType.equals(InternalEncodingConstants.QNAME_TYPE_PROPERTIES)) {
            return this.propertiesSerializer.deserialize(name, reader, context);
        }
        throw new DeserializationException("soap.unexpectedElementType", new Object[]{"", elementType.toString()});
    }

    public void doSerializeInstance(Object obj, QName name, SerializerCallback callback, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        if (obj instanceof HashMap) {
            this.hashMapSerializer.serialize(obj, name, callback, writer, context);
        } else if (obj instanceof Properties) {
            this.propertiesSerializer.serialize(obj, name, callback, writer, context);
        } else if (obj instanceof Hashtable) {
            this.hashtableSerializer.serialize(obj, name, callback, writer, context);
        } else if (obj instanceof TreeMap) {
            this.treeMapSerializer.serialize(obj, name, callback, writer, context);
        } else if (obj instanceof Map) {
            this.hashMapSerializer.serialize(obj, name, callback, writer, context);
        } else {
            throw new SerializationException("soap.cannot.serialize.type", obj.getClass().getName());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

