/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationEntry;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationType;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralEnumerationType;
import com.sun.xml.rpc.processor.model.literal.LiteralListType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPListType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.soap.SOAPVersion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class EnumerationGenerator
extends GeneratorBase {
    private Set types;

    public EnumerationGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new EnumerationGenerator(model, config, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        return new EnumerationGenerator(model, config, properties);
    }

    private EnumerationGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.types = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        this.types = null;
    }

    protected void visitParameter(Parameter param) throws Exception {
        AbstractType type = param.getType();
        if (type.isSOAPType()) {
            ((SOAPType)type).accept(this);
        } else {
            ((LiteralType)type).accept(this);
        }
    }

    protected void preVisitResponse(Response response) throws Exception {
        Iterator iter = response.getParameters();
        while (iter.hasNext()) {
            ((Parameter)iter.next()).accept(this);
        }
    }

    protected void preVisitRequest(Request request) throws Exception {
        Iterator iter = request.getParameters();
        while (iter.hasNext()) {
            ((Parameter)iter.next()).accept(this);
        }
    }

    protected void visitFault(Fault fault) throws Exception {
        if (fault.getBlock().getType().isSOAPType()) {
            ((SOAPType)fault.getBlock().getType()).accept(this);
        }
        JavaException exception = fault.getJavaException();
        Iterator members = exception.getMembers();
        AbstractType aType = (AbstractType)exception.getOwner();
        if (aType.isSOAPType()) {
            while (members.hasNext()) {
                SOAPType type = ((SOAPStructureMember)((JavaStructureMember)members.next()).getOwner()).getType();
                type.accept(this);
            }
        } else {
            LiteralType type = null;
            while (members.hasNext()) {
                JavaStructureMember javaMember = (JavaStructureMember)members.next();
                if (javaMember.getOwner() instanceof LiteralElementMember) {
                    type = ((LiteralElementMember)javaMember.getOwner()).getType();
                } else if (javaMember.getOwner() instanceof LiteralAttributeMember) {
                    type = ((LiteralAttributeMember)javaMember.getOwner()).getType();
                }
                type.accept(this);
            }
        }
    }

    public void visit(SOAPCustomType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    public void visit(SOAPSimpleType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    public void visit(SOAPAnyType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    public void visit(SOAPEnumerationType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        this.generateEnumeration(type);
    }

    protected void visitSOAPArrayType(SOAPArrayType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        super.visitSOAPArrayType(type);
    }

    protected void visitSOAPStructureType(SOAPStructureType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        super.visitSOAPStructureType(type);
    }

    public void visit(LiteralEnumerationType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        this.generateEnumeration(type);
    }

    public void visit(LiteralListType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        type.getItemType().accept(this);
        this.registerType(type);
    }

    public void visit(SOAPListType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        type.getItemType().accept(this);
        this.registerType(type);
    }

    private boolean isRegistered(AbstractType type) {
        return this.types.contains(type);
    }

    private void registerType(AbstractType type) {
        this.types.add(type);
    }

    private void generateEnumeration(AbstractType type) {
        this.log("generating Enumeration for: " + type.getJavaType().getRealName());
        try {
            String className = type.getJavaType().getRealName();
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            GeneratedFileInfo fi = new GeneratedFileInfo();
            fi.setFile(classFile);
            fi.setType("Enumeration");
            this.env.addGeneratedFile(fi);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            this.writePackage(out, className);
            out.pln();
            this.writeClassDecl(out, className);
            this.writeMembers(out, (JavaEnumerationType)type.getJavaType());
            out.pln();
            this.writeClassConstructor(out, className, (JavaEnumerationType)type.getJavaType());
            out.pln();
            this.writeGetValue(out, (JavaEnumerationType)type.getJavaType());
            out.pln();
            this.writeFromValue(out, (JavaEnumerationType)type.getJavaType());
            out.pln();
            this.writeFromString(out, (JavaEnumerationType)type.getJavaType());
            out.pln();
            this.writeToString(out, (JavaEnumerationType)type.getJavaType());
            out.pln();
            this.writeEquals(out, (JavaEnumerationType)type.getJavaType());
            out.pln();
            this.writeHashCode(out, (JavaEnumerationType)type.getJavaType());
            out.pOln("}");
            out.close();
        }
        catch (Exception e) {
            GeneratorBase.fail(e);
        }
    }

    private void writeClassDecl(IndentingWriter p, String className) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.stripQualifier(className)).append(" implements java.io.Serializable {").toString());
    }

    private void writeMembers(IndentingWriter p, JavaEnumerationType javaEnum) throws IOException {
        JavaEnumerationEntry entry;
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        this.env.getNames();
        String className = Names.stripQualifier(javaEnum.getRealName());
        p.pln("private " + baseTypeStr + " value;");
        Iterator enums = javaEnum.getEntries();
        if (!SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
            enums = javaEnum.getEntries();
            while (enums.hasNext()) {
                entry = (JavaEnumerationEntry)enums.next();
                p.pln("public static final String _" + entry.getName() + "String = \"" + entry.getLiteralValue() + "\";");
            }
            p.pln();
        }
        enums = javaEnum.getEntries();
        while (enums.hasNext()) {
            entry = (JavaEnumerationEntry)enums.next();
            if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
                if (baseTypeStr.equals("long")) {
                    p.pln("public static final " + baseTypeStr + " _" + entry.getName() + " = " + entry.getLiteralValue() + "L;");
                    continue;
                }
                p.pln("public static final " + baseTypeStr + " _" + entry.getName() + " = (" + baseTypeStr + ")" + entry.getLiteralValue() + ";");
                continue;
            }
            p.pln("public static final " + baseTypeStr + " _" + entry.getName() + " = new " + baseTypeStr + "(_" + entry.getName() + "String);");
        }
        p.pln();
        enums = javaEnum.getEntries();
        while (enums.hasNext()) {
            entry = (JavaEnumerationEntry)enums.next();
            p.pln("public static final " + className + " " + entry.getName() + " = new " + className + "(_" + entry.getName() + ");");
        }
    }

    private void writeClassConstructor(IndentingWriter p, String className, JavaEnumerationType javaEnum) throws IOException {
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        StringBuffer stringBuffer = new StringBuffer().append("protected ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.stripQualifier(className)).append("(").append(baseTypeStr).append(" value) {").toString());
        p.pln("this.value = value;");
        p.pOln("}");
    }

    private void writeGetValue(IndentingWriter p, JavaEnumerationType javaEnum) throws IOException {
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        p.plnI("public " + baseTypeStr + " getValue() {");
        p.pln("return value;");
        p.pOln("}");
    }

    private void writeFromValue(IndentingWriter p, JavaEnumerationType javaEnum) throws IOException {
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        this.env.getNames();
        String className = Names.stripQualifier(javaEnum.getRealName());
        p.plnI("public static " + className + " fromValue(" + baseTypeStr + " value)");
        p.pln("throws java.lang.IllegalStateException {");
        Iterator enums = javaEnum.getEntries();
        int i = 0;
        while (enums.hasNext()) {
            JavaEnumerationEntry entry = (JavaEnumerationEntry)enums.next();
            if (i > 0) {
                p.p(" else ");
            }
            if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
                p.plnI("if (" + entry.getName() + ".value == value) {");
            } else {
                p.plnI("if (" + entry.getName() + ".value.equals(value)) {");
            }
            p.pln("return " + entry.getName() + ";");
            p.pO("}");
            ++i;
        }
        p.pln();
        p.pln("throw new IllegalArgumentException();");
        p.pOln("}");
    }

    private void writeFromString(IndentingWriter p, JavaEnumerationType javaEnum) throws IOException {
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        this.env.getNames();
        String className = Names.stripQualifier(javaEnum.getRealName());
        p.plnI("public static " + className + " fromString(String value)");
        p.pln("throws java.lang.IllegalStateException {");
        Iterator enums = javaEnum.getEntries();
        int i = 0;
        while (enums.hasNext()) {
            JavaEnumerationEntry entry = (JavaEnumerationEntry)enums.next();
            if (i > 0) {
                p.p(" else ");
            }
            if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
                p.plnI("if (value.equals(\"" + entry.getLiteralValue() + "\")) {");
            } else {
                p.plnI("if (value.equals(_" + entry.getName() + "String)) {");
            }
            p.pln("return " + entry.getName() + ";");
            p.pO("}");
            ++i;
        }
        p.pln();
        p.pln("throw new IllegalArgumentException();");
        p.pOln("}");
    }

    private void writeToString(IndentingWriter p, JavaEnumerationType javaEnum) throws IOException {
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        this.env.getNames();
        String className = Names.stripQualifier(javaEnum.getRealName());
        p.plnI("public String toString() {");
        String exp = "value";
        if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
            exp = SimpleToBoxedUtil.getBoxedExpressionOfType(exp, baseTypeStr);
        }
        p.pln("return " + exp + ".toString();");
        p.pOln("}");
    }

    private void writeEquals(IndentingWriter p, JavaEnumerationType javaEnum) throws IOException {
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        this.env.getNames();
        String className = Names.stripQualifier(javaEnum.getRealName());
        p.plnI("public boolean equals(Object obj) {");
        p.plnI("if (!(obj instanceof " + className + ")) {");
        p.pln("return false;");
        p.pOln("}");
        if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
            p.pln("return ((" + className + ")obj).value == value;");
        } else {
            p.pln("return ((" + className + ")obj).value.equals(value);");
        }
        p.pOln("}");
    }

    private void writeHashCode(IndentingWriter p, JavaEnumerationType javaEnum) throws IOException {
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        p.plnI("public int hashCode() {");
        if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
            String boxedExp = SimpleToBoxedUtil.getBoxedExpressionOfType("value", baseTypeStr);
            p.pln("return " + boxedExp + ".toString().hashCode();");
        } else {
            p.pln("return value.hashCode();");
        }
        p.pOln("}");
    }
}

