/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Properties;

public class ServiceInterfaceGenerator
implements ProcessorAction {
    private File sourceDir;
    private ProcessorEnvironment env;
    private String JAXRPCVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Model model, Configuration config, Properties options) {
        try {
            this.env = config.getEnvironment();
            this.env.getNames().resetPrefixFactory();
            String key = "sourceDirectory";
            String dirPath = options.getProperty(key);
            this.sourceDir = new File(dirPath);
            this.env = config.getEnvironment();
            this.JAXRPCVersion = options.getProperty("JAXRPC Version");
            Iterator iter = model.getServices();
            while (iter.hasNext()) {
                Service service = (Service)iter.next();
                this.process(service);
            }
            Object var9_8 = null;
            this.sourceDir = null;
            this.env = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.sourceDir = null;
            this.env = null;
            throw throwable;
        }
    }

    private void process(Service service) {
        try {
            JavaInterface intf = service.getJavaInterface();
            String className = this.env.getNames().customJavaTypeClassName(intf);
            this.log("creating service interface: " + className);
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            GeneratedFileInfo fi = new GeneratedFileInfo();
            fi.setFile(classFile);
            fi.setType("Service");
            this.env.addGeneratedFile(fi);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            GeneratorBase.writePackage(out, className, this.JAXRPCVersion);
            out.pln("import javax.xml.rpc.*;");
            out.pln();
            StringBuffer stringBuffer = new StringBuffer().append("public interface ");
            this.env.getNames();
            out.plnI(stringBuffer.append(Names.stripQualifier(className)).append(" extends javax.xml.rpc.Service {").toString());
            Iterator ports = service.getPorts();
            while (ports.hasNext()) {
                Port port = (Port)ports.next();
                String portClass = port.getJavaInterface().getName();
                String portName = this.env.getNames().getPortName(port);
                portName = this.env.getNames().validJavaClassName(portName);
                out.pln("public " + portClass + " get" + portName + "();");
            }
            out.pOln("}");
            out.close();
        }
        catch (Exception e) {
            throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(e));
        }
    }

    private void log(String msg) {
        if (this.env.verbose()) {
            StringBuffer stringBuffer = new StringBuffer().append("[");
            this.env.getNames();
            System.out.println(stringBuffer.append(Names.stripQualifier(this.getClass().getName())).append(": ").append(msg).append("]").toString());
        }
    }
}

