/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.WSDLTypeGenerator;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Message;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.soap.SOAPWSDLConstants;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.wsdl.document.Binding;
import com.sun.xml.rpc.wsdl.document.BindingFault;
import com.sun.xml.rpc.wsdl.document.BindingInput;
import com.sun.xml.rpc.wsdl.document.BindingOperation;
import com.sun.xml.rpc.wsdl.document.BindingOutput;
import com.sun.xml.rpc.wsdl.document.Definitions;
import com.sun.xml.rpc.wsdl.document.Input;
import com.sun.xml.rpc.wsdl.document.MessagePart;
import com.sun.xml.rpc.wsdl.document.Operation;
import com.sun.xml.rpc.wsdl.document.OperationStyle;
import com.sun.xml.rpc.wsdl.document.Output;
import com.sun.xml.rpc.wsdl.document.PortType;
import com.sun.xml.rpc.wsdl.document.Service;
import com.sun.xml.rpc.wsdl.document.WSDLDocument;
import com.sun.xml.rpc.wsdl.document.schema.SchemaKinds;
import com.sun.xml.rpc.wsdl.document.soap.SOAPAddress;
import com.sun.xml.rpc.wsdl.document.soap.SOAPBinding;
import com.sun.xml.rpc.wsdl.document.soap.SOAPBody;
import com.sun.xml.rpc.wsdl.document.soap.SOAPFault;
import com.sun.xml.rpc.wsdl.document.soap.SOAPOperation;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import com.sun.xml.rpc.wsdl.document.soap.SOAPUse;
import com.sun.xml.rpc.wsdl.framework.DuplicateEntityException;
import com.sun.xml.rpc.wsdl.parser.Constants;
import com.sun.xml.rpc.wsdl.parser.WSDLWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class WSDLGenerator
implements Constants,
ProcessorAction {
    private SOAPWSDLConstants soapWSDLConstants = null;
    private SOAPVersion soapVer = SOAPVersion.SOAP_11;
    private File destDir;
    private ProcessorEnvironment env;
    private Model model;
    protected static final String PART_NAME_LITERAL_REQUEST_WRAPPER = "parameters";
    protected static final String PART_NAME_LITERAL_RESPONSE_WRAPPER = "result";

    public WSDLGenerator() {
        this(SOAPVersion.SOAP_11);
    }

    public WSDLGenerator(SOAPVersion ver) {
        this.init(ver);
        this.destDir = null;
        this.env = null;
        this.model = null;
    }

    private void init(SOAPVersion ver) {
        this.soapWSDLConstants = SOAPConstantsFactory.getSOAPWSDLConstants(ver);
        this.soapVer = ver;
    }

    public void perform(Model model, Configuration config, Properties properties) {
        this.perform(model, config, properties, SOAPVersion.SOAP_11);
    }

    public void perform(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        ProcessorEnvironment env = config.getEnvironment();
        String key = "nonclassDestinationDirectory";
        String dirPath = properties.getProperty(key);
        File destDir = new File(dirPath);
        WSDLGenerator generator = new WSDLGenerator(env, destDir, model, ver);
        generator.doGeneration();
    }

    private WSDLGenerator(ProcessorEnvironment env, File destDir, Model model) {
        this(env, destDir, model, SOAPVersion.SOAP_11);
    }

    private WSDLGenerator(ProcessorEnvironment env, File destDir, Model model, SOAPVersion ver) {
        this.init(ver);
        this.env = env;
        this.model = model;
        this.destDir = destDir;
    }

    private void doGeneration() {
        try {
            this.doGeneration(this.model);
        }
        catch (Exception e) {
            throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(e));
        }
    }

    private void doGeneration(Model model) throws Exception {
        String modelerName = (String)model.getProperty("com.sun.xml.rpc.processor.model.ModelerName");
        if (modelerName != null && modelerName.equals("com.sun.xml.rpc.processor.modeler.wsdl.WSDLModeler")) {
            return;
        }
        File wsdlFile = new File(this.destDir, model.getName().getLocalPart() + ".wsdl");
        WSDLDocument document = this.generateDocument(model);
        try {
            WSDLWriter writer = new WSDLWriter();
            FileOutputStream fos = new FileOutputStream(wsdlFile);
            GeneratedFileInfo fi = new GeneratedFileInfo();
            fi.setFile(wsdlFile);
            fi.setType("Wsdl");
            this.env.addGeneratedFile(fi);
            writer.write(document, fos);
            fos.close();
        }
        catch (IOException e) {
            this.fail("generator.cant.write", wsdlFile.toString());
        }
    }

    private WSDLDocument generateDocument(Model model) throws Exception {
        WSDLDocument document = new WSDLDocument();
        Definitions definitions = new Definitions(document);
        definitions.setName(model.getName().getLocalPart());
        definitions.setTargetNamespaceURI(model.getTargetNamespaceURI());
        document.setDefinitions(definitions);
        this.generateTypes(model, document);
        this.generateMessages(model, definitions);
        this.generatePortTypes(model, definitions);
        this.generateBindings(model, definitions);
        this.generateServices(model, definitions);
        return document;
    }

    private void generateTypes(Model model, WSDLDocument document) throws Exception {
        WSDLTypeGenerator typeGenerator = new WSDLTypeGenerator(model, document, this.soapVer);
        typeGenerator.run();
    }

    protected String getSOAPEncodingNamespace(Port port) {
        if (port.getSOAPVersion().equals(SOAPVersion.SOAP_12.toString())) {
            return "http://www.w3.org/2002/06/soap-encoding";
        }
        return "http://schemas.xmlsoap.org/soap/encoding/";
    }

    protected String getSOAPTransportHttpURI(Port port) {
        if (port.getSOAPVersion().equals(SOAPVersion.SOAP_12.toString())) {
            return "http://www.w3.org/2002/06/soap/bindings/HTTP/";
        }
        return "http://schemas.xmlsoap.org/soap/http";
    }

    private void generateMessages(Model model, Definitions definitions) throws Exception {
        Iterator services = model.getServices();
        while (services.hasNext()) {
            com.sun.xml.rpc.processor.model.Service service = (com.sun.xml.rpc.processor.model.Service)services.next();
            Iterator ports = service.getPorts();
            while (ports.hasNext()) {
                Port port = (Port)ports.next();
                PortType wsdlPortType = new PortType(definitions);
                wsdlPortType.setName(this.getWSDLPortTypeName(port));
                Iterator operations = port.getOperations();
                while (operations.hasNext()) {
                    com.sun.xml.rpc.processor.model.Operation operation = (com.sun.xml.rpc.processor.model.Operation)operations.next();
                    String localOperationName = operation.getName().getLocalPart();
                    Request request = operation.getRequest();
                    com.sun.xml.rpc.wsdl.document.Message wsdlRequestMessage = new com.sun.xml.rpc.wsdl.document.Message(definitions);
                    wsdlRequestMessage.setName(this.getWSDLInputMessageName(operation));
                    this.fillInMessageParts(request, wsdlRequestMessage, true, operation.getStyle());
                    definitions.add(wsdlRequestMessage);
                    Response response = operation.getResponse();
                    if (response != null) {
                        com.sun.xml.rpc.wsdl.document.Message wsdlResponseMessage = new com.sun.xml.rpc.wsdl.document.Message(definitions);
                        wsdlResponseMessage.setName(this.getWSDLOutputMessageName(operation));
                        this.fillInMessageParts(response, wsdlResponseMessage, false, operation.getStyle());
                        definitions.add(wsdlResponseMessage);
                    }
                    TreeSet faultSet = new TreeSet(new GeneratorUtil.FaultComparator());
                    faultSet.addAll(operation.getFaultsSet());
                    Iterator faults = faultSet.iterator();
                    while (faults.hasNext()) {
                        Fault fault = (Fault)faults.next();
                        com.sun.xml.rpc.wsdl.document.Message wsdlFaultMessage = new com.sun.xml.rpc.wsdl.document.Message(definitions);
                        wsdlFaultMessage.setName(this.getWSDLFaultMessageName(fault));
                        MessagePart part = new MessagePart();
                        part.setName(fault.getBlock().getName().getLocalPart());
                        JavaException javaException = fault.getJavaException();
                        AbstractType type = fault.getBlock().getType();
                        if (type.isSOAPType()) {
                            part.setDescriptorKind(SchemaKinds.XSD_TYPE);
                            if (fault.getSubfaults() != null) {
                                QName ownerName = ((AbstractType)javaException.getOwner()).getName();
                                part.setDescriptor(ownerName);
                            } else {
                                part.setDescriptor(type.getName());
                            }
                        } else if (type.isLiteralType()) {
                            part.setDescriptorKind(SchemaKinds.XSD_ELEMENT);
                            part.setDescriptor(fault.getElementName());
                        }
                        wsdlFaultMessage.add(part);
                        try {
                            definitions.add(wsdlFaultMessage);
                        }
                        catch (DuplicateEntityException e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private void fillInMessageParts(Message message, com.sun.xml.rpc.wsdl.document.Message wsdlMessage, boolean isRequest, SOAPStyle style) throws Exception {
        if (message == null) {
            return;
        }
        if (style == SOAPStyle.RPC) {
            Iterator parameters = message.getParameters();
            while (parameters.hasNext()) {
                Parameter parameter = (Parameter)parameters.next();
                MessagePart part = new MessagePart();
                part.setName(parameter.getName());
                AbstractType type = parameter.getType();
                if (type.getName() == null) continue;
                if (type.isSOAPType() || style == SOAPStyle.RPC) {
                    part.setDescriptorKind(SchemaKinds.XSD_TYPE);
                    part.setDescriptor(type.getName());
                } else if (type.isLiteralType()) {
                    part.setDescriptorKind(SchemaKinds.XSD_ELEMENT);
                    part.setDescriptor(type.getName());
                }
                wsdlMessage.add(part);
            }
        } else {
            Iterator iter = message.getBodyBlocks();
            if (iter.hasNext()) {
                Block bodyBlock = (Block)iter.next();
                MessagePart part = new MessagePart();
                part.setName(isRequest ? PART_NAME_LITERAL_REQUEST_WRAPPER : PART_NAME_LITERAL_RESPONSE_WRAPPER);
                part.setDescriptorKind(SchemaKinds.XSD_ELEMENT);
                part.setDescriptor(bodyBlock.getName());
                wsdlMessage.add(part);
            }
        }
    }

    private void generatePortTypes(Model model, Definitions definitions) throws Exception {
        Iterator services = model.getServices();
        while (services.hasNext()) {
            com.sun.xml.rpc.processor.model.Service service = (com.sun.xml.rpc.processor.model.Service)services.next();
            Iterator ports = service.getPorts();
            while (ports.hasNext()) {
                Port port = (Port)ports.next();
                PortType wsdlPortType = new PortType(definitions);
                wsdlPortType.setName(this.getWSDLPortTypeName(port));
                Iterator operations = port.getOperations();
                while (operations.hasNext()) {
                    com.sun.xml.rpc.processor.model.Operation operation = (com.sun.xml.rpc.processor.model.Operation)operations.next();
                    String localOperationName = operation.getName().getLocalPart();
                    Operation wsdlOperation = new Operation();
                    wsdlOperation.setName(localOperationName);
                    wsdlOperation.setStyle(OperationStyle.REQUEST_RESPONSE);
                    if (operation.getStyle().equals(SOAPStyle.RPC) && operation.getResponse() != null) {
                        String paramOrder = "";
                        Iterator parameters = operation.getRequest().getParameters();
                        int i = 0;
                        while (parameters.hasNext()) {
                            if (i > 0) {
                                paramOrder = paramOrder + " ";
                            }
                            Parameter parameter = (Parameter)parameters.next();
                            paramOrder = paramOrder + parameter.getName();
                            ++i;
                        }
                        wsdlOperation.setParameterOrder(paramOrder);
                    }
                    Input input = new Input();
                    input.setMessage(new QName(model.getTargetNamespaceURI(), this.getWSDLInputMessageName(operation)));
                    wsdlOperation.setInput(input);
                    if (this.getWSDLOutputMessageName(operation) != null) {
                        Output output = new Output();
                        output.setMessage(new QName(model.getTargetNamespaceURI(), this.getWSDLOutputMessageName(operation)));
                        wsdlOperation.setOutput(output);
                    }
                    TreeSet faultSet = new TreeSet(new GeneratorUtil.FaultComparator());
                    faultSet.addAll(operation.getFaultsSet());
                    Iterator faults = faultSet.iterator();
                    while (faults.hasNext()) {
                        Fault fault = (Fault)faults.next();
                        com.sun.xml.rpc.wsdl.document.Fault wsdlFault = new com.sun.xml.rpc.wsdl.document.Fault();
                        wsdlFault.setName(fault.getName());
                        wsdlFault.setMessage(new QName(model.getTargetNamespaceURI(), this.getWSDLFaultMessageName(fault)));
                        wsdlOperation.addFault(wsdlFault);
                    }
                    wsdlPortType.add(wsdlOperation);
                }
                definitions.add(wsdlPortType);
            }
        }
    }

    private void generateBindings(Model model, Definitions definitions) throws Exception {
        Iterator services = model.getServices();
        while (services.hasNext()) {
            com.sun.xml.rpc.processor.model.Service service = (com.sun.xml.rpc.processor.model.Service)services.next();
            Iterator ports = service.getPorts();
            while (ports.hasNext()) {
                Port port = (Port)ports.next();
                boolean isMixed = false;
                SOAPStyle defaultStyle = null;
                Iterator operations = port.getOperations();
                while (operations.hasNext()) {
                    com.sun.xml.rpc.processor.model.Operation operation = (com.sun.xml.rpc.processor.model.Operation)operations.next();
                    if (operation.getStyle() == null) {
                        operation.setStyle(SOAPStyle.RPC);
                    }
                    if (defaultStyle == null) {
                        defaultStyle = operation.getStyle();
                        continue;
                    }
                    if (defaultStyle == operation.getStyle()) continue;
                    isMixed = true;
                }
                String localPortName = port.getName().getLocalPart();
                Binding wsdlBinding = new Binding(definitions);
                wsdlBinding.setName(this.getWSDLBindingName(port));
                wsdlBinding.setPortType(new QName(model.getTargetNamespaceURI(), this.getWSDLPortTypeName(port)));
                SOAPBinding soapBinding = new SOAPBinding();
                if (defaultStyle != null && !isMixed) {
                    soapBinding.setStyle(defaultStyle);
                }
                soapBinding.setTransport(this.getSOAPTransportHttpURI(port));
                wsdlBinding.addExtension(soapBinding);
                Iterator operations2 = port.getOperations();
                while (operations2.hasNext()) {
                    com.sun.xml.rpc.processor.model.Operation operation = (com.sun.xml.rpc.processor.model.Operation)operations2.next();
                    BindingOperation wsdlOperation = new BindingOperation();
                    wsdlOperation.setName(operation.getName().getLocalPart());
                    wsdlOperation.setStyle(OperationStyle.REQUEST_RESPONSE);
                    SOAPOperation soapOperation = new SOAPOperation();
                    soapOperation.setSOAPAction(operation.getSOAPAction());
                    if (!operation.getStyle().equals(defaultStyle)) {
                        soapOperation.setStyle(operation.getStyle());
                    }
                    wsdlOperation.addExtension(soapOperation);
                    Request request = operation.getRequest();
                    BindingInput input = new BindingInput();
                    SOAPBody soapBody = new SOAPBody();
                    soapBody.setUse(operation.getUse());
                    if (operation.getUse() == SOAPUse.ENCODED) {
                        soapBody.setEncodingStyle(this.getSOAPEncodingNamespace(port));
                    }
                    if (operation.getStyle() == SOAPStyle.RPC) {
                        soapBody.setNamespace(model.getTargetNamespaceURI());
                    }
                    input.addExtension(soapBody);
                    wsdlOperation.setInput(input);
                    Response response = operation.getResponse();
                    if (response != null) {
                        BindingOutput output = new BindingOutput();
                        soapBody = new SOAPBody();
                        soapBody.setUse(operation.getUse());
                        if (operation.getUse() == SOAPUse.ENCODED) {
                            soapBody.setEncodingStyle(this.getSOAPEncodingNamespace(port));
                        }
                        if (operation.getStyle() == SOAPStyle.RPC) {
                            soapBody.setNamespace(model.getTargetNamespaceURI());
                        }
                        output.addExtension(soapBody);
                        wsdlOperation.setOutput(output);
                    }
                    TreeSet faultSet = new TreeSet(new GeneratorUtil.FaultComparator());
                    faultSet.addAll(operation.getFaultsSet());
                    Iterator faults = faultSet.iterator();
                    while (faults.hasNext()) {
                        Fault fault = (Fault)faults.next();
                        BindingFault bindingFault = new BindingFault();
                        bindingFault.setName(fault.getName());
                        SOAPFault soapFault = new SOAPFault();
                        soapFault.setName(fault.getName());
                        if (fault.getBlock().getType().isSOAPType()) {
                            soapFault.setUse(SOAPUse.ENCODED);
                            soapFault.setEncodingStyle(this.getSOAPEncodingNamespace(port));
                            soapFault.setNamespace(model.getTargetNamespaceURI());
                        } else {
                            soapFault.setUse(SOAPUse.LITERAL);
                        }
                        bindingFault.addExtension(soapFault);
                        wsdlOperation.addFault(bindingFault);
                    }
                    wsdlBinding.add(wsdlOperation);
                }
                definitions.add(wsdlBinding);
            }
        }
    }

    private void generateServices(Model model, Definitions definitions) throws Exception {
        Iterator services = model.getServices();
        while (services.hasNext()) {
            com.sun.xml.rpc.processor.model.Service service = (com.sun.xml.rpc.processor.model.Service)services.next();
            Service wsdlService = new Service(definitions);
            wsdlService.setName(service.getName().getLocalPart());
            Iterator ports = service.getPorts();
            while (ports.hasNext()) {
                Port port = (Port)ports.next();
                String localPortName = port.getName().getLocalPart();
                com.sun.xml.rpc.wsdl.document.Port wsdlPort = new com.sun.xml.rpc.wsdl.document.Port(definitions);
                wsdlPort.setName(this.getWSDLPortName(port));
                wsdlPort.setBinding(new QName(model.getTargetNamespaceURI(), this.getWSDLBindingName(port)));
                SOAPAddress soapAddress = new SOAPAddress();
                soapAddress.setLocation(port.getAddress() == null ? "REPLACE_WITH_ACTUAL_URL" : port.getAddress());
                wsdlPort.addExtension(soapAddress);
                wsdlService.add(wsdlPort);
            }
            definitions.add(wsdlService);
        }
    }

    private String getWSDLBaseName(Port port) {
        return port.getName().getLocalPart();
    }

    private String getWSDLPortName(Port port) {
        QName value = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
        if (value != null) {
            return value.getLocalPart();
        }
        return this.getWSDLBaseName(port) + "Port";
    }

    private String getWSDLBindingName(Port port) {
        QName value = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLBindingName");
        if (value != null) {
            return value.getLocalPart();
        }
        return this.getWSDLBaseName(port) + "Binding";
    }

    private String getWSDLPortTypeName(Port port) {
        QName value = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName");
        if (value != null) {
            return value.getLocalPart();
        }
        return port.getName().getLocalPart();
    }

    private String getWSDLInputMessageName(com.sun.xml.rpc.processor.model.Operation operation) {
        QName value = (QName)operation.getRequest().getProperty("com.sun.xml.rpc.processor.model.WSDLMessageName");
        if (value != null) {
            return value.getLocalPart();
        }
        return operation.getName().getLocalPart();
    }

    private String getWSDLOutputMessageName(com.sun.xml.rpc.processor.model.Operation operation) {
        if (operation.getResponse() == null) {
            return null;
        }
        QName value = (QName)operation.getResponse().getProperty("com.sun.xml.rpc.processor.model.WSDLMessageName");
        if (value != null) {
            return value.getLocalPart();
        }
        return operation.getName().getLocalPart() + "Response";
    }

    private String getWSDLFaultMessageName(Fault fault) {
        QName value = (QName)fault.getProperty("com.sun.xml.rpc.processor.model.WSDLMessageName");
        if (value != null) {
            return value.getLocalPart();
        }
        return fault.getName();
    }

    protected void fail(String key, String arg) {
        throw new GeneratorException(key, arg);
    }
}

