/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterBase;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterFactory;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterFactoryImpl;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ArraySerializerWriter
extends SerializerWriterBase
implements GeneratorConstants {
    private String serializerMemberName;
    private AbstractType baseElemType;
    private SerializerWriterFactory writerFactory;
    private SOAPType dataType;
    private static Set boxedSet = null;

    public ArraySerializerWriter(SOAPType type, Names names) {
        super(type, names);
        this.dataType = type;
        String serializerName = names.typeObjectArraySerializerClassName(type);
        this.serializerMemberName = names.getClassMemberName(serializerName, type) + ((SOAPArrayType)type).getRank();
        this.baseElemType = this.getBaseElementType();
        this.writerFactory = new SerializerWriterFactoryImpl(names);
    }

    public void createSerializer(IndentingWriter p, StringBuffer typeName, String serName, boolean encodeTypes, boolean multiRefEncoding, String typeMapping) throws IOException {
        SOAPArrayType type = (SOAPArrayType)this.type;
        String nillable = type.isNillable() ? "NULLABLE" : "NOT_NULLABLE";
        String referenceable = type.isReferenceable() ? "REFERENCEABLE" : "NOT_REFERENCEABLE";
        String multiRef = multiRefEncoding && type.isReferenceable() ? "SERIALIZE_AS_REF" : "DONT_SERIALIZE_AS_REF";
        String encodeType = encodeTypes ? "ENCODE_TYPE" : "DONT_ENCODE_TYPE";
        this.declareType(p, typeName, type.getName(), false, false);
        StringBuffer elemName = new StringBuffer("elemName");
        if (type.getElementName() != null) {
            this.declareType(p, elemName, type.getElementName(), false, false);
        } else {
            elemName = new StringBuffer("null");
        }
        StringBuffer elemType = new StringBuffer("elemType");
        this.declareType(p, elemType, this.baseElemType.getName(), false, false);
        if (this.isSimpleType(this.baseElemType.getJavaType().getRealName()) && !((SOAPType)this.baseElemType).isReferenceable()) {
            SerializerWriter writer = this.writerFactory.createWriter(this.baseElemType);
            StringBuffer serNameElemType = new StringBuffer(serName + elemType);
            writer.createSerializer(p, serNameElemType, serName + "elemSerializer", encodeTypes, multiRefEncoding, typeMapping);
            p.plnI(this.serializerName() + " " + serName + " = new SimpleTypeArraySerializer(" + typeName + ",");
            p.pln(encodeType + ", " + nillable + ", " + this.getEncodingStyleString() + " , ");
            p.pln(elemName + ", " + elemType + ", " + this.baseElemType.getJavaType().getRealName() + ".class, " + type.getRank() + ", " + type.getSize() + ", (SimpleTypeSerializer)" + serName + "elemSerializer, " + this.getSOAPVersionString() + ");");
            p.pO();
        } else {
            p.plnI(this.serializerName() + " " + serName + " = new ObjectArraySerializer(" + typeName + ",");
            p.pln(encodeType + ", " + nillable + ", " + this.getEncodingStyleString() + " , ");
            p.pln(elemName + ", " + elemType + ", " + this.baseElemType.getJavaType().getRealName() + ".class, " + type.getRank() + ", " + type.getSize() + ", " + this.getSOAPVersionString() + ");");
            p.pO();
        }
        if (type.isReferenceable()) {
            p.pln(serName + " = new " + GeneratorConstants.REFERENCEABLE_SERIALIZER_NAME + "(" + multiRef + ", " + serName + ", " + this.getSOAPVersionString() + ");");
        }
    }

    public void declareSerializer(IndentingWriter p, boolean isStatic, boolean isFinal) throws IOException {
        String modifier = this.getPrivateModifier(isStatic, isFinal);
        p.pln(modifier + this.serializerName() + " " + this.serializerMemberName() + ";");
    }

    public String serializerMemberName() {
        return this.getPrefix(this.dataType) + "_" + this.serializerMemberName;
    }

    public String deserializerMemberName() {
        return this.getPrefix(this.dataType) + "_" + this.serializerMemberName;
    }

    protected String getPrivateModifier(boolean isStatic, boolean isFinal) {
        return "private " + super.getModifier(isStatic, isFinal);
    }

    public AbstractType getBaseElementType() {
        SOAPType elemType = ((SOAPArrayType)this.type).getElementType();
        while (elemType instanceof SOAPArrayType) {
            elemType = ((SOAPArrayType)elemType).getElementType();
        }
        return elemType;
    }

    private boolean isSimpleType(String javaName) {
        return SimpleToBoxedUtil.isPrimitive(javaName) || boxedSet.contains(javaName);
    }

    static {
        boxedSet = new HashSet();
        boxedSet.add("java.lang.Boolean");
        boxedSet.add("java.lang.Byte");
        boxedSet.add("java.lang.Double");
        boxedSet.add("java.lang.Float");
        boxedSet.add("java.lang.Int");
        boxedSet.add("java.lang.Long");
        boxedSet.add("java.lang.Short");
        boxedSet.add("java.lang.String");
        boxedSet.add("javax.xml.namespace.QName");
        boxedSet.add("java.lang.BigDecimal");
        boxedSet.add("java.lang.BigInteger");
        boxedSet.add("java.net.URI");
        boxedSet.add("java.util.Calendar");
        boxedSet.add("java.util.Date");
    }
}

